/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.ecoop21;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.terms.newPath.ResolutionPath;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import mb.scopegraph.resolution.RExp;
import mb.scopegraph.resolution.RStep;
import mb.scopegraph.resolution.RVar;
import mb.scopegraph.resolution.State;
import mb.scopegraph.resolution.StateMachine;
import org.metaborg.util.Ref;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.Futures;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.tuple.Tuple2;

public class ResolutionInterpreter<S, L, D, M> {
    private final IFuture<Tuple2<Env<S, L, D>, M>> EMPTY_ENV;
    private final ResolutionContext<S, L, D, M> context;
    private final StateMachine<L> stateMachine;

    public ResolutionInterpreter(ResolutionContext<S, L, D, M> context, StateMachine<L> stateMachine) {
        this.context = context;
        this.stateMachine = stateMachine;
        this.EMPTY_ENV = CompletableFuture.completedFuture(Tuple2.of(Env.empty(), context.unitMetadata()));
    }

    public IFuture<Tuple2<Env<S, L, D>, M>> resolve(ScopePath<S, L> path, State<L> state, ICancel cancel) throws InterruptedException {
        cancel.throwIfCancelled();
        Store store = new Store();
        for (RStep step : state.resolutionSteps()) {
            this.evaluateStep(path, step, store, cancel);
        }
        return store.lookup(state.resultVar());
    }

    private void evaluateStep(ScopePath<S, L> path, RStep<L> step, Store<S, L, D, M> store, ICancel cancel) {
        IFuture<Tuple2<Env<S, L, D>, M>> env = this.evaluateExp(path, step.getExp(), store, cancel);
        store.store(step.getVar(), env);
    }

    private IFuture<Tuple2<Env<S, L, D>, M>> evaluateExp(final ScopePath<S, L> path, RExp<L> exp, final Store<S, L, D, M> store, final ICancel cancel) {
        final S scope = path.getTarget();
        IFuture env = (IFuture)exp.match(new RExp.Cases<L, IFuture<Tuple2<Env<S, L, D>, M>>>(){

            @Override
            public IFuture<Tuple2<Env<S, L, D>, M>> caseResolve() {
                return ResolutionInterpreter.this.context.getDatum(scope).thenCompose(d_opt -> d_opt.map(d -> {
                    try {
                        return ResolutionInterpreter.this.context.dataWf(d, cancel).thenApply(wf -> Tuple2.of((Boolean)wf._1() != false ? Env.of(path.resolve(d)) : Env.empty(), wf._2()));
                    }
                    catch (InterruptedException e) {
                        return CompletableFuture.completedExceptionally(e);
                    }
                }).orElse(ResolutionInterpreter.this.EMPTY_ENV));
            }

            @Override
            public IFuture<Tuple2<Env<S, L, D>, M>> caseSubEnv(L label, String stateRef) {
                State newState = ResolutionInterpreter.this.stateMachine.state(stateRef);
                return ResolutionInterpreter.this.context.getEdges(scope, label).thenCompose(tgts -> AggregateFuture.forAll(tgts, tgt -> {
                    Optional<ScopePath<Object, Object>> newPathOpt = path.step(label, tgt);
                    if (newPathOpt.isPresent()) {
                        return ResolutionInterpreter.this.context.externalEnv(newPathOpt.get(), newState);
                    }
                    return ResolutionInterpreter.this.EMPTY_ENV;
                }).thenApply(arg_0 -> ResolutionInterpreter.access$2(ResolutionInterpreter.this, arg_0)));
            }

            @Override
            public IFuture<Tuple2<Env<S, L, D>, M>> caseMerge(List<RVar> vars) {
                return AggregateFuture.forAll(vars, store::lookup).thenApply(arg_0 -> ResolutionInterpreter.access$2(ResolutionInterpreter.this, arg_0));
            }

            @Override
            public IFuture<Tuple2<Env<S, L, D>, M>> caseShadow(RVar left, RVar right) {
                IFuture leftEnvFuture = store.lookup(left);
                IFuture rightEnvFuture = store.lookup(right);
                return AggregateFuture.apply(leftEnvFuture, rightEnvFuture).thenCompose(envs -> {
                    Env leftEnv = (Env)((Tuple2)envs._1())._1();
                    Env rightEnv = (Env)((Tuple2)envs._2())._1();
                    Object metadata = ResolutionInterpreter.this.context.compose(((Tuple2)envs._1())._2(), ((Tuple2)envs._2())._2());
                    if (rightEnv.isEmpty()) {
                        return CompletableFuture.completedFuture(Tuple2.of(leftEnv, metadata));
                    }
                    if (leftEnv.isEmpty()) {
                        return CompletableFuture.completedFuture(Tuple2.of(rightEnv, metadata));
                    }
                    Ref envBuilderRef = new Ref();
                    IFuture<List<Tuple2>> future = AggregateFuture.forAll(rightEnv, path -> ResolutionInterpreter.this.isShadowed(path.getDatum(), leftEnv, cancel).thenApply(equiv -> {
                        if (!((Boolean)equiv._1()).booleanValue()) {
                            if (envBuilderRef.get() == null) {
                                Env.Builder envBuilder = Env.builder();
                                envBuilder.addAll(leftEnv);
                                envBuilder.add(path);
                                envBuilderRef.set(envBuilder);
                            } else {
                                ((Env.Builder)envBuilderRef.get()).add(path);
                            }
                        }
                        return equiv._2();
                    }));
                    return future.thenApply(metadataList -> {
                        Object m = metadataList.stream().reduce(metadata, ResolutionInterpreter.this.context::compose);
                        Env.Builder envBuilder = (Env.Builder)envBuilderRef.get();
                        if (envBuilder == null) {
                            return Tuple2.of(leftEnv, m);
                        }
                        return Tuple2.of(envBuilder.build(), m);
                    });
                });
            }

            @Override
            public IFuture<Tuple2<Env<S, L, D>, M>> caseCExp(RVar envVar, RExp<L> exp) {
                return store.lookup(envVar).thenCompose(env -> {
                    if (((Env)env._1()).isEmpty()) {
                        return ResolutionInterpreter.this.evaluateExp(path, exp, store, cancel).thenApply(res -> Tuple2.of((Env)res._1(), ResolutionInterpreter.this.context.compose(env._2(), res._2())));
                    }
                    return CompletableFuture.completedFuture(env);
                });
            }
        });
        return env;
    }

    private IFuture<Tuple2<Boolean, M>> isShadowed(D datum, Iterable<ResolutionPath<S, L, D>> specifics, ICancel cancel) {
        return Futures.reduce(Tuple2.of(false, this.context.unitMetadata()), specifics, (acc, path) -> (Boolean)acc._1() != false ? CompletableFuture.completedFuture(acc) : this.context.dataLeq(datum, path.getDatum(), cancel).thenApply(res -> Tuple2.of((Boolean)res._1(), this.context.compose(acc._2(), res._2()))));
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<Env<S, L, D>, M> mergeSubEnvironments(Iterable<Tuple2<Env<S, L, D>, M>> envs) {
        metadata = this.context.unitMetadata();
        firstEnv = null;
        envIterator = envs.iterator();
        while (envIterator.hasNext()) {
            env = envIterator.next();
            metadata = this.context.compose(metadata, env._2());
            if (env._1().isEmpty()) continue;
            firstEnv = env._1();
            break;
        }
        if (firstEnv == null) {
            return Tuple2.of(Env.empty(), metadata);
        }
        envBuilder = null;
        while (envIterator.hasNext()) {
            env = envIterator.next();
            metadata = this.context.compose(metadata, env._2());
            if (env._1().isEmpty()) continue;
            envBuilder = Env.builder();
            envBuilder.addAll(firstEnv);
            envBuilder.addAll(env._1());
            break;
        }
        if (envBuilder != null) ** GOTO lbl27
        return Tuple2.of(firstEnv, metadata);
lbl-1000:
        // 1 sources

        {
            env = envIterator.next();
            metadata = this.context.compose(metadata, env._2());
            if (env._1().isEmpty()) continue;
            envBuilder.addAll(env._1());
lbl27:
            // 3 sources

            ** while (envIterator.hasNext())
        }
lbl28:
        // 1 sources

        return Tuple2.of(envBuilder.build(), metadata);
    }

    static /* synthetic */ Tuple2 access$2(ResolutionInterpreter resolutionInterpreter, Iterable iterable) {
        return resolutionInterpreter.mergeSubEnvironments(iterable);
    }

    public static interface ResolutionContext<S, L, D, M> {
        public IFuture<Tuple2<Env<S, L, D>, M>> externalEnv(ScopePath<S, L> var1, State<L> var2);

        public IFuture<Iterable<S>> getEdges(S var1, L var2);

        public IFuture<Optional<D>> getDatum(S var1);

        public IFuture<Tuple2<Boolean, M>> dataWf(D var1, ICancel var2) throws InterruptedException;

        public IFuture<Tuple2<Boolean, M>> dataLeq(D var1, D var2, ICancel var3) throws InterruptedException;

        public M unitMetadata();

        public M compose(M var1, M var2);
    }

    private static class Store<S, L, D, M> {
        private final HashMap<RVar, IFuture<Tuple2<Env<S, L, D>, M>>> store = new HashMap();

        private Store() {
        }

        public void store(RVar var, IFuture<Tuple2<Env<S, L, D>, M>> value) {
            this.store.put(var, value);
        }

        public IFuture<Tuple2<Env<S, L, D>, M>> lookup(RVar var) {
            IFuture<Tuple2<Env<S, L, D>, M>> value = this.store.get(var);
            if (value == null) {
                throw new IllegalStateException("Variable " + var + " does not exist.");
            }
            return value;
        }
    }
}

