/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.classloader;

import java.net.URISyntaxException;
import java.net.URL;
import mb.resource.ResourceRuntimeException;
import mb.resource.classloader.ClassLoaderToNativeResolver;
import mb.resource.fs.FSResource;
import mb.resource.hierarchical.HierarchicalResource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FSResourceClassLoaderToNativeResolver
implements ClassLoaderToNativeResolver {
    @Override
    public @Nullable HierarchicalResource toNativeFile(URL url) {
        return this.toNativeResource(url);
    }

    @Override
    public @Nullable HierarchicalResource toNativeDirectory(URL url) {
        return this.toNativeResource(url);
    }

    private @Nullable HierarchicalResource toNativeResource(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                return new FSResource(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new ResourceRuntimeException("Could not get local filesystem URI (with 'file' protocol); conversion of URL '" + url + "' to an URI failed", e);
            }
        }
        return null;
    }
}

