/*
 * Decompiled with CFR 0.152.
 */
package mb.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import mb.resource.Resource;

public interface ReadableResource
extends Resource,
AutoCloseable {
    public boolean exists() throws IOException;

    public boolean isReadable() throws IOException;

    public Instant getLastModifiedTime() throws IOException;

    public long getSize() throws IOException;

    public InputStream openRead() throws IOException;

    default public BufferedInputStream openReadBuffered() throws IOException {
        return new BufferedInputStream(this.openRead());
    }

    default public byte[] readBytes() throws IOException {
        try (InputStream inputStream = this.openRead();){
            byte[] byArray;
            byte[] buffer = new byte[4096];
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(buffer.length);){
                int bytesRead;
                while ((bytesRead = inputStream.read(buffer, 0, buffer.length)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.flush();
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
    }

    default public String readString(Charset fromCharset) throws IOException {
        return new String(this.readBytes(), fromCharset);
    }

    default public String readString() throws IOException {
        return this.readString(StandardCharsets.UTF_8);
    }

    @Override
    public void close() throws IOException;
}

