/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.diff;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mb.p_raffrayi.impl.diff.IDifferContext;
import mb.p_raffrayi.impl.diff.IDifferOps;
import mb.p_raffrayi.impl.diff.IScopeGraphDiffer;
import mb.p_raffrayi.impl.diff.ScopeDiff;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.diff.BiMap;
import mb.scopegraph.oopsla20.diff.Edge;
import mb.scopegraph.oopsla20.diff.ScopeGraphDiff;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.patching.IPatchCollection;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;

public class MatchingDiffer<S, L, D>
implements IScopeGraphDiffer<S, L, D> {
    private static final ILogger logger = LoggerUtils.logger(MatchingDiffer.class);
    private final IDifferOps<S, L, D> differOps;
    private final IDifferContext<S, L, D> context;
    private final BiMap.Immutable<S> scopeMatches;
    private final Map<Tuple2<S, L>, IFuture<ScopeDiff<S, L, D>>> scopeDiffs = new HashMap<Tuple2<S, L>, IFuture<ScopeDiff<S, L, D>>>();

    public MatchingDiffer(IDifferOps<S, L, D> differOps, IDifferContext<S, L, D> context) {
        this(differOps, context, BiMap.Immutable.of());
    }

    public MatchingDiffer(IDifferOps<S, L, D> differOps, IDifferContext<S, L, D> context, BiMap.Immutable<S> scopeMatches) {
        this.differOps = differOps;
        this.context = context;
        this.scopeMatches = scopeMatches;
    }

    public MatchingDiffer(IDifferOps<S, L, D> differOps, IDifferContext<S, L, D> context, Iterable<Map.Entry<S, S>> scopeMatches) {
        this.differOps = differOps;
        this.context = context;
        BiMap.Transient<S> _scopeMatches = BiMap.Transient.of();
        for (Map.Entry<S, S> match : scopeMatches) {
            _scopeMatches.put(match.getKey(), match.getValue());
        }
        this.scopeMatches = _scopeMatches.freeze();
    }

    @Override
    public IFuture<ScopeGraphDiff<S, L, D>> diff(List<S> currentRootScopes, List<S> previousRootScopes) {
        return CompletableFuture.completedFuture(ScopeGraphDiff.empty());
    }

    @Override
    public IFuture<ScopeGraphDiff<S, L, D>> diff(IScopeGraph.Immutable<S, L, D> initiallyMatchedGraph, Collection<S> scopes, Collection<S> sharedScopes, IPatchCollection.Immutable<S> patches, Collection<S> openScopes, Multimap<S, EdgeOrData<L>> openEdges) {
        if (!(openScopes.isEmpty() && openEdges.isEmpty() && patches.isIdentity())) {
            throw new IllegalStateException("Cannot create matching differ with open scopes/edges.");
        }
        return CompletableFuture.completedFuture(ScopeGraphDiff.empty());
    }

    @Override
    public boolean matchScopes(BiMap.Immutable<S> scopes) {
        for (Map.Entry entry : scopes.asMap().entrySet()) {
            Object previous;
            Object current = entry.getKey();
            if (current.equals(this.getCurrent(previous = entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void typeCheckerFinished() {
    }

    @Override
    public IFuture<Optional<S>> match(S previousScope) {
        this.assertOwnScope(previousScope);
        return CompletableFuture.completedFuture(Optional.of(previousScope));
    }

    @Override
    public IFuture<ScopeDiff<S, L, D>> scopeDiff(S previousScope, L label) {
        this.assertOwnScope(previousScope);
        return this.scopeDiffs.computeIfAbsent(Tuple2.of(previousScope, label), __ -> {
            Object currentScope = this.getCurrent(previousScope);
            return this.context.getEdges(currentScope, label).thenApply(tgts -> {
                ScopeDiff.Builder builder = ScopeDiff.builder();
                tgts.forEach(tgt -> {
                    ScopeDiff.Builder builder2 = builder.addMatchedEdges(new Edge<Object, Object>(currentScope, label, tgt));
                });
                return builder.build();
            });
        });
    }

    private S getCurrent(S previousScope) {
        return this.scopeMatches.getValueOrDefault(previousScope, previousScope);
    }

    private void assertOwnScope(S scope) {
        if (!this.differOps.ownScope(scope)) {
            logger.error("Scope {} not owned.", scope);
            throw new IllegalStateException("Scope " + scope + " not owned.");
        }
    }
}

