/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.actors.impl;

import java.util.Random;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import mb.p_raffrayi.actors.impl.IActorScheduler;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class WonkyScheduler
implements IActorScheduler {
    private static final ILogger logger = LoggerUtils.logger(WonkyScheduler.class);
    private final int parallelism;
    private final ScheduledThreadPoolExecutor executor;
    private final double preemptProbability;
    private final int scheduleDelayBoundMillis;
    private final Random rnd;

    public WonkyScheduler(int parallelism, double preemptProbability, int scheduleDelayBoundMillis) {
        this.parallelism = parallelism;
        this.executor = new ScheduledThreadPoolExecutor(parallelism);
        this.preemptProbability = preemptProbability;
        this.scheduleDelayBoundMillis = scheduleDelayBoundMillis;
        this.rnd = new Random();
    }

    @Override
    public int parallelism() {
        return this.parallelism;
    }

    @Override
    public boolean isActive() {
        return this.executor.getActiveCount() != 0 || !this.executor.getQueue().isEmpty();
    }

    @Override
    public void schedule(Runnable runnable, int priority, AtomicReference<Runnable> taskRef) {
        Task task = new Task(runnable);
        if (!taskRef.compareAndSet(null, task)) {
            logger.error("Actor {} already scheduled", runnable);
            throw new IllegalStateException("Actor " + runnable + " already scheduled.");
        }
        this.executor.schedule(task, (long)this.rnd.nextInt(this.scheduleDelayBoundMillis), TimeUnit.MILLISECONDS);
    }

    @Override
    public void reschedule(Runnable oldTask, int newPriority, AtomicReference<Runnable> taskRef) {
    }

    @Override
    public boolean preempt(int priority) {
        return this.rnd.nextDouble() < this.preemptProbability;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    private class Task
    implements Runnable {
        private final Runnable runnable;
        private final AtomicBoolean active;

        Task(Runnable runnable) {
            this.runnable = runnable;
            this.active = new AtomicBoolean(true);
        }

        @Override
        public void run() {
            if (this.active.compareAndSet(true, false)) {
                this.runnable.run();
            }
        }
    }
}

