/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.solvers;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.solvers.BaseSolver;
import mb.nabl2.terms.unification.u.IUnifier;

public final class BaseSolution
extends BaseSolver.ABaseSolution
implements Serializable {
    private final SolverConfig config;
    private final ImmutableSet<IConstraint> constraints;
    private final IUnifier.Immutable unifier;
    private static final long serialVersionUID = 42L;

    private BaseSolution(SolverConfig config, Iterable<? extends IConstraint> constraints, IUnifier.Immutable unifier) {
        this.config = Objects.requireNonNull(config, "config");
        this.constraints = ImmutableSet.copyOf(constraints);
        this.unifier = Objects.requireNonNull(unifier, "unifier");
    }

    private BaseSolution(BaseSolution original, SolverConfig config, ImmutableSet<IConstraint> constraints, IUnifier.Immutable unifier) {
        this.config = config;
        this.constraints = constraints;
        this.unifier = unifier;
    }

    @Override
    public SolverConfig config() {
        return this.config;
    }

    @Override
    public ImmutableSet<IConstraint> constraints() {
        return this.constraints;
    }

    @Override
    public IUnifier.Immutable unifier() {
        return this.unifier;
    }

    public final BaseSolution withConfig(SolverConfig value) {
        if (this.config == value) {
            return this;
        }
        SolverConfig newValue = Objects.requireNonNull(value, "config");
        return new BaseSolution(this, newValue, this.constraints, this.unifier);
    }

    public final BaseSolution withConstraints(IConstraint ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new BaseSolution(this, this.config, (ImmutableSet<IConstraint>)newValue, this.unifier);
    }

    public final BaseSolution withConstraints(Iterable<? extends IConstraint> elements) {
        if (this.constraints == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new BaseSolution(this, this.config, (ImmutableSet<IConstraint>)newValue, this.unifier);
    }

    public final BaseSolution withUnifier(IUnifier.Immutable value) {
        if (this.unifier == value) {
            return this;
        }
        IUnifier.Immutable newValue = Objects.requireNonNull(value, "unifier");
        return new BaseSolution(this, this.config, this.constraints, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BaseSolution && this.equalTo((BaseSolution)another);
    }

    private boolean equalTo(BaseSolution another) {
        return this.config.equals(another.config) && this.constraints.equals(another.constraints) && this.unifier.equals(another.unifier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + this.unifier.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BaseSolution").omitNullValues().add("config", (Object)this.config).add("constraints", this.constraints).add("unifier", (Object)this.unifier).toString();
    }

    public static BaseSolution of(SolverConfig config, ImmutableSet<IConstraint> constraints, IUnifier.Immutable unifier) {
        return BaseSolution.of(config, constraints, unifier);
    }

    public static BaseSolution of(SolverConfig config, Iterable<? extends IConstraint> constraints, IUnifier.Immutable unifier) {
        return new BaseSolution(config, constraints, unifier);
    }

    public static BaseSolution copyOf(BaseSolver.ABaseSolution instance) {
        if (instance instanceof BaseSolution) {
            return (BaseSolution)instance;
        }
        return BaseSolution.of(instance.config(), instance.constraints(), instance.unifier());
    }
}

