/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import mb.nabl2.relations.variants.VariantRelationDescription;
import mb.nabl2.solver.ASolverConfig;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.pepm16.terms.ResolutionParameters;
import org.metaborg.util.functions.PartialFunction1;

public final class SolverConfig
extends ASolverConfig
implements Serializable {
    private final ResolutionParameters resolutionParams;
    private final ImmutableMap<String, VariantRelationDescription<ITerm>> relations;
    private final ImmutableMap<String, PartialFunction1<ITerm, ITerm>> functions;
    private static final long serialVersionUID = 42L;

    private SolverConfig(ResolutionParameters resolutionParams, Map<String, ? extends VariantRelationDescription<ITerm>> relations, Map<String, ? extends PartialFunction1<ITerm, ITerm>> functions) {
        this.resolutionParams = Objects.requireNonNull(resolutionParams, "resolutionParams");
        this.relations = ImmutableMap.copyOf(relations);
        this.functions = ImmutableMap.copyOf(functions);
    }

    private SolverConfig(SolverConfig original, ResolutionParameters resolutionParams, ImmutableMap<String, VariantRelationDescription<ITerm>> relations, ImmutableMap<String, PartialFunction1<ITerm, ITerm>> functions) {
        this.resolutionParams = resolutionParams;
        this.relations = relations;
        this.functions = functions;
    }

    @Override
    public ResolutionParameters getResolutionParams() {
        return this.resolutionParams;
    }

    public ImmutableMap<String, VariantRelationDescription<ITerm>> getRelations() {
        return this.relations;
    }

    public ImmutableMap<String, PartialFunction1<ITerm, ITerm>> getFunctions() {
        return this.functions;
    }

    public final SolverConfig withResolutionParams(ResolutionParameters value) {
        if (this.resolutionParams == value) {
            return this;
        }
        ResolutionParameters newValue = Objects.requireNonNull(value, "resolutionParams");
        return new SolverConfig(this, newValue, this.relations, this.functions);
    }

    public final SolverConfig withRelations(Map<String, ? extends VariantRelationDescription<ITerm>> entries) {
        if (this.relations == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new SolverConfig(this, this.resolutionParams, (ImmutableMap<String, VariantRelationDescription<ITerm>>)newValue, this.functions);
    }

    public final SolverConfig withFunctions(Map<String, ? extends PartialFunction1<ITerm, ITerm>> entries) {
        if (this.functions == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new SolverConfig(this, this.resolutionParams, this.relations, (ImmutableMap<String, PartialFunction1<ITerm, ITerm>>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SolverConfig && this.equalTo((SolverConfig)another);
    }

    private boolean equalTo(SolverConfig another) {
        return this.resolutionParams.equals(another.resolutionParams) && this.relations.equals(another.relations) && this.functions.equals(another.functions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.resolutionParams.hashCode();
        h += (h << 5) + this.relations.hashCode();
        h += (h << 5) + this.functions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SolverConfig").omitNullValues().add("resolutionParams", (Object)this.resolutionParams).add("relations", this.relations).add("functions", this.functions).toString();
    }

    public static SolverConfig of(ResolutionParameters resolutionParams, Map<String, ? extends VariantRelationDescription<ITerm>> relations, Map<String, ? extends PartialFunction1<ITerm, ITerm>> functions) {
        return new SolverConfig(resolutionParams, relations, functions);
    }

    public static SolverConfig copyOf(ASolverConfig instance) {
        if (instance instanceof SolverConfig) {
            return (SolverConfig)instance;
        }
        return SolverConfig.of(instance.getResolutionParams(), instance.getRelations(), instance.getFunctions());
    }
}

