/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.messages;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.MessageContent;

final class TextMessage
extends MessageContent.ATextMessage
implements Serializable {
    private final String text;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private TextMessage(String text) {
        this.text = Objects.requireNonNull(text, "text");
        this.hashCode = this.computeHashCode();
    }

    private TextMessage(TextMessage original, String text) {
        this.text = text;
        this.hashCode = this.computeHashCode();
    }

    @Override
    String getText() {
        return this.text;
    }

    public final TextMessage withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new TextMessage(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TextMessage && this.equalTo((TextMessage)another);
    }

    private boolean equalTo(TextMessage another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.text.equals(another.text);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public static TextMessage of(String text) {
        return new TextMessage(text);
    }

    public static TextMessage copyOf(MessageContent.ATextMessage instance) {
        if (instance instanceof TextMessage) {
            return (TextMessage)instance;
        }
        return TextMessage.of(instance.getText());
    }

    private Object readResolve() throws ObjectStreamException {
        return new TextMessage(this, this.text);
    }
}

