/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.equality;

import mb.nabl2.constraints.equality.CEqual;
import mb.nabl2.constraints.equality.CInequal;
import mb.nabl2.constraints.equality.IEqualityConstraint;
import mb.nabl2.constraints.messages.MessageInfo;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.substitution.ISubstitution;
import org.metaborg.util.functions.Function1;

public final class EqualityConstraints {
    private static final String C_EQUAL = "CEqual";
    private static final String C_INEQUAL = "CInequal";

    public static TermMatch.IMatcher<IEqualityConstraint> matcher() {
        return TermMatch.M.cases(TermMatch.M.appl3(C_EQUAL, TermMatch.M.term(), TermMatch.M.term(), MessageInfo.matcher(), (c, term1, term2, origin) -> CEqual.of(term1, term2, origin)), TermMatch.M.appl3(C_INEQUAL, TermMatch.M.term(), TermMatch.M.term(), MessageInfo.matcher(), (c, term1, term2, origin) -> CInequal.of(term1, term2, origin)));
    }

    public static ITerm build(IEqualityConstraint constraint) {
        return constraint.match(IEqualityConstraint.Cases.of(eq -> TermBuild.B.newAppl(C_EQUAL, eq.getLeft(), eq.getRight(), MessageInfo.build(eq.getMessageInfo())), ineq -> TermBuild.B.newAppl(C_INEQUAL, ineq.getLeft(), ineq.getRight(), MessageInfo.build(ineq.getMessageInfo()))));
    }

    public static IEqualityConstraint substitute(IEqualityConstraint constraint, ISubstitution.Immutable subst) {
        return constraint.match(IEqualityConstraint.Cases.of(eq -> CEqual.of(subst.apply(eq.getLeft()), subst.apply(eq.getRight()), eq.getMessageInfo().apply(subst::apply)), ineq -> CInequal.of(subst.apply(ineq.getLeft()), subst.apply(ineq.getRight()), ineq.getMessageInfo().apply(subst::apply))));
    }

    public static IEqualityConstraint transform(IEqualityConstraint constraint, Function1<ITerm, ITerm> map) {
        return constraint.match(IEqualityConstraint.Cases.of(eq -> CEqual.of((ITerm)map.apply(eq.getLeft()), (ITerm)map.apply(eq.getRight()), eq.getMessageInfo().apply(map::apply)), ineq -> CInequal.of((ITerm)map.apply(ineq.getLeft()), (ITerm)map.apply(ineq.getRight()), ineq.getMessageInfo().apply(map::apply))));
    }
}

