/*
 * Decompiled with CFR 0.152.
 */
package mb.log.api;

import mb.log.api.Level;

public interface Logger {
    public boolean isTraceEnabled();

    default public void trace(String msg) {
        this.trace(msg, new Object[0]);
    }

    default public void trace(String msg, Throwable cause) {
        this.trace(msg, cause, new Object[0]);
    }

    public void trace(String var1, Object ... var2);

    public void trace(String var1, Throwable var2, Object ... var3);

    public boolean isDebugEnabled();

    default public void debug(String msg) {
        this.debug(msg, new Object[0]);
    }

    default public void debug(String msg, Throwable cause) {
        this.debug(msg, cause, new Object[0]);
    }

    public void debug(String var1, Object ... var2);

    public void debug(String var1, Throwable var2, Object ... var3);

    public boolean isInfoEnabled();

    default public void info(String msg) {
        this.info(msg, new Object[0]);
    }

    default public void info(String msg, Throwable cause) {
        this.info(msg, cause, new Object[0]);
    }

    public void info(String var1, Object ... var2);

    public void info(String var1, Throwable var2, Object ... var3);

    public boolean isWarnEnabled();

    default public void warn(String msg) {
        this.warn(msg, new Object[0]);
    }

    default public void warn(String msg, Throwable cause) {
        this.warn(msg, cause, new Object[0]);
    }

    public void warn(String var1, Object ... var2);

    public void warn(String var1, Throwable var2, Object ... var3);

    public boolean isErrorEnabled();

    default public void error(String msg) {
        this.error(msg, new Object[0]);
    }

    default public void error(String msg, Throwable cause) {
        this.error(msg, cause, new Object[0]);
    }

    public void error(String var1, Object ... var2);

    public void error(String var1, Throwable var2, Object ... var3);

    default public boolean isEnabled(Level level) {
        switch (level) {
            case None: {
                return false;
            }
            case Trace: {
                return this.isTraceEnabled();
            }
            case Debug: {
                return this.isDebugEnabled();
            }
            case Info: {
                return this.isInfoEnabled();
            }
            case Warn: {
                return this.isWarnEnabled();
            }
            case Error: {
                return this.isErrorEnabled();
            }
        }
        throw new IllegalStateException("Level " + (Object)((Object)level) + " is not recognized");
    }

    default public void log(Level level, String msg) {
        switch (level) {
            case None: {
                break;
            }
            case Trace: {
                this.trace(msg);
                break;
            }
            case Debug: {
                this.debug(msg);
                break;
            }
            case Info: {
                this.info(msg);
                break;
            }
            case Warn: {
                this.warn(msg);
                break;
            }
            case Error: {
                this.error(msg);
                break;
            }
            default: {
                throw new IllegalStateException("Level " + (Object)((Object)level) + " is not recognized");
            }
        }
    }

    default public void log(Level level, String msg, Throwable cause) {
        switch (level) {
            case None: {
                break;
            }
            case Trace: {
                this.trace(msg, cause);
                break;
            }
            case Debug: {
                this.debug(msg, cause);
                break;
            }
            case Info: {
                this.info(msg, cause);
                break;
            }
            case Warn: {
                this.warn(msg, cause);
                break;
            }
            case Error: {
                this.error(msg, cause);
                break;
            }
            default: {
                throw new IllegalStateException("Level " + (Object)((Object)level) + " is not recognized");
            }
        }
    }

    default public void log(Level level, String format, Object ... args) {
        switch (level) {
            case None: {
                break;
            }
            case Trace: {
                this.trace(format, args);
                break;
            }
            case Debug: {
                this.debug(format, args);
                break;
            }
            case Info: {
                this.info(format, args);
                break;
            }
            case Warn: {
                this.warn(format, args);
                break;
            }
            case Error: {
                this.error(format, args);
                break;
            }
            default: {
                throw new IllegalStateException("Level " + (Object)((Object)level) + " is not recognized");
            }
        }
    }

    default public void log(Level level, String format, Throwable cause, Object ... args) {
        switch (level) {
            case None: {
                break;
            }
            case Trace: {
                this.trace(format, cause, args);
                break;
            }
            case Debug: {
                this.debug(format, cause, args);
                break;
            }
            case Info: {
                this.info(format, cause, args);
                break;
            }
            case Warn: {
                this.warn(format, cause, args);
                break;
            }
            case Error: {
                this.error(format, cause, args);
                break;
            }
            default: {
                throw new IllegalStateException("Level " + (Object)((Object)level) + " is not recognized");
            }
        }
    }
}

