/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.locals;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import mb.flowspec.runtime.interpreter.Types;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;

@TypeSystemReference(value=Types.class)
@NodeChild(value="valNode", type=ExpressionNode.class)
@NodeField(name="slot", type=FrameSlot.class)
public abstract class WriteVarNode
extends Node {
    protected ExpressionNode expr;

    protected abstract FrameSlot getSlot();

    public abstract void execute(VirtualFrame var1);

    @Specialization(guards={"isInt(frame)"})
    protected void writeInt(VirtualFrame frame, int value) {
        this.getSlot().setKind(FrameSlotKind.Int);
        frame.setInt(this.getSlot(), value);
    }

    @Specialization(guards={"isBoolean(frame)"})
    protected void writeBoolean(VirtualFrame frame, boolean value) {
        this.getSlot().setKind(FrameSlotKind.Boolean);
        frame.setBoolean(this.getSlot(), value);
    }

    @Specialization(replaces={"writeInt", "writeBoolean"})
    protected void writeObject(VirtualFrame frame, Object value) {
        this.getSlot().setKind(FrameSlotKind.Object);
        frame.setObject(this.getSlot(), value);
    }

    protected boolean isInt(VirtualFrame frame) {
        return this.getSlot().getKind() == FrameSlotKind.Int || this.getSlot().getKind() == FrameSlotKind.Illegal;
    }

    protected boolean isBoolean(VirtualFrame frame) {
        return this.getSlot().getKind() == FrameSlotKind.Boolean || this.getSlot().getKind() == FrameSlotKind.Illegal;
    }
}

