/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.translation.AnyDirectedEdgeExtender;
import oracle.pg.rdbms.pgql.pgview.translation.ExpressionTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.LabelTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.PathTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.SubqueryInfo;
import oracle.pg.rdbms.pgql.pgview.translation.SubqueryVisitor;
import oracle.pg.rdbms.pgql.pgview.translation.TableTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.TranslationInfo;
import oracle.pg.rdbms.pgql.pgview.translation.expression.EmptyProjection;
import oracle.pg.rdbms.pgql.pgview.translation.expression.Projection;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableExpression;
import oracle.pg.rdbms.pgql.pgview.translation.expression.TableReference;
import oracle.pg.rdbms.pgql.pgview.translation.expression.Union;
import oracle.pg.rdbms.pgql.pgview.translation.expression.XmlTable;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.DerivedTable;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.unnest.OneRowPerStep;
import oracle.pgql.lang.ir.unnest.RowsPerMatchType;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public class GraphPatternTranslator {
    static final int INCOMPATIBLE_COLS = -1;

    static TableExpression translateGraphPattern(List<ExpAsVar> selectElements, GraphPattern graphPattern, List<ExpAsVar> groupByElements, List<OrderByElem> orderByElems, QueryExpression havingExp, Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions, MetadataConnector metadataConnector, QueryContext ctx, SubqueryInfo subqueryInfo) {
        Map<QueryVariable, QueryPath> pathVariables = GraphPatternTranslator.collectPathVariables(graphPattern);
        ArrayList<ExpAsVar> subSelectElems = new ArrayList<ExpAsVar>();
        HashSet<String> subSelectVars = new HashSet<String>();
        subqueryInfo.connections.addAll(graphPattern.getConnections());
        graphPattern.getConnections().forEach(e -> {
            subqueryInfo.variables.put(e.getName(), new Pair<Boolean, VertexPairConnection>(true, (VertexPairConnection)e));
            if (e.getVariableType() == QueryVariable.VariableType.PATH && ((QueryPath)e).getRowsPerMatch().getRowsPerMatchType() == RowsPerMatchType.ONE_ROW_PER_STEP) {
                QueryPath qp = (QueryPath)e;
                OneRowPerStep orps = (OneRowPerStep)qp.getRowsPerMatch();
                subqueryInfo.variables.put(orps.getVertex1().getName(), new Pair<Boolean, QueryVertex>(true, orps.getVertex1()));
                subqueryInfo.unnestedVariables.put(orps.getVertex1().getName(), qp);
                subqueryInfo.variables.put(orps.getEdge().getName(), new Pair<Boolean, QueryEdge>(true, orps.getEdge()));
                subqueryInfo.unnestedVariables.put(orps.getEdge().getName(), qp);
                subqueryInfo.variables.put(orps.getVertex2().getName(), new Pair<Boolean, QueryVertex>(true, orps.getVertex2()));
                subqueryInfo.unnestedVariables.put(orps.getVertex2().getName(), qp);
            }
        });
        graphPattern.getVertices().forEach(v -> subqueryInfo.variables.put(v.getName(), new Pair<Boolean, QueryVertex>(true, (QueryVertex)v)));
        if (groupByElements.size() > 0) {
            subqueryInfo.groupByVariables = new HashMap<String, Pair<Boolean, QueryVariable>>();
        }
        for (ExpAsVar groupByElem : groupByElements) {
            QueryVariable var;
            QueryVariable.VariableType variableType;
            if (groupByElem.getExp().getExpType() != QueryExpression.ExpressionType.VARREF || (variableType = (var = ((QueryExpression.VarRef)groupByElem.getExp()).getVariable()).getVariableType()) != QueryVariable.VariableType.VERTEX && variableType != QueryVariable.VariableType.EDGE) continue;
            subqueryInfo.variables.put(groupByElem.getName(), new Pair<Boolean, QueryVariable>(true, var));
            subqueryInfo.groupByVariables.put(var.getName(), new Pair<Boolean, ExpAsVar>(true, groupByElem));
            subqueryInfo.groupByVariables.put(groupByElem.getName(), new Pair<Boolean, ExpAsVar>(true, groupByElem));
        }
        HashSet<QueryVertex> commonVertices = new HashSet<QueryVertex>();
        HashSet<QueryVertex> commonJoinVertices = new HashSet<QueryVertex>();
        for (ExpAsVar expAsVar : selectElements) {
            GraphPatternTranslator.addSubSelectElements(expAsVar.getExp(), subSelectElems, subSelectVars, pathExpressions, pathVariables, subqueryInfo.unnestedVariables, true, subqueryInfo.variables, commonJoinVertices, commonVertices);
            if (!GraphPatternTranslator.isVertexOrEdgeReference(expAsVar)) continue;
            subqueryInfo.selectAliases.put(expAsVar.getName(), new Pair<Boolean, ExpAsVar>(true, expAsVar));
        }
        HashMap<String, Pair<Boolean, QueryVariable>> varsAndAliases = new HashMap<String, Pair<Boolean, QueryVariable>>(subqueryInfo.variables);
        varsAndAliases.putAll(subqueryInfo.selectAliases);
        for (ExpAsVar groupByElem : groupByElements) {
            GraphPatternTranslator.addSubSelectElements(groupByElem.getExp(), subSelectElems, subSelectVars, pathExpressions, pathVariables, subqueryInfo.unnestedVariables, true, varsAndAliases, commonJoinVertices, commonVertices);
        }
        for (OrderByElem orderByElem : orderByElems) {
            GraphPatternTranslator.addSubSelectElements(orderByElem.getExp(), subSelectElems, subSelectVars, pathExpressions, pathVariables, subqueryInfo.unnestedVariables, true, varsAndAliases, commonJoinVertices, commonVertices);
        }
        if (havingExp != null) {
            GraphPatternTranslator.addSubSelectElements(havingExp, subSelectElems, subSelectVars, pathExpressions, pathVariables, subqueryInfo.unnestedVariables, true, varsAndAliases, commonJoinVertices, commonVertices);
        }
        for (QueryExpression whereConstraint : graphPattern.getConstraints()) {
            GraphPatternTranslator.addSubSelectElements(whereConstraint, subSelectElems, subSelectVars, pathExpressions, pathVariables, subqueryInfo.unnestedVariables, false, subqueryInfo.variables, commonJoinVertices, commonVertices);
        }
        for (QueryVertex commonVertex : commonJoinVertices) {
            int numKeyColumns = GraphPatternTranslator.getCompatibleKeyColumns(commonVertex, graphPattern, metadataConnector);
            if (numKeyColumns != -1) {
                GraphPatternTranslator.addSubSelectExpression((QueryExpression)new QueryExpression.FunctionCall("_ora_comp_key_f_", PgqlUtils.buildList(new QueryExpression.VarRef((QueryVariable)commonVertex))), subSelectVars, subSelectElems);
                if (!subqueryInfo.isGroupByVariable(commonVertex.getName())) continue;
                groupByElements.add(new ExpAsVar((QueryExpression)new QueryExpression.FunctionCall("_ora_comp_key_f_", PgqlUtils.buildList(new QueryExpression.VarRef((QueryVariable)commonVertex))), "_ora_comp_key_" + commonVertex.getName() + "_" + numKeyColumns, true));
                continue;
            }
            GraphPatternTranslator.addSubSelectExpression((QueryExpression)new QueryExpression.VarRef((QueryVariable)commonVertex), subSelectVars, subSelectElems);
            subqueryInfo.variables.put(commonVertex.getName(), new Pair<Boolean, QueryVertex>(false, commonVertex));
            if (!subqueryInfo.isGroupByVariable(commonVertex.getName())) continue;
            subqueryInfo.groupByVariables.put(commonVertex.getName(), new Pair<Boolean, QueryVertex>(false, commonVertex));
        }
        GraphPatternTranslator.addExtraGroupByElements(commonVertices, groupByElements, subqueryInfo.groupByVariables, subSelectElems);
        AnyDirectedEdgeExtender anyDirectedEdgeExtender = new AnyDirectedEdgeExtender(graphPattern, subSelectElems);
        TableExpression tab = IntStream.range(0, anyDirectedEdgeExtender.getExtendedConnectionsSize()).mapToObj(extension -> {
            edgeExtender.replaceExtendedEdges(extension);
            TableTranslator.VariableTableBinding variableTableBinding = TableTranslator.generateVariableTableBinding(graphPattern, metadataConnector);
            List<Map<QueryVariable, String>> patternInstantiation = TableTranslator.generateAllPatternInstantiations(graphPattern, variableTableBinding, metadataConnector);
            if (subqueryInfo.parentConf != null) {
                int size = patternInstantiation.size();
                for (int idx = size - 1; idx >= 0; --idx) {
                    Map<QueryVariable, String> conf = patternInstantiation.get(idx);
                    boolean removed = false;
                    for (QueryVariable v : subqueryInfo.parentConf.keySet()) {
                        if (conf.containsKey(v)) {
                            if (removed || conf.get(v).equals(subqueryInfo.parentConf.get(v))) continue;
                            patternInstantiation.remove(idx);
                            removed = true;
                            continue;
                        }
                        conf.put(v, subqueryInfo.parentConf.get(v));
                    }
                }
            }
            return GraphPatternTranslator.generateTranslation(patternInstantiation, graphPattern, subSelectElems, metadataConnector, pathExpressions, ctx, subqueryInfo);
        }).filter(tableExpression -> !tableExpression.getClass().equals(EmptyProjection.class)).reduce(Union::new).orElse(new EmptyProjection(subSelectElems));
        anyDirectedEdgeExtender.compressExtendedEdges();
        return tab;
    }

    static TableExpression generateTranslation(List<Map<QueryVariable, String>> patternInstantiations, GraphPattern graphPattern, List<ExpAsVar> subSelectElems, MetadataConnector metadataConnector, Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions, QueryContext ctx, SubqueryInfo subqueryInfo) {
        return GraphPatternTranslator.generateTranslation(patternInstantiations, graphPattern.getVertices(), graphPattern.getConnections(), graphPattern.getConstraints(), subSelectElems, metadataConnector, pathExpressions, ctx, subqueryInfo);
    }

    static TableExpression generateTranslation(List<Map<QueryVariable, String>> patternInstantiations, Set<QueryVertex> vertices, Set<VertexPairConnection> connections, Set<QueryExpression> constraints, List<ExpAsVar> subSelectElems, MetadataConnector metadataConnector, Map<QueryExpression, PathTranslator.PathExpressionInfo> pathAggr, QueryContext ctx, SubqueryInfo subqueryInfo) {
        TranslationInfo translationInfo = new TranslationInfo(subSelectElems, connections, constraints, pathAggr, ctx, subqueryInfo);
        ArrayList<Projection> allProjections = new ArrayList<Projection>();
        Map<QueryVariable, String> parentConf = subqueryInfo.parentConf;
        List<SubqueryInfo.Constraints> extraConstraints = subqueryInfo.extraConstraints;
        HashMap<QueryPath, Map<Pair<String, String>, Integer>> pathMaps = new HashMap<QueryPath, Map<Pair<String, String>, Integer>>();
        for (QueryPath queryPath : translationInfo.getPathExpressions().values().stream().filter(info -> info.isUnnestedExpression).map(info -> info.queryPath).collect(Collectors.toSet())) {
            HashMap<Pair<String, String>, Integer> pathMap = new HashMap<Pair<String, String>, Integer>();
            pathMaps.put(queryPath, pathMap);
            for (Map<QueryVariable, String> instantiation : patternInstantiations) {
                Pair<String, String> key;
                if (!instantiation.containsKey(queryPath) || pathMap.containsKey(key = new Pair<String, String>(instantiation.get(queryPath.getSrc()), instantiation.get(queryPath.getDst())))) continue;
                pathMap.put(key, pathMap.size());
            }
        }
        for (Map map : patternInstantiations) {
            List<TableExpression> tables = GraphPatternTranslator.getTables(vertices, connections, map, translationInfo, metadataConnector, ctx);
            translationInfo.subqueryInfo.extraConstraints = null;
            translationInfo.subqueryInfo.parentConf = null;
            QueryExpression filterWhere = GraphPatternTranslator.translateWhere(constraints, map, metadataConnector, translationInfo);
            QueryExpression joinWhere = GraphPatternTranslator.getJoinFilter(vertices, translationInfo, map, metadataConnector, ctx);
            QueryExpression where = GraphPatternTranslator.normalize((QueryExpression)new QueryExpression.LogicalExpression.And(joinWhere, filterWhere));
            List<Pair<String, String>> solutionBlockSpecificSelectElements = GraphPatternTranslator.generateSpecificSelectElements(subSelectElems, map, pathMaps, metadataConnector, translationInfo);
            tables.addAll(GraphPatternTranslator.getXmlTables(connections, translationInfo.getPathExpressions()));
            Projection projection2 = new Projection(false, true, "", solutionBlockSpecificSelectElements, tables, GraphPatternTranslator.getWhereString(where, pathAggr, metadataConnector, ctx, subqueryInfo), Collections.emptyList(), null, Collections.emptyList(), "", "");
            allProjections.add(projection2);
        }
        subqueryInfo.parentConf = parentConf;
        subqueryInfo.extraConstraints = extraConstraints;
        return allProjections.stream().map(projection -> projection).reduce(Union::new).orElse(new EmptyProjection(subSelectElems));
    }

    private static List<Pair<String, String>> generateSpecificSelectElements(List<ExpAsVar> selectElements, Map<QueryVariable, String> conf, Map<QueryPath, Map<Pair<String, String>, Integer>> branchesMap, MetadataConnector metadataConnector, TranslationInfo translationInfo) {
        ArrayList<Pair<String, String>> translatedExpressions = new ArrayList<Pair<String, String>>();
        for (ExpAsVar expAsVar : selectElements) {
            QueryExpression translatedExpression = ExpressionTranslator.translateForSubSelect(expAsVar.getExp(), new ExpressionTranslator.SubSelectTransOptions(conf, metadataConnector, false, translationInfo));
            QueryExpression exp = expAsVar.getExp();
            if (exp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)exp).getFunctionName().equals("_ora_comp_key_f_") && translatedExpression.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)translatedExpression).getFunctionName().equals("_ora_comp_key_f_")) {
                String varName = ((QueryExpression.VarRef)((QueryExpression.FunctionCall)exp).getArgs().get(0)).getVariable().getName();
                QueryExpression.FunctionCall function = (QueryExpression.FunctionCall)translatedExpression;
                for (int j = 0; j < function.getArgs().size(); ++j) {
                    QueryExpression prop = (QueryExpression)function.getArgs().get(j);
                    translatedExpressions.add(new Pair<String, String>(prop.toString(), varName + "_" + j));
                }
                continue;
            }
            if (PathTranslator.isPathVar(expAsVar)) {
                QueryExpression tableExp = ((QueryExpression.ConcatExpression)((QueryExpression.ConcatExpression)((QueryExpression.ConcatExpression)translatedExpression).getExp1()).getExp1()).getExp1();
                QueryExpression keyExp = ((QueryExpression.ConcatExpression)((QueryExpression.ConcatExpression)translatedExpression).getExp1()).getExp2();
                keyExp = GraphPatternTranslator.escapeforPath(keyExp, false);
                String alias = expAsVar.getName().substring("$_".length());
                if (PathTranslator.needsToChar(expAsVar)) {
                    ArrayList<QueryExpression> args = new ArrayList<QueryExpression>();
                    args.add(keyExp);
                    keyExp = new QueryExpression.FunctionCall("TO_CHAR", args);
                    alias = alias.substring(0, alias.length() - "_tc".length());
                }
                translatedExpressions.add(new Pair<String, String>(GraphPatternTranslator.unescapeTableName(tableExp.toString()), alias + "_table"));
                translatedExpressions.add(new Pair<String, String>(keyExp.toString(), alias + "_key"));
                continue;
            }
            if (exp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)exp).getFunctionName().equalsIgnoreCase("id") && translatedExpression.getExpType() == QueryExpression.ExpressionType.VARREF) {
                translatedExpressions.add(new Pair<String, String>(PgqlUtils.escapeAndEnquoteIdentifier(exp.toString()), expAsVar.getName()));
                continue;
            }
            if (translatedExpression.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)translatedExpression).getFunctionName().equals("_ora_unnested_function_")) {
                QueryPath branchPath;
                Map<Pair<String, String>, Integer> pathMap;
                boolean isParentExpression = oracle.pgql.lang.ir.PgqlUtils.getVariables((QueryExpression)translatedExpression).stream().allMatch(var -> translationInfo.isParentVariable(var.getName()));
                if (isParentExpression) {
                    translatedExpressions.add(new Pair<String, String>(PgqlUtils.escapeAndEnquoteIdentifier(((QueryExpression)((QueryExpression.FunctionCall)translatedExpression).getArgs().get(0)).toString()), expAsVar.getName()));
                    continue;
                }
                QueryExpression.FunctionCall fc = (QueryExpression.FunctionCall)translatedExpression;
                QueryExpression unnestedExp = (QueryExpression)fc.getArgs().get(0);
                PathTranslator.PathExpressionInfo info = translationInfo.getPathExpressions().get(unnestedExp);
                String tableAlias = info.queryPath.getName();
                String xmlTableAlias = PgqlUtils.escapeAndEnquoteIdentifier(XmlTable.getTableAlias(tableAlias));
                if (unnestedExp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)unnestedExp).getFunctionName().equals("_ora_comp_key_f_")) {
                    QueryExpression.FunctionCall fc2 = (QueryExpression.FunctionCall)unnestedExp;
                    String varName = ((QueryExpression.VarRef)fc2.getArgs().get(0)).getVariable().getName();
                    for (int i = 0; i <= info.numKeyColumns; ++i) {
                        String keyColumn = PgqlUtils.escapeAndEnquoteIdentifier(varName + "_" + i);
                        translatedExpressions.add(new Pair<String, String>(xmlTableAlias + "." + keyColumn, keyColumn));
                    }
                    continue;
                }
                String expRef = GraphPatternTranslator.getUnnestedExpressionReference((QueryExpression.FunctionCall)translatedExpression, translationInfo.getPathExpressions());
                if (unnestedExp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)unnestedExp).getFunctionName().equalsIgnoreCase("match_number") && (pathMap = branchesMap.get(branchPath = info.queryPath)).size() > 1) {
                    int branchNumber = pathMap.get(new Pair<String, String>(conf.get(branchPath.getSrc()), conf.get(branchPath.getDst())));
                    expRef = pathMap.size() + " * (" + expRef + " - 1) + " + branchNumber + " + 1";
                }
                translatedExpressions.add(new Pair<String, String>(expRef, expAsVar.getName()));
                continue;
            }
            String alias = null;
            if (!QueryExpression.ExpressionType.STAR.equals((Object)translatedExpression.getExpType())) {
                alias = expAsVar.getName();
            }
            translatedExpressions.add(new Pair<String, String>(GraphPatternTranslator.escapePropertyAccess(translatedExpression, translationInfo), alias));
        }
        return translatedExpressions;
    }

    static String getUnnestedExpressionReference(QueryExpression.FunctionCall functionCall, Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions) {
        QueryExpression unnestedExp = (QueryExpression)functionCall.getArgs().get(0);
        String tableAlias = pathExpressions.get((Object)unnestedExp).queryPath.getName();
        String xmlTableAlias = XmlTable.getTableAlias(tableAlias);
        String expTranslation = PgqlUtils.escapeAndEnquoteIdentifier(xmlTableAlias) + "." + PgqlUtils.escapeAndEnquoteIdentifier(unnestedExp.toString());
        if (unnestedExp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL) {
            QueryExpression.FunctionCall fc = (QueryExpression.FunctionCall)unnestedExp;
            String functionName = fc.getFunctionName().toLowerCase();
            if (functionName.equals("element_number")) {
                expTranslation = PgqlUtils.escapeAndEnquoteIdentifier(xmlTableAlias) + "." + PgqlUtils.escapeAndEnquoteIdentifier("\"ROWN_$\"");
                if (pathExpressions.containsKey(fc)) {
                    OneRowPerStep orps;
                    String queryVariable = ((QueryExpression.VarRef)fc.getArgs().get(0)).getVariable().getName();
                    if (queryVariable.equals((orps = (OneRowPerStep)pathExpressions.get((Object)fc).queryPath.getRowsPerMatch()).getVertex1().getName())) {
                        expTranslation = "2 * " + expTranslation + " - 1";
                    } else if (queryVariable.equals(orps.getEdge().getName())) {
                        expTranslation = "2 * " + expTranslation;
                    } else if (queryVariable.equals(orps.getVertex2().getName())) {
                        expTranslation = "2 * " + expTranslation + " + 1";
                    }
                }
            } else if (functionName.equals("match_number")) {
                expTranslation = PgqlUtils.escapeAndEnquoteIdentifier(tableAlias) + "." + PgqlUtils.escapeAndEnquoteIdentifier("\"ROWN_$\"");
            }
        }
        return expTranslation;
    }

    static String escapePropertyAccess(QueryExpression exp, TranslationInfo info) {
        QueryExpression.VarRef varRef;
        if (exp.getExpType() == QueryExpression.ExpressionType.PROP_ACCESS) {
            QueryExpression.PropertyAccess propertyAccess = (QueryExpression.PropertyAccess)exp;
            if (info.isParentVariable(propertyAccess.getVariable().getName()) && !info.isForParentWhere()) {
                return PgqlUtils.escapeAndEnquoteIdentifier(propertyAccess.toString());
            }
            return ExpressionTranslator.escapePropertyAccess(propertyAccess);
        }
        if (exp.getExpType() == QueryExpression.ExpressionType.VARREF && info.isParentVariable((varRef = (QueryExpression.VarRef)exp).getVariable().getName()) && !info.isForParentWhere()) {
            return PgqlUtils.escapeAndEnquoteIdentifier(varRef.toString());
        }
        return exp.toString();
    }

    private static String unescapeTableName(String tableName) {
        if (tableName.startsWith("'\"") && tableName.endsWith("\"'")) {
            return "'" + tableName.substring(2, tableName.length() - 2).replaceAll("\"\"", "\"") + "'";
        }
        return tableName;
    }

    static QueryExpression escapeforPath(QueryExpression keyExp, boolean escapeCommas) {
        if (keyExp.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)keyExp).getFunctionName().equalsIgnoreCase("DECODE")) {
            QueryExpression.FunctionCall fc1 = (QueryExpression.FunctionCall)keyExp;
            QueryExpression.FunctionCall fc2 = (QueryExpression.FunctionCall)fc1.getArgs().get(0);
            keyExp = (QueryExpression)fc2.getArgs().get(0);
            if (escapeCommas) {
                keyExp = ExpressionTranslator.escapeCommas(keyExp);
            }
        } else if (keyExp.getExpType() == QueryExpression.ExpressionType.CONCAT) {
            QueryExpression.ConcatExpression ce = (QueryExpression.ConcatExpression)keyExp;
            QueryExpression.ConcatExpression exp1 = (QueryExpression.ConcatExpression)ce.getExp1();
            exp1.setExp1(GraphPatternTranslator.escapeforPath(exp1.getExp1(), true));
            ce.setExp2(GraphPatternTranslator.escapeforPath(ce.getExp2(), true));
        }
        return keyExp;
    }

    private static QueryExpression normalize(QueryExpression queryExpression) {
        if (queryExpression.getExpType() == QueryExpression.ExpressionType.AND) {
            QueryExpression.Constant.ConstBoolean constantExpression;
            QueryExpression.LogicalExpression.And andExpression = (QueryExpression.LogicalExpression.And)queryExpression;
            QueryExpression expr1 = GraphPatternTranslator.normalize(andExpression.getExp1());
            QueryExpression expr2 = GraphPatternTranslator.normalize(andExpression.getExp2());
            if (expr1.getExpType() == QueryExpression.ExpressionType.BOOLEAN && ((Boolean)(constantExpression = (QueryExpression.Constant.ConstBoolean)expr1).getValue()).booleanValue()) {
                return expr2;
            }
            if (expr2.getExpType() == QueryExpression.ExpressionType.BOOLEAN && ((Boolean)(constantExpression = (QueryExpression.Constant.ConstBoolean)expr2).getValue()).booleanValue()) {
                return expr1;
            }
            return new QueryExpression.LogicalExpression.And(expr1, expr2);
        }
        return queryExpression;
    }

    private static String getWhereString(QueryExpression whereExpression, Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions, MetadataConnector metadataConnector, QueryContext ctx, SubqueryInfo subqueryInfo) {
        if (whereExpression.getExpType() == QueryExpression.ExpressionType.BOOLEAN) {
            QueryExpression.Constant.ConstBoolean boolExpr = (QueryExpression.Constant.ConstBoolean)whereExpression;
            if (((Boolean)boolExpr.getValue()).booleanValue()) {
                return "";
            }
            return "1 <> 1";
        }
        return ExpressionTranslator.translateQueryExpression(whereExpression, new ExpressionTranslator.QueryExpTransOptions(false, false, true, false, pathExpressions, metadataConnector, ctx, subqueryInfo.extraConstraints, subqueryInfo.parentConf, subqueryInfo));
    }

    private static QueryExpression getJoinFilter(Set<QueryVertex> vertices, TranslationInfo translationInfo, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, QueryContext ctx) {
        QueryExpression.Constant.ConstBoolean joinFilter = new QueryExpression.Constant.ConstBoolean(true);
        for (QueryVertex v : vertices) {
            if (!translationInfo.needParentLabelJoin((QueryVariable)v)) continue;
            QueryExpression.FunctionCall labelExp = new QueryExpression.FunctionCall("label", PgqlUtils.buildList(new QueryExpression.VarRef(translationInfo.getParentVariable(v.getName()))));
            joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)new QueryExpression.Constant.ConstString(metadataConnector.getLabelForVertexTable(conf.get(v))), (QueryExpression)labelExp));
        }
        Map<QueryVariable, List<Pair<VertexPairConnection, TranslationInfo.Position>>> vertexConnections = translationInfo.getVertexConnections();
        for (QueryVariable v : vertexConnections.keySet()) {
            List<Pair<VertexPairConnection, TranslationInfo.Position>> parentConnections;
            List<Pair<VertexPairConnection, TranslationInfo.Position>> connections = vertexConnections.get(v);
            if (translationInfo.isParentVariable(v.getName()) && (parentConnections = translationInfo.getCommonVertexConnections(v)).size() > 0) {
                if (translationInfo.isForParentWhere()) {
                    if (((VertexPairConnection)parentConnections.get((int)0).first).getVariableType() == QueryVariable.VariableType.PATH && connections.size() > 0 && ((VertexPairConnection)connections.get((int)0).first).getVariableType() == QueryVariable.VariableType.EDGE && !ctx.sbqJoinWorks()) {
                        throw new UnsupportedOperationException("Pattern not supported for 21c and older DB versions");
                    }
                    connections.addAll(parentConnections);
                } else if (connections.size() > 0) {
                    Pair<VertexPairConnection, TranslationInfo.Position> child = connections.get(0);
                    Pair<VertexPairConnection, TranslationInfo.Position> parent = parentConnections.get(0);
                    joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, GraphPatternTranslator.getChildParentConnectionsJoin(child, parent, conf, metadataConnector));
                }
            }
            if (connections.size() > 1) {
                Pair<VertexPairConnection, TranslationInfo.Position> pos1 = connections.get(0);
                for (int i = 1; i < connections.size(); ++i) {
                    Pair<VertexPairConnection, TranslationInfo.Position> pos2 = connections.get(i);
                    joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, GraphPatternTranslator.getConnectionsJoin(pos1, pos2, conf, metadataConnector));
                    pos1 = pos2;
                }
            }
            if (translationInfo.needVertexConnectionJoin(v)) {
                joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, GraphPatternTranslator.getVertexConnectionJoin(connections.get(0), (QueryVertex)v, conf, metadataConnector, translationInfo));
                continue;
            }
            Pair<VertexPairConnection, TranslationInfo.Position> edge = translationInfo.getEdgeConnection(v);
            if (edge == null) continue;
            joinFilter = new QueryExpression.LogicalExpression.And((QueryExpression)joinFilter, GraphPatternTranslator.getEdgeKeyNotNull(edge, conf, metadataConnector));
        }
        return joinFilter;
    }

    private static QueryExpression getConnectionsJoin(Pair<VertexPairConnection, TranslationInfo.Position> pos1, Pair<VertexPairConnection, TranslationInfo.Position> pos2, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        VertexPairConnection conn1 = (VertexPairConnection)pos1.first;
        VertexPairConnection conn2 = (VertexPairConnection)pos2.first;
        if (conn1.getVariableType() == QueryVariable.VariableType.EDGE && conn2.getVariableType() == QueryVariable.VariableType.EDGE) {
            List<String> key1 = GraphPatternTranslator.getEdgeSrcOrDstKey(pos1, conf, metadataConnector);
            List<String> key2 = GraphPatternTranslator.getEdgeSrcOrDstKey(pos2, conf, metadataConnector);
            for (int i = 0; i < key1.size(); ++i) {
                QueryExpression.PropertyAccess key1Access = new QueryExpression.PropertyAccess((QueryVariable)conn1, key1.get(i));
                QueryExpression.PropertyAccess key2Access = new QueryExpression.PropertyAccess((QueryVariable)conn2, key2.get(i));
                join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)key1Access, (QueryExpression)key2Access));
            }
        } else {
            Pair<QueryExpression, QueryExpression> exp1 = GraphPatternTranslator.getSrcOrDstTableAndKeyExp(pos1, conf, metadataConnector);
            Pair<QueryExpression, QueryExpression> exp2 = GraphPatternTranslator.getSrcOrDstTableAndKeyExp(pos2, conf, metadataConnector);
            join = new QueryExpression.LogicalExpression.And((QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)exp1.first, (QueryExpression)exp2.first), (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)exp1.second, (QueryExpression)exp2.second));
        }
        return join;
    }

    private static QueryExpression getChildParentConnectionsJoin(Pair<VertexPairConnection, TranslationInfo.Position> child, Pair<VertexPairConnection, TranslationInfo.Position> parent, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryVertex commonVertex;
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        VertexPairConnection conn1 = (VertexPairConnection)child.first;
        VertexPairConnection conn2 = (VertexPairConnection)parent.first;
        QueryVertex queryVertex = commonVertex = parent.second == TranslationInfo.Position.SRC ? conn2.getSrc() : conn2.getDst();
        if (conn1.getVariableType() == QueryVariable.VariableType.EDGE && conn2.getVariableType() == QueryVariable.VariableType.EDGE) {
            List<String> key1 = GraphPatternTranslator.getEdgeSrcOrDstKey(child, conf, metadataConnector);
            for (int i = 0; i < key1.size(); ++i) {
                QueryExpression.PropertyAccess key1Access = new QueryExpression.PropertyAccess((QueryVariable)conn1, key1.get(i));
                QueryExpression key2Access = GraphPatternTranslator.buildKeyColumnReference((QueryVariable)commonVertex, i + 1);
                join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)key1Access, key2Access));
            }
        } else {
            Pair<QueryExpression, QueryExpression> exp1 = GraphPatternTranslator.getSrcOrDstTableAndKeyExp(child, conf, metadataConnector);
            QueryExpression parentTable = GraphPatternTranslator.buildKeyColumnReference((QueryVariable)commonVertex, 0);
            QueryExpression parentKey = GraphPatternTranslator.getKeyExpForParentPath(commonVertex, conf, metadataConnector);
            join = new QueryExpression.LogicalExpression.And((QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)exp1.first, parentTable), (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)exp1.second, parentKey));
        }
        return join;
    }

    private static List<String> getEdgeSrcOrDstKey(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        return GraphPatternTranslator.getEdgeSrcOrDstKeyPair(connection, conf, metadataConnector).stream().map(pair -> (String)pair.first).collect(Collectors.toList());
    }

    private static List<Pair<String, String>> getEdgeSrcOrDstKeyPair(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        String edge = conf.get(connection.first);
        List<Pair<String, String>> key = connection.second == TranslationInfo.Position.SRC ? metadataConnector.getEdgeTableSrcKey(edge) : metadataConnector.getEdgeTableDstKey(edge);
        return key;
    }

    private static Pair<QueryExpression, QueryExpression> getSrcOrDstTableAndKeyExp(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression keyExp;
        QueryExpression tableExp;
        if (((VertexPairConnection)connection.first).getVariableType() == QueryVariable.VariableType.PATH) {
            tableExp = new QueryExpression.PropertyAccess((QueryVariable)connection.first, connection.second + "_TABLE");
            keyExp = new QueryExpression.PropertyAccess((QueryVariable)connection.first, connection.second + "_KEY");
        } else {
            tableExp = GraphPatternTranslator.getSrcOrDstTable(connection, conf);
            keyExp = GraphPatternTranslator.getKeyExpForPath(GraphPatternTranslator.getEdgeSrcOrDstKey(connection, conf, metadataConnector), (QueryVariable)connection.first, conf.get(connection.first), metadataConnector);
        }
        return new Pair<QueryExpression, QueryExpression>(tableExp, keyExp);
    }

    private static QueryExpression getSrcOrDstTable(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf) {
        QueryVertex vertex = connection.second == TranslationInfo.Position.SRC ? ((VertexPairConnection)connection.first).getSrc() : ((VertexPairConnection)connection.first).getDst();
        return new QueryExpression.Constant.ConstString(conf.get(vertex));
    }

    private static QueryExpression getKeyExpForPath(List<String> keyColumns, QueryVariable variable, String tableName, MetadataConnector metadataConnector) {
        QueryExpression keyExp = null;
        boolean escapeKeyCol = keyColumns.size() > 1;
        for (String keyCol : keyColumns) {
            Object colAccess = escapeKeyCol ? ExpressionTranslator.escapeKeyColumnForPath(variable, keyCol, tableName, metadataConnector) : new QueryExpression.PropertyAccess(variable, keyCol);
            if (keyExp == null) {
                keyExp = colAccess;
                continue;
            }
            keyExp = new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression(keyExp, (QueryExpression)new QueryExpression.Constant.ConstString(",")), colAccess);
        }
        return keyExp;
    }

    private static QueryExpression getKeyExpForParentPath(QueryVertex commonVertex, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        Object keyExp = null;
        int numKeyCols = metadataConnector.getVertexTableKey(conf.get(commonVertex)).size();
        for (int i = 1; i <= numKeyCols; ++i) {
            QueryExpression colAccess = GraphPatternTranslator.buildKeyColumnReference((QueryVariable)commonVertex, i);
            keyExp = keyExp == null ? colAccess : new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression(keyExp, (QueryExpression)new QueryExpression.Constant.ConstString(",")), colAccess);
        }
        return keyExp;
    }

    private static QueryExpression getVertexConnectionJoin(Pair<VertexPairConnection, TranslationInfo.Position> connection, QueryVertex vertex, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, TranslationInfo translationInfo) {
        boolean isParentVariable = translationInfo.isParentVertex(vertex.getName());
        boolean canSplitKey = translationInfo.canSplitId(vertex.getName());
        String vertexTable = conf.get(vertex);
        if (((VertexPairConnection)connection.first).getVariableType() == QueryVariable.VariableType.EDGE) {
            List<Pair<String, String>> edgeTableKey = GraphPatternTranslator.getEdgeSrcOrDstKeyPair(connection, conf, metadataConnector);
            return GraphPatternTranslator.getVertexEdgeJoin(edgeTableKey, (QueryEdge)connection.first, vertex, isParentVariable, canSplitKey, vertexTable, translationInfo.isForParentWhere());
        }
        return GraphPatternTranslator.getVertexPathJoin((QueryPath)connection.first, vertex, (TranslationInfo.Position)((Object)connection.second), conf, metadataConnector, isParentVariable, canSplitKey, translationInfo.isForParentWhere());
    }

    private static QueryExpression getVertexEdgeJoin(List<Pair<String, String>> edgeTableKey, QueryEdge edge, QueryVertex vertex, boolean isParentVariable, boolean canSplitKey, String vertexTableName, boolean forParentWhere) {
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        if (isParentVariable && !forParentWhere) {
            if (canSplitKey) {
                QueryExpression tableName = GraphPatternTranslator.buildKeyColumnReference((QueryVariable)vertex, 0);
                QueryExpression.RelationalExpression.Equal tableFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)new QueryExpression.Constant.ConstString(vertexTableName), tableName);
                join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)tableFilter);
                for (int i = 0; i < edgeTableKey.size(); ++i) {
                    Pair<String, String> keyColumn = edgeTableKey.get(i);
                    QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)edge, (String)keyColumn.first);
                    QueryExpression vertexKey = GraphPatternTranslator.buildKeyColumnReference((QueryVariable)vertex, i + 1);
                    QueryExpression.RelationalExpression.Equal vertexFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)keyAccess, vertexKey);
                    join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)vertexFilter);
                }
            } else {
                QueryExpression.PropertyAccess concat = new QueryExpression.PropertyAccess((QueryVariable)edge, (String)edgeTableKey.get((int)0).first);
                for (int i = 1; i < edgeTableKey.size(); ++i) {
                    concat = new QueryExpression.ConcatExpression((QueryExpression)concat, (QueryExpression)new QueryExpression.Constant.ConstString(","));
                    concat = new QueryExpression.ConcatExpression((QueryExpression)concat, (QueryExpression)new QueryExpression.PropertyAccess((QueryVariable)edge, (String)edgeTableKey.get((int)i).first));
                }
                QueryExpression.ConcatExpression edgeKey = new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.Constant.ConstString(vertexTableName), (QueryExpression)new QueryExpression.Constant.ConstString("(")), (QueryExpression)concat), (QueryExpression)new QueryExpression.Constant.ConstString(")"));
                join = new QueryExpression.RelationalExpression.Equal((QueryExpression)new QueryExpression.VarRef((QueryVariable)vertex), (QueryExpression)edgeKey);
            }
        } else {
            for (Pair<String, String> keyColumn : edgeTableKey) {
                QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)edge, (String)keyColumn.first);
                QueryExpression.PropertyAccess vertexKey = new QueryExpression.PropertyAccess((QueryVariable)vertex, (String)keyColumn.second);
                QueryExpression.RelationalExpression.Equal vertexFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)keyAccess, (QueryExpression)vertexKey);
                join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)vertexFilter);
            }
        }
        return join;
    }

    private static QueryExpression buildKeyColumnReference(QueryVariable var, int idx) {
        return new QueryExpression.FunctionCall("_ora_varref_function_", PgqlUtils.buildList(new QueryExpression.VarRef((QueryVariable)new ExpAsVar((QueryExpression)new QueryExpression.VarRef(var), var.getName() + "_" + idx, false))));
    }

    private static QueryExpression getVertexPathJoin(QueryPath path, QueryVertex vertex, TranslationInfo.Position variableName, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, boolean isParentVariable, boolean canSplitKey, boolean isForParentWhere) {
        QueryExpression.PropertyAccess tableAccess = new QueryExpression.PropertyAccess((QueryVariable)path, (Object)((Object)variableName) + "_TABLE");
        QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)path, (Object)((Object)variableName) + "_KEY");
        String tab = conf.get(vertex);
        if (isParentVariable && !isForParentWhere) {
            if (canSplitKey) {
                QueryExpression tableName = GraphPatternTranslator.buildKeyColumnReference((QueryVariable)vertex, 0);
                QueryExpression.RelationalExpression.Equal tableFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)new QueryExpression.Constant.ConstString(tab), tableName);
                List<String> vertexTableKey = metadataConnector.getVertexTableKey(tab);
                QueryExpression vertexKey = GraphPatternTranslator.buildKeyColumnReference((QueryVariable)vertex, 1);
                for (int i = 1; i < vertexTableKey.size(); ++i) {
                    vertexKey = new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.ConcatExpression(vertexKey, (QueryExpression)new QueryExpression.Constant.ConstString(",")), GraphPatternTranslator.buildKeyColumnReference((QueryVariable)vertex, i + 1));
                }
                QueryExpression.RelationalExpression.Equal vertexFilter = new QueryExpression.RelationalExpression.Equal((QueryExpression)keyAccess, vertexKey);
                return new QueryExpression.LogicalExpression.And((QueryExpression)tableFilter, (QueryExpression)vertexFilter);
            }
            QueryExpression.VarRef vertexKey = new QueryExpression.VarRef((QueryVariable)vertex);
            QueryExpression.ConcatExpression compositeKey = new QueryExpression.ConcatExpression((QueryExpression)tableAccess, (QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)new QueryExpression.Constant.ConstString("("), (QueryExpression)new QueryExpression.ConcatExpression((QueryExpression)keyAccess, (QueryExpression)new QueryExpression.Constant.ConstString(")"))));
            return new QueryExpression.RelationalExpression.Equal((QueryExpression)compositeKey, (QueryExpression)vertexKey);
        }
        List<String> keyColumns = metadataConnector.getVertexTableKey(tab);
        QueryExpression vertexKey = GraphPatternTranslator.getKeyExpForPath(keyColumns, (QueryVariable)vertex, tab, metadataConnector);
        return new QueryExpression.LogicalExpression.And((QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)tableAccess, (QueryExpression)new QueryExpression.Constant.ConstString(tab)), (QueryExpression)new QueryExpression.RelationalExpression.Equal((QueryExpression)keyAccess, vertexKey));
    }

    private static QueryExpression getEdgeKeyNotNull(Pair<VertexPairConnection, TranslationInfo.Position> connection, Map<QueryVariable, String> conf, MetadataConnector metadataConnector) {
        QueryExpression.Constant.ConstBoolean join = new QueryExpression.Constant.ConstBoolean(true);
        List<String> edgeKey = GraphPatternTranslator.getEdgeSrcOrDstKey(connection, conf, metadataConnector);
        for (String keyColumn : edgeKey) {
            QueryExpression.PropertyAccess keyAccess = new QueryExpression.PropertyAccess((QueryVariable)connection.first, keyColumn);
            QueryExpression.LogicalExpression.Not edgeFilter = new QueryExpression.LogicalExpression.Not((QueryExpression)new QueryExpression.IsNull((QueryExpression)keyAccess));
            join = new QueryExpression.LogicalExpression.And((QueryExpression)join, (QueryExpression)edgeFilter);
        }
        return join;
    }

    private static QueryExpression translateWhere(Set<QueryExpression> constraints, Map<QueryVariable, String> conf, MetadataConnector metadataConnector, TranslationInfo translationInfo) {
        return constraints.stream().filter(queryExpression -> !LabelTranslator.isLabelExpression(queryExpression) || GraphPatternTranslator.isPathExpression(queryExpression, translationInfo.getPathExpressions().keySet())).map(queryExpression -> ExpressionTranslator.translateForSubSelect(queryExpression, new ExpressionTranslator.SubSelectTransOptions(conf, metadataConnector, true, translationInfo))).reduce((QueryExpression)new QueryExpression.Constant.ConstBoolean(true), QueryExpression.LogicalExpression.And::new);
    }

    private static boolean isPathExpression(QueryExpression queryExpression, Set<QueryExpression> pathExpressions) {
        QueryExpression.FunctionCall functionCall;
        if (pathExpressions.contains(queryExpression)) {
            return true;
        }
        if (queryExpression.getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && (functionCall = (QueryExpression.FunctionCall)queryExpression).getFunctionName().equals("has_label")) {
            return pathExpressions.contains(new QueryExpression.FunctionCall("label", Collections.singletonList((QueryExpression)functionCall.getArgs().get(0))));
        }
        return false;
    }

    private static List<TableExpression> getTables(Set<QueryVertex> vertices, Set<VertexPairConnection> connections, Map<QueryVariable, String> variableTableMap, TranslationInfo translationInfo, MetadataConnector metadataConnector, QueryContext ctx) {
        List<TableExpression> allTables = vertices.stream().filter(translationInfo::needVertexConnectionJoin).filter(v -> translationInfo.isNotCommonVariableInSubquery(v.getName())).map(queryVertex -> new TableReference(metadataConnector.getSchemaQualifiedVertexTableName((String)variableTableMap.get(queryVertex)), (QueryVariable)queryVertex)).collect(Collectors.toList());
        connections.stream().filter(conn -> conn.getVariableType() == QueryVariable.VariableType.EDGE).map(conn -> (QueryEdge)conn).forEach(queryEdge -> allTables.add(new TableReference(metadataConnector.getSchemaQualifiedEdgeTableName((String)variableTableMap.get(queryEdge)), (QueryVariable)queryEdge)));
        connections.stream().filter(conn -> conn.getVariableType() == QueryVariable.VariableType.PATH).map(conn -> (QueryPath)conn).forEach(queryPath -> allTables.add(PathTranslator.translatePath(queryPath, variableTableMap, metadataConnector, translationInfo, ctx)));
        return allTables;
    }

    private static List<TableExpression> getXmlTables(Set<VertexPairConnection> connections, Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions) {
        ArrayList<TableExpression> xmlTables = new ArrayList<TableExpression>();
        connections.stream().filter(conn -> conn.getVariableType() == QueryVariable.VariableType.PATH).map(conn -> (QueryPath)conn).filter(queryPath -> queryPath.getRowsPerMatch().getRowsPerMatchType() == RowsPerMatchType.ONE_ROW_PER_STEP).forEach(queryPath -> {
            ArrayList<XmlTable.Column> columns = new ArrayList<XmlTable.Column>();
            boolean isReversed = false;
            boolean addRownum = false;
            for (Map.Entry entry : pathExpressions.entrySet()) {
                PathTranslator.PathExpressionInfo info = (PathTranslator.PathExpressionInfo)entry.getValue();
                if (!info.isUnnestedExpression || !info.queryPath.equals(queryPath)) continue;
                if (info.isReversed) {
                    isReversed = true;
                }
                if (((QueryExpression)entry.getKey()).getExpType() == QueryExpression.ExpressionType.FUNCTION_CALL && ((QueryExpression.FunctionCall)entry.getKey()).getFunctionName().equals("_ora_comp_key_f_")) {
                    String varName = ((QueryExpression.VarRef)((QueryExpression.FunctionCall)entry.getKey()).getArgs().get(0)).getVariable().getName();
                    for (int i = 0; i <= ((PathTranslator.PathExpressionInfo)entry.getValue()).numKeyColumns; ++i) {
                        columns.add(new XmlTable.Column(varName + "_" + i, "varchar2(4000)", "/EXPRESSIONS/EXP" + info.expNumber + "/" + "K" + i));
                    }
                    continue;
                }
                if (info.requiresElementNumber) {
                    addRownum = true;
                    continue;
                }
                columns.add(new XmlTable.Column(((QueryExpression)entry.getKey()).toString(), ((PathTranslator.PathExpressionInfo)entry.getValue()).dataType == null ? "varchar2(4000)" : ((PathTranslator.PathExpressionInfo)entry.getValue()).dataType, "/EXPRESSIONS/EXP" + info.expNumber));
            }
            if (columns.size() > 0 || addRownum) {
                xmlTables.add(new XmlTable(queryPath.getName(), columns, addRownum, isReversed));
            }
        });
        return xmlTables;
    }

    static List<QueryExpression> getSubSelectElements(QueryExpression exp, final Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions, final Map<QueryVariable, QueryPath> pathVariables, final Map<String, QueryPath> unnestedVariables, final Map<String, Pair<Boolean, QueryVariable>> variables, final Set<QueryVertex> commonJoinVertices, final Set<QueryVertex> commonVertices) {
        final ArrayList<QueryExpression> subSelectElements = new ArrayList<QueryExpression>();
        exp.accept((QueryExpressionVisitor)new SubqueryVisitor(){

            @Override
            public void visitVarRef(QueryExpression.VarRef varRef) {
                QueryVariable variable = varRef.getVariable();
                if (!variable.isAnonymous() && variables.containsKey(variable.getName())) {
                    switch (variable.getVariableType()) {
                        case VERTEX: 
                        case EDGE: {
                            subSelectElements.add(varRef);
                        }
                    }
                }
                if (unnestedVariables.containsKey(variable.getName()) && !pathExpressions.containsKey(varRef)) {
                    pathExpressions.put(varRef, new PathTranslator.PathExpressionInfo((QueryPath)unnestedVariables.get(variable.getName()), pathExpressions.size() + 1, null, true, false));
                }
            }

            @Override
            public void visitPropertyAccess(QueryExpression.PropertyAccess prop) {
                if (variables.containsKey(prop.getVariable().getName())) {
                    QueryVariable v;
                    if (unnestedVariables.containsKey(prop.getVariable().getName()) && !pathExpressions.containsKey(prop)) {
                        pathExpressions.put(prop, new PathTranslator.PathExpressionInfo((QueryPath)unnestedVariables.get(prop.getVariable().getName()), pathExpressions.size() + 1, null, true, false));
                    }
                    if (!ExpressionTranslator.getQueryVariable(v = (QueryVariable)((Pair)variables.get((Object)prop.getVariable().getName())).second).getName().equals(prop.getVariable().getName())) {
                        prop.setVariable(v);
                    }
                    subSelectElements.add(prop);
                }
            }

            private void addFunctionToSubselect(QueryExpression.FunctionCall functionCall) {
                if (functionCall.getArgs().stream().allMatch(arg -> {
                    QueryVariable v = ((QueryExpression.VarRef)arg).getVariable();
                    return variables.containsKey(v.getName());
                })) {
                    subSelectElements.add(functionCall);
                }
            }

            private boolean isUnnestedVariable(QueryExpression exp) {
                QueryVariable v = ((QueryExpression.VarRef)exp).getVariable();
                return unnestedVariables.containsKey(v.getName());
            }

            private void addFunctionToPathExpressions(QueryExpression.FunctionCall functionCall) {
                if (functionCall.getArgs().stream().allMatch(this::isUnnestedVariable) && !pathExpressions.containsKey(functionCall)) {
                    pathExpressions.put(functionCall, new PathTranslator.PathExpressionInfo((QueryPath)unnestedVariables.get(((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable().getName()), pathExpressions.size() + 1, null, true, false));
                }
            }

            @Override
            public void visitIdOrLabelFunction(QueryExpression.FunctionCall functionCall) {
                this.addFunctionToSubselect(functionCall);
                this.addFunctionToPathExpressions(functionCall);
            }

            @Override
            public void visitKeyColumnsFunction(QueryExpression.FunctionCall functionCall) {
                this.addFunctionToSubselect(functionCall);
                this.addFunctionToPathExpressions(functionCall);
            }

            @Override
            public void visitVarRefSubqueryFunction(QueryExpression.FunctionCall functionCall) {
            }

            @Override
            public void visitIsSourceOrIsDestOfFunction(QueryExpression.FunctionCall functionCall) {
                this.addFunctionToSubselect(functionCall);
                this.addFunctionToPathExpressions(functionCall);
            }

            @Override
            public void visitSrcDstPredicate(QueryExpression.SourceDestinationPredicate sourceDestinationPredicate) {
                if (variables.containsKey(sourceDestinationPredicate.getEdgeReference().getVariable().getName()) && variables.containsKey(sourceDestinationPredicate.getVertexReference().getVariable().getName())) {
                    subSelectElements.add(sourceDestinationPredicate);
                }
            }

            @Override
            public void visitHasLabelFunction(QueryExpression.FunctionCall functionCall) {
                QueryExpression.FunctionCall labelFunctionCall;
                if (variables.containsKey(((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable().getName())) {
                    subSelectElements.add(new QueryExpression.FunctionCall("label", PgqlUtils.buildList((QueryExpression)functionCall.getArgs().get(0))));
                    subSelectElements.addAll(GraphPatternTranslator.getSubSelectElements((QueryExpression)functionCall.getArgs().get(1), pathExpressions, pathVariables, unnestedVariables, variables, commonJoinVertices, commonVertices));
                }
                if (this.isUnnestedVariable((QueryExpression)functionCall.getArgs().get(0)) && !pathExpressions.containsKey(labelFunctionCall = new QueryExpression.FunctionCall("label", PgqlUtils.buildList((QueryExpression)functionCall.getArgs().get(0))))) {
                    pathExpressions.put(labelFunctionCall, new PathTranslator.PathExpressionInfo((QueryPath)unnestedVariables.get(((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable().getName()), pathExpressions.size() + 1, null, true, false));
                }
            }

            @Override
            public void visitMatchnumOrElementNumber(QueryExpression.FunctionCall functionCall) {
                this.addFunctionToSubselect(functionCall);
                if (functionCall.getArgs().size() != 1) {
                    throw new PgqlToSqlException("Wrong number of elements in function call: " + functionCall.getFunctionName() + " should have 1 argument");
                }
                QueryVariable v = ((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable();
                if (unnestedVariables.containsKey(v.getName()) && !pathExpressions.containsKey(functionCall)) {
                    pathExpressions.put(functionCall, new PathTranslator.PathExpressionInfo((QueryPath)unnestedVariables.get(v.getName()), pathExpressions.size() + 1, null, true, true));
                }
            }

            @Override
            public void visitAggregation(QueryExpression.Aggregation.AbstractAggregation agg) {
                QueryPath queryPath = GraphPatternTranslator.isPathAggregation((QueryExpression.Aggregation)agg, pathVariables);
                if (queryPath != null) {
                    pathExpressions.put(agg, new PathTranslator.PathExpressionInfo(queryPath, pathExpressions.size() + 1, null, false, false));
                    subSelectElements.add(agg);
                } else {
                    subSelectElements.addAll(GraphPatternTranslator.getSubSelectElements(agg.getExp(), pathExpressions, pathVariables, unnestedVariables, variables, commonJoinVertices, commonVertices));
                }
            }

            public void visit(QueryExpression.ScalarSubquery scalarSubquery) {
                this.visitSubquery((QueryExpression.Subquery)scalarSubquery);
            }

            public void visit(QueryExpression.Function.Exists exists) {
                this.visitSubquery((QueryExpression.Subquery)exists);
            }

            public void visitSubquery(QueryExpression.Subquery subquery) {
                this.visit(subquery.getQuery());
                for (oracle.pgql.lang.ir.TableExpression t : subquery.getQuery().getTableExpressions()) {
                    switch (t.getTableExpressionType()) {
                        case GRAPH_PATTERN: {
                            this.visitGraphPattern((GraphPattern)t);
                            break;
                        }
                        case DERIVED_TABLE: {
                            this.visitSubquery((QueryExpression.Subquery)((DerivedTable)t));
                        }
                    }
                }
            }

            private void visitGraphPattern(GraphPattern gp) {
                gp.getConnections().forEach(e -> {
                    if (variables.containsKey(e.getSrc().getName())) {
                        commonJoinVertices.add(e.getSrc());
                    }
                    if (variables.containsKey(e.getDst().getName())) {
                        commonJoinVertices.add(e.getDst());
                    }
                });
                gp.getVertices().forEach(v -> {
                    if (variables.containsKey(v.getName())) {
                        commonVertices.add(v);
                        QueryExpression.FunctionCall labelFunctionCall = new QueryExpression.FunctionCall("label", PgqlUtils.buildList(new QueryExpression.VarRef((QueryVariable)((Pair)variables2.get((Object)v.getName())).second)));
                        subSelectElements.add(labelFunctionCall);
                        if (unnestedVariables.containsKey(v.getName()) && !pathExpressions.containsKey(labelFunctionCall)) {
                            pathExpressions.put(labelFunctionCall, new PathTranslator.PathExpressionInfo((QueryPath)unnestedVariables.get(v.getName()), pathExpressions.size() + 1, null, true, false));
                        }
                    }
                });
            }
        });
        return subSelectElements;
    }

    private static List<QueryExpression> getAggregates(QueryExpression exp) {
        final ArrayList<QueryExpression> aggregates = new ArrayList<QueryExpression>();
        exp.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(QueryExpression.Aggregation.AggrCount aggrCount) {
                aggregates.add(aggrCount);
            }

            public void visit(QueryExpression.Aggregation.AggrListagg aggrListagg) {
                aggregates.add(aggrListagg);
            }

            public void visit(QueryExpression.Aggregation.AggrJsonArrayagg aggrJsonArrayagg) {
                aggregates.add(aggrJsonArrayagg);
            }

            public void visit(QueryExpression.Aggregation.AggrMin aggrMin) {
                aggregates.add(aggrMin);
            }

            public void visit(QueryExpression.Aggregation.AggrMax aggrMax) {
                aggregates.add(aggrMax);
            }

            public void visit(QueryExpression.Aggregation.AggrSum aggrSum) {
                aggregates.add(aggrSum);
            }

            public void visit(QueryExpression.Aggregation.AggrAvg aggrAvg) {
                aggregates.add(aggrAvg);
            }

            public void visit(QueryExpression.Aggregation.AggrArrayAgg aggrArrayagg) {
                aggregates.add(aggrArrayagg);
            }
        });
        return aggregates;
    }

    private static QueryPath isPathAggregation(QueryExpression.Aggregation aggregation, Map<QueryVariable, QueryPath> pathVariables) {
        boolean hasAggregates = GraphPatternTranslator.getAggregates(((QueryExpression.Aggregation.AbstractAggregation)aggregation).getExp()).size() > 0;
        for (QueryVariable variable : oracle.pgql.lang.ir.PgqlUtils.getVariables((QueryExpression)aggregation)) {
            if (!pathVariables.containsKey(variable) || hasAggregates) continue;
            return pathVariables.get(variable);
        }
        return null;
    }

    static void addSubSelectElements(QueryExpression queryExpression, List<ExpAsVar> subSelectProj, Set<String> subSelectVars, Map<QueryExpression, PathTranslator.PathExpressionInfo> pathExpressions, Map<QueryVariable, QueryPath> pathVariables, Map<String, QueryPath> unnestedVariables, boolean addProjection, Map<String, Pair<Boolean, QueryVariable>> variables, Set<QueryVertex> commonJoinVertices, Set<QueryVertex> commonVertices) {
        List<QueryExpression> queryExpressions = GraphPatternTranslator.getSubSelectElements(queryExpression, pathExpressions, pathVariables, unnestedVariables, variables, commonJoinVertices, commonVertices);
        for (QueryExpression exp : queryExpressions) {
            if (!addProjection) continue;
            GraphPatternTranslator.addSubSelectExpression(exp, subSelectVars, subSelectProj);
        }
    }

    static void addSubSelectExpression(ExpAsVar expAsVar, Set<String> subSelectVars, List<ExpAsVar> subSelectProj) {
        String subSelectVar = expAsVar.toString();
        String escapedVar = PgqlUtils.escapeAndEnquoteIdentifier(subSelectVar);
        if (!subSelectVars.contains(escapedVar)) {
            subSelectProj.add(expAsVar);
            subSelectVars.add(escapedVar);
        }
    }

    static void addSubSelectExpression(QueryExpression exp, Set<String> subSelectVars, List<ExpAsVar> subSelectProj) {
        String subSelectVar = exp.toString();
        String escapedVar = PgqlUtils.escapeAndEnquoteIdentifier(subSelectVar);
        if (!subSelectVars.contains(escapedVar)) {
            subSelectProj.add(new ExpAsVar(exp, subSelectVar, false));
            subSelectVars.add(escapedVar);
        }
    }

    static int getCompatibleKeyColumns(QueryVertex vertex, GraphPattern graphPattern, MetadataConnector metadataConnector) {
        TableTranslator.VariableTableBinding variableTableBinding = TableTranslator.generateVariableTableBinding(graphPattern, metadataConnector);
        return GraphPatternTranslator.getCompatibleKeyColumns(vertex, metadataConnector, variableTableBinding);
    }

    static int getCompatibleKeyColumns(QueryVertex vertex, MetadataConnector metadataConnector, TableTranslator.VariableTableBinding variableTableBinding) {
        int numKeyColumns = -1;
        List<String> keyTypes = null;
        for (String table : variableTableBinding.vertexTableMap.get(vertex)) {
            List<String> currentKeyTypes = metadataConnector.getVertexTableKeyTypes(table);
            if (keyTypes == null) {
                keyTypes = currentKeyTypes;
                numKeyColumns = currentKeyTypes.size();
                continue;
            }
            if (currentKeyTypes.size() != numKeyColumns) {
                return -1;
            }
            for (int i = 0; i < numKeyColumns; ++i) {
                if (GraphPatternTranslator.areCompatibleTypes(currentKeyTypes.get(i), keyTypes.get(i))) continue;
                return -1;
            }
        }
        return numKeyColumns;
    }

    public static boolean areCompatibleTypes(String type1, String type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (type1.equals(type2)) {
            return true;
        }
        return GraphPatternTranslator.getTypeFamily(type1).equals(GraphPatternTranslator.getTypeFamily(type2));
    }

    private static String getTypeFamily(String type) {
        switch (type) {
            case "CHAR": 
            case "VARCHAR2": 
            case "CHARACTER": 
            case "VARCHAR": {
                return "CHAR";
            }
            case "NCHAR": 
            case "NVARCHAR2": 
            case "NATIONAL CHARACTER": 
            case "NATIONAL CHAR": {
                return "NCHAR";
            }
            case "NUMBER": 
            case "FLOAT": 
            case "BINARY_FLOAT": 
            case "BINARY_DOUBLE": 
            case "NUMERIC": 
            case "DECIMAL": 
            case "DEC": 
            case "INTEGER": 
            case "INT": 
            case "DOUBLE PRECISION": 
            case "REAL": {
                return "NUMBER";
            }
            case "DATE": 
            case "TIMESTAMP": {
                return "DATE";
            }
        }
        return type;
    }

    static Map<QueryVariable, QueryPath> collectPathVariables(GraphPattern gp) {
        HashMap<QueryVariable, QueryPath> pathVariables = new HashMap<QueryVariable, QueryPath>();
        gp.getConnections().stream().filter(conn -> conn.getVariableType() == QueryVariable.VariableType.PATH).forEach(conn -> {
            QueryPath path = (QueryPath)conn;
            path.getVertices().forEach(vertex -> pathVariables.put((QueryVariable)vertex, path));
            path.getConnections().forEach(connection -> pathVariables.put((QueryVariable)connection, path));
        });
        return pathVariables;
    }

    static boolean isVertexOrEdgeReference(ExpAsVar expAsVar) {
        if (expAsVar.getExp().getExpType() == QueryExpression.ExpressionType.VARREF) {
            return GraphPatternTranslator.isVertexOrEdgeReference((QueryExpression.VarRef)expAsVar.getExp());
        }
        return false;
    }

    static boolean isVertexOrEdgeReference(QueryExpression.VarRef varRef) {
        QueryVariable var = varRef.getVariable();
        QueryVariable.VariableType type = var.getVariableType();
        if (type == QueryVariable.VariableType.EXP_AS_VAR) {
            return GraphPatternTranslator.isVertexOrEdgeReference((ExpAsVar)var);
        }
        return type == QueryVariable.VariableType.VERTEX || type == QueryVariable.VariableType.EDGE;
    }

    static void addExtraGroupByElements(Set<QueryVertex> commonVertices, List<ExpAsVar> groupByElements, Map<String, Pair<Boolean, QueryVariable>> groupByVariables, List<ExpAsVar> subSelectElems) {
        if (commonVertices.size() > 0 && groupByVariables != null && groupByVariables.size() > 0) {
            final HashSet extraGroupByElements = new HashSet();
            for (QueryVertex commonVertex : commonVertices) {
                final String vertexName = commonVertex.getName();
                if (!groupByVariables.containsKey(vertexName)) continue;
                QueryVariable gbVariable = (QueryVariable)groupByVariables.get((Object)vertexName).second;
                final String alias = gbVariable.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR && ((ExpAsVar)gbVariable).getExp().getExpType() == QueryExpression.ExpressionType.VARREF ? ((QueryExpression.VarRef)((ExpAsVar)gbVariable).getExp()).getVariable().getName() : vertexName;
                for (ExpAsVar select : subSelectElems) {
                    select.accept((QueryExpressionVisitor)new SubqueryVisitor(){

                        private boolean isSameVariable(String varName) {
                            return varName.equals(vertexName) || varName.equals(alias);
                        }

                        private void addGroupByElement(QueryExpression exp) {
                            extraGroupByElements.add(new ExpAsVar(exp, exp.toString(), true));
                        }

                        @Override
                        public void visitVarRef(QueryExpression.VarRef varRef) {
                            if (this.isSameVariable(varRef.getVariable().getName())) {
                                this.addGroupByElement((QueryExpression)varRef);
                            }
                        }

                        @Override
                        public void visitPropertyAccess(QueryExpression.PropertyAccess propertyAccess) {
                            if (this.isSameVariable(propertyAccess.getVariable().getName())) {
                                extraGroupByElements.add(new ExpAsVar((QueryExpression)propertyAccess, propertyAccess.toString(), true));
                            }
                        }

                        @Override
                        public void visitIdOrLabelFunction(QueryExpression.FunctionCall functionCall) {
                            QueryVariable var = ExpressionTranslator.getQueryVariable((QueryExpression.VarRef)functionCall.getArgs().get(0));
                            if (this.isSameVariable(var.getName())) {
                                extraGroupByElements.add(new ExpAsVar((QueryExpression)functionCall, functionCall.toString(), true));
                            }
                        }

                        @Override
                        public void visitKeyColumnsFunction(QueryExpression.FunctionCall functionCall) {
                        }

                        @Override
                        public void visitVarRefSubqueryFunction(QueryExpression.FunctionCall functionCall) {
                        }

                        @Override
                        public void visitIsSourceOrIsDestOfFunction(QueryExpression.FunctionCall functionCall) {
                        }

                        @Override
                        public void visitSrcDstPredicate(QueryExpression.SourceDestinationPredicate sourceDestinationPredicate) {
                        }

                        @Override
                        public void visitHasLabelFunction(QueryExpression.FunctionCall functionCall) {
                            QueryVariable var = ExpressionTranslator.getQueryVariable((QueryExpression.VarRef)functionCall.getArgs().get(0));
                            if (this.isSameVariable(var.getName())) {
                                extraGroupByElements.add(new ExpAsVar((QueryExpression)functionCall, functionCall.toString(), true));
                            }
                        }

                        @Override
                        public void visitMatchnumOrElementNumber(QueryExpression.FunctionCall functionCall) {
                        }

                        @Override
                        public void visitAggregation(QueryExpression.Aggregation.AbstractAggregation agg) {
                            agg.getExp().accept((QueryExpressionVisitor)this);
                        }
                    });
                }
            }
            groupByElements.addAll(extraGroupByElements);
        }
    }
}

