/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.pg.rdbms.pgql.BindValueInfo;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.ExecutionInfo;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.ModifyContext;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlCreatePgUtils;
import oracle.pg.rdbms.pgql.PgqlExecuteCallStatement;
import oracle.pg.rdbms.pgql.PgqlPreparedStatement;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlSqlCreateTrans;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTrans;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlTrans;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlTranslator;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgsql.PgSqlDdlExecution;
import oracle.pg.rdbms.pgql.pgview.GraphMetadataHandler;
import oracle.pg.rdbms.pgql.pgview.PgViewDdlExecution;
import oracle.pg.rdbms.pgql.pgview.PgViewDmlExecution;
import oracle.pg.rdbms.pgql.pgview.PgViewModifyTrans;
import oracle.pg.rdbms.pgql.pgview.PgViewResultSet;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataRefreshTimes;
import oracle.pg.rdbms.pgql.pgview.metadata.TranslationCache;
import oracle.pg.rdbms.pgql.pgview.metadata.TranslationCacheValue;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.sql.TIMESTAMPTZ;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgqlExecution
implements PgqlPreparedStatement {
    private static final Logger ms_log = LoggerFactory.getLogger(PgqlExecution.class);
    private final QueryContext ctx;
    private final ModifyContext modifyCtx;
    private final PgqlTranslator pt;
    private String pgql;
    private BindValueInfo bvInfo;
    private boolean translated;
    private boolean parsed;
    private boolean prepared;
    private int prepareTimeout;
    private int prepareParallel;
    private int prepareDS;
    private int prepareMaxResults;
    private String translateMatchOptions;
    private String translateOptions;
    private PgViewDmlExecution dmlExecution;
    private static TranslationCache translationCache;
    private PgqlSqlTrans sqlTrans;
    private int fetchSize = 1000;
    private int batchSize = 500;
    private long rsCntr;
    private final Map<Long, PgqlResultSet> rsMap;
    private ExecutionInfo executionInfo;
    public static final String USER_REQUESTED_CANCEL_ERROR = "User requested cancel of current operation";
    private static final String AUTO_COMMIT_MODIFY_ERROR = "Connection auto-commit should be off for modify";

    PgqlExecution(PgqlConnection pgqlConn) {
        this(pgqlConn, "");
    }

    PgqlExecution(PgqlConnection pgqlConn, String pgql) {
        this(pgqlConn, pgql, 0, 0, 2, -1, null, null);
    }

    PgqlExecution(PgqlConnection pgqlConn, String pgql, int timeout, int parallel, int dynamicSampling, int maxResults, String matchOptions, String options) {
        this.ctx = QueryContext.getQueryContext(pgqlConn);
        this.modifyCtx = ModifyContext.getModifyContext(pgqlConn);
        this.pt = PgqlTranslator.getPgqlTranslator(this.ctx);
        this.initQuery(pgql);
        this.rsCntr = 0L;
        this.rsMap = new HashMap<Long, PgqlResultSet>();
        this.executionInfo = new ExecutionInfo();
        PgqlExecution.initTranslationCache();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Constructing new PGQL Execution:");
            ms_log.debug(" pgql=[" + this.pgql + "] ");
        }
        if (this.pgql != null && !this.pgql.isEmpty()) {
            try {
                if (this.isNotCachedTranslation(matchOptions, options)) {
                    this.parseAndSetOptions(matchOptions, options);
                    if (this.ctx.graphType == GraphType.PG_VIEWS) {
                        this.sqlTrans = this.pt.buildTranslation();
                        this.translated = true;
                        this.cacheTranslation(matchOptions, options, this.sqlTrans.getTranslationType());
                    }
                }
                if (this.ctx.graphType == GraphType.PG_VIEWS) {
                    if (this.sqlTrans.getTranslationType() == PgqlSqlTrans.TranslationType.QUERY) {
                        this.prepareQuery(parallel, dynamicSampling, maxResults);
                        this.storePrepareParameters(timeout, parallel, dynamicSampling, maxResults);
                    } else if (this.sqlTrans.getTranslationType() == PgqlSqlTrans.TranslationType.MODIFY) {
                        this.prepareModify(parallel, dynamicSampling);
                        this.storePrepareParameters(timeout, parallel, dynamicSampling, maxResults);
                    }
                }
            }
            catch (SQLException | PgqlException ex) {
                throw new PgqlToSqlException(ex);
            }
        }
    }

    @Override
    public PgqlResultSet getResultSet() {
        if (this.rsCntr > 0L) {
            return this.rsMap.get(this.rsCntr - 1L);
        }
        throw new PgqlToSqlException("ResultSet not available. Execute a query first.");
    }

    @Override
    public long getModifyCount() {
        return this.executionInfo.modifyCount;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setBoolean(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setBoolean(parameterIndex, x);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setDouble(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setDouble(parameterIndex, x);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setFloat(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setFloat(parameterIndex, x);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setInt(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setInt(parameterIndex, x);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setLong(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setLong(parameterIndex, x);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setString(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setString(parameterIndex, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setTimestamp(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setTimestamp(parameterIndex, x);
        }
    }

    public void setDate(int parameterIndex, LocalDate x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setDate(i + 1, Date.valueOf(x));
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTime(int parameterIndex, LocalTime x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setTime(i + 1, Time.valueOf(x));
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTimestamp(int parameterIndex, LocalDateTime x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setTimestamp(i + 1, Timestamp.valueOf(x));
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTimeWithTimezone(int parameterIndex, OffsetTime x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            OraclePreparedStatement ps = (OraclePreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    TIMESTAMPTZ ttz = new TIMESTAMPTZ(ps.getConnection(), Timestamp.from(x.atDate(LocalDate.ofEpochDay(0L)).toInstant()), (ZoneId)x.getOffset());
                    ps.setTIMESTAMPTZ(i + 1, ttz);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTimestampWithTimezone(int parameterIndex, OffsetDateTime x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            OraclePreparedStatement ps = (OraclePreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    TIMESTAMPTZ ttz = new TIMESTAMPTZ(ps.getConnection(), Timestamp.from(x.toInstant()), (ZoneId)x.getOffset());
                    ps.setTIMESTAMPTZ(i + 1, ttz);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setArray(int parameterIndex, List<?> x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PgqlSqlQueryTrans translateQuery() throws PgqlToSqlException, PgqlException {
        return this.translateQuery(this.prepareParallel, this.prepareDS, this.prepareMaxResults, this.translateMatchOptions);
    }

    @Override
    public PgqlSqlQueryTrans translateQuery(String pgql, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.translateQuery(0, 2, -1, options);
    }

    @Override
    public PgqlSqlQueryTrans translateQuery(String pgql, int parallel, int dynamicSampling, int maxResults, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.translateQuery(parallel, dynamicSampling, maxResults, options);
    }

    @Override
    public PgqlSqlTrans translateStatement() throws PgqlToSqlException, PgqlException {
        return this.translateStatement(this.translateMatchOptions, this.translateOptions);
    }

    @Override
    public PgqlSqlTrans translateStatement(String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        return this.translateStatement(this.prepareParallel, this.prepareDS, this.prepareMaxResults, matchOptions, options);
    }

    @Override
    public PgqlSqlTrans translateStatement(String pgql, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.translateStatement(matchOptions, options);
    }

    @Override
    public PgqlSqlTrans translateStatement(int parallel, int dynamicSampling, int maxResults, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        if (ms_log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("translateStatement called\n");
            sb.append("       parallel=[").append(parallel).append("]\n");
            sb.append("dynamicSampling=[").append(dynamicSampling).append("]\n");
            sb.append("     maxResults=[").append(maxResults).append("]\n");
            sb.append("   matchOptions=[").append(matchOptions).append("]\n");
            sb.append("        options=[").append(options).append("]\n");
            ms_log.debug(sb.toString());
        }
        this.translateIfNecessary(matchOptions, options);
        PgqlSqlTrans sql = this.sqlTrans;
        if (this.ctx.graphType == GraphType.PG_VIEWS && sql.getTranslationType() != PgqlSqlTrans.TranslationType.QUERY) {
            throw new PgqlToSqlException("Translation not supported for PG views");
        }
        if (sql.getTranslationType() == PgqlSqlTrans.TranslationType.QUERY) {
            PgqlSqlQueryTrans sqlQuery = (PgqlSqlQueryTrans)sql;
            sql = new PgqlSqlQueryTransImpl(DbmsUtils.getQueryWrapper(sqlQuery.getSqlTranslation(), maxResults, parallel, dynamicSampling), sqlQuery.getSqlBvList());
        }
        return sql;
    }

    @Override
    public PgqlSqlTrans translateStatement(String pgql, int parallel, int dynamicSampling, int maxResults, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.translateStatement(parallel, dynamicSampling, maxResults, matchOptions, options);
    }

    @Override
    public PgqlResultSet executeQuery() throws PgqlToSqlException, PgqlException {
        return this.executeQuery(this.prepareTimeout, this.prepareParallel, this.prepareDS, this.prepareMaxResults, this.translateMatchOptions);
    }

    @Override
    public PgqlResultSet executeQuery(String pgql, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.executeQuery(0, 0, 2, -1, options);
    }

    @Override
    public PgqlResultSet executeQuery(int timeout, int parallel, int dynamicSampling, int maxResults, String options) throws PgqlToSqlException, PgqlException {
        PgViewResultSet oprs;
        if (ms_log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("executeQuery called\n");
            sb.append("        timeout=[").append(timeout).append("]\n");
            sb.append("       parallel=[").append(parallel).append("]\n");
            sb.append("dynamicSampling=[").append(dynamicSampling).append("]\n");
            sb.append("     maxResults=[").append(maxResults).append("]\n");
            sb.append("        options=[").append(options).append("]\n");
            ms_log.debug(sb.toString());
        }
        this.translateIfNecessary(options, null);
        if (this.sqlTrans.getTranslationType() != PgqlSqlTrans.TranslationType.QUERY) {
            throw new PgqlToSqlException("Statement not valid for executeQuery(), use execute() instead");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (this.executionInfo.isCanceled) {
                throw new PgqlException(USER_REQUESTED_CANCEL_ERROR);
            }
            if (this.prepared) {
                this.checkStoredParameters(timeout, parallel, dynamicSampling, maxResults);
            } else {
                this.prepareQuery(parallel, dynamicSampling, maxResults);
            }
            ps = (PreparedStatement)this.executionInfo.currentStmts[0];
            if (timeout > 0) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("executeQuery: setting timeout " + timeout);
                }
                ps.setQueryTimeout(timeout);
            }
            rs = ps.executeQuery();
        }
        catch (Exception e) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Exception during executeQuery: ", (Throwable)e);
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Trying to close result set and statement");
            }
            DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
            this.checkTableOrViewDoesNotExistError(e);
            throw new PgqlToSqlException(e.getMessage(), e);
        }
        try {
            oprs = new PgViewResultSet(rs, ps, this.getFetchSize(), this.ctx, this, this.rsCntr, !this.prepared);
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Adding PgqlResultSet id=[" + this.rsCntr + "] to rsMap");
        }
        this.rsMap.put(this.rsCntr, oprs);
        ++this.rsCntr;
        this.executionInfo.modifyCount = -1L;
        return oprs;
    }

    @Override
    public PgqlResultSet executeQuery(String pgql, int timeout, int parallel, int dynamicSampling, int maxResults, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.executeQuery(timeout, parallel, dynamicSampling, maxResults, options);
    }

    @Override
    public boolean execute(String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        return this.execute(0, 2, matchOptions, options);
    }

    @Override
    public boolean execute(String pgql, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.execute(matchOptions, options);
    }

    @Override
    public boolean execute(int parallel, int dynamicSampling, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        try {
            if (ms_log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("execute called\n");
                sb.append("       parallel=[").append(parallel).append("]\n");
                sb.append("dynamicSampling=[").append(dynamicSampling).append("]\n");
                sb.append("   matchOptions=[").append(matchOptions).append("]\n");
                sb.append("        options=[").append(options).append("]\n");
                ms_log.debug(sb.toString());
            }
            this.translateIfNecessary(matchOptions, options);
            if (this.ctx.pgqlConn.getJdbcConnection().getAutoCommit() && this.modifyCtx.getOption(ModifyContext.BooleanOption.AUTO_COMMIT)) {
                throw new PgqlToSqlException("Connection auto-commit should be off when AUTO_COMMIT=T flag is used ");
            }
            if (this.sqlTrans.getTranslationType() == PgqlSqlTrans.TranslationType.QUERY) {
                this.executeQuery(0, parallel, dynamicSampling, -1, matchOptions);
                return true;
            }
            if (this.sqlTrans.getTranslationType() == PgqlSqlTrans.TranslationType.CALL) {
                PgqlExecuteCallStatement pecs = (PgqlExecuteCallStatement)this.sqlTrans;
                pecs.execute();
                return false;
            }
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        if (this.ctx.graphType == GraphType.PG_VIEWS) {
            this.executeOnPgView(parallel, dynamicSampling);
        } else {
            this.executeOnPgSql(parallel, dynamicSampling);
        }
        return false;
    }

    private void executeOnPgView(int parallel, int dynamicSampling) throws PgqlException {
        try {
            boolean append = this.sqlTrans.getTranslationType() != PgqlSqlTrans.TranslationType.MODIFY || ((PgViewModifyTrans)this.sqlTrans).getModifications().size() <= 1;
            int safeParallel = this.getParallelSafeValue(parallel, append);
            boolean parallelEnabled = this.enableSessionParallel(safeParallel);
            switch (this.sqlTrans.getTranslationType()) {
                case CREATE: {
                    this.throwIfGraphExists();
                    PgqlSqlCreateTrans createTrans = (PgqlSqlCreateTrans)this.sqlTrans;
                    CreatePropertyGraph cpg = (CreatePropertyGraph)createTrans.getCreateTranslation()[0];
                    PgViewDdlExecution ddlExecution = new PgViewDdlExecution(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName);
                    ddlExecution.createPG(cpg, this.ctx.checkTypes);
                    break;
                }
                case DROP: {
                    PgViewDdlExecution ddlExecution = new PgViewDdlExecution(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName);
                    PgqlTranslator.deleteGraphMetadata(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.schemaName, this.ctx.graphName);
                    translationCache.deleteGraphTranslations(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName);
                    ddlExecution.dropPG();
                    break;
                }
                case MODIFY: {
                    if (this.ctx.pgqlConn.getJdbcConnection().getAutoCommit()) {
                        throw new PgqlToSqlException(AUTO_COMMIT_MODIFY_ERROR);
                    }
                    if (this.prepared) {
                        this.checkStoredParameters(0, parallel, dynamicSampling, -1);
                    } else {
                        this.prepareModify(parallel, dynamicSampling);
                    }
                    this.dmlExecution.executeModify(this.modifyCtx.getOption(ModifyContext.BooleanOption.AUTO_COMMIT));
                    break;
                }
                default: {
                    throw new PgqlToSqlException("Operation not supported for property graph view model:" + (Object)((Object)this.sqlTrans.getTranslationType()));
                }
            }
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private void executeOnPgSql(int parallel, int dynamicSampling) throws PgqlException {
        switch (this.sqlTrans.getTranslationType()) {
            case CREATE: {
                this.throwIfGraphExists();
                PgqlSqlCreateTrans createTrans = (PgqlSqlCreateTrans)this.sqlTrans;
                CreatePropertyGraph cpg = (CreatePropertyGraph)createTrans.getCreateTranslation()[0];
                PgSqlDdlExecution ddlExecution = new PgSqlDdlExecution(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName);
                PgSqlDdlExecution.createPg(cpg);
                break;
            }
            case DROP: {
                PgSqlDdlExecution ddlExecution = new PgSqlDdlExecution(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName);
                ddlExecution.dropPg();
                break;
            }
            default: {
                throw new PgqlToSqlException("Operation not supported for SQL property graphs:" + (Object)((Object)this.sqlTrans.getTranslationType()));
            }
        }
    }

    @Override
    public boolean execute(String pgql, int parallel, int dynamicSampling, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.execute(parallel, dynamicSampling, matchOptions, options);
    }

    private int getParallelSafeValue(int parallel, boolean isParallelSafe) {
        if (isParallelSafe) {
            return parallel;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Parallel not safe, using [0] instead");
        }
        return 0;
    }

    private boolean enableSessionParallel(int parallel) throws SQLException {
        boolean enabled = false;
        if (parallel != 0) {
            String alterStr = "BEGIN\n  EXECUTE IMMEDIATE 'ALTER SESSION ENABLE PARALLEL QUERY';\n  EXECUTE IMMEDIATE 'ALTER SESSION ENABLE PARALLEL DML';\nEND;";
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Altering session parameters:[\n" + alterStr + "\n]");
            }
            try (Statement stmt = this.createStatement();){
                stmt.execute(alterStr);
                enabled = true;
            }
        }
        return enabled;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void close() throws PgqlException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Close called");
            ms_log.debug("Number of PgqlResultSets: [" + this.rsMap.size() + "]");
        }
        PgqlResultSet[] resultSets = this.rsMap.values().toArray(new PgqlResultSet[0]);
        for (int i = 0; i < resultSets.length; ++i) {
            PgqlResultSet rs = resultSets[i];
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Closing PgqlResultSet #" + i);
            }
            if (rs == null) continue;
            rs.close();
        }
        this.cancelOrClose(false);
    }

    @Override
    public void cancel() throws PgqlException {
        this.executionInfo.isCanceled = true;
        this.cancelOrClose(true);
    }

    private void cancelOrClose(boolean cancel) throws PgqlException {
        try {
            if (this.executionInfo.currentStmts != null) {
                ms_log.debug("Canceling or closing [" + this.executionInfo.currentStmts.length + "] statements");
                for (int i = 0; i < this.executionInfo.currentStmts.length; ++i) {
                    if (this.executionInfo.currentStmts[i] == null || this.executionInfo.currentStmts[i].isClosed()) continue;
                    Statement stmt = this.executionInfo.currentStmts[i];
                    if (cancel) {
                        stmt.cancel();
                        continue;
                    }
                    stmt.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    void deregisterResultSet(long id) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Deregistering Result Set [" + id + "]");
        }
        this.rsMap.remove(id);
    }

    private void initQuery(String pgql) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("setting pgql string in prepareStatement");
            ms_log.debug("pgql=[" + pgql + "]");
        }
        this.pgql = pgql;
        this.bvInfo = BindValueInfo.getBindValueInfo();
        this.parsed = false;
        this.translated = false;
        this.prepared = false;
        this.prepareTimeout = 0;
        this.prepareParallel = 0;
        this.prepareDS = 2;
        this.prepareMaxResults = -1;
        this.translateMatchOptions = null;
        this.translateOptions = null;
        this.sqlTrans = null;
    }

    private void checkTableOrViewDoesNotExistError(Exception ex) throws PgqlToSqlException {
        if (ex.getMessage() != null && ex.getMessage().contains("ORA-00942") && this.sqlTrans != null) {
            String errorMessage;
            switch (this.sqlTrans.getTranslationType()) {
                case CREATE: {
                    errorMessage = "Some of the provided tables do not exist.";
                    break;
                }
                default: {
                    errorMessage = "Graph " + this.ctx.schemaName + "." + this.ctx.graphName + " does not exist.";
                }
            }
            throw new PgqlToSqlException(errorMessage);
        }
    }

    private Statement createStatement() throws SQLException {
        if (this.executionInfo.isCanceled) {
            throw new PgqlToSqlException(USER_REQUESTED_CANCEL_ERROR);
        }
        return this.ctx.pgqlConn.getJdbcConnection().createStatement();
    }

    private void prepareQuery(int parallel, int dynamicSampling, int maxResults) throws SQLException {
        this.executionInfo = new ExecutionInfo();
        String sqlStr = ((PgqlSqlQueryTrans)this.sqlTrans).getSqlTranslation();
        sqlStr = DbmsUtils.getQueryWrapper(sqlStr, maxResults, parallel, dynamicSampling).toString();
        if (this.executionInfo.isCanceled) {
            throw new PgqlToSqlException(USER_REQUESTED_CANCEL_ERROR);
        }
        PreparedStatement stmt = this.ctx.pgqlConn.getJdbcConnection().prepareStatement(sqlStr, 1004, 1007);
        this.executionInfo.currentStmts = new Statement[]{stmt};
    }

    private void prepareModify(int parallel, int dynamicSampling) throws SQLException {
        PgViewModifyTrans modifyTrans = (PgViewModifyTrans)this.sqlTrans;
        this.executionInfo = new ExecutionInfo();
        this.dmlExecution = new PgViewDmlExecution(this.ctx.pgqlConn.getJdbcConnection(), this.executionInfo);
        boolean append = modifyTrans.getModifications().size() <= 1;
        int safeParallel = this.getParallelSafeValue(parallel, append);
        this.enableSessionParallel(safeParallel);
        this.dmlExecution.prepareModify(modifyTrans, safeParallel, dynamicSampling, append);
    }

    private void storePrepareParameters(int timeout, int parallel, int dynamicSampling, int maxResults) {
        this.prepared = true;
        this.prepareTimeout = timeout;
        this.prepareParallel = parallel;
        this.prepareDS = dynamicSampling;
        this.prepareMaxResults = maxResults;
    }

    private void checkStoredParameters(int timeout, int parallel, int dynamicSampling, int maxResults) {
        if (timeout != 0 && timeout != this.prepareTimeout) {
            throw new PgqlToSqlException("timeout [" + timeout + "] value used in execute is different from timeout [" + this.prepareTimeout + "] used in prepare");
        }
        if (parallel != 0 && parallel != this.prepareParallel) {
            throw new PgqlToSqlException("parallel [" + parallel + "] value used in execute is different from parallel [" + this.prepareParallel + "] used in prepare");
        }
        if (dynamicSampling != 2 && dynamicSampling != this.prepareDS) {
            throw new PgqlToSqlException("dynamicSampling [" + dynamicSampling + "] value used in execute is different from dynamicSampling [" + this.prepareDS + "] used in prepare");
        }
        if (maxResults != -1 && maxResults != this.prepareMaxResults) {
            throw new PgqlToSqlException("maxResults [" + maxResults + "] value used in execute is different from maxResults [" + this.prepareMaxResults + "] used in prepare");
        }
    }

    private void translateIfNecessary(String matchOptions, String options) throws PgqlException {
        if (this.parsed || this.translated) {
            if (matchOptions != null && !matchOptions.isEmpty() && !matchOptions.equals(this.translateMatchOptions)) {
                throw new PgqlToSqlException("matchOptions [" + matchOptions + "] provided are different from matchOptions [" + this.translateMatchOptions + "] used in prepare");
            }
            if (options != null && !options.isEmpty() && !options.equals(this.translateOptions)) {
                throw new PgqlToSqlException("options [" + options + "] provided are different from options [" + this.translateOptions + "] used in prepare");
            }
        }
        if (!this.translated) {
            if (this.parsed) {
                this.sqlTrans = this.pt.buildTranslation();
            } else if (this.isNotCachedTranslation(matchOptions, options)) {
                this.parseAndSetOptions(matchOptions, options);
                this.sqlTrans = this.pt.buildTranslation();
                if (this.ctx.graphType == GraphType.PG_VIEWS) {
                    this.cacheTranslation(matchOptions, options, this.sqlTrans.getTranslationType());
                }
            }
            this.executionInfo = new ExecutionInfo();
            this.parsed = true;
            this.translated = true;
        }
    }

    private boolean isNotCachedTranslation(String matchOptions, String options) {
        if (translationCache.containsTranslation(this.ctx.pgqlConn, this.pgql, matchOptions, options)) {
            ms_log.debug("Getting translation from the cache");
            TranslationCacheValue translation = translationCache.getTranslation(this.ctx.pgqlConn, this.pgql, matchOptions, options);
            if (!MetadataRefreshTimes.isRefreshed(this.ctx.pgqlConn, translation.getSchemaName(), translation.getGraphName())) {
                ms_log.debug("Cache is not refreshed, ignoring translated query");
                return true;
            }
            ms_log.debug("Checking if the current graph is PGM");
            if (translation.getGraphName().equals("PROPERTY_GRAPH_METADATA")) {
                try {
                    ms_log.debug("Starting PGM update");
                    GraphMetadataHandler.graphMetadataInitiator(this.ctx.pgqlConn, translation.getSchemaName());
                }
                catch (SQLException e) {
                    throw new PgqlToSqlException(e);
                }
            }
            this.sqlTrans = translation.getSqlTrans();
            this.bvInfo = translation.getBvInfo();
            this.translated = true;
            this.translateMatchOptions = matchOptions;
            this.translateOptions = options;
            this.ctx.graphType = GraphType.PG_VIEWS;
            return false;
        }
        ms_log.debug("Translation not in cache or cache disabled");
        return true;
    }

    private void cacheTranslation(String matchOptions, String options, PgqlSqlTrans.TranslationType transType) {
        if (transType != PgqlSqlTrans.TranslationType.CREATE && transType != PgqlSqlTrans.TranslationType.DROP) {
            translationCache.cacheTranslation(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName, this.pgql, matchOptions, options, this.sqlTrans, this.bvInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initTranslationCache() {
        if (translationCache != null) return;
        Class<TranslationCache> clazz = TranslationCache.class;
        synchronized (TranslationCache.class) {
            if (translationCache != null) return;
            translationCache = new TranslationCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void clearTranslationCache(PgqlConnection pgqlConn) {
        PgqlExecution.initTranslationCache();
        translationCache.clear(pgqlConn.getJdbcConnection());
    }

    static void disableTranslationCache(PgqlConnection pgqlConn) {
        PgqlExecution.initTranslationCache();
        translationCache.disable(pgqlConn.getJdbcConnection());
    }

    static void enableTranslationCache(PgqlConnection pgqlConn) {
        PgqlExecution.initTranslationCache();
        translationCache.enable(pgqlConn.getJdbcConnection());
    }

    static void setTranslationCacheMaxCapacity(PgqlConnection pgqlConn, int maxCapacity) {
        PgqlExecution.initTranslationCache();
        translationCache.setMaxCapacity(pgqlConn.getJdbcConnection(), maxCapacity);
    }

    public static void deleteCache(PgqlConnection pgqlConn, String schema, String graphName) {
        if (translationCache != null) {
            translationCache.deleteGraphTranslations(pgqlConn, schema, graphName);
        }
        PgqlTranslator.deleteGraphMetadata(pgqlConn.getJdbcConnection(), schema, graphName);
    }

    private void parseAndSetOptions(String matchOptions, String options) throws PgqlException {
        this.pt.prepareTranslation(this.pgql, null, this.bvInfo);
        this.parsed = true;
        if (this.pt.isCallStatement) {
            return;
        }
        PgqlUtils.setQueryOptions(this.ctx, matchOptions);
        this.translateMatchOptions = matchOptions;
        PgqlUtils.setModifyOptions(this.modifyCtx, options);
        this.translateOptions = options;
    }

    private void throwIfGraphExists() throws PgqlException {
        if (PgqlCreatePgUtils.existsGraph(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName)) {
            throw new PgqlException("Graph " + this.ctx.schemaName + "." + this.ctx.graphName + " already exists");
        }
    }
}

