/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlSqlTrans;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pgql.lang.ddl.CallStatement;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class PgqlExecuteCallStatement
implements PgqlSqlTrans {
    private PgqlConnection pgqlConn;
    private CallStatement callStatement;

    public PgqlExecuteCallStatement(PgqlConnection pgqlConn, CallStatement callStatement) {
        this.pgqlConn = pgqlConn;
        this.callStatement = callStatement;
    }

    public void execute() {
        block3 : switch (this.callStatement.getPackageName()) {
            case "PG": {
                switch (this.callStatement.getRoutineName()) {
                    case "VALIDATE": {
                        SchemaQualifiedName schemaQualifiedName = this.verifyValidateParams();
                        this.executeValidate(schemaQualifiedName);
                        break block3;
                    }
                }
                throw new PgqlToSqlException("Function " + this.callStatement.getPackageName() + "." + this.callStatement.getRoutineName() + " does not exist");
            }
            default: {
                throw new PgqlToSqlException("Package " + this.callStatement.getPackageName() + " does not exist");
            }
        }
    }

    private SchemaQualifiedName verifyValidateParams() {
        String graphName;
        String graphSchema = this.pgqlConn.getSchema();
        switch (this.callStatement.getArgumentList().size()) {
            case 1: {
                graphName = (String)((QueryExpression.Constant.ConstString)this.callStatement.getArgumentList().get(0)).getValue();
                break;
            }
            case 2: {
                graphSchema = (String)((QueryExpression.Constant.ConstString)this.callStatement.getArgumentList().get(0)).getValue();
                graphName = (String)((QueryExpression.Constant.ConstString)this.callStatement.getArgumentList().get(1)).getValue();
                break;
            }
            default: {
                throw new PgqlToSqlException("Invalid number of parameters for " + this.callStatement.getPackageName() + "." + this.callStatement.getRoutineName());
            }
        }
        GraphType graphType = PgqlUtils.getGraphType(this.pgqlConn.getJdbcConnection(), graphSchema, graphName, true);
        SchemaQualifiedName schemaQualifiedName = new SchemaQualifiedName(graphSchema, graphName);
        if (graphType == null) {
            throw new PgqlToSqlException("Graph " + schemaQualifiedName + " does not exist");
        }
        if (graphType != GraphType.PG_VIEWS) {
            throw new PgqlToSqlException("Graph " + schemaQualifiedName + " is a " + (Object)((Object)graphType) + " graph, only PG_PGQL graphs are allowed for PG.VALIDATE() CALL");
        }
        return schemaQualifiedName;
    }

    private void executeValidate(SchemaQualifiedName schemaQualifiedName) {
        block2: {
            try {
                PreparedStatement ps = this.pgqlConn.getJdbcConnection().prepareStatement(this.validatePlSql());
                ps.setString(1, schemaQualifiedName.getSchemaName());
                ps.setString(2, schemaQualifiedName.getName());
                ps.execute();
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() != 20001) break block2;
                String message = ex.getMessage();
                throw new PgqlToSqlException(ex.getMessage().substring(message.indexOf("ORA-20001: ") + "ORA-20001: ".length(), message.indexOf("\n")));
            }
        }
    }

    private String validatePlSql() {
        return "DECLARE\n  graph_schema                VARCHAR2(128) := ?;\n  graph_name                  VARCHAR2(128) := ?;\n  v_elem_table_join_key       VARCHAR2(2048);\n  v_cursor                    SYS_REFCURSOR;\n  v_elem_schema               VARCHAR2(128);\n  v_elem_table                VARCHAR2(128);\n  v_elem_name                 VARCHAR2(128);\n  v_elem_type                 VARCHAR2(8);\n  v_columns                   sys.odcivarchar2list;\n  v_columns_comma_sep         VARCHAR2(2048);\n  v_columns_concat            VARCHAR2(2048);\n  v_count_unique_match        INTEGER;\n  v_duplicate_value           VARCHAR2(2048);\n  v_edge_src_dst_key          VARCHAR2(2048);\n  v_edge_cursor               SYS_REFCURSOR;\n  v_edge_vt_name              VARCHAR2(128);\n  v_edge_vt_type              VARCHAR2(16);\n  v_edge_vt_columns           sys.odcivarchar2list;\n  v_edge_vt_columns_comma_sep VARCHAR2(2048);\n  v_edge_vt_columns_concat    VARCHAR2(2048);\n  v_vertex_sql                VARCHAR2(2048);\n  v_vertex_schema_name        VARCHAR2(128);\n  v_vertex_table_name         VARCHAR2(128);\n  v_vertex_columns            sys.odcivarchar2list;\n  v_vertex_columns_comma_sep  VARCHAR2(2048);\n  v_count_fk_cons             INTEGER;\n  v_join_condition            VARCHAR2(2048);\n  v_condition                 VARCHAR2(2048);\n  v_edge_key_values           VARCHAR2(2048);\n  v_mismatched_value          VARCHAR2(2048);\nBEGIN\n   -- Retrieve element table information (vertices or edges) and associated keys\n  v_elem_table_join_key := 'SELECT et.SCHEMA_NAME, et.TABLE_NAME, et.ET_NAME, et.ET_TYPE, CAST(COLLECT(k.COLUMN_NAME ORDER BY k.column_number) AS sys.odcivarchar2list) '\n                           || 'FROM '\n                           || sys.dbms_assert.enquote_name(graph_schema, false)\n                           || '.'\n                           || sys.dbms_assert.enquote_name(graph_name || '_ELEM_TABLE$', false)\n                           || ' et '\n                           || 'JOIN '\n                           || sys.dbms_assert.enquote_name(graph_schema, false)\n                           || '.'\n                           || sys.dbms_assert.enquote_name(graph_name || '_KEY$', false)\n                           || ' k '\n                           || 'ON et.ET_NAME = k.ET_NAME AND et.ET_TYPE = k.KEY_TYPE '\n                           || 'GROUP BY et.ET_TYPE, et.ET_NAME, et.SCHEMA_NAME, et.TABLE_NAME';\n\n  OPEN v_cursor FOR v_elem_table_join_key;\n\n  LOOP\n    FETCH v_cursor INTO\n      v_elem_schema,\n      v_elem_table,\n      v_elem_name,\n      v_elem_type,\n      v_columns;\n    EXIT WHEN v_cursor%notfound;\n    v_columns_comma_sep := '';\n    v_columns_concat := '';\n    FOR i IN 1..v_columns.count LOOP\n      v_columns_comma_sep := v_columns_comma_sep || sys.dbms_assert.enquote_name(v_columns(i), false);\n      v_columns_concat := v_columns_concat || sys.dbms_assert.enquote_name(v_columns(i), false);\n      IF i <> v_columns.count THEN\n        v_columns_comma_sep := v_columns_comma_sep || ', ';\n        v_columns_concat := v_columns_concat || ' ||'', ''|| ';\n      END IF;\n    END LOOP;\n    -- Count unique matches of column names as constraints (UNIQUE or PRIMARY KEY)\n    SELECT\n      COUNT(*)\n    INTO v_count_unique_match\n    FROM\n      (\n        SELECT\n          ac.constraint_type AS constraint_type,\n          LISTAGG(acc.column_name, ', ') WITHIN GROUP(\n          ORDER BY\n            acc.position\n          )                  AS list_columns\n        FROM\n          sys.all_constraints ac\n          JOIN sys.all_cons_columns acc ON ac.owner = acc.owner\n                                       AND ac.table_name = acc.table_name\n                                       AND ac.constraint_name = acc.constraint_name\n        WHERE\n          ac.owner = v_elem_schema\n          AND ac.table_name = v_elem_table\n          AND ac.status = 'ENABLED'\n          AND ac.validated = 'VALIDATED'\n          AND ( ac.constraint_type = 'U'\n                OR ac.constraint_type = 'P' )\n        GROUP BY\n          ac.owner,\n          ac.table_name,\n          ac.constraint_name,\n          ac.constraint_type\n      ) sub\n    WHERE\n      sub.list_columns = v_columns_comma_sep;\n    IF ( v_count_unique_match = 0 ) THEN\n      BEGIN\n        -- Check for duplicate values in the element table(vertex or edge)\n        EXECUTE IMMEDIATE 'SELECT '\n                          || v_columns_concat\n                          || ' FROM '\n                          || sys.dbms_assert.enquote_name(v_elem_schema, false)\n                          || '.'\n                          || sys.dbms_assert.enquote_name(v_elem_table, false)\n                          || ' GROUP BY '\n                          || v_columns_comma_sep\n                          || ' HAVING COUNT(*) > 1 FETCH FIRST 1 ROWS ONLY'\n        INTO v_duplicate_value;\n      EXCEPTION\n        WHEN no_data_found THEN\n          v_duplicate_value := NULL;\n      END;\n      IF v_duplicate_value IS NOT NULL THEN\n        raise_application_error(\n                               -20001,\n                               'Duplicate '\n                               || lower(v_elem_type)\n                               || ' key '\n                               || v_duplicate_value\n                               || ' for '\n                               || v_elem_name\n                               || ' (column(s): '\n                               || v_columns_comma_sep\n                               || ')'\n        );\n      END IF;\n    END IF;\n    IF v_elem_type = 'EDGE' THEN\n     -- Query to retrieve source and destination keys for edges\n      v_edge_src_dst_key := 'SELECT VT_NAME, KEY_TYPE, CAST(COLLECT(ET_COLUMN_NAME ORDER BY ET_COLUMN_NUMBER) AS sys.odcivarchar2list) AS LIST_COLUMNS '\n                            || 'FROM '\n                            || sys.dbms_assert.enquote_name(graph_schema, false)\n                            || '.'\n                            || sys.dbms_assert.enquote_name(graph_name || '_SRC_DST_KEY$', false)\n                            || ' WHERE ET_NAME = :1 '\n                            || 'GROUP BY ET_NAME, VT_NAME, KEY_TYPE';\n      OPEN v_edge_cursor FOR v_edge_src_dst_key\n        USING v_elem_name;\n      LOOP\n        FETCH v_edge_cursor INTO\n          v_edge_vt_name,\n          v_edge_vt_type,\n          v_edge_vt_columns;\n        EXIT WHEN v_edge_cursor%notfound;\n        -- Query to retrieve vertex information (schema, table, and columns)\n        v_vertex_sql := 'SELECT et.SCHEMA_NAME, et.TABLE_NAME, CAST(COLLECT(k.COLUMN_NAME) AS sys.odcivarchar2list) '\n                        || 'FROM '\n                        || sys.dbms_assert.enquote_name(graph_schema, false)\n                        || '.'\n                        || sys.dbms_assert.enquote_name(graph_name || '_ELEM_TABLE$', false)\n                        || ' et '\n                        || 'JOIN '\n                        || sys.dbms_assert.enquote_name(graph_schema, false)\n                        || '.'\n                        || sys.dbms_assert.enquote_name(graph_name || '_KEY$', false)\n                        || ' k '\n                        || 'ON et.ET_NAME = k.ET_NAME AND et.ET_TYPE = k.KEY_TYPE '\n                        || 'WHERE et.ET_NAME = :1 AND et.ET_TYPE = :2 '\n                        || 'GROUP BY et.SCHEMA_NAME, et.TABLE_NAME';\n        EXECUTE IMMEDIATE v_vertex_sql\n        INTO\n          v_vertex_schema_name,\n          v_vertex_table_name,\n          v_vertex_columns\n          USING v_edge_vt_name, 'VERTEX';\n        v_vertex_columns_comma_sep := '';\n        FOR i IN 1..v_vertex_columns.count LOOP\n          v_vertex_columns_comma_sep := v_vertex_columns_comma_sep || sys.dbms_assert.enquote_name(v_vertex_columns(i), false);\n          IF i <> v_vertex_columns.count THEN\n            v_vertex_columns_comma_sep := v_vertex_columns_comma_sep || ', ';\n          END IF;\n        END LOOP;\n        v_edge_vt_columns_comma_sep := '';\n        v_edge_vt_columns_concat := '';\n        FOR i IN 1..v_edge_vt_columns.count LOOP\n          v_edge_vt_columns_comma_sep := v_edge_vt_columns_comma_sep || sys.dbms_assert.enquote_name(v_edge_vt_columns(i), false);\n          IF i <> v_edge_vt_columns.count THEN\n            v_edge_vt_columns_comma_sep := v_edge_vt_columns_comma_sep || ', ';\n          END IF;\n        END LOOP;\n        IF\n          v_elem_schema = v_vertex_schema_name\n          AND v_elem_table = v_vertex_table_name\n          AND v_columns_comma_sep = v_vertex_columns_comma_sep\n        THEN\n          CONTINUE;\n        END IF;\n        -- Check foreign key constraints between edge and vertex\n        SELECT\n          COUNT(*)\n        INTO v_count_fk_cons\n        FROM\n          (\n            SELECT\n              ac.constraint_type AS constraint_type,\n              LISTAGG(acc.column_name, ', ') WITHIN GROUP(\n              ORDER BY\n                acc.position\n              )                  AS list_columns,\n              r_owner,\n              r_constraint_name\n            FROM\n              sys.all_constraints ac\n              JOIN sys.all_cons_columns acc ON ac.owner = acc.owner\n                                           AND ac.table_name = acc.table_name\n                                           AND ac.constraint_name = acc.constraint_name\n            WHERE\n              ac.owner = v_elem_schema\n              AND ac.table_name = v_elem_table\n              AND ac.status = 'ENABLED'\n              AND ac.validated = 'VALIDATED'\n              AND ac.constraint_type = 'R'\n            GROUP BY\n              ac.constraint_type,\n              ac.owner,\n              ac.table_name,\n              ac.constraint_name,\n              r_owner,\n              r_constraint_name\n          ) ref\n          JOIN (\n            SELECT\n              LISTAGG(acc.column_name, ', ') WITHIN GROUP(\n              ORDER BY\n                acc.position\n              ) AS list_columns,\n              ac.owner,\n              ac.constraint_name\n            FROM\n              sys.all_constraints ac\n              JOIN sys.all_cons_columns acc ON ac.owner = acc.owner\n                                           AND ac.table_name = acc.table_name\n                                           AND ac.constraint_name = acc.constraint_name\n            WHERE\n              ac.owner = v_vertex_schema_name\n              AND ac.table_name = v_vertex_table_name\n            GROUP BY\n              ac.owner,\n              ac.table_name,\n              ac.constraint_name\n          ) org ON ref.r_owner = org.owner\n                   AND ref.r_constraint_name = org.constraint_name\n        WHERE\n          ref.list_columns = v_edge_vt_columns_comma_sep\n          AND org.list_columns = v_vertex_columns_comma_sep;\n        -- If no foreign key constraints are found, continue to the next iteration\n        IF v_count_fk_cons = 0 THEN\n          v_join_condition := '';\n          v_condition := '';\n          v_edge_vt_columns_concat := '';\n          FOR i IN 1..v_edge_vt_columns.count LOOP\n            v_join_condition := v_join_condition\n                                || 't1.'\n                                || sys.dbms_assert.enquote_name(v_edge_vt_columns(i), false)\n                                || ' = t2.'\n                                || sys.dbms_assert.enquote_name(v_vertex_columns(i), false);\n            v_condition := v_condition\n                           || 't2.'\n                           || sys.dbms_assert.enquote_name(v_vertex_columns(i), false)\n                           || ' IS NULL';\n            v_edge_vt_columns_concat := v_edge_vt_columns_concat\n                                        || 't1.'\n                                        || sys.dbms_assert.enquote_name(v_edge_vt_columns(i), false);\n            IF i <> v_edge_vt_columns.count THEN\n              v_join_condition := v_join_condition || ' AND ';\n              v_condition := v_condition || ' AND ';\n              v_edge_vt_columns_concat := v_edge_vt_columns_concat || ' ||'', ''|| ';\n            END IF;\n\n          END LOOP;\n\n          v_columns_concat := '';\n          FOR i IN 1..v_columns.count LOOP\n            v_columns_concat := v_columns_concat\n                                || 't1.'\n                                || sys.dbms_assert.enquote_name(v_columns(i), false);\n            IF i <> v_columns.count THEN\n              v_columns_concat := v_columns_concat || ' ||'', ''|| ';\n            END IF;\n          END LOOP;\n          BEGIN\n            -- Execute a dynamic SQL query to check for invalid vertex keys in the edge table\n            EXECUTE IMMEDIATE 'SELECT '\n                              || v_columns_concat\n                              || ', '\n                              || v_edge_vt_columns_concat\n                              || ' FROM '\n                              || sys.dbms_assert.enquote_name(v_elem_schema, false)\n                              || '.'\n                              || sys.dbms_assert.enquote_name(v_elem_table, false)\n                              || ' t1 LEFT JOIN '\n                              || sys.dbms_assert.enquote_name(v_vertex_schema_name, false)\n                              || '.'\n                              || sys.dbms_assert.enquote_name(v_vertex_table_name, false)\n                              || ' t2 ON '\n                              || v_join_condition\n                              || ' WHERE '\n                              || v_condition\n                              || ' FETCH FIRST 1 ROWS ONLY'\n            INTO\n              v_edge_key_values,\n              v_mismatched_value;\n          EXCEPTION\n            WHEN no_data_found THEN\n              v_edge_key_values := NULL;\n          END;\n          IF v_edge_key_values IS NOT NULL THEN\n            raise_application_error(\n                                   -20001,\n                                   'Invalid vertex key '\n                                   || v_mismatched_value\n                                   || ' for edge '\n                                   || v_edge_key_values\n                                   || ' in edge table '\n                                   || v_elem_name\n                                   || ' with '\n                                   ||(\n                                     CASE v_edge_vt_type\n                                       WHEN 'EDGE_SOURCE' THEN\n                                         'source'\n                                       WHEN 'EDGE_DESTINATION' THEN\n                                         'destination'\n                                     END\n                                   )\n                                   || ' key column(s) '\n                                   || v_edge_vt_columns_comma_sep\n                                   || ' referencing '\n                                   || v_edge_vt_name\n                                   || ' ( '\n                                   || v_vertex_columns_comma_sep\n                                   || ' )'\n            );\n          END IF;\n        END IF;\n      END LOOP;\n      CLOSE v_edge_cursor;\n    END IF;\n  END LOOP;\n  CLOSE v_cursor;\nEND;";
    }

    @Override
    public PgqlSqlTrans.TranslationType getTranslationType() {
        return PgqlSqlTrans.TranslationType.CALL;
    }
}

