/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import oracle.pgx.api.PgxFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BatchTask.class);
    private final List<T> elements;
    private final Function<List<T>, PgxFuture<?>> uploadFunction;
    private final Predicate<Throwable> retryPredicate;
    private final AtomicBoolean globalAbortFlag;

    public BatchTask(List<T> elements, Function<List<T>, PgxFuture<?>> uploadFunction, Predicate<Throwable> retryPredicate, AtomicBoolean globalAbortFlag) {
        this.elements = elements;
        this.uploadFunction = uploadFunction;
        this.retryPredicate = retryPredicate;
        this.globalAbortFlag = globalAbortFlag;
    }

    private String getId() {
        return Integer.toHexString(System.identityHashCode(this));
    }

    public PgxFuture<Void> upload() {
        if (this.globalAbortFlag.get()) {
            LOG.debug("global abort flag is set, completing [{}] without doing anything", (Object)this);
            return PgxFuture.completedFuture(null);
        }
        PgxFuture promise = new PgxFuture();
        if (LOG.isDebugEnabled()) {
            promise.whenComplete((unused, throwable) -> LOG.debug("promise of task {} completed", (Object)this));
        }
        this.uploadFunction.apply(this.elements).thenAccept(o -> promise.complete(null)).exceptionally(throwable -> {
            this.splitTaskOnException((PgxFuture<Void>)promise, (Throwable)throwable);
            return null;
        });
        return promise;
    }

    public void splitTaskOnException(PgxFuture<Void> promise, Throwable throwable) {
        if (this.globalAbortFlag.get()) {
            LOG.debug("aborting [{}] bc. global abort flag is set", (Object)this);
            promise.completeExceptionally(throwable);
            return;
        }
        if (this.elements.size() == 1) {
            LOG.debug("aborting [{}] bc. batch size is already 1", (Object)this);
            this.globalAbortFlag.set(true);
            promise.completeExceptionally(throwable);
            return;
        }
        if (!this.retryPredicate.test(throwable.getCause())) {
            LOG.debug("aborting [{}] bc. throwable is not expected for retry", (Object)this);
            this.globalAbortFlag.set(true);
            promise.completeExceptionally(throwable);
            return;
        }
        int halfElements = this.elements.size() / 2;
        List<T> list1 = this.elements.subList(0, halfElements);
        List<T> list2 = this.elements.subList(halfElements, this.elements.size());
        BatchTask<T> task1 = new BatchTask<T>(list1, this.uploadFunction, this.retryPredicate, this.globalAbortFlag);
        BatchTask<T> task2 = new BatchTask<T>(list2, this.uploadFunction, this.retryPredicate, this.globalAbortFlag);
        LOG.debug("splitting {} into {} and {}", new Object[]{this, task1, task2});
        BatchTask.scheduleUploadTasks(Arrays.asList(task1, task2)).thenComplete(promise);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("#elements", this.elements.size()).toString();
    }

    public static <T> PgxFuture<Void> scheduleUploadTasks(List<BatchTask<T>> tasks) {
        return PgxFuture.allOf(tasks.stream().map(BatchTask::upload).collect(Collectors.toList()));
    }
}

