/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.annotation.Nonnull;
import oracle.pg.rdbms.sqlpgq.SqlPgqGraphBuilder;
import oracle.pg.rdbms.sqlpgq.SqlPgqMetadata;
import oracle.pg.rdbms.sqlpgq.SqlPgqResultSetTable;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgx.graphviz.formatter.Graph;
import oracle.pgx.graphviz.formatter.Table;

class SqlPgqBuilder {
    private SqlPgqMetadata metadata;
    private Graph graph;
    private Table table;

    SqlPgqBuilder(String query, Connection conn) {
        this.metadata = new SqlPgqMetadata(query, conn);
    }

    public void build() throws SQLException {
        try {
            this.graph = new WithQueryVariablesDetected(this.metadata).createMaterializedView().generateVertexAndEdgeQueries().executeVertexEdgeQueriesAndBuildGraphWithResult();
            this.table = this.buildTable();
        }
        finally {
            this.metadata.dropViewAndMaterializedView();
        }
    }

    public Table buildTable() throws SQLException {
        String query = String.format("SELECT * FROM %s", PgqlUtils.printIdentifier((String)this.metadata.getMaterializedViewName()));
        Statement statement = this.metadata.getConnection().createStatement();
        ResultSet rs = statement.executeQuery(query);
        List<String> header = this.metadata.getOriginalHeader();
        return new SqlPgqResultSetTable(rs, header);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Table getTable() {
        return this.table;
    }

    public String getGraphName() {
        return this.metadata.getGraphName();
    }

    @Nonnull
    public String getGraphSchemaName() {
        return this.metadata.getGraphSchemaName();
    }

    public SqlPgqMetadata getSqlPgqMetadata() {
        return this.metadata;
    }

    public boolean isVisualizable() {
        return this.metadata.isVisualizable();
    }

    public long getSize() {
        return this.metadata.getSize();
    }

    private static class WithVertexAndEdgeQueries {
        private SqlPgqMetadata metadata;

        private WithVertexAndEdgeQueries(SqlPgqMetadata metadata) {
            this.metadata = metadata;
        }

        private Graph executeVertexEdgeQueriesAndBuildGraphWithResult() throws SQLException {
            SqlPgqGraphBuilder graphBuilder = new SqlPgqGraphBuilder(this.metadata);
            return graphBuilder.build();
        }
    }

    private static class WithMaterializedViewCreated {
        private SqlPgqMetadata metadata;

        private WithMaterializedViewCreated(SqlPgqMetadata metadata) {
            this.metadata = metadata;
        }

        private WithVertexAndEdgeQueries generateVertexAndEdgeQueries() throws SQLException {
            this.metadata.createVertexAndEdgeQueries();
            return new WithVertexAndEdgeQueries(this.metadata);
        }
    }

    private static class WithQueryVariablesDetected {
        private SqlPgqMetadata metadata;

        private WithQueryVariablesDetected(SqlPgqMetadata metadata) {
            this.metadata = metadata;
        }

        private WithMaterializedViewCreated createMaterializedView() throws SQLException {
            this.metadata.createMaterializedView();
            return new WithMaterializedViewCreated(this.metadata);
        }
    }
}

