/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.imports.parser;

import oracle.pg.imports.GraphImportInputFormat;
import oracle.pg.imports.GraphImporter;
import oracle.pg.imports.exceptions.GraphImportException;
import oracle.pg.imports.parser.graphson.GraphsonParser;

public final class ReaderFactory {
    public static GraphsonParser getReader(GraphImportInputFormat format, GraphImporter importer) throws GraphImportException {
        if (format == null) {
            throw new GraphImportException("Input format not valid.");
        }
        GraphsonParser reader = null;
        if (format == GraphImportInputFormat.GRAPHSON) {
            reader = new GraphsonParser();
        }
        if (reader == null) {
            throw new GraphImportException(String.format("Input format: %s not valid.", new Object[]{format}));
        }
        ReaderFactory.initReader(reader, format, importer);
        return reader;
    }

    private static void initReader(GraphsonParser reader, GraphImportInputFormat format, GraphImporter importer) {
        if (format == GraphImportInputFormat.GRAPHSON) {
            GraphsonParser graphsonParser = reader;
            graphsonParser.setStringFieldsSize(importer.getStringFieldsSize()).setFractionalSecondsPrecision(importer.getFractionalSecondsPrecision());
        }
        reader.setFilePath(importer.getFilePath()).setConnectionManager(importer.getConnectionManager()).setBatchSize(importer.getBatchSize()).setThreads(importer.getThreads());
    }
}

