/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.net.URI;
import oracle.pgx.config.LinkTemplateUtils;

public enum LinkTemplate {
    SESSIONS("core/v1/sessions"),
    DESTROY_SESSION("core/v1/session"),
    LISTENERS("core/v1/listeners"),
    DESCRIBE_FRAME("core/v1/describeFrame"),
    CREATE_FRAME_BUILDER("core/v1/createFrameBuilder"),
    ADD_ROWS_TO_FRAME_BUILDER("core/v1/frameBuilders/x-frame-builder-id/rows"),
    BUILD_FRAME("core/v1/frameBuilders/x-frame-builder-id/build"),
    DESTROY_FRAME_BUILDER("core/v1/frameBuilders/x-frame-builder-id"),
    LOAD_FRAME("core/v1/loadFrame"),
    FRAME_SELF("core/v1/frames/x-frame-id"),
    FRAME_COLUMN_SELF("core/v1/frames/x-frame-id/columns/x-column-id"),
    STORE_FRAME("core/v1/frames/x-frame-id/store"),
    SELECT_FRAME("core/v1/frames/x-frame-id/select"),
    FLATTEN_FRAME("core/v1/frames/x-frame-id/flatten"),
    FRAME_HEAD("core/v1/frames/x-frame-id/extractHead"),
    FRAME_TAIL("core/v1/frames/x-frame-id/extractTail"),
    FRAME_COUNT("core/v1/frames/x-frame-id/count"),
    FRAME_UNION("core/v1/frames/union"),
    FRAME_JOIN("core/v1/frames/join"),
    FRAME_PRINT("core/v1/frames/x-frame-id/print"),
    FRAME_TO_PGQL_RESULTSET("core/v1/frames/x-frame-id/pgqlResultSet"),
    FRAMES_SELF("core/v1/frames"),
    LOAD_GRAPH("core/v1/loadGraph"),
    CHANGES("core/v1/changes"),
    BUILD_GRAPH("core/v1/buildGraph"),
    BUILD_GRAPH_SNAPSHOT("core/v1/buildGraphSnapshot"),
    ALTER_GRAPH("core/v1/alterGraph"),
    ALTER_GRAPH_SNAPSHOT("core/v1/alterGraphSnapshot"),
    DESCRIBE_GRAPH("core/v2/describe"),
    DESCRIBE_GRAPH_LEGACY("core/v1/describe"),
    COMPILE_PROGRAM("core/v1/compileAnalysis"),
    REFRESH_GRAPH("core/v1/graphs/x-graph-id/refresh"),
    IS_FRESH_GRAPH("core/v1/graphs/x-graph-id/isFresh"),
    COMPUTE_PATH("core/v1/graphs/x-graph-id/computePath"),
    RENAME_GRAPH("core/v1/graphs/x-graph-id/name"),
    PUBLISH_GRAPH("core/v1/graphs/x-graph-id/publish"),
    GRAPH_IS_PUBLISHED("core/v1/graphs/x-graph-id/isPublished"),
    CORE_PIN_GRAPH("core/v1/graphs/x-graph-id/pin"),
    GRAPH_IS_PINNED("core/v1/graphs/x-graph-id/isPinned"),
    COMBINE_PROPERTIES("core/v1/graphs/x-graph-id/combineProperties"),
    EXISTS("core/v1/graphs/x-graph-id/exists"),
    EXISTS_IN_TABLE("core/v1/graphs/x-graph-id/tables/x-table-name/exists"),
    STORE("core/v1/graphs/x-graph-id/store"),
    CREATE_GRAPH_FROM_FRAMES("core/v1/createGraphFromFrames"),
    SORT_BY_DEGREE("core/v1/graphs/x-graph-id/sortByDegree"),
    UNDIRECT("core/v1/graphs/x-graph-id/undirect"),
    TRANSPOSE("core/v1/graphs/x-graph-id/transpose"),
    SIMPLIFY("core/v1/graphs/x-graph-id/simplify"),
    BIPARTITE_SUBGRAPHS("core/v1/graphs/x-graph-id/bipartiteSubgraphs"),
    FROM_FILTER_SUBGRAPHS("core/v1/graphs/x-graph-id/fromFilterSubgraphs"),
    SPARSIFIED_SUBGRAPHS("core/v1/graphs/x-graph-id/sparsifiedSubgraphs"),
    CLONE("core/v1/graphs/x-graph-id/clone"),
    RANDOM_ENTITY("core/v1/graphs/x-graph-id/randomEntity"),
    EXPAND_GRAPH("core/v1/graphs/x-graph-id/beta/expandGraph"),
    GRAPH_SELF("core/v1/graphs/x-graph-id"),
    GRAPH_BY_NAME("core/v1/getGraphByName"),
    GRAPH_NAMES_SELF("core/v1/graphNames/x-namespace-id"),
    GRAPHS_SELF("core/v1/graphs"),
    MLMODEL_SELF("core/v1/mlModels/x-model-name"),
    PG2VEC_MODELS("core/v1/pg2vecMlModels"),
    GRAPHWISE_MODELS("core/v1/graphWiseMlModels"),
    UNSUPERVISED_GRAPHWISE_MODELS("core/v1/unsupervisedGraphWiseMlModels"),
    EDGEWISE_MODELS("core/v1/edgeWiseMlModels"),
    UNSUPERVISED_EDGEWISE_MODELS("core/v1/unsupervisedEdgeWiseMlModels"),
    DEEPWALK_MODELS("core/v1/deepWalkMlModels"),
    FIT_PG2VEC_MODEL("core/v1/pg2vecMlModels/x-model-name/fit"),
    FIT_DEEPWALK_MODEL("core/v1/deepWalkMlModels/x-model-name/fit"),
    FIT_GRAPHWISE_MODEL("core/v1/graphWiseMlModels/x-model-name/fit"),
    FIT_EDGEWISE_MODEL("core/v1/edgeWiseMlModels/x-model-name/fit"),
    FIT_UNSUPERVISED_EDGEWISE_MODEL("core/v1/unsupervisedEdgeWiseMlModels/x-model-name/fit"),
    FIT_UNSUPERVISED_GRAPHWISE_MODEL("core/v1/unsupervisedGraphWiseMlModels/x-model-name/fit"),
    INFER_GRAPHLET_PG2VEC_MODEL("core/v1/pg2vecMlModels/x-model-name/infer"),
    INFER_GRAPHWISE_MODEL("core/v1/graphWiseMlModels/x-model-name/infer"),
    INFER_EDGEWISE_MODEL("core/v1/edgeWiseMlModels/x-model-name/infer"),
    INFER_UNSUPERVISED_EDGEWISE_MODEL("core/v1/unsupervisedEdgeWiseMlModels/x-model-name/infer"),
    INFER_UNSUPERVISED_GRAPHWISE_MODEL("core/v1/unsupervisedGraphWiseMlModels/x-model-name/infer"),
    INFER_ANOMALY_UNSUPERVISED_GRAPHWISE_MODEL("core/v1/unsupervisedGraphWiseMlModels/x-model-name/inferAnomaly"),
    FIND_ANOMALY_THRESHOLD_UNSUPERVISED_GRAPHWISE_MODEL("core/v1/unsupervisedGraphWiseMlModels/x-model-name/findAnomalyThreshold"),
    EXPLAIN_GRAPHWISE_MODEL("core/v1/graphWiseMlModels/x-model-name/explain"),
    COMPUTE_SIMILARS_PG2VEC_MODEL("core/v1/pg2vecMlModels/x-model-name/computeSimilars"),
    COMPUTE_SIMILARS_DEEPWALK_MODEL("core/v1/deepWalkMlModels/x-model-name/computeSimilars"),
    COMPUTE_SIMILARS_BATCHED_PG2VEC_MODEL("core/v1/pg2vecMlModels/x-model-name/computeSimilarsBatch"),
    COMPUTE_SIMILARS_BATCHED_DEEPWALK_MODEL("core/v1/deepWalkMlModels/x-model-name/computeSimilarsBatch"),
    GET_MODEL_DATA_PG2VEC_MODEL("core/v1/pg2vecMlModels/x-model-name/trainedGraphletVectors"),
    GET_MODEL_DATA_DEEPWALK_MODEL("core/v1/deepWalkMlModels/x-model-name/trainedVertexVectors"),
    GET_TRAINING_LOG_EDGEWISE_MODEL("core/v1/edgeWiseMlModels/x-model-name/getTrainingLog"),
    GET_TRAINING_LOG_GRAPHWISE_MODEL("core/v1/graphWiseMlModels/x-model-name/getTrainingLog"),
    GET_TRAINING_LOG_UNSUPERVISED_EDGEWISE_MODEL("core/v1/unsupervisedEdgeWiseMlModels/x-model-name/getTrainingLog"),
    GET_TRAINING_LOG_UNSUPERVISED_GRAPHWISE_MODEL("core/v1/unsupervisedGraphWiseMlModels/x-model-name/getTrainingLog"),
    LOAD_MODEL("core/v1/loadModel"),
    STORE_MODEL_DATA_WITH_CONFIG("core/v1/mlModels/x-model-name/storeWithConfig"),
    DELETE_MODEL("core/v1/mlModels/x-model-store-name/x-model-name/delete"),
    GET_MODEL_DESCRIPTION("core/v1/mlModels/x-model-store-name/x-model-name/description"),
    CREATE_MODEL_STORE("core/v1/modelStores"),
    DELETE_MODEL_STORE("core/v1/modelStores/x-model-store-name/delete"),
    LIST_MODEL_STORES("core/v1/modelStores/list"),
    LIST_MODELS_IN_MODEL_STORE("core/v1/modelStores/x-model-store-name/models"),
    FUTURE_STATUS("{context}/v1/futures/x-future-id/status"),
    FUTURE_CANCEL("{context}/v1/futures/x-future-id"),
    FUTURE_VALUE("{context}/v1/futures/x-future-id/value"),
    VERTEX_SELF("core/v1/graphs/x-graph-id/vertices/x-vertex-id"),
    VERTEX_IN_TABLE_SELF("core/v1/graphs/x-graph-id/tables/x-table-name/vertices/x-vertex-id"),
    VERTEX_LABEL_SELF("core/v1/graphs/x-graph-id/vertices/x-vertex-id/labelsSet"),
    VERTEX_NEIGHBORS("core/v1/graphs/x-graph-id/vertices/x-vertex-id/neighbors"),
    CONNECTED_EDGES("core/v1/graphs/x-graph-id/vertices/x-vertex-id/connectedEdges"),
    EDGE_COUNT("core/v1/graphs/x-graph-id/vertices/x-vertex-id/edgeCount"),
    EDGE_SELF("core/v1/graphs/x-graph-id/edges/x-edge-id"),
    EDGE_IN_TABLE_SELF("core/v1/graphs/x-graph-id/tables/x-table-name/edges/x-edge-id"),
    EDGE_LABEL_SELF("core/v1/graphs/x-graph-id/edges/x-edge-id/label"),
    VERTEX_FROM_EDGE("core/v1/graphs/x-graph-id/edges/x-edge-id/vertex"),
    PROPERTIES_SELF("core/v1/graphs/x-graph-id/properties"),
    PROPERTY_SELF("core/v1/graphs/x-graph-id/properties/x-property-name"),
    PROPERTY_VALUE_SELF("core/v1/graphs/x-graph-id/properties/x-property-name/values/x-property-key"),
    PROPERTY_CLONE("core/v1/graphs/x-graph-id/properties/x-property-name/clone"),
    PROPERTY_EXPAND("core/v1/graphs/x-graph-id/properties/x-property-name/expand"),
    PROPERTY_IS_PUBLISHED("core/v1/graphs/x-graph-id/properties/x-property-name/isPublished"),
    PUBLISH_PROPERTY("core/v1/graphs/x-graph-id/properties/x-property-name/publish"),
    PROPERTY_NAME("core/v1/graphs/x-graph-id/properties/x-property-name/name"),
    PROPERTY_FILL("core/v1/graphs/x-graph-id/properties/x-property-name/fillValue"),
    PROPERTY_VALUES("core/v1/graphs/x-graph-id/properties/x-property-name/values"),
    SCALAR_VALUE_SELF("core/v1/scalars/x-scalar-name/value"),
    SCALAR_SELF("core/v1/scalars/x-scalar-name"),
    SCALARS_SELF("core/v1/scalars"),
    MAPS_SELF("core/v1/maps"),
    MAP_SELF("core/v1/maps/x-map-name"),
    MAP_ENTRIES("core/v1/maps/x-map-name/entries"),
    MAP_PROXY_SELF("core/v1/mapProxies/x-proxy-id"),
    MAP_PROXY_KEYS("core/v1/mapProxies/x-proxy-id/keys"),
    MAP_PROXY_KEY("core/v1/mapProxies/x-proxy-id/keys/x-map-key"),
    MAP_PROXY_ENTRIES("core/v1/mapProxies/x-proxy-id/entries"),
    MAP_ENTRY_SELF("core/v1/maps/x-map-name/entries/x-map-key"),
    MAP_ENTRY("core/v1/maps/x-map-name/entries/x-map-key"),
    MAP_EXTRACT_TOPK("core/v1/maps/x-map-name/extractTopK"),
    MAP_PROXY_VALUE("core/v1/mapProxies/x-proxy-id/keys/x-map-key/value"),
    MAP_PROXIES_SELF("core/v1/mapProxies"),
    PGQL_RESULT_PROXIES("core/v1/pgqlProxies"),
    PGQL_RESULT_PROXY_SELF("core/v1/pgqlProxies/x-proxy-id"),
    PGQL_RESULT_PROXY_RESULTS("core/v1/pgqlProxies/x-proxy-id/results"),
    PGQL_RESULT_PROXY_ELEMENTS("core/v1/pgqlProxies/x-proxy-id/elements"),
    PGQL_RESULT_PROXY_TO_FRAME("core/v1/pgqlProxies/x-proxy-id/toFrame"),
    PGQL_RUN("core/v1/pgql/run"),
    PGQL_EXECUTE("core/v1/pgql/execute"),
    PGQL_CLONE_AND_EXECUTE("core/v1/pgql/cloneAndExecute"),
    PGQL_EXPLAIN("core/v1/pgql/explain"),
    PGQL_QUERY_RESULT_SELF("core/v1/pgql/queryResults/x-result-set-id"),
    PGQL_PREPARE("core/v1/pgql/prepare"),
    PGQL_PREPARED_STATEMENT_EXECUTE("core/v1/pgql/preparedStatements/x-ps-id/execute"),
    PGQL_PREPARED_STATEMENT("core/v1/pgql/preparedStatements/x-ps-id"),
    COLLECTION_INFO_SELF("core/v1/collections/x-collection-name"),
    PGQL_PREPARED_STATEMENT_EXECUTE_ANY("core/v1/pgql/preparedStatements/x-ps-id/executeAny"),
    REDACTION("core/v1/redactions"),
    REDACTION_DELETE("core/v1/redactions-delete"),
    COLLECTIONS_SELF("core/v1/collections"),
    COLLECTION_CONTAINS("core/v1/collections/x-collection-name/contains"),
    COLLECTION_ELEMENTS("core/v1/collections/x-collection-name/elements"),
    COLLECTION_PROXY_SELF("core/v1/collectionProxies/x-proxy-id"),
    COLLECTION_TO_MUTABLE("core/v1/collections/x-collection-name/toMutable"),
    COLLECTION_IS_MUTABLE("core/v1/collections/x-collection-name/isMutable"),
    COLLECTION_CLONE("core/v1/collections/x-collection-name/clone"),
    COLLECTION_ADD_ELEMENTS("core/v1/collections/x-collection-name/elements"),
    COLLECTION_REMOVE_ELEMENTS("core/v1/collections/x-collection-name/elements"),
    COLLECTION_PROXY_ELEMENTS("core/v1/collectionProxies/x-proxy-id/elements"),
    COLLECTION_PROXIES_SELF("core/v1/collectionProxies"),
    ANALYSES_SELF("core/v1/analyses"),
    ANALYSES_IDS_SELF("core/v1/availableAnalysesIds"),
    ANALYSIS_SELF("core/v1/analyses/x-aid"),
    ANALYSIS_RUN("core/v1/analyses/x-aid/run"),
    ALLPATH_PROXY_SELF("core/v1/pathProxies/x-proxy-id"),
    ALLPATH_PROXY_PATH_SELF("core/v1/pathProxies/x-proxy-id/paths/x-destination"),
    ALLPATH_PROXIES_SELF("core/v1/pathProxies"),
    SNAPSHOT_SELF("core/v1/graphs/x-graph-id/snapshots/x-creation-ts"),
    LOOK_UP_SNAPSHOTS("core/v1/lookupSnapshots"),
    LOOK_UP_SNAPSHOTS_BY_ID("core/v1/graphs/x-graph-id/snapshots"),
    SNAPSHOT_CHECKOUT("core/v1/graphs/x-graph-id/snapshots/x-creation-ts/checkout"),
    PROPERTY_PROXIES_SELF("core/v1/propertyProxies"),
    PROPERTY_PROXY_VALUE_SELF("core/v1/propertyProxies/x-proxy-id/values/x-property-key"),
    PROPERTY_PROXY_SELF("core/v1/propertyProxies/x-proxy-id"),
    PROPERTY_PROXY_VALUES("core/v1/propertyProxies/x-proxy-id/values"),
    PROPERTY_PROXY_TOPK("core/v1/propertyProxies/x-proxy-id/topKValues"),
    PROPERTY_PROXY_BOTTOMK("core/v1/propertyProxies/x-proxy-id/bottomKValues"),
    COMPONENTS_PROXY_SELF("core/v1/componentsProxies/x-proxy-id"),
    COMPONENTS_FOR_ID("core/v1/componentsProxies/x-proxy-id/componentIds/x-node"),
    COMPONENTS_PROXIES_SELF("core/v1/componentsProxies"),
    COMPONENT_STORAGES_SELF("core/v1/componentStorages"),
    COMPONENT_STORAGE_SELF("core/v1/componentStorages/x-component-storage-name"),
    COMPONENT_CONTAINS("core/v1/componentStorages/x-component-storage-name/components/x-id/contains"),
    EXECUTION_ENVIRONMENT("core/v1/executionEnvironment"),
    UPDATE_EXECUTION_ENVIRONMENT("core/v1/executionEnvironment"),
    USER_GRAPH_PERMISSION("core/v1/graphs/x-graph-id/currentUserPermission"),
    GRANT_GRAPH_PERMISSION("core/v1/graphs/x-graph-id/grantPermission"),
    REVOKE_GRAPH_PERMISSION("core/v1/graphs/x-graph-id/revokePermission"),
    VERSION_SELF("{context}/{version}"),
    PGX_CONFIG("control/v1/pgxConfig"),
    START_ENGINE("control/v1/start"),
    SHUTDOWN_ENGINE("control/v1/shutdown"),
    ENGINE_IS_RUNNING("control/v1/isRunning"),
    ENGINE_IS_READY("control/v1/isReady"),
    ENGINE_HAS_SESSIONS("control/v1/hasSessions"),
    IS_GRAPH_PRELOADING_DONE("control/v1/isGraphPreloadingDone"),
    SERVER_STATE("control/v1/serverState"),
    SESSIONS_INFOS("control/v1/sessions"),
    SESSION_SELF("control/v1/sessions/x-session-id"),
    SHARED_GRAPHS("control/v1/graphs"),
    SHARED_GRAPH_INFO("control/v1/graphs/x-graph-name"),
    GRAPH_INFO("control/v1/sessions/x-session-id/graphs/x-graph-name"),
    MEMORY_INFO("control/v1/memoryInfo"),
    MEMORY_CLEANUP("control/v1/freeCachedMemory"),
    THREAD_POOL_INFO("control/v1/threadPool/lookup"),
    ADMIN_UNPIN("control/v1/unpinGraph"),
    UPDATE_PGX_CONFIG("control/v1/updatePgxConfig"),
    MAX_SESSION_MEMORY_LIMIT("control/v1/maxMemory/x-session-id"),
    CURRENT_USER_NAME("control/v1/currentUserName"),
    CURRENT_USER_ROLES("control/v1/currentUserRoles"),
    CURRENT_USER_SYSTEM_PERMISSIONS("control/v1/currentUserSystemPermissions"),
    GET_RESOURCE_ELASTICITY_STATUS("cluster/v1/resourceElasticityStatus"),
    UPDATE_MAX_ATTAINABLE_RESOURCES("cluster/v1/maxAttainableResources"),
    ADD_HOST("cluster/v1/hostAddition"),
    REMOVE_HOST("cluster/v1/hostRemoval"),
    VERSION("version"),
    IS_RUNNING("isRunning"),
    IS_READY("isReady"),
    HAS_SESSIONS("hasSessions");

    private final String text;

    private LinkTemplate(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    public URI generateLink(URI baseURI, Object ... params) {
        return LinkTemplateUtils.generateLink(baseURI, this.text, params);
    }

    public URI generateLink(Object ... params) {
        return LinkTemplateUtils.generateLink(this.text, params);
    }

    public String generateUrl(URI baseUri, Object ... params) {
        return this.generateLink(baseUri, params).toString();
    }
}

