/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.common.Either;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.Self;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.function.QuadFunction;
import oracle.pgx.common.util.internal.EdgeDeserializer;
import oracle.pgx.common.util.internal.VertexDeserializer;

public final class EntityDeserializationHelper {
    public static <E extends Entity> E deserialize(JsonParser jp, DeserializationContext ctxt, String defaultTableName, IdType defaultIdType, QuadFunction<PgxId, String, IdType, Object, E> newEntity) throws IOException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        PgxId graphId = JsonUtil.fromJsonNode(node.get("graphId"), PgxId.class);
        JsonNode tableNameNode = node.get("tableName");
        String tableName = tableNameNode == null ? defaultTableName : JsonUtil.fromJsonNode(tableNameNode, String.class);
        JsonNode idTypeNode = node.get("idType");
        IdType keyType = idTypeNode == null ? defaultIdType : JsonUtil.fromJsonNode(idTypeNode, IdType.class);
        Object key = JsonUtil.fromJsonNode(node.get("key"), keyType.getTypeClass());
        Self self = JsonUtil.fromJsonNode(node, Self.class);
        Entity e = (Entity)((Object)newEntity.apply((Object)graphId, (Object)tableName, (Object)keyType, key));
        e.setLinks(self.getLinks());
        return (E)((Object)e);
    }

    public static Either<Entity, Object> deserializeEntityOrKey(JsonNode valueNode) throws IOException {
        EntityType entityType;
        JsonNode entityTypeNode = valueNode.get("entityType");
        EntityType entityType2 = entityType = entityTypeNode != null ? JsonUtil.fromJsonNode(entityTypeNode, EntityType.class) : null;
        if (entityType != null) {
            JsonParser parser = JsonUtil.treeAsTokens((TreeNode)valueNode);
            DeserializationContext ctxt = JsonUtil.getDeserializationContext();
            switch (entityType) {
                case VERTEX: {
                    return Either.left((Object)((Object)VertexDeserializer.getDeserializer().deserialize(parser, ctxt)));
                }
                case EDGE: {
                    return Either.left((Object)((Object)EdgeDeserializer.getDeserializer().deserialize(parser, ctxt)));
                }
            }
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ENTITY_TYPE", (Object[])new Object[]{entityType}));
        }
        return Either.right((Object)JsonUtil.fromJsonNode(valueNode, Object.class));
    }

    private EntityDeserializationHelper() {
    }
}

