/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.spatial;

import java.io.Serializable;
import oracle.pgql.lang.spatial.WktParseException;

public class Point2D
implements Serializable {
    private final double x;
    private final double y;
    private final double m;

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
        this.m = Double.NaN;
    }

    public Point2D(double x, double y, double m) {
        this.x = x;
        this.y = y;
        this.m = m;
    }

    public static Point2D fromWkt(String wktPoint) {
        if (wktPoint.indexOf(40) == -1 || wktPoint.indexOf(41) == -1 || wktPoint.indexOf(40) > wktPoint.indexOf(41)) {
            throw new WktParseException(wktPoint + " is not in the right format");
        }
        String prefix = wktPoint.substring(0, wktPoint.indexOf(40));
        String values = wktPoint.substring(wktPoint.indexOf(40) + 1, wktPoint.indexOf(41));
        int xValEndPos = values.indexOf(32);
        if (xValEndPos == -1) {
            throw new WktParseException(wktPoint + " is not in the right format");
        }
        Double xVal = Double.parseDouble(values.substring(0, xValEndPos));
        int yValStartPos = values.indexOf(32) + 1;
        switch (prefix.trim()) {
            case "POINT": {
                Double yVal = Double.parseDouble(values.substring(yValStartPos, values.length()));
                return new Point2D(xVal, yVal);
            }
            case "POINT M": {
                int yValEndPos = values.substring(yValStartPos).indexOf(32) + yValStartPos + 1;
                Double yVal = Double.parseDouble(values.substring(yValStartPos, yValEndPos));
                Double mVal = Double.parseDouble(values.substring(yValEndPos));
                return new Point2D(xVal, yVal, mVal);
            }
        }
        throw new WktParseException(wktPoint + " is not in the right format");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Point2D)) {
            return false;
        }
        Point2D point = (Point2D)o;
        if (Double.compare(point.getX(), this.x) != 0) {
            return false;
        }
        if (Double.compare(point.getY(), this.y) != 0) {
            return false;
        }
        return Double.compare(point.getM(), this.m) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.getX());
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getY());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getM());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getM() {
        return this.m;
    }
}

