/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ddl.propertygraph;

import java.util.List;
import java.util.stream.Collectors;
import oracle.pgql.lang.ddl.propertygraph.BaseElementTable;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class BaseGraph {
    private SchemaQualifiedName graphName;
    private List<BaseElementTable> baseElementTables;
    private List<String> allElementTablesExcept;

    public BaseGraph(SchemaQualifiedName graphName, List<BaseElementTable> baseElementTables, List<String> allElementTablesExcept) {
        this.graphName = graphName;
        this.baseElementTables = baseElementTables;
        this.allElementTablesExcept = allElementTablesExcept;
    }

    public SchemaQualifiedName getGraphName() {
        return this.graphName;
    }

    public void setGraphName(SchemaQualifiedName graphName) {
        this.graphName = graphName;
    }

    public List<BaseElementTable> getBaseElementTables() {
        return this.baseElementTables;
    }

    public void setBaseElementTables(List<BaseElementTable> baseElementTables) {
        this.baseElementTables = baseElementTables;
    }

    public List<String> getAllElementTablesExcept() {
        return this.allElementTablesExcept;
    }

    public void setAllElementTablesExcept(List<String> allElementTablesExcept) {
        this.allElementTablesExcept = allElementTablesExcept;
    }

    public String toString() {
        String result = this.graphName.toString(true);
        result = this.baseElementTables != null ? result + " ELEMENT TABLES ( " + this.baseElementTables.stream().map(x -> x.toString()).collect(Collectors.joining(", ")) + ")" : (this.allElementTablesExcept != null ? result + " ALL ELEMENT TABLES EXCEPT ( " + this.allElementTablesExcept.stream().map(x -> PgqlUtils.printIdentifier(x)).collect(Collectors.joining(", ")) + " )" : result + " ALL ELEMENT TABLES");
        return result;
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseGraph other = (BaseGraph)obj;
        if (this.allElementTablesExcept == null ? other.allElementTablesExcept != null : !this.allElementTablesExcept.equals(other.allElementTablesExcept)) {
            return false;
        }
        if (this.baseElementTables == null ? other.baseElementTables != null : !this.baseElementTables.equals(other.baseElementTables)) {
            return false;
        }
        return !(this.graphName == null ? other.graphName != null : !this.graphName.equals(other.graphName));
    }
}

