/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ddl;

import java.util.List;
import java.util.stream.Collectors;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.StatementType;

public class CallStatement
implements PgqlStatement {
    private String schemaName;
    private String packageName;
    private String routineName;
    private List<QueryExpression> argumentList;

    public CallStatement(String routineName, List<QueryExpression> argumentList) {
        this(null, routineName, argumentList);
    }

    public CallStatement(String packageName, String routineName, List<QueryExpression> argumentList) {
        this(null, packageName, routineName, argumentList);
    }

    public CallStatement(String schemaName, String packageName, String routineName, List<QueryExpression> argumentList) {
        this.schemaName = schemaName;
        this.packageName = packageName;
        this.routineName = routineName;
        this.argumentList = argumentList;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getRoutineName() {
        return this.routineName;
    }

    public void setRoutineName(String routineName) {
        this.routineName = routineName;
    }

    public List<QueryExpression> getArgumentList() {
        return this.argumentList;
    }

    public void setArgumentList(List<QueryExpression> argumentList) {
        this.argumentList = argumentList;
    }

    public String toString() {
        String schemaNamePart = this.schemaName == null ? "" : PgqlUtils.printIdentifier(this.schemaName, false) + ".";
        String packageNamePart = this.packageName == null ? "" : PgqlUtils.printIdentifier(this.packageName, false) + ".";
        String arguments = this.argumentList.stream().map(Object::toString).collect(Collectors.joining(", "));
        return "CALL " + schemaNamePart + packageNamePart + PgqlUtils.printIdentifier(this.routineName, false) + "(" + arguments + ")";
    }

    @Override
    public StatementType getStatementType() {
        return StatementType.CALL;
    }

    public int hashCode() {
        return 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallStatement other = (CallStatement)obj;
        if (this.argumentList == null ? other.argumentList != null : !this.argumentList.equals(other.argumentList)) {
            return false;
        }
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        if (this.routineName == null ? other.routineName != null : !this.routineName.equals(other.routineName)) {
            return false;
        }
        return !(this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName));
    }
}

