# Copyright (c) 2014, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

import unittest

from cybox.test import EntityTestCase, round_trip
from maec.package.analysis import Analysis


class TestPackage(EntityTestCase, unittest.TestCase):
    klass = Analysis

    _full_dict = {

    }

    def test_id_autoset(self):
        o = Analysis()
        self.assertNotEqual(o.id_, None)

    def test_round_trip(self):
        o = Analysis()
        o2 = round_trip(o)

        self.assertEqual(o.to_dict(), o2.to_dict())

if __name__ == "__main__":
    unittest.main()
    