from zope.interface import implements

from collective.wtf.interfaces import ICSVWorkflowConfig

class DefaultConfig(object):
    implements(ICSVWorkflowConfig)
    
    known_roles = ['Anonymous', 'Manager', 'Owner', 'Reader', 'Editor', 'Contributor']
    known_permissions = ['Access contents information', 'View', 'Modify portal content']
    
    # remember to call .copy() when using these!
        
    info_template = {'id': '',
                     'title': '',
                     'description': "",
                     'state_variable': 'review_state',
                     'initial_state': '',
                     'permissions': [],
                     'script_info': [],
                     'state_info': [],
                     'transition_info': [],
                     'worklist_info': [],
                     'manager_bypass': False,
                     'creation_guard': None,
                     'variable_info': [{'default_expr': 'transition/getId|nothing',
                                        'default_type': 'string',
                                        'default_value': '',
                                        'description': 'Previous transition\n',
                                        'for_catalog': False,
                                        'for_status': True,
                                        'guard_expr': '',
                                        'guard_groups': (),
                                        'guard_permissions': (),
                                        'guard_roles': (),
                                        'id': 'action',
                                        'update_always': True},
                                       {'default_expr': 'user/getId',
                                        'default_type': 'string',
                                        'default_value': '',
                                        'description': 'The ID of the user who performed the last transition\n',
                                        'for_catalog': False,
                                        'for_status': True,
                                        'guard_expr': '',
                                        'guard_groups': (),
                                        'guard_permissions': (),
                                        'guard_roles': (),
                                        'id': 'actor',
                                        'update_always': True},
                                       {'default_expr': "python:state_change.kwargs.get('comment', '')",
                                        'default_type': 'string',
                                        'default_value': '',
                                        'description': 'Comment about the last transition\n',
                                        'for_catalog': False,
                                        'for_status': True,
                                        'guard_expr': '',
                                        'guard_groups': (),
                                        'guard_permissions': (),
                                        'guard_roles': (),
                                        'id': 'comments',
                                        'update_always': True},
                                       {'default_expr': 'state_change/getHistory',
                                        'default_type': 'string',
                                        'default_value': '',
                                        'description': 'Provides access to workflow history\n',
                                        'for_catalog': False,
                                        'for_status': False,
                                        'guard_expr': '',
                                        'guard_groups': (),
                                        'guard_permissions': ('Request review',
                                                              'Review portal content'),
                                        'guard_roles': (),
                                        'id': 'review_history',
                                        'update_always': False},
                                       {'default_expr': 'state_change/getDateTime',
                                        'default_type': 'string',
                                        'default_value': '',
                                        'description': 'When the previous transition was performed\n',
                                        'for_catalog': False,
                                        'for_status': True,
                                        'guard_expr': '',
                                        'guard_groups': (),
                                        'guard_permissions': (),
                                        'guard_roles': (),
                                        'id': 'time',
                                        'update_always': True}],}
                
    state_template = {'id': '',
                      'title': '',
                      'description': '',
                      'transitions': (),
                      'groups': [],
                      'permissions': [],
                      'variables': []}
                      
    state_permission_template = {'acquired': False,
                                 'name': '',
                                 'roles': ()}
                                 
    transition_template = {'id': '',
                           'title': '',
                           'description': '',
                           'new_state_id': '',
                           'actbox_category': 'workflow',
                           'actbox_name': '',
                           'actbox_url': '',
                           'actbox_icon': '',
                           'trigger_type': '',
                           'script_name': '',
                           'after_script_name': '',
                           'guard_expr': '',
                           'guard_groups': (),
                           'guard_permissions': (),
                           'guard_roles': (),
                           'variables': []}
                           
    worklist_template = {'id': '',
                         'title': '',
                         'description': '',
                         'actbox_category': 'global',
                         'actbox_name': 'Pending (%(count)d)',
                         'actbox_url': '',
                         'actbox_icon': '',
                         'guard_expr': '',
                         'guard_groups': (),
                         'guard_permissions': (),
                         'guard_roles': (),
                         'var_match': [('review_state', '')]}

    script_template = {'id': '',
                       'meta_type': '',
                       'module': '',
                       'function': '',
                       'filename': ''}
                       
