'''OpenGL extension KHR.texture_compression_astc_ldr

This module customises the behaviour of the 
OpenGL.raw.GL.KHR.texture_compression_astc_ldr to provide a more 
Python-friendly API

Overview (from the spec)
	
	Adaptive Scalable Texture Compression (ASTC) is a new texture
	compression technology that offers unprecendented flexibility,
	while producing better or comparable results than existing texture
	compressions at all bit rates. It includes support for 2D and 3D
	textures, with low and high dynamic range, at bitrates from below
	1 bit/pixel up to 8 bits/pixel in fine steps.
	
	The goal of this extension is to support the 2D, LDR-only profile
	of the ASTC texture compression specification.
	
	ASTC-compressed textures are handled in OpenGL ES and OpenGL by
	adding new supported formats to the existing mechanisms for handling
	compressed textures.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/KHR/texture_compression_astc_ldr.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.KHR.texture_compression_astc_ldr import *
### END AUTOGENERATED SECTION