# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class ApplicationGatewayRewriteRuleSet(SubResource):
    """Rewrite rule set of an application gateway.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param rewrite_rules: Rewrite rules in the rewrite rule set.
    :type rewrite_rules:
     list[~azure.mgmt.network.v2018_12_01.models.ApplicationGatewayRewriteRule]
    :ivar provisioning_state: Provisioning state of the rewrite rule set
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    :param name: Name of the rewrite rule set that is unique within an
     Application Gateway.
    :type name: str
    :ivar etag: A unique read-only string that changes whenever the resource
     is updated.
    :vartype etag: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rewrite_rules': {'key': 'properties.rewriteRules', 'type': '[ApplicationGatewayRewriteRule]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayRewriteRuleSet, self).__init__(**kwargs)
        self.rewrite_rules = kwargs.get('rewrite_rules', None)
        self.provisioning_state = None
        self.name = kwargs.get('name', None)
        self.etag = None
