/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.core.SelfExpandingBufferredInputStream;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.HttpContextProvider;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.microprofile.config.ResteasyConfig;
import org.jboss.resteasy.microprofile.config.ResteasyConfigFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class ApacheHttpClient4Engine
implements ClientHttpEngine {
    private static String processId = null;
    protected HttpClient httpClient;
    protected boolean createdHttpClient;
    protected HttpContext httpContext;
    protected HttpContextProvider httpContextProvider;
    protected boolean closed;
    protected SSLContext sslContext;
    protected HostnameVerifier hostnameVerifier;
    protected int responseBufferSize = 8192;
    protected HttpHost defaultProxy = null;
    protected boolean chunked = false;
    protected boolean followRedirects = false;
    protected int fileUploadInMemoryThresholdLimit = 1;
    protected MemoryUnit fileUploadMemoryUnit = MemoryUnit.MB;
    protected File fileUploadTempFileDir = new File(ResteasyConfigFactory.getConfig().getValue("java.io.tmpdir", ResteasyConfig.SOURCE.SYSTEM));

    public ApacheHttpClient4Engine() {
        this.httpClient = this.createDefaultHttpClient();
        this.createdHttpClient = true;
    }

    public ApacheHttpClient4Engine(HttpHost defaultProxy) {
        this.defaultProxy = defaultProxy;
        this.httpClient = this.createDefaultHttpClient();
        this.createdHttpClient = true;
    }

    public ApacheHttpClient4Engine(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ApacheHttpClient4Engine(HttpClient httpClient, boolean closeHttpClient) {
        this.httpClient = httpClient;
        this.createdHttpClient = closeHttpClient;
    }

    @Deprecated
    public ApacheHttpClient4Engine(HttpClient httpClient, HttpContext httpContext) {
        this.httpClient = httpClient;
        this.httpContext = httpContext;
    }

    public ApacheHttpClient4Engine(HttpClient httpClient, HttpContextProvider httpContextProvider) {
        this.httpClient = httpClient;
        this.httpContextProvider = httpContextProvider;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public int getFileUploadInMemoryThresholdLimit() {
        return this.fileUploadInMemoryThresholdLimit;
    }

    public void setFileUploadInMemoryThresholdLimit(int fileUploadInMemoryThresholdLimit) {
        this.fileUploadInMemoryThresholdLimit = fileUploadInMemoryThresholdLimit;
    }

    public MemoryUnit getFileUploadMemoryUnit() {
        return this.fileUploadMemoryUnit;
    }

    public void setFileUploadMemoryUnit(MemoryUnit fileUploadMemoryUnit) {
        this.fileUploadMemoryUnit = fileUploadMemoryUnit;
    }

    public File getFileUploadTempFileDir() {
        return this.fileUploadTempFileDir;
    }

    public void setFileUploadTempFileDir(File fileUploadTempFileDir) {
        this.fileUploadTempFileDir = fileUploadTempFileDir;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Deprecated
    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    @Deprecated
    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public HttpHost getDefaultProxy() {
        return (HttpHost)this.httpClient.getParams().getParameter("http.route.default-proxy");
    }

    public static CaseInsensitiveMap<String> extractHeaders(HttpResponse response) {
        CaseInsensitiveMap headers = new CaseInsensitiveMap();
        for (Header header : response.getAllHeaders()) {
            headers.add((Object)header.getName(), (Object)header.getValue());
        }
        return headers;
    }

    protected InputStream createBufferedStream(InputStream is) {
        if (this.responseBufferSize == 0) {
            return is;
        }
        if (this.responseBufferSize < 0) {
            return new SelfExpandingBufferredInputStream(is);
        }
        return new BufferedInputStream(is, this.responseBufferSize);
    }

    @Override
    public ClientResponse invoke(ClientInvocation request) {
        HttpResponse res;
        ResteasyProviderFactory.getInstance().property("using.httpClient", (Object)"true");
        String uri = request.getUri().toString();
        HttpRequestBase httpMethod = this.createHttpMethod(uri, request.getMethod());
        try {
            this.loadHttpMethod(request, httpMethod);
            HttpContext ctx = this.httpContext;
            if (ctx == null && this.httpContextProvider != null) {
                ctx = this.httpContextProvider.getContext();
            }
            res = this.httpClient.execute((HttpUriRequest)httpMethod, ctx);
        }
        catch (Exception e) {
            LogMessages.LOGGER.clientSendProcessingFailure(e);
            throw new ProcessingException(Messages.MESSAGES.unableToInvokeRequest(e.toString()), (Throwable)e);
        }
        finally {
            this.cleanUpAfterExecute(httpMethod);
            ResteasyProviderFactory.getInstance().property("using.httpClient", null);
        }
        ClientResponse response = new ClientResponse(request.getClientConfiguration()){
            InputStream stream;
            InputStream hc4Stream;

            @Override
            protected void setInputStream(InputStream is) {
                this.stream = is;
                this.resetEntity();
            }

            public InputStream getInputStream() {
                if (this.stream == null) {
                    HttpEntity entity = res.getEntity();
                    if (entity == null) {
                        return null;
                    }
                    try {
                        this.hc4Stream = entity.getContent();
                        this.stream = ApacheHttpClient4Engine.this.createBufferedStream(this.hc4Stream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.stream;
            }

            public void releaseConnection() throws IOException {
                this.releaseConnection(true);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void releaseConnection(boolean consumeInputStream) throws IOException {
                if (consumeInputStream) {
                    try {
                        if (this.stream != null) {
                            this.stream.close();
                            return;
                        }
                        InputStream is = this.getInputStream();
                        if (is == null) return;
                        is.close();
                        return;
                    }
                    finally {
                        if (this.hc4Stream != null) {
                            try {
                                this.hc4Stream.close();
                            }
                            catch (IOException is) {}
                        } else {
                            try {
                                HttpEntity entity = res.getEntity();
                                if (entity != null) {
                                    entity.getContent().close();
                                }
                            }
                            catch (IOException entity) {}
                        }
                    }
                }
                if (!(res instanceof CloseableHttpResponse)) return;
                try {
                    ((CloseableHttpResponse)res).close();
                    return;
                }
                catch (IOException e) {
                    LogMessages.LOGGER.warn(Messages.MESSAGES.couldNotCloseHttpResponse(), e);
                }
            }
        };
        response.setProperties(request.getMutableProperties());
        response.setStatus(res.getStatusLine().getStatusCode());
        response.setReasonPhrase(res.getStatusLine().getReasonPhrase());
        response.setHeaders((MultivaluedMap<String, String>)ApacheHttpClient4Engine.extractHeaders(res));
        response.setClientConfiguration(request.getClientConfiguration());
        return response;
    }

    protected HttpRequestBase createHttpMethod(String url, String restVerb) {
        if ("GET".equals(restVerb)) {
            return new HttpGet(url);
        }
        if ("POST".equals(restVerb)) {
            return new HttpPost(url);
        }
        final String verb = restVerb;
        return new HttpPost(url){

            public String getMethod() {
                return verb;
            }
        };
    }

    protected HttpClient createDefaultHttpClient() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams((HttpParams)params);
        if (this.defaultProxy != null) {
            params.setParameter("http.route.default-proxy", (Object)this.defaultProxy);
        }
        return new DefaultHttpClient((HttpParams)params);
    }

    protected void setRedirectRequired(ClientInvocation request, HttpRequestBase httpMethod) {
        HttpClientParams.setRedirecting((HttpParams)httpMethod.getParams(), (boolean)true);
    }

    protected void setRedirectNotRequired(ClientInvocation request, HttpRequestBase httpMethod) {
        HttpClientParams.setRedirecting((HttpParams)httpMethod.getParams(), (boolean)false);
    }

    protected void loadHttpMethod(ClientInvocation request, HttpRequestBase httpMethod) throws Exception {
        if (this.isFollowRedirects()) {
            this.setRedirectRequired(request, httpMethod);
        } else {
            this.setRedirectNotRequired(request, httpMethod);
        }
        if (request.getEntity() != null) {
            if (httpMethod instanceof HttpGet) {
                throw new ProcessingException(Messages.MESSAGES.getRequestCannotHaveBody());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            request.getDelegatingOutputStream().setDelegate((OutputStream)baos);
            try {
                HttpEntity entity = this.buildEntity(request);
                HttpPost post = (HttpPost)httpMethod;
                this.commitHeaders(request, httpMethod);
                post.setEntity(entity);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.commitHeaders(request, httpMethod);
        }
    }

    protected void commitHeaders(ClientInvocation request, HttpRequestBase httpMethod) {
        MultivaluedMap<String, String> headers = request.getHeaders().asMap();
        for (Map.Entry header : headers.entrySet()) {
            List values = (List)header.getValue();
            for (String value : values) {
                httpMethod.addHeader((String)header.getKey(), value);
            }
        }
    }

    @Override
    public void close() {
        ClientConnectionManager manager;
        if (this.closed) {
            return;
        }
        if (this.createdHttpClient && this.httpClient != null && (manager = this.httpClient.getConnectionManager()) != null) {
            manager.shutdown();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    protected void cleanUpAfterExecute(HttpRequestBase httpMethod) {
        HttpPost postMethod;
        HttpEntity entity;
        if (httpMethod != null && httpMethod instanceof HttpPost && (entity = (postMethod = (HttpPost)httpMethod).getEntity()) != null && entity instanceof FileExposingFileEntity) {
            File tempRequestFile = ((FileExposingFileEntity)entity).getFile();
            try {
                boolean isDeleted = tempRequestFile.delete();
                if (!isDeleted) {
                    this.handleFileNotDeletedError(tempRequestFile, null);
                }
            }
            catch (Exception ex) {
                this.handleFileNotDeletedError(tempRequestFile, ex);
            }
        }
    }

    protected HttpEntity buildEntity(ClientInvocation request) throws IOException {
        Object entityToBuild = null;
        DeferredFileOutputStream memoryManagedOutStream = this.writeRequestBodyToOutputStream(request);
        MediaType mediaType = request.getHeaders().getMediaType();
        if (memoryManagedOutStream.isInMemory()) {
            ByteArrayEntity entityToBuildByteArray = new ByteArrayEntity(memoryManagedOutStream.getData());
            if (mediaType != null) {
                entityToBuildByteArray.setContentType((Header)new BasicHeader("Content-Type", mediaType.toString()));
            }
            entityToBuild = entityToBuildByteArray;
        } else {
            entityToBuild = new FileExposingFileEntity(memoryManagedOutStream.getFile(), mediaType == null ? null : mediaType.toString());
        }
        if (request.isChunked()) {
            entityToBuild.setChunked(true);
        }
        return entityToBuild;
    }

    private DeferredFileOutputStream writeRequestBodyToOutputStream(ClientInvocation request) throws IOException {
        DeferredFileOutputStream memoryManagedOutStream = new DeferredFileOutputStream(this.fileUploadInMemoryThresholdLimit * this.getMemoryUnitMultiplier(), this.getTempfilePrefix(), ".tmp", this.fileUploadTempFileDir);
        request.getDelegatingOutputStream().setDelegate((OutputStream)memoryManagedOutStream);
        request.writeRequestBody(request.getEntityStream());
        memoryManagedOutStream.close();
        return memoryManagedOutStream;
    }

    protected String getTempfilePrefix() {
        return processId;
    }

    private int getMemoryUnitMultiplier() {
        switch (this.fileUploadMemoryUnit) {
            case BY: {
                return 1;
            }
            case KB: {
                return 1024;
            }
            case MB: {
                return 0x100000;
            }
            case GB: {
                return 0x40000000;
            }
        }
        return 1;
    }

    private void handleFileNotDeletedError(File tempRequestFile, Exception ex) {
        LogMessages.LOGGER.warn(Messages.MESSAGES.couldNotDeleteFile(tempRequestFile.getAbsolutePath()), ex);
        tempRequestFile.deleteOnExit();
    }

    static {
        try {
            processId = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return ManagementFactory.getRuntimeMXBean().getName().replaceAll("[^0-9a-zA-Z]", "");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae);
        }
    }

    private static class FileExposingFileEntity
    extends FileEntity {
        FileExposingFileEntity(File pFile, String pContentType) {
            super(pFile, pContentType);
        }

        File getFile() {
            return this.file;
        }
    }

    public static enum MemoryUnit {
        BY,
        KB,
        MB,
        GB;

    }
}

