/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobInfo;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.common.task.TaskInfo;
import org.ow2.proactive.scheduler.common.task.TaskStatus;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.ow2.proactive.scheduler.task.SchedulerVars;

@PublicAPI
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class TaskState
extends Task
implements Comparable<TaskState> {
    public static final int SORT_BY_ID = 1;
    public static final int SORT_BY_NAME = 2;
    public static final int SORT_BY_STATUS = 3;
    public static final int SORT_BY_DESCRIPTION = 4;
    public static final int SORT_BY_EXECUTIONLEFT = 5;
    public static final int SORT_BY_EXECUTIONONFAILURELEFT = 6;
    public static final int SORT_BY_STARTED_TIME = 8;
    public static final int SORT_BY_FINISHED_TIME = 9;
    public static final int SORT_BY_HOST_NAME = 10;
    public static final int SORT_BY_EXEC_DURATION = 11;
    public static final int ASC_ORDER = 1;
    public static final int DESC_ORDER = 2;
    protected static int currentSort = 1;
    protected static int currentOrder = 1;
    public static final Comparator<TaskState> COMPARE_BY_FINISHED_TIME_ASC = new Comparator<TaskState>(){

        @Override
        public int compare(TaskState task1, TaskState task2) {
            return Long.compare(task1.getFinishedTime(), task2.getFinishedTime());
        }
    };
    private static final long serialVersionUID = 141L;

    public abstract void update(TaskInfo var1);

    @XmlTransient
    public abstract List<TaskState> getDependences();

    @Override
    @XmlTransient
    public List<Task> getDependencesList() {
        return null;
    }

    @Override
    public void addDependence(Task task) {
        throw new IllegalStateException("This method cannot be used on a submitted task");
    }

    @Override
    public void addDependences(List<Task> tasks) {
        throw new IllegalStateException("This method cannot be used on a submitted task");
    }

    public static void setSortingBy(int sortBy) {
        currentSort = sortBy;
    }

    public static void setSortingOrder(int order) {
        currentOrder = order == 1 || order == 2 ? order : 1;
    }

    @Override
    public int compareTo(TaskState task) {
        switch (currentSort) {
            case 4: {
                return currentOrder == 1 ? this.description.compareTo(task.description) : task.description.compareTo(this.description);
            }
            case 2: {
                return currentOrder == 1 ? this.name.compareTo(task.name) : task.name.compareTo(this.name);
            }
            case 3: {
                return currentOrder == 1 ? this.getStatus().compareTo(task.getStatus()) : task.getStatus().compareTo(this.getStatus());
            }
            case 8: {
                return currentOrder == 1 ? (int)(this.getStartTime() - task.getStartTime()) : (int)(task.getStartTime() - this.getStartTime());
            }
            case 9: {
                return currentOrder == 1 ? (int)(this.getFinishedTime() - task.getFinishedTime()) : (int)(task.getFinishedTime() - this.getFinishedTime());
            }
            case 5: {
                return currentOrder == 1 ? Integer.valueOf(this.getNumberOfExecutionLeft()).compareTo(task.getNumberOfExecutionLeft()) : Integer.valueOf(task.getNumberOfExecutionLeft()).compareTo(this.getNumberOfExecutionLeft());
            }
            case 6: {
                return currentOrder == 1 ? Integer.valueOf(this.getNumberOfExecutionOnFailureLeft()).compareTo(task.getNumberOfExecutionOnFailureLeft()) : Integer.valueOf(task.getNumberOfExecutionOnFailureLeft()).compareTo(this.getNumberOfExecutionOnFailureLeft());
            }
            case 10: {
                return currentOrder == 1 ? this.getExecutionHostName().compareTo(task.getExecutionHostName()) : task.getExecutionHostName().compareTo(this.getExecutionHostName());
            }
            case 11: {
                return currentOrder == 1 ? (int)(this.getExecutionDuration() - task.getExecutionDuration()) : (int)(task.getExecutionDuration() - this.getExecutionDuration());
            }
        }
        return currentOrder == 1 ? this.getId().compareTo(task.getId()) : task.getId().compareTo(this.getId());
    }

    public abstract TaskInfo getTaskInfo();

    public boolean isTaskAlive() {
        return this.getTaskInfo().getStatus().isTaskAlive();
    }

    public long getFinishedTime() {
        return this.getTaskInfo().getFinishedTime();
    }

    public JobId getJobId() {
        return this.getTaskInfo().getJobId();
    }

    public long getStartTime() {
        return this.getTaskInfo().getStartTime();
    }

    public long getScheduledTime() {
        return this.getTaskInfo().getScheduledTime();
    }

    public TaskId getId() {
        return this.getTaskInfo().getTaskId();
    }

    public TaskStatus getStatus() {
        return this.getTaskInfo().getStatus();
    }

    public int getProgress() {
        return this.getTaskInfo().getProgress();
    }

    public String getExecutionHostName() {
        return this.getTaskInfo().getExecutionHostName();
    }

    public String[] getExecutionHostNameList() {
        return this.getTaskInfo().getExecutionHostNameList();
    }

    public int getNumberOfExecutionLeft() {
        return this.getTaskInfo().getNumberOfExecutionLeft();
    }

    public int getNumberOfExecutionOnFailureLeft() {
        return this.getTaskInfo().getNumberOfExecutionOnFailureLeft();
    }

    public long getExecutionDuration() {
        return this.getTaskInfo().getExecutionDuration();
    }

    public abstract int getMaxNumberOfExecutionOnFailure();

    @Override
    public String getName() {
        if (this.getId() == null || this.getId().getReadableName().equals("NOT SET")) {
            return super.getName();
        }
        return this.getId().getReadableName();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getId() + ")";
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (TaskState.class.isAssignableFrom(obj.getClass())) {
            return ((TaskState)obj).getId().equals(this.getId());
        }
        return false;
    }

    public abstract TaskState replicate() throws Exception;

    public abstract int getIterationIndex();

    public abstract int getReplicationIndex();

    public Map<String, Serializable> getScopeVariables() {
        HashMap<String, Serializable> scopeVariables = new HashMap<String, Serializable>();
        Map jobVariables = Optional.ofNullable(this.getTaskInfo().getJobInfo()).map(JobInfo::getVariables).orElse(null);
        for (TaskVariable variable : this.variables.values()) {
            if (variable.isJobInherited() && (!variable.isJobInherited() || jobVariables != null && jobVariables.containsKey(variable.getName()))) continue;
            scopeVariables.put(variable.getName(), (Serializable)((Object)variable.getValue()));
        }
        return scopeVariables;
    }

    public Map<String, Serializable> getSystemVariables() {
        HashMap<String, Serializable> systemVariables = new HashMap<String, Serializable>();
        if (this.getTaskInfo() != null) {
            systemVariables.put(SchedulerVars.PA_JOB_ID.toString(), (Serializable)((Object)this.getTaskInfo().getJobId().value()));
            systemVariables.put(SchedulerVars.PA_JOB_NAME.toString(), (Serializable)((Object)this.getTaskInfo().getJobId().getReadableName()));
            if (this.getId() != null) {
                systemVariables.put(SchedulerVars.PA_TASK_ID.toString(), (Serializable)((Object)this.getId().value()));
                systemVariables.put(SchedulerVars.PA_TASK_NAME.toString(), (Serializable)((Object)this.getName()));
            }
            systemVariables.put(SchedulerVars.PA_USER.toString(), Optional.ofNullable(this.getTaskInfo().getJobInfo()).map(JobInfo::getJobOwner).orElse(null));
            systemVariables.put(SchedulerVars.PA_TASK_ITERATION.toString(), Integer.valueOf(this.getIterationIndex()));
            systemVariables.put(SchedulerVars.PA_TASK_REPLICATION.toString(), Integer.valueOf(this.getReplicationIndex()));
        }
        return systemVariables;
    }

    public Map<String, Serializable> getRuntimeVariables() {
        HashMap<String, Serializable> runtimeVariables = new HashMap<String, Serializable>();
        runtimeVariables.putAll(this.getScopeVariables());
        TaskInfo taskInfo = this.getTaskInfo();
        if (taskInfo != null && taskInfo.getVariables() != null) {
            runtimeVariables.putAll(taskInfo.getVariables());
        }
        runtimeVariables.putAll(this.getSystemVariables());
        return runtimeVariables;
    }

    public Map<String, String> getRuntimeGenericInformation() {
        HashMap<String, String> runtimeGenericInformation = new HashMap<String, String>();
        if (this.getTaskInfo() == null) {
            return runtimeGenericInformation;
        }
        Map<String, Serializable> runtimeVariables = this.getRuntimeVariables();
        if (this.getTaskInfo().getJobInfo() != null && this.getTaskInfo().getJobInfo().getGenericInformation() != null) {
            runtimeGenericInformation.putAll(TaskState.applyReplacementsOnGenericInformation(this.getTaskInfo().getJobInfo().getGenericInformation(), runtimeVariables));
        }
        if (this.genericInformation != null) {
            runtimeGenericInformation.putAll(TaskState.applyReplacementsOnGenericInformation(this.genericInformation, runtimeVariables));
        }
        return runtimeGenericInformation;
    }
}

