# -*- coding: utf-8 -*-

# django-security-txt
# security_txt/migrations/0005_policy.py

# Generated by Django 3.1.7 on 2021-03-25 00:14


from typing import List, Tuple

from django.db import models, migrations
from django.db.migrations.operations.base import Operation
from django.core.validators import URLValidator, RegexValidator


__all__: List[str] = ["Migration"]


class Migration(migrations.Migration):
    """Migration."""

    dependencies: List[Tuple[str, str]] = [
        ("security_txt", "0005_policy"),
    ]

    operations: List[Operation] = [
        migrations.CreateModel(
            name="Encryption",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "type",
                    models.PositiveIntegerField(
                        choices=[
                            (1, "URL"),
                            (2, "OPENPGPKEY DNS record"),
                            (3, "OpenPGP key fingerprint"),
                        ],
                        db_index=True,
                        default=1,
                        help_text="contact type, possible variants: URL, OPENPGPKEY DNS record, OpenPGP key fingerprint",  # noqa: E501
                        verbose_name="type",
                    ),
                ),
                (
                    "url",
                    models.URLField(  # noqa: DJ01
                        blank=True,
                        db_index=True,
                        help_text="URL to public OpenPGP key",
                        max_length=512,
                        null=True,
                        validators=[URLValidator(schemes=["https"])],
                        verbose_name="URL",
                    ),
                ),
                (
                    "dns",
                    models.CharField(  # noqa: DJ01
                        blank=True,
                        db_index=True,
                        help_text="OPENPGPKEY DNS record",
                        max_length=512,
                        null=True,
                        validators=[
                            RegexValidator(
                                message="Invalid OPENPGPKEY DNS record, for more informations see: https://tools.ietf.org/html/rfc7929",  # noqa: E501
                                regex=r"([0-9 A-F a-f]{16,64})(._openpgpkey.)((?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?\\.)+[a-z0-9][a-z0-9-]{0,61}[a-z0-9])(\\?type=OPENPGPKEY$)",  # noqa: E501
                            )
                        ],
                        verbose_name="DNS record",
                    ),
                ),
                (
                    "fingerprint",
                    models.CharField(  # noqa: DJ01
                        blank=True,
                        db_index=True,
                        help_text="OpenPGP key fingerprint",
                        max_length=512,
                        null=True,
                        validators=[
                            RegexValidator(
                                message="Invalid OpenPGP key fingerprint",
                                regex=r"([0-9 A-F a-f]{16,64}$)",
                            )
                        ],
                        verbose_name="key fingerprint",
                    ),
                ),
            ],
            options={
                "verbose_name": "encryption",
                "verbose_name_plural": "encryption",
                "ordering": ["type"],
                "unique_together": {("type", "url", "dns", "fingerprint")},
            },
        ),
    ]
