# -*- coding: utf-8 -*-

# django-security-txt
# security_txt/migrations/0005_policy.py

# Generated by Django 3.1.7 on 2021-03-23 11:03


from typing import List, Tuple

from django.db import models, migrations
from django.core.validators import URLValidator
from django.db.migrations.operations.base import Operation


__all__: List[str] = ["Migration"]


class Migration(migrations.Migration):
    """Migration."""

    dependencies: List[Tuple[str, str]] = [
        ("security_txt", "0004_hiring"),
    ]

    operations: List[Operation] = [
        migrations.CreateModel(
            name="Policy",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        db_index=True,
                        help_text="indicates a link to where the vulnerability disclosure policy is located",  # noqa: E501
                        max_length=512,
                        unique=True,
                        validators=[URLValidator(schemes=["https"])],
                        verbose_name="URL",
                    ),
                ),
            ],
            options={
                "verbose_name": "policy",
                "verbose_name_plural": "policies",
                "ordering": ["url"],
            },
        ),
    ]
