# -*- coding: utf-8 -*-

# django-security-txt
# security_txt/migrations/0004_hiring.py

# Generated by Django 3.1.7 on 2021-03-22 22:11


from typing import List, Tuple

from django.db import models, migrations
from django.core.validators import URLValidator
from django.db.migrations.operations.base import Operation


__all__: List[str] = ["Migration"]


class Migration(migrations.Migration):
    """Migration."""

    dependencies: List[Tuple[str, str]] = [
        ("security_txt", "0003_auto_20210322_1857"),
    ]

    operations: List[Operation] = [
        migrations.CreateModel(
            name="Hiring",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "url",
                    models.URLField(
                        db_index=True,
                        help_text="used for linking to the vendor's security-related job positions",  # noqa: E501
                        max_length=512,
                        unique=True,
                        validators=[URLValidator(schemes=["https"])],
                        verbose_name="URL",
                    ),
                ),
            ],
            options={
                "verbose_name": "hiring",
                "verbose_name_plural": "hiring",
                "ordering": ["url"],
            },
        ),
    ]
