#include "pse.h"
#include "configfile.h"
#include <cctype>

using namespace Vipster;

Vipster::PseMap Vipster::pse = {
    {{"",      { "", "", "", 0,   0.0f,       -1,   1.46f, 3.21f, {   0,   0,   0, 255 } }},
     {"H",     { "", "", "", 1,   1.0079f,    0.72f, 0.72f, 2.27f, { 190, 190, 190, 255 } }},
     {"He",    { "", "", "", 2,   4.0026f,    0.6f,  0.6f,  2.65f, { 215, 255, 255, 255 } }},
     {"Li",    { "", "", "", 3,   6.941f,     2.53f, 2.53f, 3.44f, { 204, 126, 255, 255 } }},
     {"Be",    { "", "", "", 4,   9.0122f,    1.7f,  1.7f,  2.89f, { 192, 255,   0, 255 } }},
     {"B",     { "", "", "", 5,   10.811f,    1.55f, 1.55f, 3.63f, { 255, 181, 181, 255 } }},
     {"C",     { "", "", "", 6,   12.0107f,   1.46f, 1.46f, 3.21f, { 102, 102, 102, 255 } }},
     {"N",     { "", "", "", 7,   14.007f,    1.34f, 1.34f, 2.93f, {  11,  11, 255, 255 } }},
     {"O",     { "", "", "", 8,   15.999f,    1.38f, 1.38f, 2.87f, { 255,  11,  11, 255 } }},
     {"F",     { "", "", "", 9,   18.998f,    1.34f, 1.34f, 2.78f, { 126, 177, 255, 255 } }},
     {"Ne",    { "", "", "", 10,  20.18f,     1.3f,  1.3f,  2.91f, { 177, 226, 243, 255 } }},
     {"Na",    { "", "", "", 11,  22.99f,     2.91f, 2.91f, 4.29f, { 170,  90, 241, 255 } }},
     {"Mg",    { "", "", "", 12,  24.305f,    2.46f, 2.46f, 3.27f, { 137, 255,   0, 255 } }},
     {"Al",    { "", "", "", 13,  26.982f,    2.23f, 2.23f, 3.48f, { 190, 164, 164, 255 } }},
     {"Si",    { "", "", "", 14,  28.086f,    2.1f,  2.1f,  3.97f, { 126, 153, 153, 255 } }},
     {"P",     { "", "", "", 15,  30.974f,    2.0f,  2.0f,  3.4f,  { 255, 126,   0, 255 } }},
     {"S",     { "", "", "", 16,  32.065f,    1.93f, 1.93f, 3.4f,  { 177, 177,   0, 255 } }},
     {"Cl",    { "", "", "", 17,  35.453f,    1.87f, 1.87f, 3.31f, {  30, 239,  30, 255 } }},
     {"Ar",    { "", "", "", 18,  39.948f,    1.83f, 1.83f, 3.55f, { 126, 208, 226, 255 } }},
     {"K",     { "", "", "", 19,  39.098f,    3.7f,  3.7f,  5.2f,  { 141,  62, 210, 255 } }},
     {"Ca",    { "", "", "", 20,  40.078f,    3.29f, 3.29f, 4.37f, {  61, 255,   0, 255 } }},
     {"Sc",    { "", "", "", 21,  44.9559f,   2.72f, 2.72f, 3.99f, { 228, 228, 228, 255 } }},
     {"Ti",    { "", "", "", 22,  47.867f,    2.57f, 2.57f, 3.21f, { 190, 192, 197, 255 } }},
     {"V",     { "", "", "", 23,  50.9415f,   2.36f, 2.36f, 3.21f, { 164, 164, 170, 255 } }},
     {"Cr",    { "", "", "", 24,  51.9961f,   2.4f,  2.4f,  3.21f, { 137, 153, 197, 255 } }},
     {"Mn",    { "", "", "", 25,  54.938f,    2.63f, 2.63f, 3.21f, { 155, 121, 197, 255 } }},
     {"Fe",    { "", "", "", 26,  55.845f,    2.36f, 2.36f, 3.21f, { 223, 102,  51, 255 } }},
     {"Co",    { "", "", "", 27,  58.9332f,   2.38f, 2.38f, 3.21f, { 239, 141, 159, 255 } }},
     {"Ni",    { "", "", "", 28,  58.6934f,   2.29f, 2.29f, 3.08f, {  79, 208,  79, 255 } }},
     {"Cu",    { "", "", "", 29,  63.546f,    2.61f, 2.61f, 2.65f, { 197, 126,  51, 255 } }},
     {"Zn",    { "", "", "", 30,  65.39f,     2.48f, 2.48f, 2.63f, { 124, 126, 175, 255 } }},
     {"Ga",    { "", "", "", 31,  69.723f,    2.38f, 2.38f, 3.53f, { 192, 141, 141, 255 } }},
     {"Ge",    { "", "", "", 32,  72.64f,     2.31f, 2.31f, 3.99f, { 102, 141, 141, 255 } }},
     {"As",    { "", "", "", 33,  74.922f,    2.25f, 2.25f, 3.5f,  { 188, 126, 226, 255 } }},
     {"Se",    { "", "", "", 34,  78.96f,     2.19f, 2.19f, 3.59f, { 255, 159,   0, 255 } }},
     {"Br",    { "", "", "", 35,  79.904f,    2.15f, 2.15f, 3.5f,  { 164,  39,  39, 255 } }},
     {"Kr",    { "", "", "", 36,  83.798f,    2.08f, 2.08f, 3.82f, {  90, 183, 208, 255 } }},
     {"Rb",    { "", "", "", 37,  85.4678f,   3.99f, 3.99f, 5.73f, { 112,  44, 175, 255 } }},
     {"Sr",    { "", "", "", 38,  87.62f,     3.63f, 3.63f, 4.71f, {   0, 255,   0, 255 } }},
     {"Y",     { "", "", "", 39,  88.9059f,   3.06f, 3.06f, 3.21f, { 146, 255, 255, 255 } }},
     {"Zr",    { "", "", "", 40,  91.224f,    2.8f,  2.8f,  3.21f, { 146, 223, 223, 255 } }},
     {"Nb",    { "", "", "", 41,  92.9064f,   2.59f, 2.59f, 3.21f, { 113, 192, 201, 255 } }},
     {"Mo",    { "", "", "", 42,  95.94f,     2.74f, 2.74f, 3.21f, {  84, 181, 181, 255 } }},
     {"Tc",    { "", "", "", 43,  98.0f,      2.95f, 2.95f, 3.21f, {  57, 157, 157, 255 } }},
     {"Ru",    { "", "", "", 44,  101.07f,    2.38f, 2.38f, 3.21f, {  35, 141, 141, 255 } }},
     {"Rh",    { "", "", "", 45,  102.9055f,  2.55f, 2.55f, 3.21f, {   9, 124, 139, 255 } }},
     {"Pd",    { "", "", "", 46,  106.42f,    2.48f, 2.48f, 3.08f, {   0, 104, 132, 255 } }},
     {"Ag",    { "", "", "", 47,  107.8682f,  2.89f, 2.89f, 3.25f, { 223, 223, 255, 255 } }},
     {"Cd",    { "", "", "", 48,  112.411f,   2.8f,  2.8f,  2.99f, { 255, 215, 141, 255 } }},
     {"In",    { "", "", "", 49,  114.818f,   2.72f, 2.72f, 3.65f, { 164, 117, 113, 255 } }},
     {"Sn",    { "", "", "", 50,  118.71f,    2.66f, 2.66f, 4.1f,  { 102, 126, 126, 255 } }},
     {"Sb",    { "", "", "", 51,  121.76f,    2.61f, 2.61f, 3.89f, { 157,  99, 181, 255 } }},
     {"Te",    { "", "", "", 52,  127.6f,     2.55f, 2.55f, 3.89f, { 210, 121,   0, 255 } }},
     {"I",     { "", "", "", 53,  126.9045f,  2.51f, 2.51f, 3.74f, { 146,   0, 146, 255 } }},
     {"Xe",    { "", "", "", 54,  131.293f,   2.46f, 2.46f, 4.08f, {  66, 157, 175, 255 } }},
     {"Cs",    { "", "", "", 55,  132.9055f,  4.25f, 4.25f, 6.48f, {  86,  21, 141, 255 } }},
     {"Ba",    { "", "", "", 56,  137.327f,   3.74f, 3.74f, 5.06f, {   0, 201,   0, 255 } }},
     {"La",    { "", "", "", 57,  138.9055f,  3.19f, 3.19f, 3.21f, { 112, 210, 255, 255 } }},
     {"Ce",    { "", "", "", 58,  140.116f,   1.46f, 1.46f, 3.21f, { 255, 255, 197, 255 } }},
     {"Pr",    { "", "", "", 59,  140.9077f,  1.46f, 1.46f, 3.21f, { 215, 255, 197, 255 } }},
     {"Nd",    { "", "", "", 60,  144.24f,    1.46f, 1.46f, 3.21f, { 197, 255, 197, 255 } }},
     {"Pm",    { "", "", "", 61,  145.0f,     1.46f, 1.46f, 3.21f, { 163, 255, 197, 255 } }},
     {"Sm",    { "", "", "", 62,  150.36f,    1.46f, 1.46f, 3.21f, { 141, 255, 197, 255 } }},
     {"Eu",    { "", "", "", 63,  151.964f,   1.46f, 1.46f, 3.21f, {  95, 255, 197, 255 } }},
     {"Gd",    { "", "", "", 64,  157.25f,    1.46f, 1.46f, 3.21f, {  68, 255, 197, 255 } }},
     {"Tb",    { "", "", "", 65,  158.9253f,  1.46f, 1.46f, 3.21f, {  48, 255, 197, 255 } }},
     {"Dy",    { "", "", "", 66,  162.5f,     1.46f, 1.46f, 3.21f, {  30, 255, 197, 255 } }},
     {"Ho",    { "", "", "", 67,  164.9303f,  1.46f, 1.46f, 3.21f, {   0, 255, 155, 255 } }},
     {"Er",    { "", "", "", 68,  167.259f,   1.46f, 1.46f, 3.21f, {   0, 228, 117, 255 } }},
     {"Tm",    { "", "", "", 69,  168.9342f,  1.46f, 1.46f, 3.21f, {   0, 210,  81, 255 } }},
     {"Yb",    { "", "", "", 70,  173.04f,    1.46f, 1.46f, 3.21f, {   0, 190,  55, 255 } }},
     {"Lu",    { "", "", "", 71,  174.967f,   3.02f, 3.02f, 3.21f, {   0, 170,  35, 255 } }},
     {"Hf",    { "", "", "", 72,  178.49f,    2.83f, 2.83f, 3.21f, {  75, 192, 255, 255 } }},
     {"Ta",    { "", "", "", 73,  180.9479f,  2.61f, 2.61f, 3.21f, {  75, 164, 255, 255 } }},
     {"W",     { "", "", "", 74,  183.84f,    2.76f, 2.76f, 3.21f, {  33, 146, 214, 255 } }},
     {"Re",    { "", "", "", 75,  186.207f,   3.0f,  3.0f,  3.21f, {  37, 124, 170, 255 } }},
     {"Os",    { "", "", "", 76,  190.23f,    2.42f, 2.42f, 3.21f, {  37, 102, 150, 255 } }},
     {"Ir",    { "", "", "", 77,  192.217f,   2.59f, 2.59f, 3.21f, {  21,  84, 135, 255 } }},
     {"Pt",    { "", "", "", 78,  195.078f,   2.42f, 2.42f, 3.31f, { 243, 237, 208, 255 } }},
     {"Au",    { "", "", "", 79,  196.9665f,  2.72f, 2.72f, 3.14f, { 204, 208,  30, 255 } }},
     {"Hg",    { "", "", "", 80,  200.592f,   2.82f, 2.82f, 2.93f, { 181, 181, 192, 255 } }},
     {"Tl",    { "", "", "", 81,  204.3833f,  2.8f,  2.8f,  3.7f,  { 164,  84,  75, 255 } }},
     {"Pb",    { "", "", "", 82,  207.2f,     2.78f, 2.78f, 3.82f, {  86,  88,  95, 255 } }},
     {"Bi",    { "", "", "", 83,  208.9804f,  2.76f, 2.76f, 3.91f, { 157,  79, 181, 255 } }},
     {"Po",    { "", "", "", 84,  209.f,      1.46f, 1.46f, 3.72f, { 170,  90,   0, 255 } }},
     {"At",    { "", "", "", 85,  210.f,      1.46f, 1.46f, 3.82f, { 117,  79,  68, 255 } }},
     {"Rn",    { "", "", "", 86,  222.f,      2.74f, 2.74f, 4.16f, {  66, 130, 150, 255 } }},
     {"Fr",    { "", "", "", 87,  223.f,      1.46f, 1.46f, 6.58f, {  66,   0, 102, 255 } }},
     {"Ra",    { "", "", "", 88,  226.f,      1.46f, 1.46f, 5.35f, {   0, 124,   0, 255 } }},
     {"Ac",    { "", "", "", 89,  227.f,      1.46f, 1.46f, 3.21f, { 112, 170, 248, 255 } }},
     {"Th",    { "", "", "", 90,  232.03806f, 1.46f, 1.46f, 3.21f, {   0, 186, 255, 255 } }},
     {"Pa",    { "", "", "", 91,  231.03588f, 1.46f, 1.46f, 3.21f, {   0, 159, 255, 255 } }},
     {"U",     { "", "", "", 92,  238.02891f, 1.46f, 1.46f, 3.51f, {   0, 141, 255, 255 } }},
     {"Np",    { "", "", "", 93,  237.f,      1.46f, 1.46f, 3.21f, {   0, 126, 255, 255 } }},
     {"Pu",    { "", "", "", 94,  244.f,      1.46f, 1.46f, 3.21f, {   0, 106, 255, 255 } }},
     {"Am",    { "", "", "", 95,  243.f,      1.46f, 1.46f, 3.21f, {  84,  90, 241, 255 } }},
     {"Cm",    { "", "", "", 96,  247.f,      1.46f, 1.46f, 3.21f, { 119,  90, 226, 255 } }},
     {"Bk",    { "", "", "", 97,  247.f,      1.46f, 1.46f, 3.21f, { 137,  79, 226, 255 } }},
     {"Cf",    { "", "", "", 98,  251.f,      1.46f, 1.46f, 3.21f, { 159,  53, 210, 255 } }},
     {"Es",    { "", "", "", 99,  252.f,      1.46f, 1.46f, 3.21f, { 177,  30, 210, 255 } }},
     {"Fm",    { "", "", "", 100, 257.f,      1.46f, 1.46f, 3.21f, { 177,  30, 186, 255 } }},
     {"Md",    { "", "", "", 101, 258.f,      1.46f, 1.46f, 3.21f, { 177,  11, 164, 255 } }},
     {"No",    { "", "", "", 102, 259.f,      1.46f, 1.46f, 3.21f, { 188,  11, 135, 255 } }},
     {"Lr",    { "", "", "", 103, 266.f,      1.46f, 1.46f, 3.21f, { 197,   0, 102, 255 } }},
     {"Rf",    { "", "", "", 104, 267.f,      1.46f, 1.46f, 3.21f, { 204,   0,  88, 255 } }},
     {"Db",    { "", "", "", 105, 268.f,      1.46f, 1.46f, 3.21f, { 208,   0,  79, 255 } }},
     {"Sg",    { "", "", "", 106, 269.f,      1.46f, 1.46f, 3.21f, { 215,   0,  68, 255 } }},
     {"Bh",    { "", "", "", 107, 270.f,      1.46f, 1.46f, 3.21f, { 223,   0,  55, 255 } }},
     {"Hs",    { "", "", "", 108, 269.f,      1.46f, 1.46f, 3.21f, { 228,   0,  44, 255 } }},
     {"Mt",    { "", "", "", 109, 278.f,      1.46f, 1.46f, 3.21f, { 234,   0,  37, 255 } }},
     {"Ds",    { "", "", "", 110, 281.f,      1.46f, 1.46f, 3.21f, { 237,   0,  35, 255 } }},
     {"Rg",    { "", "", "", 111, 281.f,      1.46f, 1.46f, 3.21f, { 239,   0,  33, 255 } }},
     {"Cn",    { "", "", "", 112, 285.f,      1.46f, 1.46f, 3.21f, { 241,   0,  30, 255 } }},
     {"Uut",   { "", "", "", 113, 286.f,      1.46f, 1.46f, 3.21f, { 243,   0,  28, 255 } }},
     {"Fl",    { "", "", "", 114, 289.f,      1.46f, 1.46f, 3.21f, { 246,   0,  25, 255 } }},
     {"Uup",   { "", "", "", 115, 289.f,      1.46f, 1.46f, 3.21f, { 248,   0,  21, 255 } }},
     {"Lv",    { "", "", "", 116, 293.f,      1.46f, 1.46f, 3.21f, { 252,   0,  19, 255 } }},
     {"Uus",   { "", "", "", 117, 294.f,      1.46f, 1.46f, 3.21f, { 252,   0,  17, 255 } }},
     {"Uuo",   { "", "", "", 118, 294.f,      1.46f, 1.46f, 3.21f, { 252,   0,  15, 255 } }},
     {"BCP",   { "", "", "", 0,   0.0f,       -1.f,  0.72f, 2.27f, {   0, 255,   0, 255 } }},
     {"RCP",   { "", "", "", 0,   0.0f,       -1.f,  0.72f, 2.27f, { 255,   0,   0, 255 } }},
     {"CCP",   { "", "", "", 0,   0.0f,       -1.f,  0.72f, 2.27f, { 255, 255,   0, 255 } }},
     {"NNACP", { "", "", "", 0,   0.0f,       -1.f,  0.72f, 2.27f, {   0,   0, 255, 255 } }}},
    true
};

PseMap::PseMap(std::initializer_list<PseMap::value_type> il, bool r)
    : std::map<std::string, PseEntry>{il}, root{r}
{}

PseEntry& PseMap::operator [](const std::string& k)
{
    auto entry = find(k);
    if(entry != end()){
        return entry->second;
    }else{
        // if key is ONLY a number, interpret as atomic number
        char *p;
        std::size_t Z = std::strtoul(k.c_str(), &p, 10);
        if(*p){
            // found a derived/custom name, try to guess base-name
            std::string kt{k};
            // make sure first letter is upper case to match default names
            if(std::islower(kt[0])){
                kt[0] = std::toupper(kt[0]);
            }
            // gradually ignore appended letters until we reach a matching atom type
            for(size_t i=kt.length(); i>0; --i)
            {
                std::string test = kt.substr(0,i);
                auto tmp = find(test);
                // local lookup, always works
                if(tmp != end()){
                    return emplace(k, tmp->second).first->second;
                }
                if(!root){
                    // lookup in global PSE
                    tmp = Vipster::pse.find(test);
                    if(tmp != Vipster::pse.end()){
                        return emplace(k, tmp->second).first->second;
                    }
                }
            }
        }else{
            // interpret atomic number
            for(const auto& pair: Vipster::pse){
                if(pair.second.Z == Z){
                    return emplace(k, pair.second).first->second;
                }
            }
        }
    }
    return emplace(k, Vipster::pse.at("")).first->second;
}

void Vipster::to_json(nlohmann::json& j, const PseEntry& p)
{
    j["PWPP"] = p.PWPP;
    j["CPPP"] = p.CPPP;
    j["CPNL"] = p.CPNL;
    j["Z"] = p.Z;
    j["m"] = p.m;
    j["bondcut"] = p.bondcut;
    j["covr"] = p.covr;
    j["vdwr"] = p.vdwr;
    j["col"] = p.col;
}

void Vipster::from_json(const nlohmann::json& j, PseEntry& p)
{
    p.PWPP = j.value("PWPP", "");
    p.CPPP = j.value("CPPP", "");
    p.CPNL = j.value("CPNL", "");
    p.Z = j.value("Z", 0u);
    p.m = j.value("m", 0.0f);
    p.bondcut = j.value("bondcut", -1.f);
    p.covr = j.value("covr", 1.46f);
    p.vdwr = j.value("vdwr", 3.21f);
    p.col = j.value("col", ColVec{0,0,0,255});
}

void Vipster::to_json(nlohmann::json& j, const PseMap& m)
{
    for(const auto& e: m){
        j[e.first] = e.second;
    }
}

void Vipster::from_json(const nlohmann::json& j, PseMap& m)
{
    for(auto it=j.begin(); it!=j.end(); ++it){
        m.emplace(it.key(), it.value());
    }
}
