#!/usr/bin/env python
"""
mbed SDK
Copyright (c) 2011-2015 ARM Limited

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import unittest
from mbed_greentea import mbed_greentea_cli

class GreenteaCliFunctionality(unittest.TestCase):

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def test_get_greentea_version(self):
        version = mbed_greentea_cli.get_greentea_version()

        self.assertIs(type(version), str)

        a, b, c = version.split('.')

        self.assertEqual(a.isdigit(), True)
        self.assertEqual(b.isdigit(), True)
        self.assertEqual(c.isdigit(), True)

    def get_hello_string(self):
        version = mbed_greentea_cli.get_greentea_version()
        hello_string = mbed_greentea_cli.get_hello_string()

        self.assertIs(type(version), str)
        self.assertIs(type(hello_string), str)
        self.assertIn(version, hello_string)


if __name__ == '__main__':
    unittest.main()
