# -*- coding: utf-8 -*-
# Generated by Django 1.9.9 on 2016-09-14 05:07
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_ffmpeg.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ConvertingCommand',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('match_by', models.CharField(choices=[(b'extension', 'Extension'), (b'name', 'File name')], default=b'extension', help_text='Video param to detected from if this command should be used to convert given video', max_length=50, verbose_name='Match by')),
                ('match_regex', models.CharField(max_length=200, verbose_name='RegExp to match video file')),
                ('is_enabled', models.BooleanField(default=True, verbose_name='Enabled?')),
                ('command', models.TextField(help_text=b'Example: /usr/bin/avconv -nostats -y -i %(input_file)s -acodec libmp3lame -ar 44100 -f flv %(output_file)s', verbose_name='System command to convert video')),
                ('convert_extension', models.CharField(help_text='Without dot: `.`', max_length=5, verbose_name='Extension')),
            ],
            options={
                'verbose_name': 'Video convert command',
                'verbose_name_plural': 'Video convert commands',
            },
        ),
        migrations.CreateModel(
            name='Video',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=500, verbose_name='Title')),
                ('video', models.FileField(upload_to=django_ffmpeg.models.video_file_path, verbose_name='Video file')),
                ('thumb', models.ImageField(blank=True, null=True, upload_to=django_ffmpeg.models.thumb_file_path, verbose_name='Thumbnail image')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created time')),
                ('convert_status', models.CharField(choices=[(b'pending', 'Pending convert'), (b'started', 'Convert started'), (b'converted', 'Converted'), (b'error', 'Not converted due to error')], default=b'pending', max_length=16, verbose_name='Video conversion status')),
                ('converted_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Convert time')),
                ('last_convert_msg', models.TextField(verbose_name='Message from last converting command')),
                ('meta_info', models.TextField(editable=False, null=True, verbose_name='Meta info about original video')),
                ('convert_extension', models.CharField(editable=False, help_text='Without dot: `.`', max_length=5, null=True, verbose_name='Extension')),
                ('user', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Uploaded by')),
            ],
            options={
                'verbose_name': 'Video',
                'verbose_name_plural': 'Videos',
            },
        ),
    ]
