# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object




class AdditionalUnattendContent(_serialization.Model):
    """Specifies additional XML formatted information that can be included in the Unattend.xml file,
    which is used by Windows Setup. Contents are defined by setting name, component name, and the
    pass in which the content is applied.

    :ivar pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
     value is "OobeSystem".
    :vartype pass_name: str
    :ivar component_name: The component name. Currently, the only allowable value is
     Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
    :vartype component_name: str
    :ivar setting_name: Specifies the name of the setting to which the content applies. Possible
     values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
     "FirstLogonCommands".
    :vartype setting_name: str or ~azure.mgmt.compute.models.SettingNames
    :ivar content: Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must include the root
     element for the setting or feature that is being inserted.
    :vartype content: str
    """

    _attribute_map = {
        "pass_name": {"key": "passName", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "setting_name": {"key": "settingName", "type": "str"},
        "content": {"key": "content", "type": "str"},
    }

    def __init__(
        self,
        *,
        pass_name: Optional[Literal["OobeSystem"]] = None,
        component_name: Optional[Literal["Microsoft-Windows-Shell-Setup"]] = None,
        setting_name: Optional[Union[str, "_models.SettingNames"]] = None,
        content: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
         value is "OobeSystem".
        :paramtype pass_name: str
        :keyword component_name: The component name. Currently, the only allowable value is
         Microsoft-Windows-Shell-Setup. Default value is "Microsoft-Windows-Shell-Setup".
        :paramtype component_name: str
        :keyword setting_name: Specifies the name of the setting to which the content applies. Possible
         values are: FirstLogonCommands and AutoLogon. Known values are: "AutoLogon" and
         "FirstLogonCommands".
        :paramtype setting_name: str or ~azure.mgmt.compute.models.SettingNames
        :keyword content: Specifies the XML formatted content that is added to the unattend.xml file
         for the specified path and component. The XML must be less than 4KB and must include the root
         element for the setting or feature that is being inserted.
        :paramtype content: str
        """
        super().__init__(**kwargs)
        self.pass_name = pass_name
        self.component_name = component_name
        self.setting_name = setting_name
        self.content = content

class ApiEntityReference(_serialization.Model):
    """The API entity reference.

    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM resource id in the form of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id

class ApiError(_serialization.Model):
    """Api error.

    :ivar details: The Api error details.
    :vartype details: list[~azure.mgmt.compute.models.ApiErrorBase]
    :ivar innererror: The Api inner error.
    :vartype innererror: ~azure.mgmt.compute.models.InnerError
    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "details": {"key": "details", "type": "[ApiErrorBase]"},
        "innererror": {"key": "innererror", "type": "InnerError"},
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        details: Optional[List["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword details: The Api error details.
        :paramtype details: list[~azure.mgmt.compute.models.ApiErrorBase]
        :keyword innererror: The Api inner error.
        :paramtype innererror: ~azure.mgmt.compute.models.InnerError
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message

class ApiErrorBase(_serialization.Model):
    """Api error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message

class Resource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags

class AvailabilitySet(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the availability set that the virtual machine should be assigned
    to. Virtual machines specified in the same availability set are allocated to different nodes to
    maximize availability. For more information about availability sets, see `Availability sets
    overview <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
    :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
    and updates for Virtual Machines in Azure
    <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
    :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
    time. An existing VM cannot be added to an availability set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Sku of the availability set, only name is required to be set. See
     AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with
     managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is
     'Classic'.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar platform_update_domain_count: Update Domain count.
    :vartype platform_update_domain_count: int
    :ivar platform_fault_domain_count: Fault Domain count.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines: A list of references to all virtual machines in the availability set.
    :vartype virtual_machines: list[~azure.mgmt.compute.models.SubResource]
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_update_domain_count": {"key": "properties.platformUpdateDomainCount", "type": "int"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResource]"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "statuses": {"key": "properties.statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["_models.SubResource"]] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Sku of the availability set, only name is required to be set. See
         AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with
         managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is
         'Classic'.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword platform_update_domain_count: Update Domain count.
        :paramtype platform_update_domain_count: int
        :keyword platform_fault_domain_count: Fault Domain count.
        :paramtype platform_fault_domain_count: int
        :keyword virtual_machines: A list of references to all virtual machines in the availability
         set.
        :paramtype virtual_machines: list[~azure.mgmt.compute.models.SubResource]
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
         2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.proximity_placement_group = proximity_placement_group
        self.statuses = None

class AvailabilitySetListResult(_serialization.Model):
    """The List Availability Set operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of availability sets. Required.
    :vartype value: list[~azure.mgmt.compute.models.AvailabilitySet]
    :ivar next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with this
     URI to fetch the next page of AvailabilitySets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailabilitySet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AvailabilitySet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of availability sets. Required.
        :paramtype value: list[~azure.mgmt.compute.models.AvailabilitySet]
        :keyword next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with
         this URI to fetch the next page of AvailabilitySets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class BootDiagnostics(_serialization.Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot
    to diagnose VM status. :code:`<br>`:code:`<br>` You can easily view the output of your console
    log. :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the
    hypervisor.

    :ivar enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
    :vartype enabled: bool
    :ivar storage_uri: Uri of the storage account to use for placing the console output and
     screenshot. :code:`<br>`:code:`<br>`If storageUri is not specified while enabling boot
     diagnostics, managed storage will be used.
    :vartype storage_uri: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "storage_uri": {"key": "storageUri", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, storage_uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
        :paramtype enabled: bool
        :keyword storage_uri: Uri of the storage account to use for placing the console output and
         screenshot. :code:`<br>`:code:`<br>`If storageUri is not specified while enabling boot
         diagnostics, managed storage will be used.
        :paramtype storage_uri: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = storage_uri

class BootDiagnosticsInstanceView(_serialization.Model):
    """The instance view of a virtual machine boot diagnostics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
     :code:`<br>`:code:`<br>`NOTE: This will **not** be set if boot diagnostics is currently enabled
     with managed storage.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The serial console log blob Uri.
     :code:`<br>`:code:`<br>`NOTE: This will **not** be set if boot diagnostics is currently enabled
     with managed storage.
    :vartype serial_console_log_blob_uri: str
    :ivar status: The boot diagnostics status information for the VM. :code:`<br>`:code:`<br>`
     NOTE: It will be set only if there are errors encountered in enabling boot diagnostics.
    :vartype status: ~azure.mgmt.compute.models.InstanceViewStatus
    """

    _validation = {
        "console_screenshot_blob_uri": {"readonly": True},
        "serial_console_log_blob_uri": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "console_screenshot_blob_uri": {"key": "consoleScreenshotBlobUri", "type": "str"},
        "serial_console_log_blob_uri": {"key": "serialConsoleLogBlobUri", "type": "str"},
        "status": {"key": "status", "type": "InstanceViewStatus"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None
        self.status = None

class ComputeLongRunningOperationProperties(_serialization.Model):
    """Compute-specific operation properties, including output.

    :ivar output: Operation output data (raw JSON).
    :vartype output: JSON
    """

    _attribute_map = {
        "output": {"key": "output", "type": "object"},
    }

    def __init__(self, *, output: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword output: Operation output data (raw JSON).
        :paramtype output: JSON
        """
        super().__init__(**kwargs)
        self.output = output

class DataDisk(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes a data disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.compute.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.compute.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than
     1023.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
    :ivar to_be_detached: Specifies whether the data disk is in process of detachment from the
     VirtualMachine/VirtualMachineScaleset.
    :vartype to_be_detached: bool
    :ivar disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk when
     StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be
     updated only via updates to the VirtualMachine Scale Set.
    :vartype disk_iops_read_write: int
    :ivar disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk when
     StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be
     updated only via updates to the VirtualMachine Scale Set.
    :vartype disk_m_bps_read_write: int
    :ivar detach_option: Specifies the detach behavior to be used while detaching a disk or which
     is already in the process of detachment from the virtual machine. Supported values:
     **ForceDetach**. :code:`<br>`:code:`<br>` detachOption: **ForceDetach** is applicable only for
     managed data disks. If a previous detachment attempt of the data disk did not complete due to
     an unexpected failure from the virtual machine and the disk is still not released then use
     force-detach as a last resort option to detach the disk forcibly from the VM. All writes might
     not have been flushed when using this detach behavior. :code:`<br>`:code:`<br>` This feature is
     still in preview mode and is not supported for VirtualMachineScaleSet. To force-detach a data
     disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
     "ForceDetach"
    :vartype detach_option: str or ~azure.mgmt.compute.models.DiskDetachOptionTypes
    :ivar delete_option: Specifies whether data disk should be deleted or detached upon VM
     deletion.:code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
     value is used, the data disk is deleted when VM is deleted.:code:`<br>`:code:`<br>` **Detach**
     If this value is used, the data disk is retained after VM is deleted.:code:`<br>`:code:`<br>`
     The default value is set to **detach**. Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
    """

    _validation = {
        "lun": {"required": True},
        "create_option": {"required": True},
        "disk_iops_read_write": {"readonly": True},
        "disk_m_bps_read_write": {"readonly": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
        "to_be_detached": {"key": "toBeDetached", "type": "bool"},
        "disk_iops_read_write": {"key": "diskIOPSReadWrite", "type": "int"},
        "disk_m_bps_read_write": {"key": "diskMBpsReadWrite", "type": "int"},
        "detach_option": {"key": "detachOption", "type": "str"},
        "delete_option": {"key": "deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        to_be_detached: Optional[bool] = None,
        detach_option: Optional[Union[str, "_models.DiskDetachOptionTypes"]] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword name: The disk name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.compute.models.VirtualHardDisk
        :keyword image: The source user image virtual hard disk. The virtual hard disk will be copied
         before being attached to the virtual machine. If SourceImage is provided, the destination
         virtual hard drive must not exist.
        :paramtype image: ~azure.mgmt.compute.models.VirtualHardDisk
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: Specifies how the virtual machine should be
         created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
         This value is used when you are using a specialized disk to create the virtual
         machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
         image to create the virtual machine. If you are using a platform image, you also use the
         imageReference element described above. If you are using a marketplace image, you  also use the
         plan element previously described. Required. Known values are: "FromImage", "Empty", and
         "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than
         1023.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
        :keyword to_be_detached: Specifies whether the data disk is in process of detachment from the
         VirtualMachine/VirtualMachineScaleset.
        :paramtype to_be_detached: bool
        :keyword detach_option: Specifies the detach behavior to be used while detaching a disk or
         which is already in the process of detachment from the virtual machine. Supported values:
         **ForceDetach**. :code:`<br>`:code:`<br>` detachOption: **ForceDetach** is applicable only for
         managed data disks. If a previous detachment attempt of the data disk did not complete due to
         an unexpected failure from the virtual machine and the disk is still not released then use
         force-detach as a last resort option to detach the disk forcibly from the VM. All writes might
         not have been flushed when using this detach behavior. :code:`<br>`:code:`<br>` This feature is
         still in preview mode and is not supported for VirtualMachineScaleSet. To force-detach a data
         disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.
         "ForceDetach"
        :paramtype detach_option: str or ~azure.mgmt.compute.models.DiskDetachOptionTypes
        :keyword delete_option: Specifies whether data disk should be deleted or detached upon VM
         deletion.:code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
         value is used, the data disk is deleted when VM is deleted.:code:`<br>`:code:`<br>` **Detach**
         If this value is used, the data disk is retained after VM is deleted.:code:`<br>`:code:`<br>`
         The default value is set to **detach**. Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.to_be_detached = to_be_detached
        self.disk_iops_read_write = None
        self.disk_m_bps_read_write = None
        self.detach_option = detach_option
        self.delete_option = delete_option

class DataDiskImage(_serialization.Model):
    """Contains the data disk images information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
    :vartype lun: int
    """

    _validation = {
        "lun": {"readonly": True},
    }

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.lun = None

class DiagnosticsProfile(_serialization.Model):
    """Specifies the boot diagnostic settings state. :code:`<br>`:code:`<br>`Minimum api-version:
    2015-06-15.

    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`\ **NOTE**\ : If storageUri is
     being specified then ensure that the storage account is in the same region and subscription as
     the VM. :code:`<br>`:code:`<br>` You can easily view the output of your console log.
     :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the
     hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.models.BootDiagnostics
    """

    _attribute_map = {
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnostics"},
    }

    def __init__(self, *, boot_diagnostics: Optional["_models.BootDiagnostics"] = None, **kwargs: Any) -> None:
        """
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`\ **NOTE**\ : If storageUri is
         being specified then ensure that the storage account is in the same region and subscription as
         the VM. :code:`<br>`:code:`<br>` You can easily view the output of your console log.
         :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the
         hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.models.BootDiagnostics
        """
        super().__init__(**kwargs)
        self.boot_diagnostics = boot_diagnostics

class DiskEncryptionSettings(_serialization.Model):
    """Describes a Encryption Settings for a Disk.

    :ivar disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
     Vault Secret.
    :vartype disk_encryption_key: ~azure.mgmt.compute.models.KeyVaultSecretReference
    :ivar key_encryption_key: Specifies the location of the key encryption key in Key Vault.
    :vartype key_encryption_key: ~azure.mgmt.compute.models.KeyVaultKeyReference
    :ivar enabled: Specifies whether disk encryption should be enabled on the virtual machine.
    :vartype enabled: bool
    """

    _attribute_map = {
        "disk_encryption_key": {"key": "diskEncryptionKey", "type": "KeyVaultSecretReference"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultKeyReference"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disk_encryption_key: Optional["_models.KeyVaultSecretReference"] = None,
        key_encryption_key: Optional["_models.KeyVaultKeyReference"] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
         Vault Secret.
        :paramtype disk_encryption_key: ~azure.mgmt.compute.models.KeyVaultSecretReference
        :keyword key_encryption_key: Specifies the location of the key encryption key in Key Vault.
        :paramtype key_encryption_key: ~azure.mgmt.compute.models.KeyVaultKeyReference
        :keyword enabled: Specifies whether disk encryption should be enabled on the virtual machine.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key
        self.enabled = enabled

class DiskInstanceView(_serialization.Model):
    """The instance view of the disk.

    :ivar name: The disk name.
    :vartype name: str
    :ivar encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype encryption_settings:
     list[~azure.mgmt.compute.models.DiskEncryptionSettings]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "[DiskEncryptionSettings]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        encryption_settings: Optional[List["_models.DiskEncryptionSettings"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword encryption_settings: Specifies the encryption settings for the OS Disk.
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype encryption_settings:
         list[~azure.mgmt.compute.models.DiskEncryptionSettings]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.name = name
        self.encryption_settings = encryption_settings
        self.statuses = statuses

class HardwareProfile(_serialization.Model):
    """Specifies the hardware settings for the virtual machine.

    :ivar vm_size: Specifies the size of the virtual machine. :code:`<br>`:code:`<br>` The enum
     data type is currently deprecated and will be removed by December 23rd 2023.
     :code:`<br>`:code:`<br>` Recommended way to get the list of available sizes is using these
     APIs: :code:`<br>`:code:`<br>` `List all available virtual machine sizes in an availability set
     <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
     <https://docs.microsoft.com/rest/api/compute/resourceskus/list>`_ :code:`<br>`:code:`<br>`
     `List all available virtual machine sizes for resizing
     <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. For more
     information about virtual machine sizes, see `Sizes for virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/sizes>`_. :code:`<br>`:code:`<br>` The
     available VM sizes depend on region and availability set. Known values are: "Basic_A0",
     "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0", "Standard_A1", "Standard_A2",
     "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8",
     "Standard_A9", "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2_v2",
     "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2", "Standard_A4m_v2", "Standard_A8m_v2",
     "Standard_B1s", "Standard_B1ms", "Standard_B2s", "Standard_B2ms", "Standard_B4ms",
     "Standard_B8ms", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11",
     "Standard_D12", "Standard_D13", "Standard_D14", "Standard_D1_v2", "Standard_D2_v2",
     "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D2_v3", "Standard_D4_v3",
     "Standard_D8_v3", "Standard_D16_v3", "Standard_D32_v3", "Standard_D64_v3", "Standard_D2s_v3",
     "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3", "Standard_D32s_v3",
     "Standard_D64s_v3", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2",
     "Standard_D15_v2", "Standard_DS1", "Standard_DS2", "Standard_DS3", "Standard_DS4",
     "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS1_v2",
     "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2",
     "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2",
     "Standard_DS13-4_v2", "Standard_DS13-2_v2", "Standard_DS14-8_v2", "Standard_DS14-4_v2",
     "Standard_E2_v3", "Standard_E4_v3", "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3",
     "Standard_E64_v3", "Standard_E2s_v3", "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3",
     "Standard_E32s_v3", "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3",
     "Standard_E64-32s_v3", "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4",
     "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
     "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
     "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
     "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
     "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
     "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
     "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
     "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
     "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
     "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
     "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
     "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
     "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12", and
     "Standard_NV24".
    :vartype vm_size: str or ~azure.mgmt.compute.models.VirtualMachineSizeTypes
    :ivar vm_size_properties: Specifies the properties for customizing the size of the virtual
     machine. Minimum api-version: 2021-07-01. :code:`<br>`:code:`<br>` This feature is still in
     preview mode and is not supported for VirtualMachineScaleSet. :code:`<br>`:code:`<br>` Please
     follow the instructions in `VM Customization <https://aka.ms/vmcustomization>`_ for more
     details.
    :vartype vm_size_properties: ~azure.mgmt.compute.models.VMSizeProperties
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "vm_size_properties": {"key": "vmSizeProperties", "type": "VMSizeProperties"},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[Union[str, "_models.VirtualMachineSizeTypes"]] = None,
        vm_size_properties: Optional["_models.VMSizeProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_size: Specifies the size of the virtual machine. :code:`<br>`:code:`<br>` The enum
         data type is currently deprecated and will be removed by December 23rd 2023.
         :code:`<br>`:code:`<br>` Recommended way to get the list of available sizes is using these
         APIs: :code:`<br>`:code:`<br>` `List all available virtual machine sizes in an availability set
         <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_
         :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
         <https://docs.microsoft.com/rest/api/compute/resourceskus/list>`_ :code:`<br>`:code:`<br>`
         `List all available virtual machine sizes for resizing
         <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. For more
         information about virtual machine sizes, see `Sizes for virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/sizes>`_. :code:`<br>`:code:`<br>` The
         available VM sizes depend on region and availability set. Known values are: "Basic_A0",
         "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0", "Standard_A1", "Standard_A2",
         "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8",
         "Standard_A9", "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2_v2",
         "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2", "Standard_A4m_v2", "Standard_A8m_v2",
         "Standard_B1s", "Standard_B1ms", "Standard_B2s", "Standard_B2ms", "Standard_B4ms",
         "Standard_B8ms", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11",
         "Standard_D12", "Standard_D13", "Standard_D14", "Standard_D1_v2", "Standard_D2_v2",
         "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D2_v3", "Standard_D4_v3",
         "Standard_D8_v3", "Standard_D16_v3", "Standard_D32_v3", "Standard_D64_v3", "Standard_D2s_v3",
         "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3", "Standard_D32s_v3",
         "Standard_D64s_v3", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2",
         "Standard_D15_v2", "Standard_DS1", "Standard_DS2", "Standard_DS3", "Standard_DS4",
         "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS1_v2",
         "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2",
         "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2",
         "Standard_DS13-4_v2", "Standard_DS13-2_v2", "Standard_DS14-8_v2", "Standard_DS14-4_v2",
         "Standard_E2_v3", "Standard_E4_v3", "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3",
         "Standard_E64_v3", "Standard_E2s_v3", "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3",
         "Standard_E32s_v3", "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3",
         "Standard_E64-32s_v3", "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4",
         "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
         "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
         "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
         "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
         "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
         "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
         "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
         "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
         "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
         "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
         "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
         "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
         "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12", and
         "Standard_NV24".
        :paramtype vm_size: str or ~azure.mgmt.compute.models.VirtualMachineSizeTypes
        :keyword vm_size_properties: Specifies the properties for customizing the size of the virtual
         machine. Minimum api-version: 2021-07-01. :code:`<br>`:code:`<br>` This feature is still in
         preview mode and is not supported for VirtualMachineScaleSet. :code:`<br>`:code:`<br>` Please
         follow the instructions in `VM Customization <https://aka.ms/vmcustomization>`_ for more
         details.
        :paramtype vm_size_properties: ~azure.mgmt.compute.models.VMSizeProperties
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.vm_size_properties = vm_size_properties

class SubResource(_serialization.Model):
    """SubResource.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id

class ImageReference(SubResource):
    """Specifies information about the image to use. You can specify information about platform
    images, marketplace images, or virtual machine images. This element is required when you want
    to use a platform image, marketplace image, or virtual machine image, but is not used in other
    creation operations. NOTE: Image reference publisher and offer can only be set when you create
    the scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar publisher: The image publisher.
    :vartype publisher: str
    :ivar offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :vartype offer: str
    :ivar sku: The image SKU.
    :vartype sku: str
    :ivar version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available. Please do not use field 'version' for gallery
     image deployment, gallery image should always use 'id' field for deployment, to use 'latest'
     version of gallery image, just set
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'
     in the 'id' field without version input.
    :vartype version: str
    :ivar exact_version: Specifies in decimal numbers, the version of platform image or marketplace
     image used to create the virtual machine. This readonly field differs from 'version', only if
     the value specified in 'version' field is 'latest'.
    :vartype exact_version: str
    :ivar shared_gallery_image_id: Specified the shared gallery image unique id for vm deployment.
     This can be fetched from shared gallery image GET call.
    :vartype shared_gallery_image_id: str
    :ivar community_gallery_image_id: Specified the community gallery image unique id for vm
     deployment. This can be fetched from community gallery image GET call.
    :vartype community_gallery_image_id: str
    """

    _validation = {
        "exact_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "exact_version": {"key": "exactVersion", "type": "str"},
        "shared_gallery_image_id": {"key": "sharedGalleryImageId", "type": "str"},
        "community_gallery_image_id": {"key": "communityGalleryImageId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        shared_gallery_image_id: Optional[str] = None,
        community_gallery_image_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword publisher: The image publisher.
        :paramtype publisher: str
        :keyword offer: Specifies the offer of the platform image or marketplace image used to create
         the virtual machine.
        :paramtype offer: str
        :keyword sku: The image SKU.
        :paramtype sku: str
        :keyword version: Specifies the version of the platform image or marketplace image used to
         create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major,
         Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image
         available at deploy time. Even if you use 'latest', the VM image will not automatically update
         after deploy time even if a new version becomes available. Please do not use field 'version'
         for gallery image deployment, gallery image should always use 'id' field for deployment, to use
         'latest' version of gallery image, just set
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}'
         in the 'id' field without version input.
        :paramtype version: str
        :keyword shared_gallery_image_id: Specified the shared gallery image unique id for vm
         deployment. This can be fetched from shared gallery image GET call.
        :paramtype shared_gallery_image_id: str
        :keyword community_gallery_image_id: Specified the community gallery image unique id for vm
         deployment. This can be fetched from community gallery image GET call.
        :paramtype community_gallery_image_id: str
        """
        super().__init__(id=id, **kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
        self.exact_version = None
        self.shared_gallery_image_id = shared_gallery_image_id
        self.community_gallery_image_id = community_gallery_image_id

class InnerError(_serialization.Model):
    """Inner error details.

    :ivar exceptiontype: The exception type.
    :vartype exceptiontype: str
    :ivar errordetail: The internal error message or exception dump.
    :vartype errordetail: str
    """

    _attribute_map = {
        "exceptiontype": {"key": "exceptiontype", "type": "str"},
        "errordetail": {"key": "errordetail", "type": "str"},
    }

    def __init__(
        self, *, exceptiontype: Optional[str] = None, errordetail: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword exceptiontype: The exception type.
        :paramtype exceptiontype: str
        :keyword errordetail: The internal error message or exception dump.
        :paramtype errordetail: str
        """
        super().__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail

class InstanceViewStatus(_serialization.Model):
    """Instance view status.

    :ivar code: The status code.
    :vartype code: str
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.compute.models.StatusLevelTypes
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "_models.StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: The status code.
        :paramtype code: str
        :keyword level: The level code. Known values are: "Info", "Warning", and "Error".
        :paramtype level: str or ~azure.mgmt.compute.models.StatusLevelTypes
        :keyword display_status: The short localizable label for the status.
        :paramtype display_status: str
        :keyword message: The detailed status message, including for alerts and error messages.
        :paramtype message: str
        :keyword time: The time of the status.
        :paramtype time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.code = code
        self.level = level
        self.display_status = display_status
        self.message = message
        self.time = time

class KeyVaultKeyReference(_serialization.Model):
    """Describes a reference to Key Vault Key.

    All required parameters must be populated in order to send to Azure.

    :ivar key_url: The URL referencing a key encryption key in Key Vault. Required.
    :vartype key_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the key. Required.
    :vartype source_vault: ~azure.mgmt.compute.models.SubResource
    """

    _validation = {
        "key_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "key_url": {"key": "keyUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
    }

    def __init__(self, *, key_url: str, source_vault: "_models.SubResource", **kwargs: Any) -> None:
        """
        :keyword key_url: The URL referencing a key encryption key in Key Vault. Required.
        :paramtype key_url: str
        :keyword source_vault: The relative URL of the Key Vault containing the key. Required.
        :paramtype source_vault: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(**kwargs)
        self.key_url = key_url
        self.source_vault = source_vault

class KeyVaultSecretReference(_serialization.Model):
    """Describes a reference to Key Vault Secret.

    All required parameters must be populated in order to send to Azure.

    :ivar secret_url: The URL referencing a secret in a Key Vault. Required.
    :vartype secret_url: str
    :ivar source_vault: The relative URL of the Key Vault containing the secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.models.SubResource
    """

    _validation = {
        "secret_url": {"required": True},
        "source_vault": {"required": True},
    }

    _attribute_map = {
        "secret_url": {"key": "secretUrl", "type": "str"},
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
    }

    def __init__(self, *, secret_url: str, source_vault: "_models.SubResource", **kwargs: Any) -> None:
        """
        :keyword secret_url: The URL referencing a secret in a Key Vault. Required.
        :paramtype secret_url: str
        :keyword source_vault: The relative URL of the Key Vault containing the secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(**kwargs)
        self.secret_url = secret_url
        self.source_vault = source_vault

class LinuxConfiguration(_serialization.Model):
    """Specifies the Linux operating system settings on the virtual machine.
    :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
    Azure-Endorsed Distributions
    <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.

    :ivar disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :vartype disable_password_authentication: bool
    :ivar ssh: Specifies the ssh key configuration for a Linux OS.
    :vartype ssh: ~azure.mgmt.compute.models.SshConfiguration
    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :vartype provision_vm_agent: bool
    :ivar patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Linux.
    :vartype patch_settings: ~azure.mgmt.compute.models.LinuxPatchSettings
    :ivar enable_vm_agent_platform_updates: Indicates whether VMAgent Platform Updates is enabled
     for the Linux virtual machine. Default value is false.
    :vartype enable_vm_agent_platform_updates: bool
    """

    _attribute_map = {
        "disable_password_authentication": {"key": "disablePasswordAuthentication", "type": "bool"},
        "ssh": {"key": "ssh", "type": "SshConfiguration"},
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "patch_settings": {"key": "patchSettings", "type": "LinuxPatchSettings"},
        "enable_vm_agent_platform_updates": {"key": "enableVMAgentPlatformUpdates", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["_models.SshConfiguration"] = None,
        provision_vm_agent: Optional[bool] = None,
        patch_settings: Optional["_models.LinuxPatchSettings"] = None,
        enable_vm_agent_platform_updates: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disable_password_authentication: Specifies whether password authentication should be
         disabled.
        :paramtype disable_password_authentication: bool
        :keyword ssh: Specifies the ssh key configuration for a Linux OS.
        :paramtype ssh: ~azure.mgmt.compute.models.SshConfiguration
        :keyword provision_vm_agent: Indicates whether virtual machine agent should be provisioned on
         the virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the
         request body, default behavior is to set it to true.  This will ensure that VM Agent is
         installed on the VM so that extensions can be added to the VM later.
        :paramtype provision_vm_agent: bool
        :keyword patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
         Linux.
        :paramtype patch_settings: ~azure.mgmt.compute.models.LinuxPatchSettings
        :keyword enable_vm_agent_platform_updates: Indicates whether VMAgent Platform Updates is
         enabled for the Linux virtual machine. Default value is false.
        :paramtype enable_vm_agent_platform_updates: bool
        """
        super().__init__(**kwargs)
        self.disable_password_authentication = disable_password_authentication
        self.ssh = ssh
        self.provision_vm_agent = provision_vm_agent
        self.patch_settings = patch_settings
        self.enable_vm_agent_platform_updates = enable_vm_agent_platform_updates

class ListUsagesResult(_serialization.Model):
    """The List Usages operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of compute resource usages. Required.
    :vartype value: list[~azure.mgmt.compute.models.Usage]
    :ivar next_link: The URI to fetch the next page of compute resource usage information. Call
     ListNext() with this to fetch the next page of compute resource usage information.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Usage"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of compute resource usages. Required.
        :paramtype value: list[~azure.mgmt.compute.models.Usage]
        :keyword next_link: The URI to fetch the next page of compute resource usage information. Call
         ListNext() with this to fetch the next page of compute resource usage information.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class NetworkInterfaceReference(SubResource):
    """Describes a network interface reference.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        primary: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword delete_option: Specify what happens to the network interface when the VM is deleted.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
        """
        super().__init__(id=id, **kwargs)
        self.primary = primary
        self.delete_option = delete_option

class NetworkProfile(_serialization.Model):
    """Specifies the network interfaces or the networking configuration of the virtual machine.

    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the virtual machine.
    :vartype network_interfaces:
     list[~azure.mgmt.compute.models.NetworkInterfaceReference]
    :ivar network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations. "2020-11-01"
    :vartype network_api_version: str or ~azure.mgmt.compute.models.NetworkApiVersion
    :ivar network_interface_configurations: Specifies the networking configurations that will be
     used to create the virtual machine networking resources.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.models.VirtualMachineNetworkInterfaceConfiguration]
    """

    _attribute_map = {
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterfaceReference]"},
        "network_api_version": {"key": "networkApiVersion", "type": "str"},
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineNetworkInterfaceConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        network_interfaces: Optional[List["_models.NetworkInterfaceReference"]] = None,
        network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = None,
        network_interface_configurations: Optional[List["_models.VirtualMachineNetworkInterfaceConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interfaces: Specifies the list of resource Ids for the network interfaces
         associated with the virtual machine.
        :paramtype network_interfaces:
         list[~azure.mgmt.compute.models.NetworkInterfaceReference]
        :keyword network_api_version: specifies the Microsoft.Network API version used when creating
         networking resources in the Network Interface Configurations. "2020-11-01"
        :paramtype network_api_version: str or ~azure.mgmt.compute.models.NetworkApiVersion
        :keyword network_interface_configurations: Specifies the networking configurations that will be
         used to create the virtual machine networking resources.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.models.VirtualMachineNetworkInterfaceConfiguration]
        """
        super().__init__(**kwargs)
        self.network_interfaces = network_interfaces
        self.network_api_version = network_api_version
        self.network_interface_configurations = network_interface_configurations

class OSDisk(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the operating system disk used by the virtual machine.
    :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs for Azure
    virtual machines <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.

    All required parameters must be populated in order to send to Azure.

    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known
     values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype encryption_settings: ~azure.mgmt.compute.models.DiskEncryptionSettings
    :ivar name: The disk name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.compute.models.VirtualHardDisk
    :ivar image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :vartype image: ~azure.mgmt.compute.models.VirtualHardDisk
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None** for Standard
     storage. **ReadOnly** for Premium storage. Known values are: "None", "ReadOnly", and
     "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system disk
     used by the virtual machine.
    :vartype diff_disk_settings: ~azure.mgmt.compute.models.DiffDiskSettings
    :ivar create_option: Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than
     1023.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
    :ivar delete_option: Specifies whether OS Disk should be deleted or detached upon VM deletion.
     :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this value is
     used, the OS disk is deleted when VM is deleted.:code:`<br>`:code:`<br>` **Detach** If this
     value is used, the os disk is retained after VM is deleted. :code:`<br>`:code:`<br>` The
     default value is set to **detach**. For an ephemeral OS Disk, the default value is set to
     **Delete**. User cannot change the delete option for ephemeral OS Disk. Known values are:
     "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
    """

    _validation = {
        "create_option": {"required": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "encryption_settings": {"key": "encryptionSettings", "type": "DiskEncryptionSettings"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "diff_disk_settings": {"key": "diffDiskSettings", "type": "DiffDiskSettings"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "ManagedDiskParameters"},
        "delete_option": {"key": "deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        encryption_settings: Optional["_models.DiskEncryptionSettings"] = None,
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        diff_disk_settings: Optional["_models.DiffDiskSettings"] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDiskParameters"] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>`
         Possible values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword encryption_settings: Specifies the encryption settings for the OS Disk.
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype encryption_settings: ~azure.mgmt.compute.models.DiskEncryptionSettings
        :keyword name: The disk name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.compute.models.VirtualHardDisk
        :keyword image: The source user image virtual hard disk. The virtual hard disk will be copied
         before being attached to the virtual machine. If SourceImage is provided, the destination
         virtual hard drive must not exist.
        :paramtype image: ~azure.mgmt.compute.models.VirtualHardDisk
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None** for Standard
         storage. **ReadOnly** for Premium storage. Known values are: "None", "ReadOnly", and
         "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system
         disk used by the virtual machine.
        :paramtype diff_disk_settings: ~azure.mgmt.compute.models.DiffDiskSettings
        :keyword create_option: Specifies how the virtual machine should be
         created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
         This value is used when you are using a specialized disk to create the virtual
         machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
         image to create the virtual machine. If you are using a platform image, you also use the
         imageReference element described above. If you are using a marketplace image, you  also use the
         plan element previously described. Required. Known values are: "FromImage", "Empty", and
         "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than
         1023.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk: ~azure.mgmt.compute.models.ManagedDiskParameters
        :keyword delete_option: Specifies whether OS Disk should be deleted or detached upon VM
         deletion. :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
         value is used, the OS disk is deleted when VM is deleted.:code:`<br>`:code:`<br>` **Detach** If
         this value is used, the os disk is retained after VM is deleted. :code:`<br>`:code:`<br>` The
         default value is set to **detach**. For an ephemeral OS Disk, the default value is set to
         **Delete**. User cannot change the delete option for ephemeral OS Disk. Known values are:
         "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.encryption_settings = encryption_settings
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.diff_disk_settings = diff_disk_settings
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.delete_option = delete_option

class OSDiskImage(_serialization.Model):
    """Contains the os disk image information.

    All required parameters must be populated in order to send to Azure.

    :ivar operating_system: The operating system of the osDiskImage. Required. Known values are:
     "Windows" and "Linux".
    :vartype operating_system: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    """

    _validation = {
        "operating_system": {"required": True},
    }

    _attribute_map = {
        "operating_system": {"key": "operatingSystem", "type": "str"},
    }

    def __init__(self, *, operating_system: Union[str, "_models.OperatingSystemTypes"], **kwargs: Any) -> None:
        """
        :keyword operating_system: The operating system of the osDiskImage. Required. Known values are:
         "Windows" and "Linux".
        :paramtype operating_system: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        """
        super().__init__(**kwargs)
        self.operating_system = operating_system

class OSProfile(_serialization.Model):
    """Specifies the operating system settings for the virtual machine. Some of the settings cannot be
    changed once VM is provisioned.

    :ivar computer_name: Specifies the host OS name of the virtual machine.
     :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
     :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
     restrictions see `Azure infrastructure services implementation guidelines
     <https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules>`_.
    :vartype computer_name: str
    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     This property cannot be updated after the VM is created. :code:`<br>`:code:`<br>`
     **Windows-only restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character
     :code:`<br>`:code:`<br>` **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>`
     **Max-length (Windows):** 20 characters.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` **Note: Do not pass any
     secrets or passwords in customData property** :code:`<br>`:code:`<br>` This property cannot be
     updated after the VM is created. :code:`<br>`:code:`<br>` customData is passed to the VM to be
     saved as a file, for more information see `Custom Data on Azure VMs
     <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_
     :code:`<br>`:code:`<br>` For using cloud-init for your Linux VM, see `Using cloud-init to
     customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
    :vartype custom_data: str
    :ivar windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :vartype windows_configuration: ~azure.mgmt.compute.models.WindowsConfiguration
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
    :vartype linux_configuration: ~azure.mgmt.compute.models.LinuxConfiguration
    :ivar secrets: Specifies set of certificates that should be installed onto the virtual machine.
     To install certificates on a virtual machine it is recommended to use the `Azure Key Vault
     virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype secrets: list[~azure.mgmt.compute.models.VaultSecretGroup]
    :ivar allow_extension_operations: Specifies whether extension operations should be allowed on
     the virtual machine. :code:`<br>`:code:`<br>`This may only be set to False when no extensions
     are present on the virtual machine.
    :vartype allow_extension_operations: bool
    :ivar require_guest_provision_signal: Optional property which must either be set to True or
     omitted.
    :vartype require_guest_provision_signal: bool
    """

    _attribute_map = {
        "computer_name": {"key": "computerName", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
        "allow_extension_operations": {"key": "allowExtensionOperations", "type": "bool"},
        "require_guest_provision_signal": {"key": "requireGuestProvisionSignal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        allow_extension_operations: Optional[bool] = None,
        require_guest_provision_signal: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword computer_name: Specifies the host OS name of the virtual machine.
         :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
         :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
         restrictions see `Azure infrastructure services implementation guidelines
         <https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules>`_.
        :paramtype computer_name: str
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` This property cannot be updated after the VM is created.
         :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
         :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
         "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
         "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
         "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
         :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
         characters.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
         characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
         :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
         fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
         digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
         resetting the password, see `How to reset the Remote Desktop service or its login password in a
         Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
         :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
        :paramtype admin_password: str
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
         length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` **Note: Do not pass any
         secrets or passwords in customData property** :code:`<br>`:code:`<br>` This property cannot be
         updated after the VM is created. :code:`<br>`:code:`<br>` customData is passed to the VM to be
         saved as a file, for more information see `Custom Data on Azure VMs
         <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_
         :code:`<br>`:code:`<br>` For using cloud-init for your Linux VM, see `Using cloud-init to
         customize a Linux VM during creation
         <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
        :paramtype custom_data: str
        :keyword windows_configuration: Specifies Windows operating system settings on the virtual
         machine.
        :paramtype windows_configuration: ~azure.mgmt.compute.models.WindowsConfiguration
        :keyword linux_configuration: Specifies the Linux operating system settings on the virtual
         machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
         Azure-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
        :paramtype linux_configuration: ~azure.mgmt.compute.models.LinuxConfiguration
        :keyword secrets: Specifies set of certificates that should be installed onto the virtual
         machine. To install certificates on a virtual machine it is recommended to use the `Azure Key
         Vault virtual machine extension for Linux
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
         Key Vault virtual machine extension for Windows
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
        :paramtype secrets: list[~azure.mgmt.compute.models.VaultSecretGroup]
        :keyword allow_extension_operations: Specifies whether extension operations should be allowed
         on the virtual machine. :code:`<br>`:code:`<br>`This may only be set to False when no
         extensions are present on the virtual machine.
        :paramtype allow_extension_operations: bool
        :keyword require_guest_provision_signal: Optional property which must either be set to True or
         omitted.
        :paramtype require_guest_provision_signal: bool
        """
        super().__init__(**kwargs)
        self.computer_name = computer_name
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets
        self.allow_extension_operations = allow_extension_operations
        self.require_guest_provision_signal = require_guest_provision_signal

class OperationStatusResponse(_serialization.Model):
    """Operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation ID.
    :vartype name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar start_time: Start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar error: Api error.
    :vartype error: ~azure.mgmt.compute.models.ApiError
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.error = None

class Plan(_serialization.Model):
    """Specifies information about the marketplace image used to create the virtual machine. This
    element is only used for marketplace images. Before you can use a marketplace image from an
    API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace
    image that you want to use and then click **Want to deploy programmatically, Get Started ->**.
    Enter any required information and then click **Save**.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code

class PurchasePlan(_serialization.Model):
    """Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher: The publisher ID. Required.
    :vartype publisher: str
    :ivar name: The plan ID. Required.
    :vartype name: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element. Required.
    :vartype product: str
    """

    _validation = {
        "publisher": {"required": True},
        "name": {"required": True},
        "product": {"required": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "product": {"key": "product", "type": "str"},
    }

    def __init__(self, *, publisher: str, name: str, product: str, **kwargs: Any) -> None:
        """
        :keyword publisher: The publisher ID. Required.
        :paramtype publisher: str
        :keyword name: The plan ID. Required.
        :paramtype name: str
        :keyword product: Specifies the product of the image from the marketplace. This is the same
         value as Offer under the imageReference element. Required.
        :paramtype product: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.name = name
        self.product = product

class Sku(_serialization.Model):
    """Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the
    hardware the scale set is currently on, you need to deallocate the VMs in the scale set before
    you modify the SKU name.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br />`
     Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
     **Basic**.
    :vartype tier: str
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, tier: Optional[str] = None, capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name.
        :paramtype name: str
        :keyword tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br
         />` Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
         **Basic**.
        :paramtype tier: str
        :keyword capacity: Specifies the number of virtual machines in the scale set.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity

class SshConfiguration(_serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.compute.models.SshPublicKey]
    """

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(self, *, public_keys: Optional[List["_models.SshPublicKey"]] = None, **kwargs: Any) -> None:
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        :paramtype public_keys: list[~azure.mgmt.compute.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys

class SshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the
    public key is placed.

    :ivar path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :vartype path: str
    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
     ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in
     Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
    :vartype key_data: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, key_data: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword path: Specifies the full path on the created VM where ssh public key is stored. If the
         file already exists, the specified key is appended to the file. Example:
         /home/user/.ssh/authorized_keys.
        :paramtype path: str
        :keyword key_data: SSH public key certificate used to authenticate with the VM through ssh. The
         key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
         ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in
         Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.key_data = key_data

class StorageProfile(_serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    :ivar image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :vartype image_reference: ~azure.mgmt.compute.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype os_disk: ~azure.mgmt.compute.models.OSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype data_disks: list[~azure.mgmt.compute.models.DataDisk]
    :ivar disk_controller_type: Specifies the disk controller type configured for the VM.
     :code:`<br>`:code:`<br>`NOTE: This property will be set to the default disk controller type if
     not specified provided virtual machine is being created as a hyperVGeneration: V2 based on the
     capabilities of the operating system disk and VM size from the the specified minimum api
     version. :code:`<br>`You need to deallocate the VM before updating its disk controller type
     unless you are updating the VM size in the VM configuration which implicitly deallocates and
     reallocates the VM. :code:`<br>`:code:`<br>` Minimum api-version: 2022-08-01. Known values are:
     "SCSI" and "NVMe".
    :vartype disk_controller_type: str or
     ~azure.mgmt.compute.models.DiskControllerTypes
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "OSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[DataDisk]"},
        "disk_controller_type": {"key": "diskControllerType", "type": "str"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.OSDisk"] = None,
        data_disks: Optional[List["_models.DataDisk"]] = None,
        disk_controller_type: Optional[Union[str, "_models.DiskControllerTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: Specifies information about the image to use. You can specify
         information about platform images, marketplace images, or virtual machine images. This element
         is required when you want to use a platform image, marketplace image, or virtual machine image,
         but is not used in other creation operations.
        :paramtype image_reference: ~azure.mgmt.compute.models.ImageReference
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype os_disk: ~azure.mgmt.compute.models.OSDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype data_disks: list[~azure.mgmt.compute.models.DataDisk]
        :keyword disk_controller_type: Specifies the disk controller type configured for the VM.
         :code:`<br>`:code:`<br>`NOTE: This property will be set to the default disk controller type if
         not specified provided virtual machine is being created as a hyperVGeneration: V2 based on the
         capabilities of the operating system disk and VM size from the the specified minimum api
         version. :code:`<br>`You need to deallocate the VM before updating its disk controller type
         unless you are updating the VM size in the VM configuration which implicitly deallocates and
         reallocates the VM. :code:`<br>`:code:`<br>` Minimum api-version: 2022-08-01. Known values are:
         "SCSI" and "NVMe".
        :paramtype disk_controller_type: str or
         ~azure.mgmt.compute.models.DiskControllerTypes
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.disk_controller_type = disk_controller_type

class UpdateResource(_serialization.Model):
    """The Update Resource model definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags

class UpgradePolicy(_serialization.Model):
    """Describes an upgrade policy - automatic, manual, or rolling.

    :ivar mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of updates to virtual machines in the scale set. You do this by using the
     manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
     scale set are  automatically updated at the same time. Known values are: "Automatic", "Manual",
     and "Rolling".
    :vartype mode: str or ~azure.mgmt.compute.models.UpgradeMode
    :ivar rolling_upgrade_policy: The configuration parameters used while performing a rolling
     upgrade.
    :vartype rolling_upgrade_policy: ~azure.mgmt.compute.models.RollingUpgradePolicy
    :ivar automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS
     Upgrade.
    :vartype automatic_os_upgrade_policy:
     ~azure.mgmt.compute.models.AutomaticOSUpgradePolicy
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "rolling_upgrade_policy": {"key": "rollingUpgradePolicy", "type": "RollingUpgradePolicy"},
        "automatic_os_upgrade_policy": {"key": "automaticOSUpgradePolicy", "type": "AutomaticOSUpgradePolicy"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.UpgradeMode"]] = None,
        rolling_upgrade_policy: Optional["_models.RollingUpgradePolicy"] = None,
        automatic_os_upgrade_policy: Optional["_models.AutomaticOSUpgradePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
         />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
         the application of updates to virtual machines in the scale set. You do this by using the
         manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
         scale set are  automatically updated at the same time. Known values are: "Automatic", "Manual",
         and "Rolling".
        :paramtype mode: str or ~azure.mgmt.compute.models.UpgradeMode
        :keyword rolling_upgrade_policy: The configuration parameters used while performing a rolling
         upgrade.
        :paramtype rolling_upgrade_policy: ~azure.mgmt.compute.models.RollingUpgradePolicy
        :keyword automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS
         Upgrade.
        :paramtype automatic_os_upgrade_policy:
         ~azure.mgmt.compute.models.AutomaticOSUpgradePolicy
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.rolling_upgrade_policy = rolling_upgrade_policy
        self.automatic_os_upgrade_policy = automatic_os_upgrade_policy

class Usage(_serialization.Model):
    """Describes Compute Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: An enum describing the unit of usage measurement. Required. Default value is
     "Count".
    :vartype unit: str
    :ivar current_value: The current usage of the resource. Required.
    :vartype current_value: int
    :ivar limit: The maximum permitted usage of the resource. Required.
    :vartype limit: int
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.compute.models.UsageName
    """

    _validation = {
        "unit": {"required": True, "constant": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    unit = "Count"

    def __init__(self, *, current_value: int, limit: int, name: "_models.UsageName", **kwargs: Any) -> None:
        """
        :keyword current_value: The current usage of the resource. Required.
        :paramtype current_value: int
        :keyword limit: The maximum permitted usage of the resource. Required.
        :paramtype limit: int
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.compute.models.UsageName
        """
        super().__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.name = name

class UsageName(_serialization.Model):
    """The Usage Names.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The name of the resource.
        :paramtype value: str
        :keyword localized_value: The localized name of the resource.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value

class VaultCertificate(_serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should
    reside on the VM.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on a
     virtual machine it is recommended to use the `Azure Key Vault virtual machine extension for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the
     `Azure Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype certificate_url: str
    :ivar certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to which the certificate should be added. The specified certificate store is implicitly
     in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
     placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt
     for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of
     these files are .pem formatted.
    :vartype certificate_store: str
    """

    _attribute_map = {
        "certificate_url": {"key": "certificateUrl", "type": "str"},
        "certificate_store": {"key": "certificateStore", "type": "str"},
    }

    def __init__(
        self, *, certificate_url: Optional[str] = None, certificate_store: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
         <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
         certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
         in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
         "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
         "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on a
         virtual machine it is recommended to use the `Azure Key Vault virtual machine extension for
         Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the
         `Azure Key Vault virtual machine extension for Windows
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
        :paramtype certificate_url: str
        :keyword certificate_store: For Windows VMs, specifies the certificate store on the Virtual
         Machine to which the certificate should be added. The specified certificate store is implicitly
         in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
         placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt
         for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of
         these files are .pem formatted.
        :paramtype certificate_store: str
        """
        super().__init__(**kwargs)
        self.certificate_url = certificate_url
        self.certificate_store = certificate_store

class VaultSecretGroup(_serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.compute.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates: list[~azure.mgmt.compute.models.VaultCertificate]
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "vault_certificates": {"key": "vaultCertificates", "type": "[VaultCertificate]"},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[List["_models.VaultCertificate"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_vault: The relative URL of the Key Vault containing all of the certificates in
         VaultCertificates.
        :paramtype source_vault: ~azure.mgmt.compute.models.SubResource
        :keyword vault_certificates: The list of key vault references in SourceVault which contain
         certificates.
        :paramtype vault_certificates: list[~azure.mgmt.compute.models.VaultCertificate]
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates

class VirtualHardDisk(_serialization.Model):
    """Describes the uri of a disk.

    :ivar uri: Specifies the virtual hard disk's uri.
    :vartype uri: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(self, *, uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: Specifies the virtual hard disk's uri.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.uri = uri

class VirtualMachine(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.models.VirtualMachineExtension]
    :ivar identity: The identity of the virtual machine, if configured.
    :vartype identity: ~azure.mgmt.compute.models.VirtualMachineIdentity
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar extended_location: The extended location of the Virtual Machine.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.models.StorageProfile
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine.
    :vartype additional_capabilities: ~azure.mgmt.compute.models.AdditionalCapabilities
    :ivar os_profile: Specifies the operating system settings used while creating the virtual
     machine. Some of the settings cannot be changed once VM is provisioned.
    :vartype os_profile: ~azure.mgmt.compute.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.models.NetworkProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :vartype security_profile: ~azure.mgmt.compute.models.SecurityProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Availability sets overview
     <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
     and updates for Virtual Machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. The availability set to which the VM is being added should be under the same resource
     group as the availability set resource. An existing VM cannot be added to an availability set.
     :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
     properties.virtualMachineScaleSet reference.
    :vartype availability_set: ~azure.mgmt.compute.models.SubResource
    :ivar virtual_machine_scale_set: Specifies information about the virtual machine scale set that
     the virtual machine should be assigned to. Virtual machines specified in the same virtual
     machine scale set are allocated to different nodes to maximize availability. Currently, a VM
     can only be added to virtual machine scale set at creation time. An existing VM cannot be added
     to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
     non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
     2019‐03‐01.
    :vartype virtual_machine_scale_set: ~azure.mgmt.compute.models.SubResource
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
    :ivar priority: Specifies the priority for the virtual machine. :code:`<br>`:code:`<br>`Minimum
     api-version: 2019-03-01. Known values are: "Regular", "Low", and "Spot".
    :vartype priority: str or ~azure.mgmt.compute.models.VirtualMachinePriorityTypes
    :ivar eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
    :vartype eviction_policy: str or
     ~azure.mgmt.compute.models.VirtualMachineEvictionPolicyTypes
    :ivar billing_profile: Specifies the billing related details of a Azure Spot virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :vartype billing_profile: ~azure.mgmt.compute.models.BillingProfile
    :ivar host: Specifies information about the dedicated host that the virtual machine resides in.
     :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
    :vartype host: ~azure.mgmt.compute.models.SubResource
    :ivar host_group: Specifies information about the dedicated host group that the virtual machine
     resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
     :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
    :vartype host_group: ~azure.mgmt.compute.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.models.VirtualMachineInstanceView
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    :ivar extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :vartype extensions_time_budget: str
    :ivar platform_fault_domain: Specifies the scale set logical fault domain into which the
     Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
     to a fault domain that best maintains balance across available fault
     domains.:code:`<br>`:code:`<li>`This is applicable only if the 'virtualMachineScaleSet'
     property of this Virtual Machine is set.:code:`<li>`The Virtual Machine Scale Set that is
     referenced, must have 'platformFaultDomainCount' &gt; 1.:code:`<li>`This property cannot be
     updated once the Virtual Machine is created.:code:`<li>`Fault domain assignment can be viewed
     in the Virtual Machine Instance View.:code:`<br>`:code:`<br>`Minimum api‐version: 2020‐12‐01.
    :vartype platform_fault_domain: int
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile:
     ~azure.mgmt.compute.models.ScheduledEventsProfile
    :ivar user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :vartype user_data: str
    :ivar capacity_reservation: Specifies information about the capacity reservation that is used
     to allocate virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
    :vartype capacity_reservation:
     ~azure.mgmt.compute.models.CapacityReservationProfile
    :ivar application_profile: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype application_profile: ~azure.mgmt.compute.models.ApplicationProfile
    :ivar time_created: Specifies the time at which the Virtual Machine resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "resources": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "vm_id": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "Plan"},
        "resources": {"key": "resources", "type": "[VirtualMachineExtension]"},
        "identity": {"key": "identity", "type": "VirtualMachineIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "security_profile": {"key": "properties.securityProfile", "type": "SecurityProfile"},
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "virtual_machine_scale_set": {"key": "properties.virtualMachineScaleSet", "type": "SubResource"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "priority": {"key": "properties.priority", "type": "str"},
        "eviction_policy": {"key": "properties.evictionPolicy", "type": "str"},
        "billing_profile": {"key": "properties.billingProfile", "type": "BillingProfile"},
        "host": {"key": "properties.host", "type": "SubResource"},
        "host_group": {"key": "properties.hostGroup", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineInstanceView"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "extensions_time_budget": {"key": "properties.extensionsTimeBudget", "type": "str"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "scheduled_events_profile": {"key": "properties.scheduledEventsProfile", "type": "ScheduledEventsProfile"},
        "user_data": {"key": "properties.userData", "type": "str"},
        "capacity_reservation": {"key": "properties.capacityReservation", "type": "CapacityReservationProfile"},
        "application_profile": {"key": "properties.applicationProfile", "type": "ApplicationProfile"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineIdentity"] = None,
        zones: Optional[List[str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        virtual_machine_scale_set: Optional["_models.SubResource"] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        priority: Optional[Union[str, "_models.VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "_models.VirtualMachineEvictionPolicyTypes"]] = None,
        billing_profile: Optional["_models.BillingProfile"] = None,
        host: Optional["_models.SubResource"] = None,
        host_group: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        extensions_time_budget: Optional[str] = None,
        platform_fault_domain: Optional[int] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["_models.CapacityReservationProfile"] = None,
        application_profile: Optional["_models.ApplicationProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.models.Plan
        :keyword identity: The identity of the virtual machine, if configured.
        :paramtype identity: ~azure.mgmt.compute.models.VirtualMachineIdentity
        :keyword zones: The virtual machine zones.
        :paramtype zones: list[str]
        :keyword extended_location: The extended location of the Virtual Machine.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.models.StorageProfile
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         virtual machine.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.models.AdditionalCapabilities
        :keyword os_profile: Specifies the operating system settings used while creating the virtual
         machine. Some of the settings cannot be changed once VM is provisioned.
        :paramtype os_profile: ~azure.mgmt.compute.models.OSProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.models.NetworkProfile
        :keyword security_profile: Specifies the Security related profile settings for the virtual
         machine.
        :paramtype security_profile: ~azure.mgmt.compute.models.SecurityProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Availability sets overview
         <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
         and updates for Virtual Machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. The availability set to which the VM is being added should be under the same resource
         group as the availability set resource. An existing VM cannot be added to an availability set.
         :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
         properties.virtualMachineScaleSet reference.
        :paramtype availability_set: ~azure.mgmt.compute.models.SubResource
        :keyword virtual_machine_scale_set: Specifies information about the virtual machine scale set
         that the virtual machine should be assigned to. Virtual machines specified in the same virtual
         machine scale set are allocated to different nodes to maximize availability. Currently, a VM
         can only be added to virtual machine scale set at creation time. An existing VM cannot be added
         to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
         non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
         2019‐03‐01.
        :paramtype virtual_machine_scale_set: ~azure.mgmt.compute.models.SubResource
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
         2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
        :keyword priority: Specifies the priority for the virtual machine.
         :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01. Known values are: "Regular", "Low",
         and "Spot".
        :paramtype priority: str or ~azure.mgmt.compute.models.VirtualMachinePriorityTypes
        :keyword eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
         Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
         'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
         :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
         and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
        :paramtype eviction_policy: str or
         ~azure.mgmt.compute.models.VirtualMachineEvictionPolicyTypes
        :keyword billing_profile: Specifies the billing related details of a Azure Spot virtual
         machine. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype billing_profile: ~azure.mgmt.compute.models.BillingProfile
        :keyword host: Specifies information about the dedicated host that the virtual machine resides
         in. :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
        :paramtype host: ~azure.mgmt.compute.models.SubResource
        :keyword host_group: Specifies information about the dedicated host group that the virtual
         machine resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
         :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
        :paramtype host_group: ~azure.mgmt.compute.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
         :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
         :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
         :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
         :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
         <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        :keyword extensions_time_budget: Specifies the time alloted for all extensions to start. The
         time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified
         in ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
         api-version: 2020-06-01.
        :paramtype extensions_time_budget: str
        :keyword platform_fault_domain: Specifies the scale set logical fault domain into which the
         Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
         to a fault domain that best maintains balance across available fault
         domains.:code:`<br>`:code:`<li>`This is applicable only if the 'virtualMachineScaleSet'
         property of this Virtual Machine is set.:code:`<li>`The Virtual Machine Scale Set that is
         referenced, must have 'platformFaultDomainCount' &gt; 1.:code:`<li>`This property cannot be
         updated once the Virtual Machine is created.:code:`<li>`Fault domain assignment can be viewed
         in the Virtual Machine Instance View.:code:`<br>`:code:`<br>`Minimum api‐version: 2020‐12‐01.
        :paramtype platform_fault_domain: int
        :keyword scheduled_events_profile: Specifies Scheduled Event related configurations.
        :paramtype scheduled_events_profile:
         ~azure.mgmt.compute.models.ScheduledEventsProfile
        :keyword user_data: UserData for the VM, which must be base-64 encoded. Customer should not
         pass any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
        :paramtype user_data: str
        :keyword capacity_reservation: Specifies information about the capacity reservation that is
         used to allocate virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
        :paramtype capacity_reservation:
         ~azure.mgmt.compute.models.CapacityReservationProfile
        :keyword application_profile: Specifies the gallery applications that should be made available
         to the VM/VMSS.
        :paramtype application_profile: ~azure.mgmt.compute.models.ApplicationProfile
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.plan = plan
        self.resources = None
        self.identity = identity
        self.zones = zones
        self.extended_location = extended_location
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.additional_capabilities = additional_capabilities
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.virtual_machine_scale_set = virtual_machine_scale_set
        self.proximity_placement_group = proximity_placement_group
        self.priority = priority
        self.eviction_policy = eviction_policy
        self.billing_profile = billing_profile
        self.host = host
        self.host_group = host_group
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None
        self.extensions_time_budget = extensions_time_budget
        self.platform_fault_domain = platform_fault_domain
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data
        self.capacity_reservation = capacity_reservation
        self.application_profile = application_profile
        self.time_created = None

class VirtualMachineAgentInstanceView(_serialization.Model):
    """The instance view of the VM Agent running on the virtual machine.

    :ivar vm_agent_version: The VM Agent full version.
    :vartype vm_agent_version: str
    :ivar extension_handlers: The virtual machine extension handler instance view.
    :vartype extension_handlers:
     list[~azure.mgmt.compute.models.VirtualMachineExtensionHandlerInstanceView]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _attribute_map = {
        "vm_agent_version": {"key": "vmAgentVersion", "type": "str"},
        "extension_handlers": {"key": "extensionHandlers", "type": "[VirtualMachineExtensionHandlerInstanceView]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        vm_agent_version: Optional[str] = None,
        extension_handlers: Optional[List["_models.VirtualMachineExtensionHandlerInstanceView"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_agent_version: The VM Agent full version.
        :paramtype vm_agent_version: str
        :keyword extension_handlers: The virtual machine extension handler instance view.
        :paramtype extension_handlers:
         list[~azure.mgmt.compute.models.VirtualMachineExtensionHandlerInstanceView]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.vm_agent_version = vm_agent_version
        self.extension_handlers = extension_handlers
        self.statuses = statuses

class VirtualMachineCaptureParameters(_serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar vhd_prefix: The captured virtual hard disk's name prefix. Required.
    :vartype vhd_prefix: str
    :ivar destination_container_name: The destination container name. Required.
    :vartype destination_container_name: str
    :ivar overwrite_vhds: Specifies whether to overwrite the destination virtual hard disk, in case
     of conflict. Required.
    :vartype overwrite_vhds: bool
    """

    _validation = {
        "vhd_prefix": {"required": True},
        "destination_container_name": {"required": True},
        "overwrite_vhds": {"required": True},
    }

    _attribute_map = {
        "vhd_prefix": {"key": "vhdPrefix", "type": "str"},
        "destination_container_name": {"key": "destinationContainerName", "type": "str"},
        "overwrite_vhds": {"key": "overwriteVhds", "type": "bool"},
    }

    def __init__(
        self, *, vhd_prefix: str, destination_container_name: str, overwrite_vhds: bool, **kwargs: Any
    ) -> None:
        """
        :keyword vhd_prefix: The captured virtual hard disk's name prefix. Required.
        :paramtype vhd_prefix: str
        :keyword destination_container_name: The destination container name. Required.
        :paramtype destination_container_name: str
        :keyword overwrite_vhds: Specifies whether to overwrite the destination virtual hard disk, in
         case of conflict. Required.
        :paramtype overwrite_vhds: bool
        """
        super().__init__(**kwargs)
        self.vhd_prefix = vhd_prefix
        self.destination_container_name = destination_container_name
        self.overwrite_vhds = overwrite_vhds

class VirtualMachineCaptureResult(SubResource):
    """Output of virtual machine capture operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar schema: the schema of the captured virtual machine.
    :vartype schema: str
    :ivar content_version: the version of the content.
    :vartype content_version: str
    :ivar parameters: parameters of the captured virtual machine.
    :vartype parameters: JSON
    :ivar resources: a list of resource items of the captured virtual machine.
    :vartype resources: list[JSON]
    """

    _validation = {
        "schema": {"readonly": True},
        "content_version": {"readonly": True},
        "parameters": {"readonly": True},
        "resources": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "schema": {"key": "$schema", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
        "parameters": {"key": "parameters", "type": "object"},
        "resources": {"key": "resources", "type": "[object]"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(id=id, **kwargs)
        self.schema = None
        self.content_version = None
        self.parameters = None
        self.resources = None

class ResourceWithOptionalLocation(_serialization.Model):
    """The Resource model definition with location property as optional.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags

class VirtualMachineExtension(ResourceWithOptionalLocation):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine extension instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.models.VirtualMachineExtensionInstanceView
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.compute.models.KeyVaultSecretReference
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineExtensionInstanceView"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {
            "key": "properties.protectedSettingsFromKeyVault",
            "type": "KeyVaultSecretReference",
        },
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        instance_view: Optional["_models.VirtualMachineExtensionInstanceView"] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional["_models.KeyVaultSecretReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword instance_view: The virtual machine extension instance view.
        :paramtype instance_view:
         ~azure.mgmt.compute.models.VirtualMachineExtensionInstanceView
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault:
         ~azure.mgmt.compute.models.KeyVaultSecretReference
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault

class VirtualMachineExtensionHandlerInstanceView(_serialization.Model):
    """The instance view of a virtual machine extension handler.

    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar status: The extension handler status.
    :vartype status: ~azure.mgmt.compute.models.InstanceViewStatus
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "status": {"key": "status", "type": "InstanceViewStatus"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        status: Optional["_models.InstanceViewStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword status: The extension handler status.
        :paramtype status: ~azure.mgmt.compute.models.InstanceViewStatus
        """
        super().__init__(**kwargs)
        self.type = type
        self.type_handler_version = type_handler_version
        self.status = status

class VirtualMachineExtensionImage(Resource):
    """Describes a Virtual Machine Extension Image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar operating_system: The operating system this extension supports.
    :vartype operating_system: str
    :ivar compute_role: The type of role (IaaS or PaaS) this extension supports.
    :vartype compute_role: str
    :ivar handler_schema: The schema defined by publisher, where extension consumers should provide
     settings in a matching schema.
    :vartype handler_schema: str
    :ivar vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
     existing extensions are usable on scalesets, but there might be cases where a publisher wants
     to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
    :vartype vm_scale_set_enabled: bool
    :ivar supports_multiple_extensions: Whether the handler can support multiple extensions.
    :vartype supports_multiple_extensions: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "operating_system": {"key": "properties.operatingSystem", "type": "str"},
        "compute_role": {"key": "properties.computeRole", "type": "str"},
        "handler_schema": {"key": "properties.handlerSchema", "type": "str"},
        "vm_scale_set_enabled": {"key": "properties.vmScaleSetEnabled", "type": "bool"},
        "supports_multiple_extensions": {"key": "properties.supportsMultipleExtensions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        operating_system: Optional[str] = None,
        compute_role: Optional[str] = None,
        handler_schema: Optional[str] = None,
        vm_scale_set_enabled: Optional[bool] = None,
        supports_multiple_extensions: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword operating_system: The operating system this extension supports.
        :paramtype operating_system: str
        :keyword compute_role: The type of role (IaaS or PaaS) this extension supports.
        :paramtype compute_role: str
        :keyword handler_schema: The schema defined by publisher, where extension consumers should
         provide settings in a matching schema.
        :paramtype handler_schema: str
        :keyword vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
         existing extensions are usable on scalesets, but there might be cases where a publisher wants
         to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
        :paramtype vm_scale_set_enabled: bool
        :keyword supports_multiple_extensions: Whether the handler can support multiple extensions.
        :paramtype supports_multiple_extensions: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.operating_system = operating_system
        self.compute_role = compute_role
        self.handler_schema = handler_schema
        self.vm_scale_set_enabled = vm_scale_set_enabled
        self.supports_multiple_extensions = supports_multiple_extensions

class VirtualMachineExtensionInstanceView(_serialization.Model):
    """The instance view of a virtual machine extension.

    :ivar name: The virtual machine extension name.
    :vartype name: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar substatuses: The resource status information.
    :vartype substatuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "substatuses": {"key": "substatuses", "type": "[InstanceViewStatus]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        substatuses: Optional[List["_models.InstanceViewStatus"]] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The virtual machine extension name.
        :paramtype name: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword substatuses: The resource status information.
        :paramtype substatuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.type_handler_version = type_handler_version
        self.substatuses = substatuses
        self.statuses = statuses

class VirtualMachineExtensionUpdate(UpdateResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Extension.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.compute.models.KeyVaultSecretReference
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {
            "key": "properties.protectedSettingsFromKeyVault",
            "type": "KeyVaultSecretReference",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional["_models.KeyVaultSecretReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault:
         ~azure.mgmt.compute.models.KeyVaultSecretReference
        """
        super().__init__(tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault

class VirtualMachineImageResource(SubResource):
    """Virtual machine image resource information.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar location: The supported Azure location of the resource. Required.
    :vartype location: str
    :ivar tags: Specifies the tags that are assigned to the virtual machine. For more information
     about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the Virtual Machine.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword location: The supported Azure location of the resource. Required.
        :paramtype location: str
        :keyword tags: Specifies the tags that are assigned to the virtual machine. For more
         information about using tags, see `Using tags to organize your Azure resources
         <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the Virtual Machine.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.extended_location = extended_location

class VirtualMachineImage(VirtualMachineImageResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Image.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar location: The supported Azure location of the resource. Required.
    :vartype location: str
    :ivar tags: Specifies the tags that are assigned to the virtual machine. For more information
     about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the Virtual Machine.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar plan: Used for establishing the purchase context of any 3rd Party artifact through
     MarketPlace.
    :vartype plan: ~azure.mgmt.compute.models.PurchasePlan
    :ivar os_disk_image: Contains the os disk image information.
    :vartype os_disk_image: ~azure.mgmt.compute.models.OSDiskImage
    :ivar data_disk_images:
    :vartype data_disk_images: list[~azure.mgmt.compute.models.DataDiskImage]
    :ivar automatic_os_upgrade_properties: Describes automatic OS upgrade properties on the image.
    :vartype automatic_os_upgrade_properties:
     ~azure.mgmt.compute.models.AutomaticOSUpgradeProperties
    :ivar hyper_v_generation: Specifies the HyperVGeneration Type. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or
     ~azure.mgmt.compute.models.HyperVGenerationTypes
    :ivar disallowed: Specifies disallowed configuration for the VirtualMachine created from the
     image.
    :vartype disallowed: ~azure.mgmt.compute.models.DisallowedConfiguration
    :ivar features:
    :vartype features: list[~azure.mgmt.compute.models.VirtualMachineImageFeature]
    :ivar architecture: Specifies the Architecture Type. Known values are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.models.ArchitectureTypes
    :ivar image_deprecation_status: Describes image deprecation status properties on the image.
    :vartype image_deprecation_status:
     ~azure.mgmt.compute.models.ImageDeprecationStatus
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "plan": {"key": "properties.plan", "type": "PurchasePlan"},
        "os_disk_image": {"key": "properties.osDiskImage", "type": "OSDiskImage"},
        "data_disk_images": {"key": "properties.dataDiskImages", "type": "[DataDiskImage]"},
        "automatic_os_upgrade_properties": {
            "key": "properties.automaticOSUpgradeProperties",
            "type": "AutomaticOSUpgradeProperties",
        },
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "disallowed": {"key": "properties.disallowed", "type": "DisallowedConfiguration"},
        "features": {"key": "properties.features", "type": "[VirtualMachineImageFeature]"},
        "architecture": {"key": "properties.architecture", "type": "str"},
        "image_deprecation_status": {"key": "properties.imageDeprecationStatus", "type": "ImageDeprecationStatus"},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        plan: Optional["_models.PurchasePlan"] = None,
        os_disk_image: Optional["_models.OSDiskImage"] = None,
        data_disk_images: Optional[List["_models.DataDiskImage"]] = None,
        automatic_os_upgrade_properties: Optional["_models.AutomaticOSUpgradeProperties"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationTypes"]] = None,
        disallowed: Optional["_models.DisallowedConfiguration"] = None,
        features: Optional[List["_models.VirtualMachineImageFeature"]] = None,
        architecture: Optional[Union[str, "_models.ArchitectureTypes"]] = None,
        image_deprecation_status: Optional["_models.ImageDeprecationStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The name of the resource. Required.
        :paramtype name: str
        :keyword location: The supported Azure location of the resource. Required.
        :paramtype location: str
        :keyword tags: Specifies the tags that are assigned to the virtual machine. For more
         information about using tags, see `Using tags to organize your Azure resources
         <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the Virtual Machine.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        :keyword plan: Used for establishing the purchase context of any 3rd Party artifact through
         MarketPlace.
        :paramtype plan: ~azure.mgmt.compute.models.PurchasePlan
        :keyword os_disk_image: Contains the os disk image information.
        :paramtype os_disk_image: ~azure.mgmt.compute.models.OSDiskImage
        :keyword data_disk_images:
        :paramtype data_disk_images: list[~azure.mgmt.compute.models.DataDiskImage]
        :keyword automatic_os_upgrade_properties: Describes automatic OS upgrade properties on the
         image.
        :paramtype automatic_os_upgrade_properties:
         ~azure.mgmt.compute.models.AutomaticOSUpgradeProperties
        :keyword hyper_v_generation: Specifies the HyperVGeneration Type. Known values are: "V1" and
         "V2".
        :paramtype hyper_v_generation: str or
         ~azure.mgmt.compute.models.HyperVGenerationTypes
        :keyword disallowed: Specifies disallowed configuration for the VirtualMachine created from the
         image.
        :paramtype disallowed: ~azure.mgmt.compute.models.DisallowedConfiguration
        :keyword features:
        :paramtype features: list[~azure.mgmt.compute.models.VirtualMachineImageFeature]
        :keyword architecture: Specifies the Architecture Type. Known values are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.models.ArchitectureTypes
        :keyword image_deprecation_status: Describes image deprecation status properties on the image.
        :paramtype image_deprecation_status:
         ~azure.mgmt.compute.models.ImageDeprecationStatus
        """
        super().__init__(id=id, name=name, location=location, tags=tags, extended_location=extended_location, **kwargs)
        self.plan = plan
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images
        self.automatic_os_upgrade_properties = automatic_os_upgrade_properties
        self.hyper_v_generation = hyper_v_generation
        self.disallowed = disallowed
        self.features = features
        self.architecture = architecture
        self.image_deprecation_status = image_deprecation_status

class VirtualMachineInstanceView(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The instance view of a virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar platform_update_domain: Specifies the update domain of the virtual machine.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: Specifies the fault domain of the virtual machine.
    :vartype platform_fault_domain: int
    :ivar computer_name: The computer name assigned to the virtual machine.
    :vartype computer_name: str
    :ivar os_name: The Operating System running on the virtual machine.
    :vartype os_name: str
    :ivar os_version: The version of Operating System running on the virtual machine.
    :vartype os_version: str
    :ivar hyper_v_generation: Specifies the HyperVGeneration Type associated with a resource. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGenerationType
    :ivar rdp_thumb_print: The Remote desktop certificate thumbprint.
    :vartype rdp_thumb_print: str
    :ivar vm_agent: The VM Agent running on the virtual machine.
    :vartype vm_agent: ~azure.mgmt.compute.models.VirtualMachineAgentInstanceView
    :ivar maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :vartype maintenance_redeploy_status:
     ~azure.mgmt.compute.models.MaintenanceRedeployStatus
    :ivar disks: The virtual machine disk information.
    :vartype disks: list[~azure.mgmt.compute.models.DiskInstanceView]
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.models.VirtualMachineExtensionInstanceView]
    :ivar vm_health: The health status for the VM.
    :vartype vm_health: ~azure.mgmt.compute.models.VirtualMachineHealthStatus
    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.models.BootDiagnosticsInstanceView
    :ivar assigned_host: Resource id of the dedicated host, on which the virtual machine is
     allocated through automatic placement, when the virtual machine is associated with a dedicated
     host group that has automatic placement enabled. :code:`<br>`:code:`<br>`Minimum api-version:
     2020-06-01.
    :vartype assigned_host: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    :ivar patch_status: [Preview Feature] The status of virtual machine patch operations.
    :vartype patch_status: ~azure.mgmt.compute.models.VirtualMachinePatchStatus
    """

    _validation = {
        "vm_health": {"readonly": True},
        "assigned_host": {"readonly": True},
    }

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "computer_name": {"key": "computerName", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "os_version": {"key": "osVersion", "type": "str"},
        "hyper_v_generation": {"key": "hyperVGeneration", "type": "str"},
        "rdp_thumb_print": {"key": "rdpThumbPrint", "type": "str"},
        "vm_agent": {"key": "vmAgent", "type": "VirtualMachineAgentInstanceView"},
        "maintenance_redeploy_status": {"key": "maintenanceRedeployStatus", "type": "MaintenanceRedeployStatus"},
        "disks": {"key": "disks", "type": "[DiskInstanceView]"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineExtensionInstanceView]"},
        "vm_health": {"key": "vmHealth", "type": "VirtualMachineHealthStatus"},
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnosticsInstanceView"},
        "assigned_host": {"key": "assignedHost", "type": "str"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "patch_status": {"key": "patchStatus", "type": "VirtualMachinePatchStatus"},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        computer_name: Optional[str] = None,
        os_name: Optional[str] = None,
        os_version: Optional[str] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationType"]] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["_models.VirtualMachineAgentInstanceView"] = None,
        maintenance_redeploy_status: Optional["_models.MaintenanceRedeployStatus"] = None,
        disks: Optional[List["_models.DiskInstanceView"]] = None,
        extensions: Optional[List["_models.VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["_models.BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        patch_status: Optional["_models.VirtualMachinePatchStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword platform_update_domain: Specifies the update domain of the virtual machine.
        :paramtype platform_update_domain: int
        :keyword platform_fault_domain: Specifies the fault domain of the virtual machine.
        :paramtype platform_fault_domain: int
        :keyword computer_name: The computer name assigned to the virtual machine.
        :paramtype computer_name: str
        :keyword os_name: The Operating System running on the virtual machine.
        :paramtype os_name: str
        :keyword os_version: The version of Operating System running on the virtual machine.
        :paramtype os_version: str
        :keyword hyper_v_generation: Specifies the HyperVGeneration Type associated with a resource.
         Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or
         ~azure.mgmt.compute.models.HyperVGenerationType
        :keyword rdp_thumb_print: The Remote desktop certificate thumbprint.
        :paramtype rdp_thumb_print: str
        :keyword vm_agent: The VM Agent running on the virtual machine.
        :paramtype vm_agent: ~azure.mgmt.compute.models.VirtualMachineAgentInstanceView
        :keyword maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
        :paramtype maintenance_redeploy_status:
         ~azure.mgmt.compute.models.MaintenanceRedeployStatus
        :keyword disks: The virtual machine disk information.
        :paramtype disks: list[~azure.mgmt.compute.models.DiskInstanceView]
        :keyword extensions: The extensions information.
        :paramtype extensions:
         list[~azure.mgmt.compute.models.VirtualMachineExtensionInstanceView]
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
         view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.models.BootDiagnosticsInstanceView
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        :keyword patch_status: [Preview Feature] The status of virtual machine patch operations.
        :paramtype patch_status: ~azure.mgmt.compute.models.VirtualMachinePatchStatus
        """
        super().__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.computer_name = computer_name
        self.os_name = os_name
        self.os_version = os_version
        self.hyper_v_generation = hyper_v_generation
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.maintenance_redeploy_status = maintenance_redeploy_status
        self.disks = disks
        self.extensions = extensions
        self.vm_health = None
        self.boot_diagnostics = boot_diagnostics
        self.assigned_host = None
        self.statuses = statuses
        self.patch_status = patch_status

class VirtualMachineListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machines. Required.
    :vartype value: list[~azure.mgmt.compute.models.VirtualMachine]
    :ivar next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch
     the next page of Virtual Machines.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachine"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machines. Required.
        :paramtype value: list[~azure.mgmt.compute.models.VirtualMachine]
        :keyword next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to
         fetch the next page of Virtual Machines.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VirtualMachineScaleSet(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The virtual machine scale set sku.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.models.Plan
    :ivar identity: The identity of the virtual machine scale set, if configured.
    :vartype identity: ~azure.mgmt.compute.models.VirtualMachineScaleSetIdentity
    :ivar zones: The virtual machine scale set zones. NOTE: Availability zones can only be set when
     you create the scale set.
    :vartype zones: list[str]
    :ivar extended_location: The extended location of the Virtual Machine Scale Set.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar upgrade_policy: The upgrade policy.
    :vartype upgrade_policy: ~azure.mgmt.compute.models.UpgradePolicy
    :ivar automatic_repairs_policy: Policy for automatic repairs.
    :vartype automatic_repairs_policy:
     ~azure.mgmt.compute.models.AutomaticRepairsPolicy
    :ivar virtual_machine_profile: The virtual machine profile.
    :vartype virtual_machine_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetVMProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar overprovision: Specifies whether the Virtual Machine Scale Set should be overprovisioned.
    :vartype overprovision: bool
    :ivar do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled, extensions
     are launched only on the requested number of VMs which are finally kept. This property will
     hence ensure that the extensions do not run on the extra overprovisioned VMs.
    :vartype do_not_run_extensions_on_overprovisioned_v_ms: bool
    :ivar unique_id: Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
    :vartype unique_id: str
    :ivar single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to
     false. However, if singlePlacementGroup is false, it may not be modified to true.
    :vartype single_placement_group: bool
    :ivar zone_balance: Whether to force strictly even Virtual Machine distribution cross x-zones
     in case there is zone outage. zoneBalance property can only be set if the zones property of the
     scale set contains more than one zone. If there are no zones or only one zone specified, then
     zoneBalance property should not be set.
    :vartype zone_balance: bool
    :ivar platform_fault_domain_count: Fault Domain count for each placement group.
    :vartype platform_fault_domain_count: int
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum
     api-version: 2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
    :ivar host_group: Specifies information about the dedicated host group that the virtual machine
     scale set resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
    :vartype host_group: ~azure.mgmt.compute.models.SubResource
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
     have the capability to support attaching managed data disks with UltraSSD_LRS storage account
     type.
    :vartype additional_capabilities: ~azure.mgmt.compute.models.AdditionalCapabilities
    :ivar scale_in_policy: Specifies the policies applied when scaling in Virtual Machines in the
     Virtual Machine Scale Set.
    :vartype scale_in_policy: ~azure.mgmt.compute.models.ScaleInPolicy
    :ivar orchestration_mode: Specifies the orchestration mode for the virtual machine scale set.
     Known values are: "Uniform" and "Flexible".
    :vartype orchestration_mode: str or ~azure.mgmt.compute.models.OrchestrationMode
    :ivar spot_restore_policy: Specifies the Spot Restore properties for the virtual machine scale
     set.
    :vartype spot_restore_policy: ~azure.mgmt.compute.models.SpotRestorePolicy
    :ivar priority_mix_policy: Specifies the desired targets for mixing Spot and Regular priority
     VMs within the same VMSS Flex instance.
    :vartype priority_mix_policy: ~azure.mgmt.compute.models.PriorityMixPolicy
    :ivar time_created: Specifies the time at which the Virtual Machine Scale Set resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    :ivar constrained_maximum_capacity: Optional property which must either be set to True or
     omitted.
    :vartype constrained_maximum_capacity: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "unique_id": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "identity": {"key": "identity", "type": "VirtualMachineScaleSetIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "upgrade_policy": {"key": "properties.upgradePolicy", "type": "UpgradePolicy"},
        "automatic_repairs_policy": {"key": "properties.automaticRepairsPolicy", "type": "AutomaticRepairsPolicy"},
        "virtual_machine_profile": {
            "key": "properties.virtualMachineProfile",
            "type": "VirtualMachineScaleSetVMProfile",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "overprovision": {"key": "properties.overprovision", "type": "bool"},
        "do_not_run_extensions_on_overprovisioned_v_ms": {
            "key": "properties.doNotRunExtensionsOnOverprovisionedVMs",
            "type": "bool",
        },
        "unique_id": {"key": "properties.uniqueId", "type": "str"},
        "single_placement_group": {"key": "properties.singlePlacementGroup", "type": "bool"},
        "zone_balance": {"key": "properties.zoneBalance", "type": "bool"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "host_group": {"key": "properties.hostGroup", "type": "SubResource"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "scale_in_policy": {"key": "properties.scaleInPolicy", "type": "ScaleInPolicy"},
        "orchestration_mode": {"key": "properties.orchestrationMode", "type": "str"},
        "spot_restore_policy": {"key": "properties.spotRestorePolicy", "type": "SpotRestorePolicy"},
        "priority_mix_policy": {"key": "properties.priorityMixPolicy", "type": "PriorityMixPolicy"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "constrained_maximum_capacity": {"key": "properties.constrainedMaximumCapacity", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineScaleSetIdentity"] = None,
        zones: Optional[List[str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
        automatic_repairs_policy: Optional["_models.AutomaticRepairsPolicy"] = None,
        virtual_machine_profile: Optional["_models.VirtualMachineScaleSetVMProfile"] = None,
        overprovision: Optional[bool] = None,
        do_not_run_extensions_on_overprovisioned_v_ms: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        zone_balance: Optional[bool] = None,
        platform_fault_domain_count: Optional[int] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        host_group: Optional["_models.SubResource"] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        scale_in_policy: Optional["_models.ScaleInPolicy"] = None,
        orchestration_mode: Optional[Union[str, "_models.OrchestrationMode"]] = None,
        spot_restore_policy: Optional["_models.SpotRestorePolicy"] = None,
        priority_mix_policy: Optional["_models.PriorityMixPolicy"] = None,
        constrained_maximum_capacity: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The virtual machine scale set sku.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.models.Plan
        :keyword identity: The identity of the virtual machine scale set, if configured.
        :paramtype identity: ~azure.mgmt.compute.models.VirtualMachineScaleSetIdentity
        :keyword zones: The virtual machine scale set zones. NOTE: Availability zones can only be set
         when you create the scale set.
        :paramtype zones: list[str]
        :keyword extended_location: The extended location of the Virtual Machine Scale Set.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        :keyword upgrade_policy: The upgrade policy.
        :paramtype upgrade_policy: ~azure.mgmt.compute.models.UpgradePolicy
        :keyword automatic_repairs_policy: Policy for automatic repairs.
        :paramtype automatic_repairs_policy:
         ~azure.mgmt.compute.models.AutomaticRepairsPolicy
        :keyword virtual_machine_profile: The virtual machine profile.
        :paramtype virtual_machine_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetVMProfile
        :keyword overprovision: Specifies whether the Virtual Machine Scale Set should be
         overprovisioned.
        :paramtype overprovision: bool
        :keyword do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled,
         extensions are launched only on the requested number of VMs which are finally kept. This
         property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
        :paramtype do_not_run_extensions_on_overprovisioned_v_ms: bool
        :keyword single_placement_group: When true this limits the scale set to a single placement
         group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be
         modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
        :paramtype single_placement_group: bool
        :keyword zone_balance: Whether to force strictly even Virtual Machine distribution cross
         x-zones in case there is zone outage. zoneBalance property can only be set if the zones
         property of the scale set contains more than one zone. If there are no zones or only one zone
         specified, then zoneBalance property should not be set.
        :paramtype zone_balance: bool
        :keyword platform_fault_domain_count: Fault Domain count for each placement group.
        :paramtype platform_fault_domain_count: int
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum
         api-version: 2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
        :keyword host_group: Specifies information about the dedicated host group that the virtual
         machine scale set resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
        :paramtype host_group: ~azure.mgmt.compute.models.SubResource
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
         have the capability to support attaching managed data disks with UltraSSD_LRS storage account
         type.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.models.AdditionalCapabilities
        :keyword scale_in_policy: Specifies the policies applied when scaling in Virtual Machines in
         the Virtual Machine Scale Set.
        :paramtype scale_in_policy: ~azure.mgmt.compute.models.ScaleInPolicy
        :keyword orchestration_mode: Specifies the orchestration mode for the virtual machine scale
         set. Known values are: "Uniform" and "Flexible".
        :paramtype orchestration_mode: str or ~azure.mgmt.compute.models.OrchestrationMode
        :keyword spot_restore_policy: Specifies the Spot Restore properties for the virtual machine
         scale set.
        :paramtype spot_restore_policy: ~azure.mgmt.compute.models.SpotRestorePolicy
        :keyword priority_mix_policy: Specifies the desired targets for mixing Spot and Regular
         priority VMs within the same VMSS Flex instance.
        :paramtype priority_mix_policy: ~azure.mgmt.compute.models.PriorityMixPolicy
        :keyword constrained_maximum_capacity: Optional property which must either be set to True or
         omitted.
        :paramtype constrained_maximum_capacity: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.zones = zones
        self.extended_location = extended_location
        self.upgrade_policy = upgrade_policy
        self.automatic_repairs_policy = automatic_repairs_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.provisioning_state = None
        self.overprovision = overprovision
        self.do_not_run_extensions_on_overprovisioned_v_ms = do_not_run_extensions_on_overprovisioned_v_ms
        self.unique_id = None
        self.single_placement_group = single_placement_group
        self.zone_balance = zone_balance
        self.platform_fault_domain_count = platform_fault_domain_count
        self.proximity_placement_group = proximity_placement_group
        self.host_group = host_group
        self.additional_capabilities = additional_capabilities
        self.scale_in_policy = scale_in_policy
        self.orchestration_mode = orchestration_mode
        self.spot_restore_policy = spot_restore_policy
        self.priority_mix_policy = priority_mix_policy
        self.time_created = None
        self.constrained_maximum_capacity = constrained_maximum_capacity

class SubResourceReadOnly(_serialization.Model):
    """SubResourceReadOnly.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None

class VirtualMachineScaleSetExtension(SubResourceReadOnly):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :vartype provision_after_extensions: list[str]
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.compute.models.KeyVaultSecretReference
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "provision_after_extensions": {"key": "properties.provisionAfterExtensions", "type": "[str]"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {
            "key": "properties.protectedSettingsFromKeyVault",
            "type": "KeyVaultSecretReference",
        },
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        provision_after_extensions: Optional[List[str]] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional["_models.KeyVaultSecretReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extension.
        :paramtype name: str
        :keyword force_update_tag: If a value is provided and is different from the previous value, the
         extension handler will be forced to update even if the extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword provision_after_extensions: Collection of extension names after which this extension
         needs to be provisioned.
        :paramtype provision_after_extensions: list[str]
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault:
         ~azure.mgmt.compute.models.KeyVaultSecretReference
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.provision_after_extensions = provision_after_extensions
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault

class VirtualMachineScaleSetExtensionProfile(_serialization.Model):
    """Describes a virtual machine scale set extension profile.

    :ivar extensions: The virtual machine scale set child extension resources.
    :vartype extensions:
     list[~azure.mgmt.compute.models.VirtualMachineScaleSetExtension]
    :ivar extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :vartype extensions_time_budget: str
    """

    _attribute_map = {
        "extensions": {"key": "extensions", "type": "[VirtualMachineScaleSetExtension]"},
        "extensions_time_budget": {"key": "extensionsTimeBudget", "type": "str"},
    }

    def __init__(
        self,
        *,
        extensions: Optional[List["_models.VirtualMachineScaleSetExtension"]] = None,
        extensions_time_budget: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extensions: The virtual machine scale set child extension resources.
        :paramtype extensions:
         list[~azure.mgmt.compute.models.VirtualMachineScaleSetExtension]
        :keyword extensions_time_budget: Specifies the time alloted for all extensions to start. The
         time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified
         in ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
         api-version: 2020-06-01.
        :paramtype extensions_time_budget: str
        """
        super().__init__(**kwargs)
        self.extensions = extensions
        self.extensions_time_budget = extensions_time_budget

class VirtualMachineScaleSetIPConfiguration(_serialization.Model):
    """Describes a virtual machine scale set network profile's IP configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The IP configuration name. Required.
    :vartype name: str
    :ivar subnet: Specifies the identifier of the subnet.
    :vartype subnet: ~azure.mgmt.compute.models.ApiEntityReference
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar public_ip_address_configuration: The publicIPAddressConfiguration.
    :vartype public_ip_address_configuration:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetPublicIPAddressConfiguration
    :ivar private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.compute.models.IPVersion
    :ivar application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application gateways. A scale set can reference backend address pools of
     multiple application gateways. Multiple scale sets cannot use the same application gateway.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.models.SubResource]
    :ivar application_security_groups: Specifies an array of references to application security
     group.
    :vartype application_security_groups: list[~azure.mgmt.compute.models.SubResource]
    :ivar load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A scale set can reference backend address pools of one public and one
     internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.models.SubResource]
    :ivar load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools of
     the load balancers. A scale set can reference inbound nat pools of one public and one internal
     load balancer. Multiple scale sets cannot use the same basic sku load balancer.
    :vartype load_balancer_inbound_nat_pools:
     list[~azure.mgmt.compute.models.SubResource]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "ApiEntityReference"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address_configuration": {
            "key": "properties.publicIPAddressConfiguration",
            "type": "VirtualMachineScaleSetPublicIPAddressConfiguration",
        },
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[SubResource]",
        },
        "application_security_groups": {"key": "properties.applicationSecurityGroups", "type": "[SubResource]"},
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_inbound_nat_pools": {"key": "properties.loadBalancerInboundNatPools", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        name: str,
        subnet: Optional["_models.ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        application_security_groups: Optional[List["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The IP configuration name. Required.
        :paramtype name: str
        :keyword subnet: Specifies the identifier of the subnet.
        :paramtype subnet: ~azure.mgmt.compute.models.ApiEntityReference
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword public_ip_address_configuration: The publicIPAddressConfiguration.
        :paramtype public_ip_address_configuration:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetPublicIPAddressConfiguration
        :keyword private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.compute.models.IPVersion
        :keyword application_gateway_backend_address_pools: Specifies an array of references to backend
         address pools of application gateways. A scale set can reference backend address pools of
         multiple application gateways. Multiple scale sets cannot use the same application gateway.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.compute.models.SubResource]
        :keyword application_security_groups: Specifies an array of references to application security
         group.
        :paramtype application_security_groups:
         list[~azure.mgmt.compute.models.SubResource]
        :keyword load_balancer_backend_address_pools: Specifies an array of references to backend
         address pools of load balancers. A scale set can reference backend address pools of one public
         and one internal load balancer. Multiple scale sets cannot use the same basic sku load
         balancer.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.compute.models.SubResource]
        :keyword load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools
         of the load balancers. A scale set can reference inbound nat pools of one public and one
         internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
        :paramtype load_balancer_inbound_nat_pools:
         list[~azure.mgmt.compute.models.SubResource]
        """
        super().__init__(**kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.application_security_groups = application_security_groups
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools

class VirtualMachineScaleSetInstanceView(_serialization.Model):
    """The instance view of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machine: The instance view status summary for the virtual machine scale set.
    :vartype virtual_machine:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetInstanceViewStatusesSummary
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.models.VirtualMachineScaleSetVMExtensionsSummary]
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    :ivar orchestration_services: The orchestration services information.
    :vartype orchestration_services:
     list[~azure.mgmt.compute.models.OrchestrationServiceSummary]
    """

    _validation = {
        "virtual_machine": {"readonly": True},
        "extensions": {"readonly": True},
        "orchestration_services": {"readonly": True},
    }

    _attribute_map = {
        "virtual_machine": {"key": "virtualMachine", "type": "VirtualMachineScaleSetInstanceViewStatusesSummary"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineScaleSetVMExtensionsSummary]"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "orchestration_services": {"key": "orchestrationServices", "type": "[OrchestrationServiceSummary]"},
    }

    def __init__(self, *, statuses: Optional[List["_models.InstanceViewStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.virtual_machine = None
        self.extensions = None
        self.statuses = statuses
        self.orchestration_services = None

class VirtualMachineScaleSetInstanceViewStatusesSummary(_serialization.Model):
    """Instance view statuses summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "statuses_summary": {"key": "statusesSummary", "type": "[VirtualMachineStatusCodeCount]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.statuses_summary = None

class VirtualMachineScaleSetListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine scale sets. Required.
    :vartype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSet]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of VMSS.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine scale sets. Required.
        :paramtype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSet]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call
         ListNext() with this to fetch the next page of VMSS.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VirtualMachineScaleSetListSkusResult(_serialization.Model):
    """The Virtual Machine Scale Set List Skus operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of skus available for the virtual machine scale set. Required.
    :vartype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSetSku]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
     ListNext() with this to fetch the next page of VMSS Skus.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSetSku"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of skus available for the virtual machine scale set. Required.
        :paramtype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSetSku]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
         ListNext() with this to fetch the next page of VMSS Skus.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VirtualMachineScaleSetListWithLinkResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine scale sets. Required.
    :vartype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSet]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of Virtual Machine Scale Sets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine scale sets. Required.
        :paramtype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSet]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call
         ListNext() with this to fetch the next page of Virtual Machine Scale Sets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VirtualMachineScaleSetNetworkConfiguration(_serialization.Model):
    """Describes a virtual machine scale set network profile's network configurations.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The network configuration name. Required.
    :vartype name: str
    :ivar primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :vartype primary: bool
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar disable_tcp_state_tracking: Specifies whether the network interface is disabled for tcp
     state tracking.
    :vartype disable_tcp_state_tracking: bool
    :ivar enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :vartype enable_fpga: bool
    :ivar network_security_group: The network security group.
    :vartype network_security_group: ~azure.mgmt.compute.models.SubResource
    :ivar dns_settings: The dns settings to be applied on the network interfaces.
    :vartype dns_settings:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :ivar ip_configurations: Specifies the IP configurations of the network interface.
    :vartype ip_configurations:
     list[~azure.mgmt.compute.models.VirtualMachineScaleSetIPConfiguration]
    :ivar enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :vartype enable_ip_forwarding: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "enable_accelerated_networking": {"key": "properties.enableAcceleratedNetworking", "type": "bool"},
        "disable_tcp_state_tracking": {"key": "properties.disableTcpStateTracking", "type": "bool"},
        "enable_fpga": {"key": "properties.enableFpga", "type": "bool"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "SubResource"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetNetworkConfigurationDnsSettings",
        },
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[VirtualMachineScaleSetIPConfiguration]"},
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        disable_tcp_state_tracking: Optional[bool] = None,
        enable_fpga: Optional[bool] = None,
        network_security_group: Optional["_models.SubResource"] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        ip_configurations: Optional[List["_models.VirtualMachineScaleSetIPConfiguration"]] = None,
        enable_ip_forwarding: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The network configuration name. Required.
        :paramtype name: str
        :keyword primary: Specifies the primary network interface in case the virtual machine has more
         than 1 network interface.
        :paramtype primary: bool
        :keyword enable_accelerated_networking: Specifies whether the network interface is accelerated
         networking-enabled.
        :paramtype enable_accelerated_networking: bool
        :keyword disable_tcp_state_tracking: Specifies whether the network interface is disabled for
         tcp state tracking.
        :paramtype disable_tcp_state_tracking: bool
        :keyword enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
        :paramtype enable_fpga: bool
        :keyword network_security_group: The network security group.
        :paramtype network_security_group: ~azure.mgmt.compute.models.SubResource
        :keyword dns_settings: The dns settings to be applied on the network interfaces.
        :paramtype dns_settings:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
        :keyword ip_configurations: Specifies the IP configurations of the network interface.
        :paramtype ip_configurations:
         list[~azure.mgmt.compute.models.VirtualMachineScaleSetIPConfiguration]
        :keyword enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :paramtype enable_ip_forwarding: bool
        :keyword delete_option: Specify what happens to the network interface when the VM is deleted.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
        """
        super().__init__(**kwargs)
        self.name = name
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.disable_tcp_state_tracking = disable_tcp_state_tracking
        self.enable_fpga = enable_fpga
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.enable_ip_forwarding = enable_ip_forwarding
        self.delete_option = delete_option

class VirtualMachineScaleSetNetworkProfile(_serialization.Model):
    """Describes a virtual machine scale set network profile.

    :ivar health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
    :vartype health_probe: ~azure.mgmt.compute.models.ApiEntityReference
    :ivar network_interface_configurations: The list of network configurations.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.models.VirtualMachineScaleSetNetworkConfiguration]
    :ivar network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations for Virtual Machine Scale Set with
     orchestration mode 'Flexible'. "2020-11-01"
    :vartype network_api_version: str or ~azure.mgmt.compute.models.NetworkApiVersion
    """

    _attribute_map = {
        "health_probe": {"key": "healthProbe", "type": "ApiEntityReference"},
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineScaleSetNetworkConfiguration]",
        },
        "network_api_version": {"key": "networkApiVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        health_probe: Optional["_models.ApiEntityReference"] = None,
        network_interface_configurations: Optional[List["_models.VirtualMachineScaleSetNetworkConfiguration"]] = None,
        network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword health_probe: A reference to a load balancer probe used to determine the health of an
         instance in the virtual machine scale set. The reference will be in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        :paramtype health_probe: ~azure.mgmt.compute.models.ApiEntityReference
        :keyword network_interface_configurations: The list of network configurations.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.models.VirtualMachineScaleSetNetworkConfiguration]
        :keyword network_api_version: specifies the Microsoft.Network API version used when creating
         networking resources in the Network Interface Configurations for Virtual Machine Scale Set with
         orchestration mode 'Flexible'. "2020-11-01"
        :paramtype network_api_version: str or ~azure.mgmt.compute.models.NetworkApiVersion
        """
        super().__init__(**kwargs)
        self.health_probe = health_probe
        self.network_interface_configurations = network_interface_configurations
        self.network_api_version = network_api_version

class VirtualMachineScaleSetOSDisk(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes a virtual machine scale set operating system disk.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The disk name.
    :vartype name: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: Specifies how the virtual machines in the scale set should be
     created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \u2013 This value is
     used when you are using an image to create the virtual machine. If you are using a platform
     image, you also use the imageReference element described above. If you are using a marketplace
     image, you  also use the plan element previously described. Required. Known values are:
     "FromImage", "Empty", and "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
    :ivar diff_disk_settings: Specifies the ephemeral disk Settings for the operating system disk
     used by the virtual machine scale set.
    :vartype diff_disk_settings: ~azure.mgmt.compute.models.DiffDiskSettings
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than
     1023.
    :vartype disk_size_gb: int
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known
     values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar image: Specifies information about the unmanaged user image to base the scale set on.
    :vartype image: ~azure.mgmt.compute.models.VirtualHardDisk
    :ivar vhd_containers: Specifies the container urls that are used to store operating system
     disks for the scale set.
    :vartype vhd_containers: list[str]
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetManagedDiskParameters
    :ivar delete_option: Specifies whether OS Disk should be deleted or detached upon VMSS Flex
     deletion (This feature is available for VMSS with Flexible OrchestrationMode only).
     :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this value is
     used, the OS disk is deleted when VMSS Flex VM is deleted.:code:`<br>`:code:`<br>` **Detach**
     If this value is used, the OS disk is retained after VMSS Flex VM is deleted.
     :code:`<br>`:code:`<br>` The default value is set to **Delete**. For an Ephemeral OS Disk, the
     default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
    """

    _validation = {
        "create_option": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "diff_disk_settings": {"key": "diffDiskSettings", "type": "DiffDiskSettings"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "vhd_containers": {"key": "vhdContainers", "type": "[str]"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
        "delete_option": {"key": "deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        diff_disk_settings: Optional["_models.DiffDiskSettings"] = None,
        disk_size_gb: Optional[int] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: Specifies how the virtual machines in the scale set should be
         created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \u2013 This value is
         used when you are using an image to create the virtual machine. If you are using a platform
         image, you also use the imageReference element described above. If you are using a marketplace
         image, you  also use the plan element previously described. Required. Known values are:
         "FromImage", "Empty", and "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
        :keyword diff_disk_settings: Specifies the ephemeral disk Settings for the operating system
         disk used by the virtual machine scale set.
        :paramtype diff_disk_settings: ~azure.mgmt.compute.models.DiffDiskSettings
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than
         1023.
        :paramtype disk_size_gb: int
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>`
         Possible values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**.
         Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword image: Specifies information about the unmanaged user image to base the scale set on.
        :paramtype image: ~azure.mgmt.compute.models.VirtualHardDisk
        :keyword vhd_containers: Specifies the container urls that are used to store operating system
         disks for the scale set.
        :paramtype vhd_containers: list[str]
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetManagedDiskParameters
        :keyword delete_option: Specifies whether OS Disk should be deleted or detached upon VMSS Flex
         deletion (This feature is available for VMSS with Flexible OrchestrationMode only).
         :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this value is
         used, the OS disk is deleted when VMSS Flex VM is deleted.:code:`<br>`:code:`<br>` **Detach**
         If this value is used, the OS disk is retained after VMSS Flex VM is deleted.
         :code:`<br>`:code:`<br>` The default value is set to **Delete**. For an Ephemeral OS Disk, the
         default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.diff_disk_settings = diff_disk_settings
        self.disk_size_gb = disk_size_gb
        self.os_type = os_type
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk
        self.delete_option = delete_option

class VirtualMachineScaleSetOSProfile(_serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :ivar computer_name_prefix: Specifies the computer name prefix for all of the virtual machines
     in the scale set. Computer name prefixes must be 1 to 15 characters long.
    :vartype computer_name_prefix: str
    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **Windows-only restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character
     :code:`<br>`:code:`<br>` **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>`
     **Max-length (Windows):** 20 characters.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :vartype admin_password: str
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
    :vartype custom_data: str
    :ivar windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :vartype windows_configuration: ~azure.mgmt.compute.models.WindowsConfiguration
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
    :vartype linux_configuration: ~azure.mgmt.compute.models.LinuxConfiguration
    :ivar secrets: Specifies set of certificates that should be installed onto the virtual machines
     in the scale set. To install certificates on a virtual machine it is recommended to use the
     `Azure Key Vault virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype secrets: list[~azure.mgmt.compute.models.VaultSecretGroup]
    :ivar allow_extension_operations: Specifies whether extension operations should be allowed on
     the virtual machine scale set. :code:`<br>`:code:`<br>`This may only be set to False when no
     extensions are present on the virtual machine scale set.
    :vartype allow_extension_operations: bool
    :ivar require_guest_provision_signal: Optional property which must either be set to True or
     omitted.
    :vartype require_guest_provision_signal: bool
    """

    _attribute_map = {
        "computer_name_prefix": {"key": "computerNamePrefix", "type": "str"},
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
        "allow_extension_operations": {"key": "allowExtensionOperations", "type": "bool"},
        "require_guest_provision_signal": {"key": "requireGuestProvisionSignal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        computer_name_prefix: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        allow_extension_operations: Optional[bool] = None,
        require_guest_provision_signal: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword computer_name_prefix: Specifies the computer name prefix for all of the virtual
         machines in the scale set. Computer name prefixes must be 1 to 15 characters long.
        :paramtype computer_name_prefix: str
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
         :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
         "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
         "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
         "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
         :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
         characters.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
         **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
         characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
         :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
         fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
         digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
         **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
         "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
         resetting the password, see `How to reset the Remote Desktop service or its login password in a
         Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
         :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
         repair disks on Azure Linux VMs using the VMAccess Extension
         <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
        :paramtype admin_password: str
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
         length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
         your VM, see `Using cloud-init to customize a Linux VM during creation
         <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
        :paramtype custom_data: str
        :keyword windows_configuration: Specifies Windows operating system settings on the virtual
         machine.
        :paramtype windows_configuration: ~azure.mgmt.compute.models.WindowsConfiguration
        :keyword linux_configuration: Specifies the Linux operating system settings on the virtual
         machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
         Azure-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
        :paramtype linux_configuration: ~azure.mgmt.compute.models.LinuxConfiguration
        :keyword secrets: Specifies set of certificates that should be installed onto the virtual
         machines in the scale set. To install certificates on a virtual machine it is recommended to
         use the `Azure Key Vault virtual machine extension for Linux
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
         Key Vault virtual machine extension for Windows
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
        :paramtype secrets: list[~azure.mgmt.compute.models.VaultSecretGroup]
        :keyword allow_extension_operations: Specifies whether extension operations should be allowed
         on the virtual machine scale set. :code:`<br>`:code:`<br>`This may only be set to False when no
         extensions are present on the virtual machine scale set.
        :paramtype allow_extension_operations: bool
        :keyword require_guest_provision_signal: Optional property which must either be set to True or
         omitted.
        :paramtype require_guest_provision_signal: bool
        """
        super().__init__(**kwargs)
        self.computer_name_prefix = computer_name_prefix
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets
        self.allow_extension_operations = allow_extension_operations
        self.require_guest_provision_signal = require_guest_provision_signal

class VirtualMachineScaleSetSku(_serialization.Model):
    """Describes an available virtual machine scale set sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the sku applies to.
    :vartype resource_type: str
    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: ~azure.mgmt.compute.models.VirtualMachineScaleSetSkuCapacity
    """

    _validation = {
        "resource_type": {"readonly": True},
        "sku": {"readonly": True},
        "capacity": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "capacity": {"key": "capacity", "type": "VirtualMachineScaleSetSkuCapacity"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None

class VirtualMachineScaleSetSkuCapacity(_serialization.Model):
    """Describes scaling information of a sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default_capacity: The default capacity.
    :vartype default_capacity: int
    :ivar scale_type: The scale type applicable to the sku. Known values are: "Automatic" and
     "None".
    :vartype scale_type: str or
     ~azure.mgmt.compute.models.VirtualMachineScaleSetSkuScaleType
    """

    _validation = {
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "default_capacity": {"readonly": True},
        "scale_type": {"readonly": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default_capacity": {"key": "defaultCapacity", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default_capacity = None
        self.scale_type = None

class VirtualMachineScaleSetStorageProfile(_serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :ivar image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :vartype image_reference: ~azure.mgmt.compute.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype os_disk: ~azure.mgmt.compute.models.VirtualMachineScaleSetOSDisk
    :ivar data_disks: Specifies the parameters that are used to add data disks to the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype data_disks:
     list[~azure.mgmt.compute.models.VirtualMachineScaleSetDataDisk]
    :ivar disk_controller_type:
    :vartype disk_controller_type: str
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "VirtualMachineScaleSetOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[VirtualMachineScaleSetDataDisk]"},
        "disk_controller_type": {"key": "diskControllerType", "type": "str"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.VirtualMachineScaleSetOSDisk"] = None,
        data_disks: Optional[List["_models.VirtualMachineScaleSetDataDisk"]] = None,
        disk_controller_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: Specifies information about the image to use. You can specify
         information about platform images, marketplace images, or virtual machine images. This element
         is required when you want to use a platform image, marketplace image, or virtual machine image,
         but is not used in other creation operations.
        :paramtype image_reference: ~azure.mgmt.compute.models.ImageReference
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
         `About disks and VHDs for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype os_disk: ~azure.mgmt.compute.models.VirtualMachineScaleSetOSDisk
        :keyword data_disks: Specifies the parameters that are used to add data disks to the virtual
         machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
         `About disks and VHDs for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype data_disks:
         list[~azure.mgmt.compute.models.VirtualMachineScaleSetDataDisk]
        :keyword disk_controller_type:
        :paramtype disk_controller_type: str
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.disk_controller_type = disk_controller_type

class VirtualMachineScaleSetVM(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a virtual machine scale set virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar instance_id: The virtual machine instance ID.
    :vartype instance_id: str
    :ivar sku: The virtual machine SKU.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.models.VirtualMachineExtension]
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar identity: The identity of the virtual machine, if configured.
    :vartype identity: ~azure.mgmt.compute.models.VirtualMachineIdentity
    :ivar latest_model_applied: Specifies whether the latest model has been applied to the virtual
     machine.
    :vartype latest_model_applied: bool
    :ivar vm_id: Azure VM unique ID.
    :vartype vm_id: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetVMInstanceView
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.models.StorageProfile
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine in the scale set. For instance: whether the virtual machine has the capability
     to support attaching managed data disks with UltraSSD_LRS storage account type.
    :vartype additional_capabilities: ~azure.mgmt.compute.models.AdditionalCapabilities
    :ivar os_profile: Specifies the operating system settings for the virtual machine.
    :vartype os_profile: ~azure.mgmt.compute.models.OSProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :vartype security_profile: ~azure.mgmt.compute.models.SecurityProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.models.NetworkProfile
    :ivar network_profile_configuration: Specifies the network profile configuration of the virtual
     machine.
    :vartype network_profile_configuration:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetVMNetworkProfileConfiguration
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Availability sets overview
     <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
     and updates for Virtual Machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :vartype availability_set: ~azure.mgmt.compute.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar model_definition_applied: Specifies whether the model applied to the virtual machine is
     the model of the virtual machine scale set or the customized model for the virtual machine.
    :vartype model_definition_applied: str
    :ivar protection_policy: Specifies the protection policy of the virtual machine.
    :vartype protection_policy:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetVMProtectionPolicy
    :ivar user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :vartype user_data: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "instance_id": {"readonly": True},
        "sku": {"readonly": True},
        "resources": {"readonly": True},
        "zones": {"readonly": True},
        "latest_model_applied": {"readonly": True},
        "vm_id": {"readonly": True},
        "instance_view": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "model_definition_applied": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "instance_id": {"key": "instanceId", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "resources": {"key": "resources", "type": "[VirtualMachineExtension]"},
        "zones": {"key": "zones", "type": "[str]"},
        "identity": {"key": "identity", "type": "VirtualMachineIdentity"},
        "latest_model_applied": {"key": "properties.latestModelApplied", "type": "bool"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineScaleSetVMInstanceView"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "security_profile": {"key": "properties.securityProfile", "type": "SecurityProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "network_profile_configuration": {
            "key": "properties.networkProfileConfiguration",
            "type": "VirtualMachineScaleSetVMNetworkProfileConfiguration",
        },
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "model_definition_applied": {"key": "properties.modelDefinitionApplied", "type": "str"},
        "protection_policy": {"key": "properties.protectionPolicy", "type": "VirtualMachineScaleSetVMProtectionPolicy"},
        "user_data": {"key": "properties.userData", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineIdentity"] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        network_profile_configuration: Optional["_models.VirtualMachineScaleSetVMNetworkProfileConfiguration"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        protection_policy: Optional["_models.VirtualMachineScaleSetVMProtectionPolicy"] = None,
        user_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.models.Plan
        :keyword identity: The identity of the virtual machine, if configured.
        :paramtype identity: ~azure.mgmt.compute.models.VirtualMachineIdentity
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.models.StorageProfile
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         virtual machine in the scale set. For instance: whether the virtual machine has the capability
         to support attaching managed data disks with UltraSSD_LRS storage account type.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.models.AdditionalCapabilities
        :keyword os_profile: Specifies the operating system settings for the virtual machine.
        :paramtype os_profile: ~azure.mgmt.compute.models.OSProfile
        :keyword security_profile: Specifies the Security related profile settings for the virtual
         machine.
        :paramtype security_profile: ~azure.mgmt.compute.models.SecurityProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.models.NetworkProfile
        :keyword network_profile_configuration: Specifies the network profile configuration of the
         virtual machine.
        :paramtype network_profile_configuration:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetVMNetworkProfileConfiguration
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Availability sets overview
         <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
         and updates for Virtual Machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. An existing VM cannot be added to an availability set.
        :paramtype availability_set: ~azure.mgmt.compute.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
         :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
         :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
         :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
         :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
         <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        :keyword protection_policy: Specifies the protection policy of the virtual machine.
        :paramtype protection_policy:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetVMProtectionPolicy
        :keyword user_data: UserData for the VM, which must be base-64 encoded. Customer should not
         pass any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
        :paramtype user_data: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.instance_id = None
        self.sku = None
        self.plan = plan
        self.resources = None
        self.zones = None
        self.identity = identity
        self.latest_model_applied = None
        self.vm_id = None
        self.instance_view = None
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.additional_capabilities = additional_capabilities
        self.os_profile = os_profile
        self.security_profile = security_profile
        self.network_profile = network_profile
        self.network_profile_configuration = network_profile_configuration
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.provisioning_state = None
        self.license_type = license_type
        self.model_definition_applied = None
        self.protection_policy = protection_policy
        self.user_data = user_data

class VirtualMachineScaleSetVMExtensionsSummary(_serialization.Model):
    """Extensions summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The extension name.
    :vartype name: str
    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        "name": {"readonly": True},
        "statuses_summary": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "statuses_summary": {"key": "statusesSummary", "type": "[VirtualMachineStatusCodeCount]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.statuses_summary = None

class VirtualMachineScaleSetVMInstanceIDs(_serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    :ivar instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :vartype instance_ids: list[str]
    """

    _attribute_map = {
        "instance_ids": {"key": "instanceIds", "type": "[str]"},
    }

    def __init__(self, *, instance_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
         scale set instance ids will result in the operation being performed on all virtual machines in
         the virtual machine scale set.
        :paramtype instance_ids: list[str]
        """
        super().__init__(**kwargs)
        self.instance_ids = instance_ids

class VirtualMachineScaleSetVMInstanceRequiredIDs(_serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    All required parameters must be populated in order to send to Azure.

    :ivar instance_ids: The virtual machine scale set instance ids. Required.
    :vartype instance_ids: list[str]
    """

    _validation = {
        "instance_ids": {"required": True},
    }

    _attribute_map = {
        "instance_ids": {"key": "instanceIds", "type": "[str]"},
    }

    def __init__(self, *, instance_ids: List[str], **kwargs: Any) -> None:
        """
        :keyword instance_ids: The virtual machine scale set instance ids. Required.
        :paramtype instance_ids: list[str]
        """
        super().__init__(**kwargs)
        self.instance_ids = instance_ids

class VirtualMachineScaleSetVMInstanceView(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The instance view of a virtual machine scale set VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar platform_update_domain: The Update Domain count.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: The Fault Domain count.
    :vartype platform_fault_domain: int
    :ivar rdp_thumb_print: The Remote desktop certificate thumbprint.
    :vartype rdp_thumb_print: str
    :ivar vm_agent: The VM Agent running on the virtual machine.
    :vartype vm_agent: ~azure.mgmt.compute.models.VirtualMachineAgentInstanceView
    :ivar maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :vartype maintenance_redeploy_status:
     ~azure.mgmt.compute.models.MaintenanceRedeployStatus
    :ivar disks: The disks information.
    :vartype disks: list[~azure.mgmt.compute.models.DiskInstanceView]
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.models.VirtualMachineExtensionInstanceView]
    :ivar vm_health: The health status for the VM.
    :vartype vm_health: ~azure.mgmt.compute.models.VirtualMachineHealthStatus
    :ivar boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :vartype boot_diagnostics: ~azure.mgmt.compute.models.BootDiagnosticsInstanceView
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    :ivar assigned_host: Resource id of the dedicated host, on which the virtual machine is
     allocated through automatic placement, when the virtual machine is associated with a dedicated
     host group that has automatic placement enabled. :code:`<br>`:code:`<br>`Minimum api-version:
     2020-06-01.
    :vartype assigned_host: str
    :ivar placement_group_id: The placement group in which the VM is running. If the VM is
     deallocated it will not have a placementGroupId.
    :vartype placement_group_id: str
    :ivar computer_name: Specifies the host OS name of the virtual machine.
     :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
     :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
     restrictions see `Azure infrastructure services implementation guidelines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions>`_.
    :vartype computer_name: str
    :ivar os_name: The Operating System running on the hybrid machine.
    :vartype os_name: str
    :ivar os_version: The version of Operating System running on the hybrid machine.
    :vartype os_version: str
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    """

    _validation = {
        "vm_health": {"readonly": True},
        "assigned_host": {"readonly": True},
    }

    _attribute_map = {
        "platform_update_domain": {"key": "platformUpdateDomain", "type": "int"},
        "platform_fault_domain": {"key": "platformFaultDomain", "type": "int"},
        "rdp_thumb_print": {"key": "rdpThumbPrint", "type": "str"},
        "vm_agent": {"key": "vmAgent", "type": "VirtualMachineAgentInstanceView"},
        "maintenance_redeploy_status": {"key": "maintenanceRedeployStatus", "type": "MaintenanceRedeployStatus"},
        "disks": {"key": "disks", "type": "[DiskInstanceView]"},
        "extensions": {"key": "extensions", "type": "[VirtualMachineExtensionInstanceView]"},
        "vm_health": {"key": "vmHealth", "type": "VirtualMachineHealthStatus"},
        "boot_diagnostics": {"key": "bootDiagnostics", "type": "BootDiagnosticsInstanceView"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "assigned_host": {"key": "assignedHost", "type": "str"},
        "placement_group_id": {"key": "placementGroupId", "type": "str"},
        "computer_name": {"key": "computerName", "type": "str"},
        "os_name": {"key": "osName", "type": "str"},
        "os_version": {"key": "osVersion", "type": "str"},
        "hyper_v_generation": {"key": "hyperVGeneration", "type": "str"},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["_models.VirtualMachineAgentInstanceView"] = None,
        maintenance_redeploy_status: Optional["_models.MaintenanceRedeployStatus"] = None,
        disks: Optional[List["_models.DiskInstanceView"]] = None,
        extensions: Optional[List["_models.VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["_models.BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        placement_group_id: Optional[str] = None,
        computer_name: Optional[str] = None,
        os_name: Optional[str] = None,
        os_version: Optional[str] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword platform_update_domain: The Update Domain count.
        :paramtype platform_update_domain: int
        :keyword platform_fault_domain: The Fault Domain count.
        :paramtype platform_fault_domain: int
        :keyword rdp_thumb_print: The Remote desktop certificate thumbprint.
        :paramtype rdp_thumb_print: str
        :keyword vm_agent: The VM Agent running on the virtual machine.
        :paramtype vm_agent: ~azure.mgmt.compute.models.VirtualMachineAgentInstanceView
        :keyword maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
        :paramtype maintenance_redeploy_status:
         ~azure.mgmt.compute.models.MaintenanceRedeployStatus
        :keyword disks: The disks information.
        :paramtype disks: list[~azure.mgmt.compute.models.DiskInstanceView]
        :keyword extensions: The extensions information.
        :paramtype extensions:
         list[~azure.mgmt.compute.models.VirtualMachineExtensionInstanceView]
        :keyword boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
         Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
         view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
         screenshot of the VM from the hypervisor.
        :paramtype boot_diagnostics: ~azure.mgmt.compute.models.BootDiagnosticsInstanceView
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        :keyword placement_group_id: The placement group in which the VM is running. If the VM is
         deallocated it will not have a placementGroupId.
        :paramtype placement_group_id: str
        :keyword computer_name: Specifies the host OS name of the virtual machine.
         :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
         :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
         restrictions see `Azure infrastructure services implementation guidelines
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-conventions>`_.
        :paramtype computer_name: str
        :keyword os_name: The Operating System running on the hybrid machine.
        :paramtype os_name: str
        :keyword os_version: The version of Operating System running on the hybrid machine.
        :paramtype os_version: str
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine [V1, V2]. Known
         values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        """
        super().__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.maintenance_redeploy_status = maintenance_redeploy_status
        self.disks = disks
        self.extensions = extensions
        self.vm_health = None
        self.boot_diagnostics = boot_diagnostics
        self.statuses = statuses
        self.assigned_host = None
        self.placement_group_id = placement_group_id
        self.computer_name = computer_name
        self.os_name = os_name
        self.os_version = os_version
        self.hyper_v_generation = hyper_v_generation

class VirtualMachineScaleSetVMListResult(_serialization.Model):
    """The List Virtual Machine Scale Set VMs operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine scale sets VMs. Required.
    :vartype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSetVM]
    :ivar next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
     ListNext() with this to fetch the next page of VMSS VMs.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetVM]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSetVM"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine scale sets VMs. Required.
        :paramtype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSetVM]
        :keyword next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
         ListNext() with this to fetch the next page of VMSS VMs.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VirtualMachineScaleSetVMProfile(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes a virtual machine scale set virtual machine profile.

    :ivar os_profile: Specifies the operating system settings for the virtual machines in the scale
     set.
    :vartype os_profile: ~azure.mgmt.compute.models.VirtualMachineScaleSetOSProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetStorageProfile
    :ivar network_profile: Specifies properties of the network interfaces of the virtual machines
     in the scale set.
    :vartype network_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetNetworkProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machines in the scale set.
    :vartype security_profile: ~azure.mgmt.compute.models.SecurityProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
    :ivar extension_profile: Specifies a collection of settings for extensions installed on virtual
     machines in the scale set.
    :vartype extension_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetExtensionProfile
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar priority: Specifies the priority for the virtual machines in the scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Known values are: "Regular",
     "Low", and "Spot".
    :vartype priority: str or ~azure.mgmt.compute.models.VirtualMachinePriorityTypes
    :ivar eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
    :vartype eviction_policy: str or
     ~azure.mgmt.compute.models.VirtualMachineEvictionPolicyTypes
    :ivar billing_profile: Specifies the billing related details of a Azure Spot VMSS.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :vartype billing_profile: ~azure.mgmt.compute.models.BillingProfile
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile:
     ~azure.mgmt.compute.models.ScheduledEventsProfile
    :ivar user_data: UserData for the virtual machines in the scale set, which must be base-64
     encoded. Customer should not pass any secrets in here. :code:`<br>`:code:`<br>`Minimum
     api-version: 2021-03-01.
    :vartype user_data: str
    :ivar capacity_reservation: Specifies the capacity reservation related details of a scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
    :vartype capacity_reservation:
     ~azure.mgmt.compute.models.CapacityReservationProfile
    :ivar application_profile: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype application_profile: ~azure.mgmt.compute.models.ApplicationProfile
    :ivar hardware_profile: Specifies the hardware profile related details of a scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype hardware_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetHardwareProfile
    :ivar service_artifact_reference: Specifies the service artifact reference id used to set same
     image version for all virtual machines in the scale set when using 'latest' image version.
     Minimum api-version: 2022-11-01.
    :vartype service_artifact_reference:
     ~azure.mgmt.compute.models.ServiceArtifactReference
    """

    _attribute_map = {
        "os_profile": {"key": "osProfile", "type": "VirtualMachineScaleSetOSProfile"},
        "storage_profile": {"key": "storageProfile", "type": "VirtualMachineScaleSetStorageProfile"},
        "network_profile": {"key": "networkProfile", "type": "VirtualMachineScaleSetNetworkProfile"},
        "security_profile": {"key": "securityProfile", "type": "SecurityProfile"},
        "diagnostics_profile": {"key": "diagnosticsProfile", "type": "DiagnosticsProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "VirtualMachineScaleSetExtensionProfile"},
        "license_type": {"key": "licenseType", "type": "str"},
        "priority": {"key": "priority", "type": "str"},
        "eviction_policy": {"key": "evictionPolicy", "type": "str"},
        "billing_profile": {"key": "billingProfile", "type": "BillingProfile"},
        "scheduled_events_profile": {"key": "scheduledEventsProfile", "type": "ScheduledEventsProfile"},
        "user_data": {"key": "userData", "type": "str"},
        "capacity_reservation": {"key": "capacityReservation", "type": "CapacityReservationProfile"},
        "application_profile": {"key": "applicationProfile", "type": "ApplicationProfile"},
        "hardware_profile": {"key": "hardwareProfile", "type": "VirtualMachineScaleSetHardwareProfile"},
        "service_artifact_reference": {"key": "serviceArtifactReference", "type": "ServiceArtifactReference"},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["_models.VirtualMachineScaleSetOSProfile"] = None,
        storage_profile: Optional["_models.VirtualMachineScaleSetStorageProfile"] = None,
        network_profile: Optional["_models.VirtualMachineScaleSetNetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        extension_profile: Optional["_models.VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        priority: Optional[Union[str, "_models.VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "_models.VirtualMachineEvictionPolicyTypes"]] = None,
        billing_profile: Optional["_models.BillingProfile"] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["_models.CapacityReservationProfile"] = None,
        application_profile: Optional["_models.ApplicationProfile"] = None,
        hardware_profile: Optional["_models.VirtualMachineScaleSetHardwareProfile"] = None,
        service_artifact_reference: Optional["_models.ServiceArtifactReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_profile: Specifies the operating system settings for the virtual machines in the
         scale set.
        :paramtype os_profile: ~azure.mgmt.compute.models.VirtualMachineScaleSetOSProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetStorageProfile
        :keyword network_profile: Specifies properties of the network interfaces of the virtual
         machines in the scale set.
        :paramtype network_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetNetworkProfile
        :keyword security_profile: Specifies the Security related profile settings for the virtual
         machines in the scale set.
        :paramtype security_profile: ~azure.mgmt.compute.models.SecurityProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
        :keyword extension_profile: Specifies a collection of settings for extensions installed on
         virtual machines in the scale set.
        :paramtype extension_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetExtensionProfile
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
         :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
         :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
         :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
         :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
         <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        :keyword priority: Specifies the priority for the virtual machines in the scale set.
         :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Known values are: "Regular",
         "Low", and "Spot".
        :paramtype priority: str or ~azure.mgmt.compute.models.VirtualMachinePriorityTypes
        :keyword eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
         Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
         'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
         :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
         and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
        :paramtype eviction_policy: str or
         ~azure.mgmt.compute.models.VirtualMachineEvictionPolicyTypes
        :keyword billing_profile: Specifies the billing related details of a Azure Spot VMSS.
         :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype billing_profile: ~azure.mgmt.compute.models.BillingProfile
        :keyword scheduled_events_profile: Specifies Scheduled Event related configurations.
        :paramtype scheduled_events_profile:
         ~azure.mgmt.compute.models.ScheduledEventsProfile
        :keyword user_data: UserData for the virtual machines in the scale set, which must be base-64
         encoded. Customer should not pass any secrets in here. :code:`<br>`:code:`<br>`Minimum
         api-version: 2021-03-01.
        :paramtype user_data: str
        :keyword capacity_reservation: Specifies the capacity reservation related details of a scale
         set. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
        :paramtype capacity_reservation:
         ~azure.mgmt.compute.models.CapacityReservationProfile
        :keyword application_profile: Specifies the gallery applications that should be made available
         to the VM/VMSS.
        :paramtype application_profile: ~azure.mgmt.compute.models.ApplicationProfile
        :keyword hardware_profile: Specifies the hardware profile related details of a scale set.
         :code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
        :paramtype hardware_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetHardwareProfile
        :keyword service_artifact_reference: Specifies the service artifact reference id used to set
         same image version for all virtual machines in the scale set when using 'latest' image version.
         Minimum api-version: 2022-11-01.
        :paramtype service_artifact_reference:
         ~azure.mgmt.compute.models.ServiceArtifactReference
        """
        super().__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.extension_profile = extension_profile
        self.license_type = license_type
        self.priority = priority
        self.eviction_policy = eviction_policy
        self.billing_profile = billing_profile
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data
        self.capacity_reservation = capacity_reservation
        self.application_profile = application_profile
        self.hardware_profile = hardware_profile
        self.service_artifact_reference = service_artifact_reference

class VirtualMachineSize(_serialization.Model):
    """Describes the properties of a VM size.

    :ivar name: The name of the virtual machine size.
    :vartype name: str
    :ivar number_of_cores: The number of cores supported by the virtual machine size. For
     Constrained vCPU capable VM sizes, this number represents the total vCPUs of quota that the VM
     uses. For accurate vCPU count, please refer to
     https://docs.microsoft.com/azure/virtual-machines/constrained-vcpu or
     https://docs.microsoft.com/rest/api/compute/resourceskus/list.
    :vartype number_of_cores: int
    :ivar os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
    :vartype os_disk_size_in_mb: int
    :ivar resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual machine
     size.
    :vartype resource_disk_size_in_mb: int
    :ivar memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
    :vartype memory_in_mb: int
    :ivar max_data_disk_count: The maximum number of data disks that can be attached to the virtual
     machine size.
    :vartype max_data_disk_count: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "number_of_cores": {"key": "numberOfCores", "type": "int"},
        "os_disk_size_in_mb": {"key": "osDiskSizeInMB", "type": "int"},
        "resource_disk_size_in_mb": {"key": "resourceDiskSizeInMB", "type": "int"},
        "memory_in_mb": {"key": "memoryInMB", "type": "int"},
        "max_data_disk_count": {"key": "maxDataDiskCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        number_of_cores: Optional[int] = None,
        os_disk_size_in_mb: Optional[int] = None,
        resource_disk_size_in_mb: Optional[int] = None,
        memory_in_mb: Optional[int] = None,
        max_data_disk_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the virtual machine size.
        :paramtype name: str
        :keyword number_of_cores: The number of cores supported by the virtual machine size. For
         Constrained vCPU capable VM sizes, this number represents the total vCPUs of quota that the VM
         uses. For accurate vCPU count, please refer to
         https://docs.microsoft.com/azure/virtual-machines/constrained-vcpu or
         https://docs.microsoft.com/rest/api/compute/resourceskus/list.
        :paramtype number_of_cores: int
        :keyword os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
        :paramtype os_disk_size_in_mb: int
        :keyword resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual
         machine size.
        :paramtype resource_disk_size_in_mb: int
        :keyword memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
        :paramtype memory_in_mb: int
        :keyword max_data_disk_count: The maximum number of data disks that can be attached to the
         virtual machine size.
        :paramtype max_data_disk_count: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.number_of_cores = number_of_cores
        self.os_disk_size_in_mb = os_disk_size_in_mb
        self.resource_disk_size_in_mb = resource_disk_size_in_mb
        self.memory_in_mb = memory_in_mb
        self.max_data_disk_count = max_data_disk_count

class VirtualMachineSizeListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    :ivar value: The list of virtual machine sizes.
    :vartype value: list[~azure.mgmt.compute.models.VirtualMachineSize]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineSize]"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualMachineSize"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of virtual machine sizes.
        :paramtype value: list[~azure.mgmt.compute.models.VirtualMachineSize]
        """
        super().__init__(**kwargs)
        self.value = value

class VirtualMachineStatusCodeCount(_serialization.Model):
    """The status code and count of the virtual machine scale set instance view status summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: The number of instances having a particular status code.
    :vartype count: int
    """

    _validation = {
        "code": {"readonly": True},
        "count": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.count = None

class WinRMConfiguration(_serialization.Model):
    """Describes Windows Remote Management configuration of the VM.

    :ivar listeners: The list of Windows Remote Management listeners.
    :vartype listeners: list[~azure.mgmt.compute.models.WinRMListener]
    """

    _attribute_map = {
        "listeners": {"key": "listeners", "type": "[WinRMListener]"},
    }

    def __init__(self, *, listeners: Optional[List["_models.WinRMListener"]] = None, **kwargs: Any) -> None:
        """
        :keyword listeners: The list of Windows Remote Management listeners.
        :paramtype listeners: list[~azure.mgmt.compute.models.WinRMListener]
        """
        super().__init__(**kwargs)
        self.listeners = listeners

class WinRMListener(_serialization.Model):
    """Describes Protocol and thumbprint of Windows Remote Management listener.

    :ivar protocol: Specifies the protocol of WinRM listener. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`\ **http** :code:`<br>`:code:`<br>` **https**. Known values are: "Http"
     and "Https".
    :vartype protocol: str or ~azure.mgmt.compute.models.ProtocolTypes
    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on a
     virtual machine it is recommended to use the `Azure Key Vault virtual machine extension for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the
     `Azure Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :vartype certificate_url: str
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "certificate_url": {"key": "certificateUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "_models.ProtocolTypes"]] = None,
        certificate_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protocol: Specifies the protocol of WinRM listener. :code:`<br>`:code:`<br>` Possible
         values are: :code:`<br>`\ **http** :code:`<br>`:code:`<br>` **https**. Known values are: "Http"
         and "Https".
        :paramtype protocol: str or ~azure.mgmt.compute.models.ProtocolTypes
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
         <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
         certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
         in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
         "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
         "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on a
         virtual machine it is recommended to use the `Azure Key Vault virtual machine extension for
         Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the
         `Azure Key Vault virtual machine extension for Windows
         <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
        :paramtype certificate_url: str
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.certificate_url = certificate_url

class WindowsConfiguration(_serialization.Model):
    """Specifies Windows operating system settings on the virtual machine.

    :ivar provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :vartype provision_vm_agent: bool
    :ivar enable_automatic_updates: Indicates whether Automatic Updates is enabled for the Windows
     virtual machine. Default value is true. :code:`<br>`:code:`<br>` For virtual machine scale
     sets, this property can be updated and updates will take effect on OS reprovisioning.
    :vartype enable_automatic_updates: bool
    :ivar time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time".
     :code:`<br>`:code:`<br>` Possible values can be `TimeZoneInfo.Id
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id>`_ value
     from time zones returned by `TimeZoneInfo.GetSystemTimeZones
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones>`_.
    :vartype time_zone: str
    :ivar additional_unattend_content: Specifies additional base-64 encoded XML formatted
     information that can be included in the Unattend.xml file, which is used by Windows Setup.
    :vartype additional_unattend_content:
     list[~azure.mgmt.compute.models.AdditionalUnattendContent]
    :ivar patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Windows.
    :vartype patch_settings: ~azure.mgmt.compute.models.PatchSettings
    :ivar win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
     PowerShell.
    :vartype win_rm: ~azure.mgmt.compute.models.WinRMConfiguration
    :ivar enable_vm_agent_platform_updates: Indicates whether VMAgent Platform Updates is enabled
     for the Windows virtual machine. Default value is false.
    :vartype enable_vm_agent_platform_updates: bool
    """

    _attribute_map = {
        "provision_vm_agent": {"key": "provisionVMAgent", "type": "bool"},
        "enable_automatic_updates": {"key": "enableAutomaticUpdates", "type": "bool"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "additional_unattend_content": {"key": "additionalUnattendContent", "type": "[AdditionalUnattendContent]"},
        "patch_settings": {"key": "patchSettings", "type": "PatchSettings"},
        "win_rm": {"key": "winRM", "type": "WinRMConfiguration"},
        "enable_vm_agent_platform_updates": {"key": "enableVMAgentPlatformUpdates", "type": "bool"},
    }

    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        enable_automatic_updates: Optional[bool] = None,
        time_zone: Optional[str] = None,
        additional_unattend_content: Optional[List["_models.AdditionalUnattendContent"]] = None,
        patch_settings: Optional["_models.PatchSettings"] = None,
        win_rm: Optional["_models.WinRMConfiguration"] = None,
        enable_vm_agent_platform_updates: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provision_vm_agent: Indicates whether virtual machine agent should be provisioned on
         the virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the
         request body, default behavior is to set it to true.  This will ensure that VM Agent is
         installed on the VM so that extensions can be added to the VM later.
        :paramtype provision_vm_agent: bool
        :keyword enable_automatic_updates: Indicates whether Automatic Updates is enabled for the
         Windows virtual machine. Default value is true. :code:`<br>`:code:`<br>` For virtual machine
         scale sets, this property can be updated and updates will take effect on OS reprovisioning.
        :paramtype enable_automatic_updates: bool
        :keyword time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard
         Time". :code:`<br>`:code:`<br>` Possible values can be `TimeZoneInfo.Id
         <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id>`_ value
         from time zones returned by `TimeZoneInfo.GetSystemTimeZones
         <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones>`_.
        :paramtype time_zone: str
        :keyword additional_unattend_content: Specifies additional base-64 encoded XML formatted
         information that can be included in the Unattend.xml file, which is used by Windows Setup.
        :paramtype additional_unattend_content:
         list[~azure.mgmt.compute.models.AdditionalUnattendContent]
        :keyword patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
         Windows.
        :paramtype patch_settings: ~azure.mgmt.compute.models.PatchSettings
        :keyword win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
         PowerShell.
        :paramtype win_rm: ~azure.mgmt.compute.models.WinRMConfiguration
        :keyword enable_vm_agent_platform_updates: Indicates whether VMAgent Platform Updates is
         enabled for the Windows virtual machine. Default value is false.
        :paramtype enable_vm_agent_platform_updates: bool
        """
        super().__init__(**kwargs)
        self.provision_vm_agent = provision_vm_agent
        self.enable_automatic_updates = enable_automatic_updates
        self.time_zone = time_zone
        self.additional_unattend_content = additional_unattend_content
        self.patch_settings = patch_settings
        self.win_rm = win_rm
        self.enable_vm_agent_platform_updates = enable_vm_agent_platform_updates

class VirtualMachineExtensionsListResult(_serialization.Model):
    """The List Extension operation response.

    :ivar value: The list of extensions.
    :vartype value: list[~azure.mgmt.compute.models.VirtualMachineExtension]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineExtension]"},
    }

    def __init__(self, *, value: Optional[List["_models.VirtualMachineExtension"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of extensions.
        :paramtype value: list[~azure.mgmt.compute.models.VirtualMachineExtension]
        """
        super().__init__(**kwargs)
        self.value = value

class VirtualMachineIdentity(_serialization.Model):
    """Identity for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the virtual machine. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user assigned
     identities. The type 'None' will remove any identities from the virtual machine. Known values
     are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.compute.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the Virtual
     Machine. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.compute.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentitiesValue}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentitiesValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the virtual machine. The type 'SystemAssigned,
         UserAssigned' includes both an implicitly created identity and a set of user assigned
         identities. The type 'None' will remove any identities from the virtual machine. Known values
         are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.compute.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the Virtual
         Machine. The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.compute.models.UserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities

class VirtualMachineScaleSetIdentity(_serialization.Model):
    """Identity for the virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine scale set identity. This property will
     only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine scale set. This property
     will only be provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the virtual machine scale set. The type
     'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
     assigned identities. The type 'None' will remove any identities from the virtual machine scale
     set. Known values are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and
     "None".
    :vartype type: str or ~azure.mgmt.compute.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the virtual machine
     scale set. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.compute.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentitiesValue}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentitiesValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the virtual machine scale set. The type
         'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
         assigned identities. The type 'None' will remove any identities from the virtual machine scale
         set. Known values are: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", and
         "None".
        :paramtype type: str or ~azure.mgmt.compute.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the virtual
         machine scale set. The user identity dictionary key references will be ARM resource ids in the
         form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.compute.models.UserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities

class AccessUri(_serialization.Model):
    """A disk access SAS uri.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar access_sas: A SAS uri for accessing a disk.
    :vartype access_sas: str
    :ivar security_data_access_sas: A SAS uri for accessing a VM guest state.
    :vartype security_data_access_sas: str
    """

    _validation = {
        "access_sas": {"readonly": True},
        "security_data_access_sas": {"readonly": True},
    }

    _attribute_map = {
        "access_sas": {"key": "accessSAS", "type": "str"},
        "security_data_access_sas": {"key": "securityDataAccessSAS", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.access_sas = None
        self.security_data_access_sas = None

class CreationData(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Data used when creating a disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar create_option: This enumerates the possible sources of a disk's creation. Required. Known
     values are: "Empty", "Attach", "FromImage", "Import", "Copy", "Restore", "Upload", "CopyStart",
     "ImportSecure", "UploadPreparedSecure", and "Import".
    :vartype create_option: str or ~azure.mgmt.compute.models.DiskCreateOption
    :ivar storage_account_id: Required if createOption is Import. The Azure Resource Manager
     identifier of the storage account containing the blob to import as a disk.
    :vartype storage_account_id: str
    :ivar image_reference: Disk source information for PIR or user images.
    :vartype image_reference: ~azure.mgmt.compute.models.ImageDiskReference
    :ivar gallery_image_reference: Required if creating from a Gallery Image. The
     id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of
     the shared galley image version from which to create a disk.
    :vartype gallery_image_reference: ~azure.mgmt.compute.models.ImageDiskReference
    :ivar source_uri: If createOption is Import, this is the URI of a blob to be imported into a
     managed disk.
    :vartype source_uri: str
    :ivar source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot or
     disk.
    :vartype source_resource_id: str
    :ivar source_unique_id: If this field is set, this is the unique id identifying the source of
     this resource.
    :vartype source_unique_id: str
    :ivar upload_size_bytes: If createOption is Upload, this is the size of the contents of the
     upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for
     the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
    :vartype upload_size_bytes: int
    :ivar logical_sector_size: Logical sector size in bytes for Ultra disks. Supported values are
     512 ad 4096. 4096 is the default.
    :vartype logical_sector_size: int
    :ivar security_data_uri: If createOption is ImportSecure, this is the URI of a blob to be
     imported into VM guest state.
    :vartype security_data_uri: str
    :ivar performance_plus: Set this flag to true to get a boost on the performance target of the
     disk deployed, see here on the respective performance target. This flag can only be set on disk
     creation time and cannot be disabled after enabled.
    :vartype performance_plus: bool
    """

    _validation = {
        "create_option": {"required": True},
        "source_unique_id": {"readonly": True},
    }

    _attribute_map = {
        "create_option": {"key": "createOption", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "image_reference": {"key": "imageReference", "type": "ImageDiskReference"},
        "gallery_image_reference": {"key": "galleryImageReference", "type": "ImageDiskReference"},
        "source_uri": {"key": "sourceUri", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "source_unique_id": {"key": "sourceUniqueId", "type": "str"},
        "upload_size_bytes": {"key": "uploadSizeBytes", "type": "int"},
        "logical_sector_size": {"key": "logicalSectorSize", "type": "int"},
        "security_data_uri": {"key": "securityDataUri", "type": "str"},
        "performance_plus": {"key": "performancePlus", "type": "bool"},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "_models.DiskCreateOption"],
        storage_account_id: Optional[str] = None,
        image_reference: Optional["_models.ImageDiskReference"] = None,
        gallery_image_reference: Optional["_models.ImageDiskReference"] = None,
        source_uri: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        upload_size_bytes: Optional[int] = None,
        logical_sector_size: Optional[int] = None,
        security_data_uri: Optional[str] = None,
        performance_plus: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword create_option: This enumerates the possible sources of a disk's creation. Required.
         Known values are: "Empty", "Attach", "FromImage", "Import", "Copy", "Restore", "Upload",
         "CopyStart", "ImportSecure", "UploadPreparedSecure", and "Import".
        :paramtype create_option: str or ~azure.mgmt.compute.models.DiskCreateOption
        :keyword storage_account_id: Required if createOption is Import. The Azure Resource Manager
         identifier of the storage account containing the blob to import as a disk.
        :paramtype storage_account_id: str
        :keyword image_reference: Disk source information for PIR or user images.
        :paramtype image_reference: ~azure.mgmt.compute.models.ImageDiskReference
        :keyword gallery_image_reference: Required if creating from a Gallery Image. The
         id/sharedGalleryImageId/communityGalleryImageId of the ImageDiskReference will be the ARM id of
         the shared galley image version from which to create a disk.
        :paramtype gallery_image_reference: ~azure.mgmt.compute.models.ImageDiskReference
        :keyword source_uri: If createOption is Import, this is the URI of a blob to be imported into a
         managed disk.
        :paramtype source_uri: str
        :keyword source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot
         or disk.
        :paramtype source_resource_id: str
        :keyword upload_size_bytes: If createOption is Upload, this is the size of the contents of the
         upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for
         the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
        :paramtype upload_size_bytes: int
        :keyword logical_sector_size: Logical sector size in bytes for Ultra disks. Supported values
         are 512 ad 4096. 4096 is the default.
        :paramtype logical_sector_size: int
        :keyword security_data_uri: If createOption is ImportSecure, this is the URI of a blob to be
         imported into VM guest state.
        :paramtype security_data_uri: str
        :keyword performance_plus: Set this flag to true to get a boost on the performance target of
         the disk deployed, see here on the respective performance target. This flag can only be set on
         disk creation time and cannot be disabled after enabled.
        :paramtype performance_plus: bool
        """
        super().__init__(**kwargs)
        self.create_option = create_option
        self.storage_account_id = storage_account_id
        self.image_reference = image_reference
        self.gallery_image_reference = gallery_image_reference
        self.source_uri = source_uri
        self.source_resource_id = source_resource_id
        self.source_unique_id = None
        self.upload_size_bytes = upload_size_bytes
        self.logical_sector_size = logical_sector_size
        self.security_data_uri = security_data_uri
        self.performance_plus = performance_plus

class Disk(Resource):  # pylint: disable=too-many-instance-attributes
    """Disk resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar managed_by: A relative URI containing the ID of the VM that has the disk attached.
    :vartype managed_by: str
    :ivar managed_by_extended: List of relative URIs containing the IDs of the VMs that have the
     disk attached. maxShares should be set to a value greater than one for disks to allow attaching
     them to multiple VMs.
    :vartype managed_by_extended: list[str]
    :ivar sku: The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS,
     Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
    :vartype sku: ~azure.mgmt.compute.models.DiskSku
    :ivar zones: The Logical zone list for Disk.
    :vartype zones: list[str]
    :ivar extended_location: The extended location where the disk will be created. Extended
     location cannot be changed.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar time_created: The time when the disk was created.
    :vartype time_created: ~datetime.datetime
    :ivar os_type: The Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar purchase_plan: Purchase plan information for the the image from which the OS disk was
     created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product:
     WindowsServer}.
    :vartype purchase_plan: ~azure.mgmt.compute.models.PurchasePlan
    :ivar supported_capabilities: List of supported capabilities for the image from which the OS
     disk was created.
    :vartype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
    :ivar creation_data: Disk source information. CreationData information cannot be changed after
     the disk has been created.
    :vartype creation_data: ~azure.mgmt.compute.models.CreationData
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar disk_size_bytes: The size of the disk in bytes. This field is read only.
    :vartype disk_size_bytes: int
    :ivar unique_id: Unique Guid identifying the resource.
    :vartype unique_id: str
    :ivar encryption_settings_collection: Encryption settings collection used for Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :vartype encryption_settings_collection:
     ~azure.mgmt.compute.models.EncryptionSettingsCollection
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    :ivar disk_iops_read_write: The number of IOPS allowed for this disk; only settable for
     UltraSSD disks. One operation can transfer between 4k and 256k bytes.
    :vartype disk_iops_read_write: int
    :ivar disk_m_bps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD
     disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of
     10.
    :vartype disk_m_bps_read_write: int
    :ivar disk_iops_read_only: The total number of IOPS that will be allowed across all VMs
     mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
    :vartype disk_iops_read_only: int
    :ivar disk_m_bps_read_only: The total throughput (MBps) that will be allowed across all VMs
     mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses
     the ISO notation, of powers of 10.
    :vartype disk_m_bps_read_only: int
    :ivar disk_state: The state of the disk. Known values are: "Unattached", "Attached",
     "Reserved", "Frozen", "ActiveSAS", "ActiveSASFrozen", "ReadyToUpload", and "ActiveUpload".
    :vartype disk_state: str or ~azure.mgmt.compute.models.DiskState
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.models.Encryption
    :ivar max_shares: The maximum number of VMs that can attach to the disk at the same time. Value
     greater than one indicates a disk that can be mounted on multiple VMs at the same time.
    :vartype max_shares: int
    :ivar share_info: Details of the list of all VMs that have the disk attached. maxShares should
     be set to a value greater than one for disks to allow attaching them to multiple VMs.
    :vartype share_info: list[~azure.mgmt.compute.models.ShareInfoElement]
    :ivar network_access_policy: Policy for accessing the disk via network. Known values are:
     "AllowAll", "AllowPrivate", and "DenyAll".
    :vartype network_access_policy: str or
     ~azure.mgmt.compute.models.NetworkAccessPolicy
    :ivar disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :vartype disk_access_id: str
    :ivar bursting_enabled_time: Latest time when bursting was last enabled on a disk.
    :vartype bursting_enabled_time: ~datetime.datetime
    :ivar tier: Performance tier of the disk (e.g, P4, S10) as described here:
     https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra
     disks.
    :vartype tier: str
    :ivar bursting_enabled: Set to true to enable bursting beyond the provisioned performance
     target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
    :vartype bursting_enabled: bool
    :ivar property_updates_in_progress: Properties of the disk for which update is pending.
    :vartype property_updates_in_progress:
     ~azure.mgmt.compute.models.PropertyUpdatesInProgress
    :ivar supports_hibernation: Indicates the OS on a disk supports hibernation.
    :vartype supports_hibernation: bool
    :ivar security_profile: Contains the security related information for the resource.
    :vartype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
    :ivar completion_percent: Percentage complete for the background copy when a resource is
     created via the CopyStart operation.
    :vartype completion_percent: float
    :ivar public_network_access: Policy for controlling export on the disk. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.compute.models.PublicNetworkAccess
    :ivar data_access_auth_mode: Additional authentication requirements when exporting or uploading
     to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
    :vartype data_access_auth_mode: str or
     ~azure.mgmt.compute.models.DataAccessAuthMode
    :ivar optimized_for_frequent_attach: Setting this property to true improves reliability and
     performance of data disks that are frequently (more than 5 times a day) by detached from one
     virtual machine and attached to another. This property should not be set for disks that are not
     detached and attached frequently as it causes the disks to not align with the fault domain of
     the virtual machine.
    :vartype optimized_for_frequent_attach: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "managed_by": {"readonly": True},
        "managed_by_extended": {"readonly": True},
        "time_created": {"readonly": True},
        "disk_size_bytes": {"readonly": True},
        "unique_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "disk_state": {"readonly": True},
        "share_info": {"readonly": True},
        "bursting_enabled_time": {"readonly": True},
        "property_updates_in_progress": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "managed_by_extended": {"key": "managedByExtended", "type": "[str]"},
        "sku": {"key": "sku", "type": "DiskSku"},
        "zones": {"key": "zones", "type": "[str]"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "PurchasePlan"},
        "supported_capabilities": {"key": "properties.supportedCapabilities", "type": "SupportedCapabilities"},
        "creation_data": {"key": "properties.creationData", "type": "CreationData"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "disk_size_bytes": {"key": "properties.diskSizeBytes", "type": "int"},
        "unique_id": {"key": "properties.uniqueId", "type": "str"},
        "encryption_settings_collection": {
            "key": "properties.encryptionSettingsCollection",
            "type": "EncryptionSettingsCollection",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "disk_iops_read_write": {"key": "properties.diskIOPSReadWrite", "type": "int"},
        "disk_m_bps_read_write": {"key": "properties.diskMBpsReadWrite", "type": "int"},
        "disk_iops_read_only": {"key": "properties.diskIOPSReadOnly", "type": "int"},
        "disk_m_bps_read_only": {"key": "properties.diskMBpsReadOnly", "type": "int"},
        "disk_state": {"key": "properties.diskState", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "max_shares": {"key": "properties.maxShares", "type": "int"},
        "share_info": {"key": "properties.shareInfo", "type": "[ShareInfoElement]"},
        "network_access_policy": {"key": "properties.networkAccessPolicy", "type": "str"},
        "disk_access_id": {"key": "properties.diskAccessId", "type": "str"},
        "bursting_enabled_time": {"key": "properties.burstingEnabledTime", "type": "iso-8601"},
        "tier": {"key": "properties.tier", "type": "str"},
        "bursting_enabled": {"key": "properties.burstingEnabled", "type": "bool"},
        "property_updates_in_progress": {
            "key": "properties.propertyUpdatesInProgress",
            "type": "PropertyUpdatesInProgress",
        },
        "supports_hibernation": {"key": "properties.supportsHibernation", "type": "bool"},
        "security_profile": {"key": "properties.securityProfile", "type": "DiskSecurityProfile"},
        "completion_percent": {"key": "properties.completionPercent", "type": "float"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "data_access_auth_mode": {"key": "properties.dataAccessAuthMode", "type": "str"},
        "optimized_for_frequent_attach": {"key": "properties.optimizedForFrequentAttach", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.DiskSku"] = None,
        zones: Optional[List[str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        purchase_plan: Optional["_models.PurchasePlan"] = None,
        supported_capabilities: Optional["_models.SupportedCapabilities"] = None,
        creation_data: Optional["_models.CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["_models.EncryptionSettingsCollection"] = None,
        disk_iops_read_write: Optional[int] = None,
        disk_m_bps_read_write: Optional[int] = None,
        disk_iops_read_only: Optional[int] = None,
        disk_m_bps_read_only: Optional[int] = None,
        encryption: Optional["_models.Encryption"] = None,
        max_shares: Optional[int] = None,
        network_access_policy: Optional[Union[str, "_models.NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        tier: Optional[str] = None,
        bursting_enabled: Optional[bool] = None,
        supports_hibernation: Optional[bool] = None,
        security_profile: Optional["_models.DiskSecurityProfile"] = None,
        completion_percent: Optional[float] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        data_access_auth_mode: Optional[Union[str, "_models.DataAccessAuthMode"]] = None,
        optimized_for_frequent_attach: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS,
         UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
        :paramtype sku: ~azure.mgmt.compute.models.DiskSku
        :keyword zones: The Logical zone list for Disk.
        :paramtype zones: list[str]
        :keyword extended_location: The extended location where the disk will be created. Extended
         location cannot be changed.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        :keyword os_type: The Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword purchase_plan: Purchase plan information for the the image from which the OS disk was
         created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product:
         WindowsServer}.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.PurchasePlan
        :keyword supported_capabilities: List of supported capabilities for the image from which the OS
         disk was created.
        :paramtype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
        :keyword creation_data: Disk source information. CreationData information cannot be changed
         after the disk has been created.
        :paramtype creation_data: ~azure.mgmt.compute.models.CreationData
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the disk to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings_collection: Encryption settings collection used for Azure Disk
         Encryption, can contain multiple encryption settings per disk or snapshot.
        :paramtype encryption_settings_collection:
         ~azure.mgmt.compute.models.EncryptionSettingsCollection
        :keyword disk_iops_read_write: The number of IOPS allowed for this disk; only settable for
         UltraSSD disks. One operation can transfer between 4k and 256k bytes.
        :paramtype disk_iops_read_write: int
        :keyword disk_m_bps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD
         disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of
         10.
        :paramtype disk_m_bps_read_write: int
        :keyword disk_iops_read_only: The total number of IOPS that will be allowed across all VMs
         mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
        :paramtype disk_iops_read_only: int
        :keyword disk_m_bps_read_only: The total throughput (MBps) that will be allowed across all VMs
         mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses
         the ISO notation, of powers of 10.
        :paramtype disk_m_bps_read_only: int
        :keyword encryption: Encryption property can be used to encrypt data at rest with customer
         managed keys or platform managed keys.
        :paramtype encryption: ~azure.mgmt.compute.models.Encryption
        :keyword max_shares: The maximum number of VMs that can attach to the disk at the same time.
         Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
        :paramtype max_shares: int
        :keyword network_access_policy: Policy for accessing the disk via network. Known values are:
         "AllowAll", "AllowPrivate", and "DenyAll".
        :paramtype network_access_policy: str or
         ~azure.mgmt.compute.models.NetworkAccessPolicy
        :keyword disk_access_id: ARM id of the DiskAccess resource for using private endpoints on
         disks.
        :paramtype disk_access_id: str
        :keyword tier: Performance tier of the disk (e.g, P4, S10) as described here:
         https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra
         disks.
        :paramtype tier: str
        :keyword bursting_enabled: Set to true to enable bursting beyond the provisioned performance
         target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
        :paramtype bursting_enabled: bool
        :keyword supports_hibernation: Indicates the OS on a disk supports hibernation.
        :paramtype supports_hibernation: bool
        :keyword security_profile: Contains the security related information for the resource.
        :paramtype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
        :keyword completion_percent: Percentage complete for the background copy when a resource is
         created via the CopyStart operation.
        :paramtype completion_percent: float
        :keyword public_network_access: Policy for controlling export on the disk. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.compute.models.PublicNetworkAccess
        :keyword data_access_auth_mode: Additional authentication requirements when exporting or
         uploading to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
        :paramtype data_access_auth_mode: str or
         ~azure.mgmt.compute.models.DataAccessAuthMode
        :keyword optimized_for_frequent_attach: Setting this property to true improves reliability and
         performance of data disks that are frequently (more than 5 times a day) by detached from one
         virtual machine and attached to another. This property should not be set for disks that are not
         detached and attached frequently as it causes the disks to not align with the fault domain of
         the virtual machine.
        :paramtype optimized_for_frequent_attach: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.managed_by = None
        self.managed_by_extended = None
        self.sku = sku
        self.zones = zones
        self.extended_location = extended_location
        self.time_created = None
        self.os_type = os_type
        self.hyper_v_generation = hyper_v_generation
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.disk_size_bytes = None
        self.unique_id = None
        self.encryption_settings_collection = encryption_settings_collection
        self.provisioning_state = None
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_m_bps_read_write = disk_m_bps_read_write
        self.disk_iops_read_only = disk_iops_read_only
        self.disk_m_bps_read_only = disk_m_bps_read_only
        self.disk_state = None
        self.encryption = encryption
        self.max_shares = max_shares
        self.share_info = None
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.bursting_enabled_time = None
        self.tier = tier
        self.bursting_enabled = bursting_enabled
        self.property_updates_in_progress = None
        self.supports_hibernation = supports_hibernation
        self.security_profile = security_profile
        self.completion_percent = completion_percent
        self.public_network_access = public_network_access
        self.data_access_auth_mode = data_access_auth_mode
        self.optimized_for_frequent_attach = optimized_for_frequent_attach

class DiskList(_serialization.Model):
    """The List Disks operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of disks. Required.
    :vartype value: list[~azure.mgmt.compute.models.Disk]
    :ivar next_link: The uri to fetch the next page of disks. Call ListNext() with this to fetch
     the next page of disks.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Disk]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Disk"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of disks. Required.
        :paramtype value: list[~azure.mgmt.compute.models.Disk]
        :keyword next_link: The uri to fetch the next page of disks. Call ListNext() with this to fetch
         the next page of disks.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class DiskUpdate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Disk update resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS,
     Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
    :vartype sku: ~azure.mgmt.compute.models.DiskSku
    :ivar os_type: the Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar encryption_settings_collection: Encryption settings collection used be Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :vartype encryption_settings_collection:
     ~azure.mgmt.compute.models.EncryptionSettingsCollection
    :ivar disk_iops_read_write: The number of IOPS allowed for this disk; only settable for
     UltraSSD disks. One operation can transfer between 4k and 256k bytes.
    :vartype disk_iops_read_write: int
    :ivar disk_m_bps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD
     disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of
     10.
    :vartype disk_m_bps_read_write: int
    :ivar disk_iops_read_only: The total number of IOPS that will be allowed across all VMs
     mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
    :vartype disk_iops_read_only: int
    :ivar disk_m_bps_read_only: The total throughput (MBps) that will be allowed across all VMs
     mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses
     the ISO notation, of powers of 10.
    :vartype disk_m_bps_read_only: int
    :ivar max_shares: The maximum number of VMs that can attach to the disk at the same time. Value
     greater than one indicates a disk that can be mounted on multiple VMs at the same time.
    :vartype max_shares: int
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.models.Encryption
    :ivar network_access_policy: Policy for accessing the disk via network. Known values are:
     "AllowAll", "AllowPrivate", and "DenyAll".
    :vartype network_access_policy: str or
     ~azure.mgmt.compute.models.NetworkAccessPolicy
    :ivar disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :vartype disk_access_id: str
    :ivar tier: Performance tier of the disk (e.g, P4, S10) as described here:
     https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra
     disks.
    :vartype tier: str
    :ivar bursting_enabled: Set to true to enable bursting beyond the provisioned performance
     target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
    :vartype bursting_enabled: bool
    :ivar purchase_plan: Purchase plan information to be added on the OS disk.
    :vartype purchase_plan: ~azure.mgmt.compute.models.PurchasePlan
    :ivar supported_capabilities: List of supported capabilities to be added on the OS disk.
    :vartype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
    :ivar property_updates_in_progress: Properties of the disk for which update is pending.
    :vartype property_updates_in_progress:
     ~azure.mgmt.compute.models.PropertyUpdatesInProgress
    :ivar supports_hibernation: Indicates the OS on a disk supports hibernation.
    :vartype supports_hibernation: bool
    :ivar public_network_access: Policy for controlling export on the disk. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.compute.models.PublicNetworkAccess
    :ivar data_access_auth_mode: Additional authentication requirements when exporting or uploading
     to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
    :vartype data_access_auth_mode: str or
     ~azure.mgmt.compute.models.DataAccessAuthMode
    :ivar optimized_for_frequent_attach: Setting this property to true improves reliability and
     performance of data disks that are frequently (more than 5 times a day) by detached from one
     virtual machine and attached to another. This property should not be set for disks that are not
     detached and attached frequently as it causes the disks to not align with the fault domain of
     the virtual machine.
    :vartype optimized_for_frequent_attach: bool
    """

    _validation = {
        "property_updates_in_progress": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "DiskSku"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "encryption_settings_collection": {
            "key": "properties.encryptionSettingsCollection",
            "type": "EncryptionSettingsCollection",
        },
        "disk_iops_read_write": {"key": "properties.diskIOPSReadWrite", "type": "int"},
        "disk_m_bps_read_write": {"key": "properties.diskMBpsReadWrite", "type": "int"},
        "disk_iops_read_only": {"key": "properties.diskIOPSReadOnly", "type": "int"},
        "disk_m_bps_read_only": {"key": "properties.diskMBpsReadOnly", "type": "int"},
        "max_shares": {"key": "properties.maxShares", "type": "int"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "network_access_policy": {"key": "properties.networkAccessPolicy", "type": "str"},
        "disk_access_id": {"key": "properties.diskAccessId", "type": "str"},
        "tier": {"key": "properties.tier", "type": "str"},
        "bursting_enabled": {"key": "properties.burstingEnabled", "type": "bool"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "PurchasePlan"},
        "supported_capabilities": {"key": "properties.supportedCapabilities", "type": "SupportedCapabilities"},
        "property_updates_in_progress": {
            "key": "properties.propertyUpdatesInProgress",
            "type": "PropertyUpdatesInProgress",
        },
        "supports_hibernation": {"key": "properties.supportsHibernation", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "data_access_auth_mode": {"key": "properties.dataAccessAuthMode", "type": "str"},
        "optimized_for_frequent_attach": {"key": "properties.optimizedForFrequentAttach", "type": "bool"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.DiskSku"] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["_models.EncryptionSettingsCollection"] = None,
        disk_iops_read_write: Optional[int] = None,
        disk_m_bps_read_write: Optional[int] = None,
        disk_iops_read_only: Optional[int] = None,
        disk_m_bps_read_only: Optional[int] = None,
        max_shares: Optional[int] = None,
        encryption: Optional["_models.Encryption"] = None,
        network_access_policy: Optional[Union[str, "_models.NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        tier: Optional[str] = None,
        bursting_enabled: Optional[bool] = None,
        purchase_plan: Optional["_models.PurchasePlan"] = None,
        supported_capabilities: Optional["_models.SupportedCapabilities"] = None,
        supports_hibernation: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        data_access_auth_mode: Optional[Union[str, "_models.DataAccessAuthMode"]] = None,
        optimized_for_frequent_attach: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS,
         UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.
        :paramtype sku: ~azure.mgmt.compute.models.DiskSku
        :keyword os_type: the Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the disk to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings_collection: Encryption settings collection used be Azure Disk
         Encryption, can contain multiple encryption settings per disk or snapshot.
        :paramtype encryption_settings_collection:
         ~azure.mgmt.compute.models.EncryptionSettingsCollection
        :keyword disk_iops_read_write: The number of IOPS allowed for this disk; only settable for
         UltraSSD disks. One operation can transfer between 4k and 256k bytes.
        :paramtype disk_iops_read_write: int
        :keyword disk_m_bps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD
         disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of
         10.
        :paramtype disk_m_bps_read_write: int
        :keyword disk_iops_read_only: The total number of IOPS that will be allowed across all VMs
         mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
        :paramtype disk_iops_read_only: int
        :keyword disk_m_bps_read_only: The total throughput (MBps) that will be allowed across all VMs
         mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses
         the ISO notation, of powers of 10.
        :paramtype disk_m_bps_read_only: int
        :keyword max_shares: The maximum number of VMs that can attach to the disk at the same time.
         Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
        :paramtype max_shares: int
        :keyword encryption: Encryption property can be used to encrypt data at rest with customer
         managed keys or platform managed keys.
        :paramtype encryption: ~azure.mgmt.compute.models.Encryption
        :keyword network_access_policy: Policy for accessing the disk via network. Known values are:
         "AllowAll", "AllowPrivate", and "DenyAll".
        :paramtype network_access_policy: str or
         ~azure.mgmt.compute.models.NetworkAccessPolicy
        :keyword disk_access_id: ARM id of the DiskAccess resource for using private endpoints on
         disks.
        :paramtype disk_access_id: str
        :keyword tier: Performance tier of the disk (e.g, P4, S10) as described here:
         https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra
         disks.
        :paramtype tier: str
        :keyword bursting_enabled: Set to true to enable bursting beyond the provisioned performance
         target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
        :paramtype bursting_enabled: bool
        :keyword purchase_plan: Purchase plan information to be added on the OS disk.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.PurchasePlan
        :keyword supported_capabilities: List of supported capabilities to be added on the OS disk.
        :paramtype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
        :keyword supports_hibernation: Indicates the OS on a disk supports hibernation.
        :paramtype supports_hibernation: bool
        :keyword public_network_access: Policy for controlling export on the disk. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.compute.models.PublicNetworkAccess
        :keyword data_access_auth_mode: Additional authentication requirements when exporting or
         uploading to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
        :paramtype data_access_auth_mode: str or
         ~azure.mgmt.compute.models.DataAccessAuthMode
        :keyword optimized_for_frequent_attach: Setting this property to true improves reliability and
         performance of data disks that are frequently (more than 5 times a day) by detached from one
         virtual machine and attached to another. This property should not be set for disks that are not
         detached and attached frequently as it causes the disks to not align with the fault domain of
         the virtual machine.
        :paramtype optimized_for_frequent_attach: bool
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.os_type = os_type
        self.disk_size_gb = disk_size_gb
        self.encryption_settings_collection = encryption_settings_collection
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_m_bps_read_write = disk_m_bps_read_write
        self.disk_iops_read_only = disk_iops_read_only
        self.disk_m_bps_read_only = disk_m_bps_read_only
        self.max_shares = max_shares
        self.encryption = encryption
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.tier = tier
        self.bursting_enabled = bursting_enabled
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.property_updates_in_progress = None
        self.supports_hibernation = supports_hibernation
        self.public_network_access = public_network_access
        self.data_access_auth_mode = data_access_auth_mode
        self.optimized_for_frequent_attach = optimized_for_frequent_attach

class EncryptionSettings(_serialization.Model):
    """Encryption settings for disk or snapshot.

    :ivar enabled: Set this flag to true and provide DiskEncryptionKey and optional
     KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and
     KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object,
     the existing settings remain unchanged.
    :vartype enabled: bool
    :ivar disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key.
    :vartype disk_encryption_key: ~azure.mgmt.compute.models.KeyVaultAndSecretReference
    :ivar key_encryption_key: Key Vault Key Url and vault id of the key encryption key.
    :vartype key_encryption_key: ~azure.mgmt.compute.models.KeyVaultAndKeyReference
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "disk_encryption_key": {"key": "diskEncryptionKey", "type": "KeyVaultAndSecretReference"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultAndKeyReference"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        disk_encryption_key: Optional["_models.KeyVaultAndSecretReference"] = None,
        key_encryption_key: Optional["_models.KeyVaultAndKeyReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Set this flag to true and provide DiskEncryptionKey and optional
         KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and
         KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object,
         the existing settings remain unchanged.
        :paramtype enabled: bool
        :keyword disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key.
        :paramtype disk_encryption_key:
         ~azure.mgmt.compute.models.KeyVaultAndSecretReference
        :keyword key_encryption_key: Key Vault Key Url and vault id of the key encryption key.
        :paramtype key_encryption_key: ~azure.mgmt.compute.models.KeyVaultAndKeyReference
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key

class GrantAccessData(_serialization.Model):
    """Data used for requesting a SAS.

    All required parameters must be populated in order to send to Azure.

    :ivar access: Required. Known values are: "None", "Read", and "Write".
    :vartype access: str or ~azure.mgmt.compute.models.AccessLevel
    :ivar duration_in_seconds: Time duration in seconds until the SAS access expires. Required.
    :vartype duration_in_seconds: int
    :ivar get_secure_vm_guest_state_sas: Set this flag to true to get additional SAS for VM guest
     state.
    :vartype get_secure_vm_guest_state_sas: bool
    """

    _validation = {
        "access": {"required": True},
        "duration_in_seconds": {"required": True},
    }

    _attribute_map = {
        "access": {"key": "access", "type": "str"},
        "duration_in_seconds": {"key": "durationInSeconds", "type": "int"},
        "get_secure_vm_guest_state_sas": {"key": "getSecureVMGuestStateSAS", "type": "bool"},
    }

    def __init__(
        self,
        *,
        access: Union[str, "_models.AccessLevel"],
        duration_in_seconds: int,
        get_secure_vm_guest_state_sas: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword access: Required. Known values are: "None", "Read", and "Write".
        :paramtype access: str or ~azure.mgmt.compute.models.AccessLevel
        :keyword duration_in_seconds: Time duration in seconds until the SAS access expires. Required.
        :paramtype duration_in_seconds: int
        :keyword get_secure_vm_guest_state_sas: Set this flag to true to get additional SAS for VM
         guest state.
        :paramtype get_secure_vm_guest_state_sas: bool
        """
        super().__init__(**kwargs)
        self.access = access
        self.duration_in_seconds = duration_in_seconds
        self.get_secure_vm_guest_state_sas = get_secure_vm_guest_state_sas

class Image(Resource):
    """The source user image virtual hard disk. The virtual hard disk will be copied before being
    attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive
    must not exist.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location of the Image.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar source_virtual_machine: The source virtual machine from which Image is created.
    :vartype source_virtual_machine: ~azure.mgmt.compute.models.SubResource
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created from
     the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to
     specify the value, if the source is managed resource like disk or snapshot, we may require the
     user to specify the property if we cannot deduce it from the source managed resource. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or
     ~azure.mgmt.compute.models.HyperVGenerationTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "source_virtual_machine": {"key": "properties.sourceVirtualMachine", "type": "SubResource"},
        "storage_profile": {"key": "properties.storageProfile", "type": "ImageStorageProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        source_virtual_machine: Optional["_models.SubResource"] = None,
        storage_profile: Optional["_models.ImageStorageProfile"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location of the Image.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        :keyword source_virtual_machine: The source virtual machine from which Image is created.
        :paramtype source_virtual_machine: ~azure.mgmt.compute.models.SubResource
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.models.ImageStorageProfile
        :keyword hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created
         from the image. From API Version 2019-03-01 if the image source is a blob, then we need the
         user to specify the value, if the source is managed resource like disk or snapshot, we may
         require the user to specify the property if we cannot deduce it from the source managed
         resource. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or
         ~azure.mgmt.compute.models.HyperVGenerationTypes
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None
        self.hyper_v_generation = hyper_v_generation

class ImageDisk(_serialization.Model):
    """Describes a image disk.

    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    """

    _attribute_map = {
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
    }

    def __init__(
        self,
        *,
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
         "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed image disk.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        """
        super().__init__(**kwargs)
        self.snapshot = snapshot
        self.managed_disk = managed_disk
        self.blob_uri = blob_uri
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set

class ImageDataDisk(ImageDisk):
    """Describes a data disk.

    All required parameters must be populated in order to send to Azure.

    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    """

    _validation = {
        "lun": {"required": True},
    }

    _attribute_map = {
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self,
        *,
        lun: int,
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
         "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed image disk.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        """
        super().__init__(
            snapshot=snapshot,
            managed_disk=managed_disk,
            blob_uri=blob_uri,
            caching=caching,
            disk_size_gb=disk_size_gb,
            storage_account_type=storage_account_type,
            disk_encryption_set=disk_encryption_set,
            **kwargs
        )
        self.lun = lun

class ImageDiskReference(_serialization.Model):
    """The source image used for creating the disk.

    :ivar id: A relative uri containing either a Platform Image Repository, user image, or Azure
     Compute Gallery image reference.
    :vartype id: str
    :ivar shared_gallery_image_id: A relative uri containing a direct shared Azure Compute Gallery
     image reference.
    :vartype shared_gallery_image_id: str
    :ivar community_gallery_image_id: A relative uri containing a community Azure Compute Gallery
     image reference.
    :vartype community_gallery_image_id: str
    :ivar lun: If the disk is created from an image's data disk, this is an index that indicates
     which of the data disks in the image to use. For OS disks, this field is null.
    :vartype lun: int
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "shared_gallery_image_id": {"key": "sharedGalleryImageId", "type": "str"},
        "community_gallery_image_id": {"key": "communityGalleryImageId", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        shared_gallery_image_id: Optional[str] = None,
        community_gallery_image_id: Optional[str] = None,
        lun: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: A relative uri containing either a Platform Image Repository, user image, or Azure
         Compute Gallery image reference.
        :paramtype id: str
        :keyword shared_gallery_image_id: A relative uri containing a direct shared Azure Compute
         Gallery image reference.
        :paramtype shared_gallery_image_id: str
        :keyword community_gallery_image_id: A relative uri containing a community Azure Compute
         Gallery image reference.
        :paramtype community_gallery_image_id: str
        :keyword lun: If the disk is created from an image's data disk, this is an index that indicates
         which of the data disks in the image to use. For OS disks, this field is null.
        :paramtype lun: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.shared_gallery_image_id = shared_gallery_image_id
        self.community_gallery_image_id = community_gallery_image_id
        self.lun = lun

class ImageListResult(_serialization.Model):
    """The List Image operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of Images. Required.
    :vartype value: list[~azure.mgmt.compute.models.Image]
    :ivar next_link: The uri to fetch the next page of Images. Call ListNext() with this to fetch
     the next page of Images.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Image]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Image"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of Images. Required.
        :paramtype value: list[~azure.mgmt.compute.models.Image]
        :keyword next_link: The uri to fetch the next page of Images. Call ListNext() with this to
         fetch the next page of Images.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ImageOSDisk(ImageDisk):
    """Describes an Operating System disk.

    All required parameters must be populated in order to send to Azure.

    :ivar snapshot: The snapshot.
    :vartype snapshot: ~azure.mgmt.compute.models.SubResource
    :ivar managed_disk: The managedDisk.
    :vartype managed_disk: ~azure.mgmt.compute.models.SubResource
    :ivar blob_uri: The Virtual Hard Disk.
    :vartype blob_uri: str
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :vartype disk_size_gb: int
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Required. Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar os_state: The OS State. For managed images, use Generalized. Required. Known values are:
     "Generalized" and "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
    """

    _validation = {
        "os_type": {"required": True},
        "os_state": {"required": True},
    }

    _attribute_map = {
        "snapshot": {"key": "snapshot", "type": "SubResource"},
        "managed_disk": {"key": "managedDisk", "type": "SubResource"},
        "blob_uri": {"key": "blobUri", "type": "str"},
        "caching": {"key": "caching", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "os_type": {"key": "osType", "type": "str"},
        "os_state": {"key": "osState", "type": "str"},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "_models.OperatingSystemTypes"],
        os_state: Union[str, "_models.OperatingSystemStateTypes"],
        snapshot: Optional["_models.SubResource"] = None,
        managed_disk: Optional["_models.SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword snapshot: The snapshot.
        :paramtype snapshot: ~azure.mgmt.compute.models.SubResource
        :keyword managed_disk: The managedDisk.
        :paramtype managed_disk: ~azure.mgmt.compute.models.SubResource
        :keyword blob_uri: The Virtual Hard Disk.
        :paramtype blob_uri: str
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
         used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         This value cannot be larger than 1023 GB.
        :paramtype disk_size_gb: int
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
         "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed image disk.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Required. Known values
         are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword os_state: The OS State. For managed images, use Generalized. Required. Known values
         are: "Generalized" and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
        """
        super().__init__(
            snapshot=snapshot,
            managed_disk=managed_disk,
            blob_uri=blob_uri,
            caching=caching,
            disk_size_gb=disk_size_gb,
            storage_account_type=storage_account_type,
            disk_encryption_set=disk_encryption_set,
            **kwargs
        )
        self.os_type = os_type
        self.os_state = os_state

class ImageStorageProfile(_serialization.Model):
    """Describes a storage profile.

    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype os_disk: ~azure.mgmt.compute.models.ImageOSDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :vartype data_disks: list[~azure.mgmt.compute.models.ImageDataDisk]
    :ivar zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
     Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
    :vartype zone_resilient: bool
    """

    _attribute_map = {
        "os_disk": {"key": "osDisk", "type": "ImageOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[ImageDataDisk]"},
        "zone_resilient": {"key": "zoneResilient", "type": "bool"},
    }

    def __init__(
        self,
        *,
        os_disk: Optional["_models.ImageOSDisk"] = None,
        data_disks: Optional[List["_models.ImageDataDisk"]] = None,
        zone_resilient: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype os_disk: ~azure.mgmt.compute.models.ImageOSDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
         for Azure virtual machines
         <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
        :paramtype data_disks: list[~azure.mgmt.compute.models.ImageDataDisk]
        :keyword zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
         Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
        :paramtype zone_resilient: bool
        """
        super().__init__(**kwargs)
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.zone_resilient = zone_resilient

class KeyVaultAndKeyReference(_serialization.Model):
    """Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the
    encryptionKey.

    All required parameters must be populated in order to send to Azure.

    :ivar source_vault: Resource id of the KeyVault containing the key or secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.models.SourceVault
    :ivar key_url: Url pointing to a key or secret in KeyVault. Required.
    :vartype key_url: str
    """

    _validation = {
        "source_vault": {"required": True},
        "key_url": {"required": True},
    }

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SourceVault"},
        "key_url": {"key": "keyUrl", "type": "str"},
    }

    def __init__(self, *, source_vault: "_models.SourceVault", key_url: str, **kwargs: Any) -> None:
        """
        :keyword source_vault: Resource id of the KeyVault containing the key or secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.models.SourceVault
        :keyword key_url: Url pointing to a key or secret in KeyVault. Required.
        :paramtype key_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.key_url = key_url

class KeyVaultAndSecretReference(_serialization.Model):
    """Key Vault Secret Url and vault id of the encryption key.

    All required parameters must be populated in order to send to Azure.

    :ivar source_vault: Resource id of the KeyVault containing the key or secret. Required.
    :vartype source_vault: ~azure.mgmt.compute.models.SourceVault
    :ivar secret_url: Url pointing to a key or secret in KeyVault. Required.
    :vartype secret_url: str
    """

    _validation = {
        "source_vault": {"required": True},
        "secret_url": {"required": True},
    }

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SourceVault"},
        "secret_url": {"key": "secretUrl", "type": "str"},
    }

    def __init__(self, *, source_vault: "_models.SourceVault", secret_url: str, **kwargs: Any) -> None:
        """
        :keyword source_vault: Resource id of the KeyVault containing the key or secret. Required.
        :paramtype source_vault: ~azure.mgmt.compute.models.SourceVault
        :keyword secret_url: Url pointing to a key or secret in KeyVault. Required.
        :paramtype secret_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url

class ManagedDiskParameters(SubResource):
    """The parameters of a managed disk.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    :ivar security_profile: Specifies the security profile for the managed disk.
    :vartype security_profile: ~azure.mgmt.compute.models.VMDiskSecurityProfile
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "security_profile": {"key": "securityProfile", "type": "VMDiskSecurityProfile"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        security_profile: Optional["_models.VMDiskSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
         "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed disk.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        :keyword security_profile: Specifies the security profile for the managed disk.
        :paramtype security_profile: ~azure.mgmt.compute.models.VMDiskSecurityProfile
        """
        super().__init__(id=id, **kwargs)
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set
        self.security_profile = security_profile

class ResourceUpdate(_serialization.Model):
    """The Resource model definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The disks and snapshots sku name. Can be Standard_LRS or Premium_LRS.
    :vartype sku: ~azure.mgmt.compute.models.DiskSku
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "DiskSku"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, sku: Optional["_models.DiskSku"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The disks and snapshots sku name. Can be Standard_LRS or Premium_LRS.
        :paramtype sku: ~azure.mgmt.compute.models.DiskSku
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.sku = sku

class Snapshot(Resource):  # pylint: disable=too-many-instance-attributes
    """Snapshot resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar managed_by: Unused. Always Null.
    :vartype managed_by: str
    :ivar sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is
     an optional parameter for incremental snapshot and the default behavior is the SKU will be set
     to the same sku as the previous snapshot.
    :vartype sku: ~azure.mgmt.compute.models.SnapshotSku
    :ivar extended_location: The extended location where the snapshot will be created. Extended
     location cannot be changed.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar time_created: The time when the snapshot was created.
    :vartype time_created: ~datetime.datetime
    :ivar os_type: The Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar purchase_plan: Purchase plan information for the image from which the source disk for the
     snapshot was originally created.
    :vartype purchase_plan: ~azure.mgmt.compute.models.PurchasePlan
    :ivar supported_capabilities: List of supported capabilities for the image from which the
     source disk from the snapshot was originally created.
    :vartype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
    :ivar creation_data: Disk source information. CreationData information cannot be changed after
     the disk has been created.
    :vartype creation_data: ~azure.mgmt.compute.models.CreationData
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar disk_size_bytes: The size of the disk in bytes. This field is read only.
    :vartype disk_size_bytes: int
    :ivar disk_state: The state of the snapshot. Known values are: "Unattached", "Attached",
     "Reserved", "Frozen", "ActiveSAS", "ActiveSASFrozen", "ReadyToUpload", and "ActiveUpload".
    :vartype disk_state: str or ~azure.mgmt.compute.models.DiskState
    :ivar unique_id: Unique Guid identifying the resource.
    :vartype unique_id: str
    :ivar encryption_settings_collection: Encryption settings collection used be Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :vartype encryption_settings_collection:
     ~azure.mgmt.compute.models.EncryptionSettingsCollection
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    :ivar incremental: Whether a snapshot is incremental. Incremental snapshots on the same disk
     occupy less space than full snapshots and can be diffed.
    :vartype incremental: bool
    :ivar incremental_snapshot_family_id: Incremental snapshots for a disk share an incremental
     snapshot family id. The Get Page Range Diff API can only be called on incremental snapshots
     with the same family id.
    :vartype incremental_snapshot_family_id: str
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.models.Encryption
    :ivar network_access_policy: Policy for accessing the disk via network. Known values are:
     "AllowAll", "AllowPrivate", and "DenyAll".
    :vartype network_access_policy: str or
     ~azure.mgmt.compute.models.NetworkAccessPolicy
    :ivar disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :vartype disk_access_id: str
    :ivar security_profile: Contains the security related information for the resource.
    :vartype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
    :ivar supports_hibernation: Indicates the OS on a snapshot supports hibernation.
    :vartype supports_hibernation: bool
    :ivar public_network_access: Policy for controlling export on the disk. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.compute.models.PublicNetworkAccess
    :ivar completion_percent: Percentage complete for the background copy when a resource is
     created via the CopyStart operation.
    :vartype completion_percent: float
    :ivar copy_completion_error: Indicates the error details if the background copy of a resource
     created via the CopyStart operation fails.
    :vartype copy_completion_error: ~azure.mgmt.compute.models.CopyCompletionError
    :ivar data_access_auth_mode: Additional authentication requirements when exporting or uploading
     to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
    :vartype data_access_auth_mode: str or
     ~azure.mgmt.compute.models.DataAccessAuthMode
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "managed_by": {"readonly": True},
        "time_created": {"readonly": True},
        "disk_size_bytes": {"readonly": True},
        "disk_state": {"readonly": True},
        "unique_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "incremental_snapshot_family_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "SnapshotSku"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "PurchasePlan"},
        "supported_capabilities": {"key": "properties.supportedCapabilities", "type": "SupportedCapabilities"},
        "creation_data": {"key": "properties.creationData", "type": "CreationData"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "disk_size_bytes": {"key": "properties.diskSizeBytes", "type": "int"},
        "disk_state": {"key": "properties.diskState", "type": "str"},
        "unique_id": {"key": "properties.uniqueId", "type": "str"},
        "encryption_settings_collection": {
            "key": "properties.encryptionSettingsCollection",
            "type": "EncryptionSettingsCollection",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "incremental": {"key": "properties.incremental", "type": "bool"},
        "incremental_snapshot_family_id": {"key": "properties.incrementalSnapshotFamilyId", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "network_access_policy": {"key": "properties.networkAccessPolicy", "type": "str"},
        "disk_access_id": {"key": "properties.diskAccessId", "type": "str"},
        "security_profile": {"key": "properties.securityProfile", "type": "DiskSecurityProfile"},
        "supports_hibernation": {"key": "properties.supportsHibernation", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "completion_percent": {"key": "properties.completionPercent", "type": "float"},
        "copy_completion_error": {"key": "properties.copyCompletionError", "type": "CopyCompletionError"},
        "data_access_auth_mode": {"key": "properties.dataAccessAuthMode", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.SnapshotSku"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        purchase_plan: Optional["_models.PurchasePlan"] = None,
        supported_capabilities: Optional["_models.SupportedCapabilities"] = None,
        creation_data: Optional["_models.CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["_models.EncryptionSettingsCollection"] = None,
        incremental: Optional[bool] = None,
        encryption: Optional["_models.Encryption"] = None,
        network_access_policy: Optional[Union[str, "_models.NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        security_profile: Optional["_models.DiskSecurityProfile"] = None,
        supports_hibernation: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        completion_percent: Optional[float] = None,
        copy_completion_error: Optional["_models.CopyCompletionError"] = None,
        data_access_auth_mode: Optional[Union[str, "_models.DataAccessAuthMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This
         is an optional parameter for incremental snapshot and the default behavior is the SKU will be
         set to the same sku as the previous snapshot.
        :paramtype sku: ~azure.mgmt.compute.models.SnapshotSku
        :keyword extended_location: The extended location where the snapshot will be created. Extended
         location cannot be changed.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        :keyword os_type: The Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword purchase_plan: Purchase plan information for the image from which the source disk for
         the snapshot was originally created.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.PurchasePlan
        :keyword supported_capabilities: List of supported capabilities for the image from which the
         source disk from the snapshot was originally created.
        :paramtype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
        :keyword creation_data: Disk source information. CreationData information cannot be changed
         after the disk has been created.
        :paramtype creation_data: ~azure.mgmt.compute.models.CreationData
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the disk to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings_collection: Encryption settings collection used be Azure Disk
         Encryption, can contain multiple encryption settings per disk or snapshot.
        :paramtype encryption_settings_collection:
         ~azure.mgmt.compute.models.EncryptionSettingsCollection
        :keyword incremental: Whether a snapshot is incremental. Incremental snapshots on the same disk
         occupy less space than full snapshots and can be diffed.
        :paramtype incremental: bool
        :keyword encryption: Encryption property can be used to encrypt data at rest with customer
         managed keys or platform managed keys.
        :paramtype encryption: ~azure.mgmt.compute.models.Encryption
        :keyword network_access_policy: Policy for accessing the disk via network. Known values are:
         "AllowAll", "AllowPrivate", and "DenyAll".
        :paramtype network_access_policy: str or
         ~azure.mgmt.compute.models.NetworkAccessPolicy
        :keyword disk_access_id: ARM id of the DiskAccess resource for using private endpoints on
         disks.
        :paramtype disk_access_id: str
        :keyword security_profile: Contains the security related information for the resource.
        :paramtype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
        :keyword supports_hibernation: Indicates the OS on a snapshot supports hibernation.
        :paramtype supports_hibernation: bool
        :keyword public_network_access: Policy for controlling export on the disk. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.compute.models.PublicNetworkAccess
        :keyword completion_percent: Percentage complete for the background copy when a resource is
         created via the CopyStart operation.
        :paramtype completion_percent: float
        :keyword copy_completion_error: Indicates the error details if the background copy of a
         resource created via the CopyStart operation fails.
        :paramtype copy_completion_error: ~azure.mgmt.compute.models.CopyCompletionError
        :keyword data_access_auth_mode: Additional authentication requirements when exporting or
         uploading to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
        :paramtype data_access_auth_mode: str or
         ~azure.mgmt.compute.models.DataAccessAuthMode
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.managed_by = None
        self.sku = sku
        self.extended_location = extended_location
        self.time_created = None
        self.os_type = os_type
        self.hyper_v_generation = hyper_v_generation
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.disk_size_bytes = None
        self.disk_state = None
        self.unique_id = None
        self.encryption_settings_collection = encryption_settings_collection
        self.provisioning_state = None
        self.incremental = incremental
        self.incremental_snapshot_family_id = None
        self.encryption = encryption
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.security_profile = security_profile
        self.supports_hibernation = supports_hibernation
        self.public_network_access = public_network_access
        self.completion_percent = completion_percent
        self.copy_completion_error = copy_completion_error
        self.data_access_auth_mode = data_access_auth_mode

class SnapshotList(_serialization.Model):
    """The List Snapshots operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of snapshots. Required.
    :vartype value: list[~azure.mgmt.compute.models.Snapshot]
    :ivar next_link: The uri to fetch the next page of snapshots. Call ListNext() with this to
     fetch the next page of snapshots.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Snapshot]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Snapshot"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of snapshots. Required.
        :paramtype value: list[~azure.mgmt.compute.models.Snapshot]
        :keyword next_link: The uri to fetch the next page of snapshots. Call ListNext() with this to
         fetch the next page of snapshots.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class SnapshotUpdate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Snapshot update resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is
     an optional parameter for incremental snapshot and the default behavior is the SKU will be set
     to the same sku as the previous snapshot.
    :vartype sku: ~azure.mgmt.compute.models.SnapshotSku
    :ivar os_type: the Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :vartype disk_size_gb: int
    :ivar encryption_settings_collection: Encryption settings collection used be Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :vartype encryption_settings_collection:
     ~azure.mgmt.compute.models.EncryptionSettingsCollection
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.models.Encryption
    :ivar network_access_policy: Policy for accessing the disk via network. Known values are:
     "AllowAll", "AllowPrivate", and "DenyAll".
    :vartype network_access_policy: str or
     ~azure.mgmt.compute.models.NetworkAccessPolicy
    :ivar disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :vartype disk_access_id: str
    :ivar supports_hibernation: Indicates the OS on a snapshot supports hibernation.
    :vartype supports_hibernation: bool
    :ivar public_network_access: Policy for controlling export on the disk. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.compute.models.PublicNetworkAccess
    :ivar data_access_auth_mode: Additional authentication requirements when exporting or uploading
     to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
    :vartype data_access_auth_mode: str or
     ~azure.mgmt.compute.models.DataAccessAuthMode
    :ivar supported_capabilities: List of supported capabilities for the image from which the OS
     disk was created.
    :vartype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "SnapshotSku"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "disk_size_gb": {"key": "properties.diskSizeGB", "type": "int"},
        "encryption_settings_collection": {
            "key": "properties.encryptionSettingsCollection",
            "type": "EncryptionSettingsCollection",
        },
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "network_access_policy": {"key": "properties.networkAccessPolicy", "type": "str"},
        "disk_access_id": {"key": "properties.diskAccessId", "type": "str"},
        "supports_hibernation": {"key": "properties.supportsHibernation", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "data_access_auth_mode": {"key": "properties.dataAccessAuthMode", "type": "str"},
        "supported_capabilities": {"key": "properties.supportedCapabilities", "type": "SupportedCapabilities"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.SnapshotSku"] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["_models.EncryptionSettingsCollection"] = None,
        encryption: Optional["_models.Encryption"] = None,
        network_access_policy: Optional[Union[str, "_models.NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        supports_hibernation: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        data_access_auth_mode: Optional[Union[str, "_models.DataAccessAuthMode"]] = None,
        supported_capabilities: Optional["_models.SupportedCapabilities"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This
         is an optional parameter for incremental snapshot and the default behavior is the SKU will be
         set to the same sku as the previous snapshot.
        :paramtype sku: ~azure.mgmt.compute.models.SnapshotSku
        :keyword os_type: the Operating System type. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
         indicates the size of the disk to create. If this field is present for updates or creation with
         other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
         running VM, and can only increase the disk's size.
        :paramtype disk_size_gb: int
        :keyword encryption_settings_collection: Encryption settings collection used be Azure Disk
         Encryption, can contain multiple encryption settings per disk or snapshot.
        :paramtype encryption_settings_collection:
         ~azure.mgmt.compute.models.EncryptionSettingsCollection
        :keyword encryption: Encryption property can be used to encrypt data at rest with customer
         managed keys or platform managed keys.
        :paramtype encryption: ~azure.mgmt.compute.models.Encryption
        :keyword network_access_policy: Policy for accessing the disk via network. Known values are:
         "AllowAll", "AllowPrivate", and "DenyAll".
        :paramtype network_access_policy: str or
         ~azure.mgmt.compute.models.NetworkAccessPolicy
        :keyword disk_access_id: ARM id of the DiskAccess resource for using private endpoints on
         disks.
        :paramtype disk_access_id: str
        :keyword supports_hibernation: Indicates the OS on a snapshot supports hibernation.
        :paramtype supports_hibernation: bool
        :keyword public_network_access: Policy for controlling export on the disk. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.compute.models.PublicNetworkAccess
        :keyword data_access_auth_mode: Additional authentication requirements when exporting or
         uploading to a disk or snapshot. Known values are: "AzureActiveDirectory" and "None".
        :paramtype data_access_auth_mode: str or
         ~azure.mgmt.compute.models.DataAccessAuthMode
        :keyword supported_capabilities: List of supported capabilities for the image from which the OS
         disk was created.
        :paramtype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.os_type = os_type
        self.disk_size_gb = disk_size_gb
        self.encryption_settings_collection = encryption_settings_collection
        self.encryption = encryption
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.supports_hibernation = supports_hibernation
        self.public_network_access = public_network_access
        self.data_access_auth_mode = data_access_auth_mode
        self.supported_capabilities = supported_capabilities

class SourceVault(_serialization.Model):
    """The vault id is an Azure Resource Manager Resource id in the form
    /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id

class VirtualMachineScaleSetDataDisk(_serialization.Model):
    """Describes a virtual machine scale set data disk.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The disk name.
    :vartype name: str
    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
     Required.
    :vartype lun: int
    :ivar caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar create_option: The create option. Required. Known values are: "FromImage", "Empty", and
     "Attach".
    :vartype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than
     1023.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetManagedDiskParameters
    :ivar disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk. Should be used
     only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be
     assigned based on diskSizeGB.
    :vartype disk_iops_read_write: int
    :ivar disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk.
     Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value
     would be assigned based on diskSizeGB.
    :vartype disk_m_bps_read_write: int
    :ivar delete_option: Specifies whether data disk should be deleted or detached upon VMSS Flex
     deletion (This feature is available for VMSS with Flexible OrchestrationMode
     only).:code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
     value is used, the data disk is deleted when the VMSS Flex VM is
     deleted.:code:`<br>`:code:`<br>` **Detach** If this value is used, the data disk is retained
     after VMSS Flex VM is deleted.:code:`<br>`:code:`<br>` The default value is set to **Delete**.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
    """

    _validation = {
        "lun": {"required": True},
        "create_option": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "create_option": {"key": "createOption", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
        "disk_iops_read_write": {"key": "diskIOPSReadWrite", "type": "int"},
        "disk_m_bps_read_write": {"key": "diskMBpsReadWrite", "type": "int"},
        "delete_option": {"key": "deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "_models.DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        disk_iops_read_write: Optional[int] = None,
        disk_m_bps_read_write: Optional[int] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The disk name.
        :paramtype name: str
        :keyword lun: Specifies the logical unit number of the data disk. This value is used to
         identify data disks within the VM and therefore must be unique for each data disk attached to a
         VM. Required.
        :paramtype lun: int
        :keyword caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
         are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
         :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
         storage. ReadOnly for Premium storage**. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword create_option: The create option. Required. Known values are: "FromImage", "Empty",
         and "Attach".
        :paramtype create_option: str or ~azure.mgmt.compute.models.DiskCreateOptionTypes
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than
         1023.
        :paramtype disk_size_gb: int
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetManagedDiskParameters
        :keyword disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk. Should be
         used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be
         assigned based on diskSizeGB.
        :paramtype disk_iops_read_write: int
        :keyword disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk.
         Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value
         would be assigned based on diskSizeGB.
        :paramtype disk_m_bps_read_write: int
        :keyword delete_option: Specifies whether data disk should be deleted or detached upon VMSS
         Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode
         only).:code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
         value is used, the data disk is deleted when the VMSS Flex VM is
         deleted.:code:`<br>`:code:`<br>` **Detach** If this value is used, the data disk is retained
         after VMSS Flex VM is deleted.:code:`<br>`:code:`<br>` The default value is set to **Delete**.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.lun = lun
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_m_bps_read_write = disk_m_bps_read_write
        self.delete_option = delete_option

class VirtualMachineScaleSetManagedDiskParameters(_serialization.Model):
    """Describes the parameters of a ScaleSet managed disk.

    :ivar storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
     are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.compute.models.StorageAccountTypes
    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :vartype disk_encryption_set:
     ~azure.mgmt.compute.models.DiskEncryptionSetParameters
    :ivar security_profile: Specifies the security profile for the managed disk.
    :vartype security_profile: ~azure.mgmt.compute.models.VMDiskSecurityProfile
    """

    _attribute_map = {
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "disk_encryption_set": {"key": "diskEncryptionSet", "type": "DiskEncryptionSetParameters"},
        "security_profile": {"key": "securityProfile", "type": "VMDiskSecurityProfile"},
    }

    def __init__(
        self,
        *,
        storage_account_type: Optional[Union[str, "_models.StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        security_profile: Optional["_models.VMDiskSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_account_type: Specifies the storage account type for the managed disk. NOTE:
         UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Known values
         are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
         "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.models.StorageAccountTypes
        :keyword disk_encryption_set: Specifies the customer managed disk encryption set resource id
         for the managed disk.
        :paramtype disk_encryption_set:
         ~azure.mgmt.compute.models.DiskEncryptionSetParameters
        :keyword security_profile: Specifies the security profile for the managed disk.
        :paramtype security_profile: ~azure.mgmt.compute.models.VMDiskSecurityProfile
        """
        super().__init__(**kwargs)
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set
        self.security_profile = security_profile

class DiskSku(_serialization.Model):
    """The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS,
    Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name. Known values are: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS",
     "UltraSSD_LRS", "Premium_ZRS", "StandardSSD_ZRS", and "PremiumV2_LRS".
    :vartype name: str or ~azure.mgmt.compute.models.DiskStorageAccountTypes
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _validation = {
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, name: Optional[Union[str, "_models.DiskStorageAccountTypes"]] = None, **kwargs: Any) -> None:
        """
        :keyword name: The sku name. Known values are: "Standard_LRS", "Premium_LRS",
         "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", "StandardSSD_ZRS", and "PremiumV2_LRS".
        :paramtype name: str or ~azure.mgmt.compute.models.DiskStorageAccountTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = None

class MaintenanceRedeployStatus(_serialization.Model):
    """Maintenance Operation Status.

    :ivar is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
     Maintenance.
    :vartype is_customer_initiated_maintenance_allowed: bool
    :ivar pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
    :vartype pre_maintenance_window_start_time: ~datetime.datetime
    :ivar pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
    :vartype pre_maintenance_window_end_time: ~datetime.datetime
    :ivar maintenance_window_start_time: Start Time for the Maintenance Window.
    :vartype maintenance_window_start_time: ~datetime.datetime
    :ivar maintenance_window_end_time: End Time for the Maintenance Window.
    :vartype maintenance_window_end_time: ~datetime.datetime
    :ivar last_operation_result_code: The Last Maintenance Operation Result Code. Known values are:
     "None", "RetryLater", "MaintenanceAborted", and "MaintenanceCompleted".
    :vartype last_operation_result_code: str or
     ~azure.mgmt.compute.models.MaintenanceOperationResultCodeTypes
    :ivar last_operation_message: Message returned for the last Maintenance Operation.
    :vartype last_operation_message: str
    """

    _attribute_map = {
        "is_customer_initiated_maintenance_allowed": {"key": "isCustomerInitiatedMaintenanceAllowed", "type": "bool"},
        "pre_maintenance_window_start_time": {"key": "preMaintenanceWindowStartTime", "type": "iso-8601"},
        "pre_maintenance_window_end_time": {"key": "preMaintenanceWindowEndTime", "type": "iso-8601"},
        "maintenance_window_start_time": {"key": "maintenanceWindowStartTime", "type": "iso-8601"},
        "maintenance_window_end_time": {"key": "maintenanceWindowEndTime", "type": "iso-8601"},
        "last_operation_result_code": {"key": "lastOperationResultCode", "type": "str"},
        "last_operation_message": {"key": "lastOperationMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_customer_initiated_maintenance_allowed: Optional[bool] = None,
        pre_maintenance_window_start_time: Optional[datetime.datetime] = None,
        pre_maintenance_window_end_time: Optional[datetime.datetime] = None,
        maintenance_window_start_time: Optional[datetime.datetime] = None,
        maintenance_window_end_time: Optional[datetime.datetime] = None,
        last_operation_result_code: Optional[Union[str, "_models.MaintenanceOperationResultCodeTypes"]] = None,
        last_operation_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
         Maintenance.
        :paramtype is_customer_initiated_maintenance_allowed: bool
        :keyword pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
        :paramtype pre_maintenance_window_start_time: ~datetime.datetime
        :keyword pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
        :paramtype pre_maintenance_window_end_time: ~datetime.datetime
        :keyword maintenance_window_start_time: Start Time for the Maintenance Window.
        :paramtype maintenance_window_start_time: ~datetime.datetime
        :keyword maintenance_window_end_time: End Time for the Maintenance Window.
        :paramtype maintenance_window_end_time: ~datetime.datetime
        :keyword last_operation_result_code: The Last Maintenance Operation Result Code. Known values
         are: "None", "RetryLater", "MaintenanceAborted", and "MaintenanceCompleted".
        :paramtype last_operation_result_code: str or
         ~azure.mgmt.compute.models.MaintenanceOperationResultCodeTypes
        :keyword last_operation_message: Message returned for the last Maintenance Operation.
        :paramtype last_operation_message: str
        """
        super().__init__(**kwargs)
        self.is_customer_initiated_maintenance_allowed = is_customer_initiated_maintenance_allowed
        self.pre_maintenance_window_start_time = pre_maintenance_window_start_time
        self.pre_maintenance_window_end_time = pre_maintenance_window_end_time
        self.maintenance_window_start_time = maintenance_window_start_time
        self.maintenance_window_end_time = maintenance_window_end_time
        self.last_operation_result_code = last_operation_result_code
        self.last_operation_message = last_operation_message

class ResourceSku(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes an available Compute SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU.
    :vartype name: str
    :ivar tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br />`
     Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
     **Basic**.
    :vartype tier: str
    :ivar size: The Size of the SKU.
    :vartype size: str
    :ivar family: The Family of this particular SKU.
    :vartype family: str
    :ivar kind: The Kind of resources that are supported in this SKU.
    :vartype kind: str
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: ~azure.mgmt.compute.models.ResourceSkuCapacity
    :ivar locations: The set of locations that the SKU is available.
    :vartype locations: list[str]
    :ivar location_info: A list of locations and availability zones in those locations where the
     SKU is available.
    :vartype location_info: list[~azure.mgmt.compute.models.ResourceSkuLocationInfo]
    :ivar api_versions: The api versions that support this SKU.
    :vartype api_versions: list[str]
    :ivar costs: Metadata for retrieving price info.
    :vartype costs: list[~azure.mgmt.compute.models.ResourceSkuCosts]
    :ivar capabilities: A name value pair to describe the capability.
    :vartype capabilities: list[~azure.mgmt.compute.models.ResourceSkuCapabilities]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.compute.models.ResourceSkuRestrictions]
    """

    _validation = {
        "resource_type": {"readonly": True},
        "name": {"readonly": True},
        "tier": {"readonly": True},
        "size": {"readonly": True},
        "family": {"readonly": True},
        "kind": {"readonly": True},
        "capacity": {"readonly": True},
        "locations": {"readonly": True},
        "location_info": {"readonly": True},
        "api_versions": {"readonly": True},
        "costs": {"readonly": True},
        "capabilities": {"readonly": True},
        "restrictions": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "capacity": {"key": "capacity", "type": "ResourceSkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "location_info": {"key": "locationInfo", "type": "[ResourceSkuLocationInfo]"},
        "api_versions": {"key": "apiVersions", "type": "[str]"},
        "costs": {"key": "costs", "type": "[ResourceSkuCosts]"},
        "capabilities": {"key": "capabilities", "type": "[ResourceSkuCapabilities]"},
        "restrictions": {"key": "restrictions", "type": "[ResourceSkuRestrictions]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.tier = None
        self.size = None
        self.family = None
        self.kind = None
        self.capacity = None
        self.locations = None
        self.location_info = None
        self.api_versions = None
        self.costs = None
        self.capabilities = None
        self.restrictions = None

class ResourceSkuCapabilities(_serialization.Model):
    """Describes The SKU capabilities object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: An invariant to describe the feature.
    :vartype name: str
    :ivar value: An invariant if the feature is measured by quantity.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None

class ResourceSkuCapacity(_serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar scale_type: The scale type applicable to the sku. Known values are: "Automatic",
     "Manual", and "None".
    :vartype scale_type: str or ~azure.mgmt.compute.models.ResourceSkuCapacityScaleType
    """

    _validation = {
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "default": {"readonly": True},
        "scale_type": {"readonly": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None

class ResourceSkuCosts(_serialization.Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Used for querying price from commerce.
    :vartype meter_id: str
    :ivar quantity: The multiplier is needed to extend the base metered cost.
    :vartype quantity: int
    :ivar extended_unit: An invariant to show the extended unit.
    :vartype extended_unit: str
    """

    _validation = {
        "meter_id": {"readonly": True},
        "quantity": {"readonly": True},
        "extended_unit": {"readonly": True},
    }

    _attribute_map = {
        "meter_id": {"key": "meterID", "type": "str"},
        "quantity": {"key": "quantity", "type": "int"},
        "extended_unit": {"key": "extendedUnit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.meter_id = None
        self.quantity = None
        self.extended_unit = None

class ResourceSkuRestrictions(_serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. Known values are: "Location" and "Zone".
    :vartype type: str or ~azure.mgmt.compute.models.ResourceSkuRestrictionsType
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar restriction_info: The information about the restriction where the SKU cannot be used.
    :vartype restriction_info: ~azure.mgmt.compute.models.ResourceSkuRestrictionInfo
    :ivar reason_code: The reason for restriction. Known values are: "QuotaId" and
     "NotAvailableForSubscription".
    :vartype reason_code: str or
     ~azure.mgmt.compute.models.ResourceSkuRestrictionsReasonCode
    """

    _validation = {
        "type": {"readonly": True},
        "values": {"readonly": True},
        "restriction_info": {"readonly": True},
        "reason_code": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "restriction_info": {"key": "restrictionInfo", "type": "ResourceSkuRestrictionInfo"},
        "reason_code": {"key": "reasonCode", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.values = None
        self.restriction_info = None
        self.reason_code = None

class ResourceSkusResult(_serialization.Model):
    """The List Resource Skus operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of skus available for the subscription. Required.
    :vartype value: list[~azure.mgmt.compute.models.ResourceSku]
    :ivar next_link: The URI to fetch the next page of Resource Skus. Call ListNext() with this URI
     to fetch the next page of Resource Skus.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceSku"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of skus available for the subscription. Required.
        :paramtype value: list[~azure.mgmt.compute.models.ResourceSku]
        :keyword next_link: The URI to fetch the next page of Resource Skus. Call ListNext() with this
         URI to fetch the next page of Resource Skus.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class RollingUpgradePolicy(_serialization.Model):
    """The configuration parameters used while performing a rolling upgrade.

    :ivar max_batch_instance_percent: The maximum percent of total virtual machine instances that
     will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
     unhealthy instances in previous or future batches can cause the percentage of instances in a
     batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
    :vartype max_batch_instance_percent: int
    :ivar max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
     instances in the scale set that can be simultaneously unhealthy, either as a result of being
     upgraded, or by being found in an unhealthy state by the virtual machine health checks before
     the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
     default value for this parameter is 20%.
    :vartype max_unhealthy_instance_percent: int
    :ivar max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
     machine instances that can be found to be in an unhealthy state. This check will happen after
     each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
     default value for this parameter is 20%.
    :vartype max_unhealthy_upgraded_instance_percent: int
    :ivar pause_time_between_batches: The wait time between completing the update for all virtual
     machines in one batch and starting the next batch. The time duration should be specified in ISO
     8601 format. The default value is 0 seconds (PT0S).
    :vartype pause_time_between_batches: str
    :ivar enable_cross_zone_upgrade: Allow VMSS to ignore AZ boundaries when constructing upgrade
     batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the
     batch size.
    :vartype enable_cross_zone_upgrade: bool
    :ivar prioritize_unhealthy_instances: Upgrade all unhealthy instances in a scale set before any
     healthy instances.
    :vartype prioritize_unhealthy_instances: bool
    :ivar rollback_failed_instances_on_policy_breach: Rollback failed instances to previous model
     if the Rolling Upgrade policy is violated.
    :vartype rollback_failed_instances_on_policy_breach: bool
    :ivar max_surge: Create new virtual machines to upgrade the scale set, rather than updating the
     existing virtual machines. Existing virtual machines will be deleted once the new virtual
     machines are created for each batch.
    :vartype max_surge: bool
    """

    _validation = {
        "max_batch_instance_percent": {"maximum": 100, "minimum": 5},
        "max_unhealthy_instance_percent": {"maximum": 100, "minimum": 5},
        "max_unhealthy_upgraded_instance_percent": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "max_batch_instance_percent": {"key": "maxBatchInstancePercent", "type": "int"},
        "max_unhealthy_instance_percent": {"key": "maxUnhealthyInstancePercent", "type": "int"},
        "max_unhealthy_upgraded_instance_percent": {"key": "maxUnhealthyUpgradedInstancePercent", "type": "int"},
        "pause_time_between_batches": {"key": "pauseTimeBetweenBatches", "type": "str"},
        "enable_cross_zone_upgrade": {"key": "enableCrossZoneUpgrade", "type": "bool"},
        "prioritize_unhealthy_instances": {"key": "prioritizeUnhealthyInstances", "type": "bool"},
        "rollback_failed_instances_on_policy_breach": {"key": "rollbackFailedInstancesOnPolicyBreach", "type": "bool"},
        "max_surge": {"key": "maxSurge", "type": "bool"},
    }

    def __init__(
        self,
        *,
        max_batch_instance_percent: Optional[int] = None,
        max_unhealthy_instance_percent: Optional[int] = None,
        max_unhealthy_upgraded_instance_percent: Optional[int] = None,
        pause_time_between_batches: Optional[str] = None,
        enable_cross_zone_upgrade: Optional[bool] = None,
        prioritize_unhealthy_instances: Optional[bool] = None,
        rollback_failed_instances_on_policy_breach: Optional[bool] = None,
        max_surge: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_batch_instance_percent: The maximum percent of total virtual machine instances
         that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
         unhealthy instances in previous or future batches can cause the percentage of instances in a
         batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
        :paramtype max_batch_instance_percent: int
        :keyword max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
         instances in the scale set that can be simultaneously unhealthy, either as a result of being
         upgraded, or by being found in an unhealthy state by the virtual machine health checks before
         the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
         default value for this parameter is 20%.
        :paramtype max_unhealthy_instance_percent: int
        :keyword max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
         machine instances that can be found to be in an unhealthy state. This check will happen after
         each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
         default value for this parameter is 20%.
        :paramtype max_unhealthy_upgraded_instance_percent: int
        :keyword pause_time_between_batches: The wait time between completing the update for all
         virtual machines in one batch and starting the next batch. The time duration should be
         specified in ISO 8601 format. The default value is 0 seconds (PT0S).
        :paramtype pause_time_between_batches: str
        :keyword enable_cross_zone_upgrade: Allow VMSS to ignore AZ boundaries when constructing
         upgrade batches. Take into consideration the Update Domain and maxBatchInstancePercent to
         determine the batch size.
        :paramtype enable_cross_zone_upgrade: bool
        :keyword prioritize_unhealthy_instances: Upgrade all unhealthy instances in a scale set before
         any healthy instances.
        :paramtype prioritize_unhealthy_instances: bool
        :keyword rollback_failed_instances_on_policy_breach: Rollback failed instances to previous
         model if the Rolling Upgrade policy is violated.
        :paramtype rollback_failed_instances_on_policy_breach: bool
        :keyword max_surge: Create new virtual machines to upgrade the scale set, rather than updating
         the existing virtual machines. Existing virtual machines will be deleted once the new virtual
         machines are created for each batch.
        :paramtype max_surge: bool
        """
        super().__init__(**kwargs)
        self.max_batch_instance_percent = max_batch_instance_percent
        self.max_unhealthy_instance_percent = max_unhealthy_instance_percent
        self.max_unhealthy_upgraded_instance_percent = max_unhealthy_upgraded_instance_percent
        self.pause_time_between_batches = pause_time_between_batches
        self.enable_cross_zone_upgrade = enable_cross_zone_upgrade
        self.prioritize_unhealthy_instances = prioritize_unhealthy_instances
        self.rollback_failed_instances_on_policy_breach = rollback_failed_instances_on_policy_breach
        self.max_surge = max_surge

class RollingUpgradeProgressInfo(_serialization.Model):
    """Information about the number of virtual machine instances in each upgrade state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successful_instance_count: The number of instances that have been successfully upgraded.
    :vartype successful_instance_count: int
    :ivar failed_instance_count: The number of instances that have failed to be upgraded
     successfully.
    :vartype failed_instance_count: int
    :ivar in_progress_instance_count: The number of instances that are currently being upgraded.
    :vartype in_progress_instance_count: int
    :ivar pending_instance_count: The number of instances that have not yet begun to be upgraded.
    :vartype pending_instance_count: int
    """

    _validation = {
        "successful_instance_count": {"readonly": True},
        "failed_instance_count": {"readonly": True},
        "in_progress_instance_count": {"readonly": True},
        "pending_instance_count": {"readonly": True},
    }

    _attribute_map = {
        "successful_instance_count": {"key": "successfulInstanceCount", "type": "int"},
        "failed_instance_count": {"key": "failedInstanceCount", "type": "int"},
        "in_progress_instance_count": {"key": "inProgressInstanceCount", "type": "int"},
        "pending_instance_count": {"key": "pendingInstanceCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.successful_instance_count = None
        self.failed_instance_count = None
        self.in_progress_instance_count = None
        self.pending_instance_count = None

class RollingUpgradeRunningStatus(_serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Known values are:
     "RollingForward", "Cancelled", "Completed", and "Faulted".
    :vartype code: str or ~azure.mgmt.compute.models.RollingUpgradeStatusCode
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar last_action: The last action performed on the rolling upgrade. Known values are: "Start"
     and "Cancel".
    :vartype last_action: str or ~azure.mgmt.compute.models.RollingUpgradeActionType
    :ivar last_action_time: Last action time of the upgrade.
    :vartype last_action_time: ~datetime.datetime
    """

    _validation = {
        "code": {"readonly": True},
        "start_time": {"readonly": True},
        "last_action": {"readonly": True},
        "last_action_time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_action": {"key": "lastAction", "type": "str"},
        "last_action_time": {"key": "lastActionTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.last_action = None
        self.last_action_time = None

class RollingUpgradeStatusInfo(Resource):
    """The status of the latest virtual machine scale set rolling upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar policy: The rolling upgrade policies applied for this upgrade.
    :vartype policy: ~azure.mgmt.compute.models.RollingUpgradePolicy
    :ivar running_status: Information about the current running state of the overall upgrade.
    :vartype running_status: ~azure.mgmt.compute.models.RollingUpgradeRunningStatus
    :ivar progress: Information about the number of virtual machine instances in each upgrade
     state.
    :vartype progress: ~azure.mgmt.compute.models.RollingUpgradeProgressInfo
    :ivar error: Error details for this upgrade, if there are any.
    :vartype error: ~azure.mgmt.compute.models.ApiError
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "policy": {"readonly": True},
        "running_status": {"readonly": True},
        "progress": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "policy": {"key": "properties.policy", "type": "RollingUpgradePolicy"},
        "running_status": {"key": "properties.runningStatus", "type": "RollingUpgradeRunningStatus"},
        "progress": {"key": "properties.progress", "type": "RollingUpgradeProgressInfo"},
        "error": {"key": "properties.error", "type": "ApiError"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.policy = None
        self.running_status = None
        self.progress = None
        self.error = None

class RunCommandDocumentBase(_serialization.Model):
    """Describes the properties of a Run Command metadata.

    All required parameters must be populated in order to send to Azure.

    :ivar schema: The VM run command schema. Required.
    :vartype schema: str
    :ivar id: The VM run command id. Required.
    :vartype id: str
    :ivar os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar label: The VM run command label. Required.
    :vartype label: str
    :ivar description: The VM run command description. Required.
    :vartype description: str
    """

    _validation = {
        "schema": {"required": True},
        "id": {"required": True},
        "os_type": {"required": True},
        "label": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "schema": {"key": "$schema", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,  # pylint: disable=redefined-builtin
        os_type: Union[str, "_models.OperatingSystemTypes"],
        label: str,
        description: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword schema: The VM run command schema. Required.
        :paramtype schema: str
        :keyword id: The VM run command id. Required.
        :paramtype id: str
        :keyword os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword label: The VM run command label. Required.
        :paramtype label: str
        :keyword description: The VM run command description. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.schema = schema
        self.id = id
        self.os_type = os_type
        self.label = label
        self.description = description

class RunCommandDocument(RunCommandDocumentBase):
    """Describes the properties of a Run Command.

    All required parameters must be populated in order to send to Azure.

    :ivar schema: The VM run command schema. Required.
    :vartype schema: str
    :ivar id: The VM run command id. Required.
    :vartype id: str
    :ivar os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar label: The VM run command label. Required.
    :vartype label: str
    :ivar description: The VM run command description. Required.
    :vartype description: str
    :ivar script: The script to be executed. Required.
    :vartype script: list[str]
    :ivar parameters: The parameters used by the script.
    :vartype parameters: list[~azure.mgmt.compute.models.RunCommandParameterDefinition]
    """

    _validation = {
        "schema": {"required": True},
        "id": {"required": True},
        "os_type": {"required": True},
        "label": {"required": True},
        "description": {"required": True},
        "script": {"required": True},
    }

    _attribute_map = {
        "schema": {"key": "$schema", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "script": {"key": "script", "type": "[str]"},
        "parameters": {"key": "parameters", "type": "[RunCommandParameterDefinition]"},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,  # pylint: disable=redefined-builtin
        os_type: Union[str, "_models.OperatingSystemTypes"],
        label: str,
        description: str,
        script: List[str],
        parameters: Optional[List["_models.RunCommandParameterDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schema: The VM run command schema. Required.
        :paramtype schema: str
        :keyword id: The VM run command id. Required.
        :paramtype id: str
        :keyword os_type: The Operating System type. Required. Known values are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword label: The VM run command label. Required.
        :paramtype label: str
        :keyword description: The VM run command description. Required.
        :paramtype description: str
        :keyword script: The script to be executed. Required.
        :paramtype script: list[str]
        :keyword parameters: The parameters used by the script.
        :paramtype parameters:
         list[~azure.mgmt.compute.models.RunCommandParameterDefinition]
        """
        super().__init__(schema=schema, id=id, os_type=os_type, label=label, description=description, **kwargs)
        self.script = script
        self.parameters = parameters

class RunCommandInput(_serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar command_id: The run command id. Required.
    :vartype command_id: str
    :ivar script: Optional. The script to be executed.  When this value is given, the given script
     will override the default script of the command.
    :vartype script: list[str]
    :ivar parameters: The run command parameters.
    :vartype parameters: list[~azure.mgmt.compute.models.RunCommandInputParameter]
    """

    _validation = {
        "command_id": {"required": True},
    }

    _attribute_map = {
        "command_id": {"key": "commandId", "type": "str"},
        "script": {"key": "script", "type": "[str]"},
        "parameters": {"key": "parameters", "type": "[RunCommandInputParameter]"},
    }

    def __init__(
        self,
        *,
        command_id: str,
        script: Optional[List[str]] = None,
        parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword command_id: The run command id. Required.
        :paramtype command_id: str
        :keyword script: Optional. The script to be executed.  When this value is given, the given
         script will override the default script of the command.
        :paramtype script: list[str]
        :keyword parameters: The run command parameters.
        :paramtype parameters: list[~azure.mgmt.compute.models.RunCommandInputParameter]
        """
        super().__init__(**kwargs)
        self.command_id = command_id
        self.script = script
        self.parameters = parameters

class RunCommandInputParameter(_serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The run command parameter name. Required.
    :vartype name: str
    :ivar value: The run command parameter value. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: str, **kwargs: Any) -> None:
        """
        :keyword name: The run command parameter name. Required.
        :paramtype name: str
        :keyword value: The run command parameter value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value

class RunCommandListResult(_serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of virtual machine run commands. Required.
    :vartype value: list[~azure.mgmt.compute.models.RunCommandDocumentBase]
    :ivar next_link: The uri to fetch the next page of run commands. Call ListNext() with this to
     fetch the next page of run commands.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RunCommandDocumentBase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.RunCommandDocumentBase"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of virtual machine run commands. Required.
        :paramtype value: list[~azure.mgmt.compute.models.RunCommandDocumentBase]
        :keyword next_link: The uri to fetch the next page of run commands. Call ListNext() with this
         to fetch the next page of run commands.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class RunCommandParameterDefinition(_serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The run command parameter name. Required.
    :vartype name: str
    :ivar type: The run command parameter type. Required.
    :vartype type: str
    :ivar default_value: The run command parameter default value.
    :vartype default_value: str
    :ivar required: The run command parameter required.
    :vartype required: bool
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "default_value": {"key": "defaultValue", "type": "str"},
        "required": {"key": "required", "type": "bool"},
    }

    def __init__(
        self, *, name: str, type: str, default_value: Optional[str] = None, required: bool = False, **kwargs: Any
    ) -> None:
        """
        :keyword name: The run command parameter name. Required.
        :paramtype name: str
        :keyword type: The run command parameter type. Required.
        :paramtype type: str
        :keyword default_value: The run command parameter default value.
        :paramtype default_value: str
        :keyword required: The run command parameter required.
        :paramtype required: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.default_value = default_value
        self.required = required

class RunCommandResult(_serialization.Model):
    """RunCommandResult.

    :ivar value: Run command operation response.
    :vartype value: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[InstanceViewStatus]"},
    }

    def __init__(self, *, value: Optional[List["_models.InstanceViewStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Run command operation response.
        :paramtype value: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.value = value

class VirtualMachineHealthStatus(_serialization.Model):
    """The health status of the VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The health status information for the VM.
    :vartype status: ~azure.mgmt.compute.models.InstanceViewStatus
    """

    _validation = {
        "status": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "InstanceViewStatus"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None

class VirtualMachineScaleSetExtensionListResult(_serialization.Model):
    """The List VM scale set extension operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of VM scale set extensions. Required.
    :vartype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSetExtension]
    :ivar next_link: The uri to fetch the next page of VM scale set extensions. Call ListNext()
     with this to fetch the next page of VM scale set extensions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetExtension]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineScaleSetExtension"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of VM scale set extensions. Required.
        :paramtype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSetExtension]
        :keyword next_link: The uri to fetch the next page of VM scale set extensions. Call ListNext()
         with this to fetch the next page of VM scale set extensions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VirtualMachineScaleSetNetworkConfigurationDnsSettings(_serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    :ivar dns_servers: List of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword dns_servers: List of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers

class VirtualMachineScaleSetPublicIPAddressConfiguration(_serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The publicIP address configuration name. Required.
    :vartype name: str
    :ivar sku: Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.
    :vartype sku: ~azure.mgmt.compute.models.PublicIPAddressSku
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar dns_settings: The dns settings to be applied on the publicIP addresses .
    :vartype dns_settings:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    :ivar ip_tags: The list of IP tags associated with the public IP address.
    :vartype ip_tags: list[~azure.mgmt.compute.models.VirtualMachineScaleSetIpTag]
    :ivar public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
    :vartype public_ip_prefix: ~azure.mgmt.compute.models.SubResource
    :ivar public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values
     are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype public_ip_address_version: str or ~azure.mgmt.compute.models.IPVersion
    :ivar delete_option: Specify what happens to the public IP when the VM is deleted. Known values
     are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "PublicIPAddressSku"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings",
        },
        "ip_tags": {"key": "properties.ipTags", "type": "[VirtualMachineScaleSetIpTag]"},
        "public_ip_prefix": {"key": "properties.publicIPPrefix", "type": "SubResource"},
        "public_ip_address_version": {"key": "properties.publicIPAddressVersion", "type": "str"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        sku: Optional["_models.PublicIPAddressSku"] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        ip_tags: Optional[List["_models.VirtualMachineScaleSetIpTag"]] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        public_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The publicIP address configuration name. Required.
        :paramtype name: str
        :keyword sku: Describes the public IP Sku. It can only be set with OrchestrationMode as
         Flexible.
        :paramtype sku: ~azure.mgmt.compute.models.PublicIPAddressSku
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword dns_settings: The dns settings to be applied on the publicIP addresses .
        :paramtype dns_settings:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
        :keyword ip_tags: The list of IP tags associated with the public IP address.
        :paramtype ip_tags: list[~azure.mgmt.compute.models.VirtualMachineScaleSetIpTag]
        :keyword public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
        :paramtype public_ip_prefix: ~azure.mgmt.compute.models.SubResource
        :keyword public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype public_ip_address_version: str or ~azure.mgmt.compute.models.IPVersion
        :keyword delete_option: Specify what happens to the public IP when the VM is deleted. Known
         values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
        """
        super().__init__(**kwargs)
        self.name = name
        self.sku = sku
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.dns_settings = dns_settings
        self.ip_tags = ip_tags
        self.public_ip_prefix = public_ip_prefix
        self.public_ip_address_version = public_ip_address_version
        self.delete_option = delete_option

class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings(_serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    All required parameters must be populated in order to send to Azure.

    :ivar domain_name_label: The Domain name label.The concatenation of the domain name label and
     vm index will be the domain name labels of the PublicIPAddress resources that will be created.
     Required.
    :vartype domain_name_label: str
    """

    _validation = {
        "domain_name_label": {"required": True},
    }

    _attribute_map = {
        "domain_name_label": {"key": "domainNameLabel", "type": "str"},
    }

    def __init__(self, *, domain_name_label: str, **kwargs: Any) -> None:
        """
        :keyword domain_name_label: The Domain name label.The concatenation of the domain name label
         and vm index will be the domain name labels of the PublicIPAddress resources that will be
         created. Required.
        :paramtype domain_name_label: str
        """
        super().__init__(**kwargs)
        self.domain_name_label = domain_name_label

class VirtualMachineScaleSetUpdate(UpdateResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Scale Set.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The virtual machine scale set sku.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar plan: The purchase plan when deploying a virtual machine scale set from VM Marketplace
     images.
    :vartype plan: ~azure.mgmt.compute.models.Plan
    :ivar identity: The identity of the virtual machine scale set, if configured.
    :vartype identity: ~azure.mgmt.compute.models.VirtualMachineScaleSetIdentity
    :ivar upgrade_policy: The upgrade policy.
    :vartype upgrade_policy: ~azure.mgmt.compute.models.UpgradePolicy
    :ivar automatic_repairs_policy: Policy for automatic repairs.
    :vartype automatic_repairs_policy:
     ~azure.mgmt.compute.models.AutomaticRepairsPolicy
    :ivar virtual_machine_profile: The virtual machine profile.
    :vartype virtual_machine_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateVMProfile
    :ivar overprovision: Specifies whether the Virtual Machine Scale Set should be overprovisioned.
    :vartype overprovision: bool
    :ivar do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled, extensions
     are launched only on the requested number of VMs which are finally kept. This property will
     hence ensure that the extensions do not run on the extra overprovisioned VMs.
    :vartype do_not_run_extensions_on_overprovisioned_v_ms: bool
    :ivar single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to
     false. However, if singlePlacementGroup is false, it may not be modified to true.
    :vartype single_placement_group: bool
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
     have the capability to support attaching managed data disks with UltraSSD_LRS storage account
     type.
    :vartype additional_capabilities: ~azure.mgmt.compute.models.AdditionalCapabilities
    :ivar scale_in_policy: Specifies the policies applied when scaling in Virtual Machines in the
     Virtual Machine Scale Set.
    :vartype scale_in_policy: ~azure.mgmt.compute.models.ScaleInPolicy
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum
     api-version: 2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "identity": {"key": "identity", "type": "VirtualMachineScaleSetIdentity"},
        "upgrade_policy": {"key": "properties.upgradePolicy", "type": "UpgradePolicy"},
        "automatic_repairs_policy": {"key": "properties.automaticRepairsPolicy", "type": "AutomaticRepairsPolicy"},
        "virtual_machine_profile": {
            "key": "properties.virtualMachineProfile",
            "type": "VirtualMachineScaleSetUpdateVMProfile",
        },
        "overprovision": {"key": "properties.overprovision", "type": "bool"},
        "do_not_run_extensions_on_overprovisioned_v_ms": {
            "key": "properties.doNotRunExtensionsOnOverprovisionedVMs",
            "type": "bool",
        },
        "single_placement_group": {"key": "properties.singlePlacementGroup", "type": "bool"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "scale_in_policy": {"key": "properties.scaleInPolicy", "type": "ScaleInPolicy"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineScaleSetIdentity"] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
        automatic_repairs_policy: Optional["_models.AutomaticRepairsPolicy"] = None,
        virtual_machine_profile: Optional["_models.VirtualMachineScaleSetUpdateVMProfile"] = None,
        overprovision: Optional[bool] = None,
        do_not_run_extensions_on_overprovisioned_v_ms: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        scale_in_policy: Optional["_models.ScaleInPolicy"] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The virtual machine scale set sku.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword plan: The purchase plan when deploying a virtual machine scale set from VM Marketplace
         images.
        :paramtype plan: ~azure.mgmt.compute.models.Plan
        :keyword identity: The identity of the virtual machine scale set, if configured.
        :paramtype identity: ~azure.mgmt.compute.models.VirtualMachineScaleSetIdentity
        :keyword upgrade_policy: The upgrade policy.
        :paramtype upgrade_policy: ~azure.mgmt.compute.models.UpgradePolicy
        :keyword automatic_repairs_policy: Policy for automatic repairs.
        :paramtype automatic_repairs_policy:
         ~azure.mgmt.compute.models.AutomaticRepairsPolicy
        :keyword virtual_machine_profile: The virtual machine profile.
        :paramtype virtual_machine_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateVMProfile
        :keyword overprovision: Specifies whether the Virtual Machine Scale Set should be
         overprovisioned.
        :paramtype overprovision: bool
        :keyword do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled,
         extensions are launched only on the requested number of VMs which are finally kept. This
         property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
        :paramtype do_not_run_extensions_on_overprovisioned_v_ms: bool
        :keyword single_placement_group: When true this limits the scale set to a single placement
         group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be
         modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
        :paramtype single_placement_group: bool
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
         have the capability to support attaching managed data disks with UltraSSD_LRS storage account
         type.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.models.AdditionalCapabilities
        :keyword scale_in_policy: Specifies the policies applied when scaling in Virtual Machines in
         the Virtual Machine Scale Set.
        :paramtype scale_in_policy: ~azure.mgmt.compute.models.ScaleInPolicy
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum
         api-version: 2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.upgrade_policy = upgrade_policy
        self.automatic_repairs_policy = automatic_repairs_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.overprovision = overprovision
        self.do_not_run_extensions_on_overprovisioned_v_ms = do_not_run_extensions_on_overprovisioned_v_ms
        self.single_placement_group = single_placement_group
        self.additional_capabilities = additional_capabilities
        self.scale_in_policy = scale_in_policy
        self.proximity_placement_group = proximity_placement_group

class VirtualMachineScaleSetUpdateIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration. NOTE: The subnet of a
    scale set may be modified as long as the original subnet and the new subnet are in the same
    virtual network.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The IP configuration name.
    :vartype name: str
    :ivar subnet: The subnet.
    :vartype subnet: ~azure.mgmt.compute.models.ApiEntityReference
    :ivar primary: Specifies the primary IP Configuration in case the network interface has more
     than one IP Configuration.
    :vartype primary: bool
    :ivar public_ip_address_configuration: The publicIPAddressConfiguration.
    :vartype public_ip_address_configuration:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
    :ivar private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or ~azure.mgmt.compute.models.IPVersion
    :ivar application_gateway_backend_address_pools: The application gateway backend address pools.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.models.SubResource]
    :ivar application_security_groups: Specifies an array of references to application security
     group.
    :vartype application_security_groups: list[~azure.mgmt.compute.models.SubResource]
    :ivar load_balancer_backend_address_pools: The load balancer backend address pools.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.models.SubResource]
    :ivar load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
    :vartype load_balancer_inbound_nat_pools:
     list[~azure.mgmt.compute.models.SubResource]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "ApiEntityReference"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address_configuration": {
            "key": "properties.publicIPAddressConfiguration",
            "type": "VirtualMachineScaleSetUpdatePublicIPAddressConfiguration",
        },
        "private_ip_address_version": {"key": "properties.privateIPAddressVersion", "type": "str"},
        "application_gateway_backend_address_pools": {
            "key": "properties.applicationGatewayBackendAddressPools",
            "type": "[SubResource]",
        },
        "application_security_groups": {"key": "properties.applicationSecurityGroups", "type": "[SubResource]"},
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[SubResource]",
        },
        "load_balancer_inbound_nat_pools": {"key": "properties.loadBalancerInboundNatPools", "type": "[SubResource]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        subnet: Optional["_models.ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional[
            "_models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration"
        ] = None,
        private_ip_address_version: Optional[Union[str, "_models.IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        application_security_groups: Optional[List["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["_models.SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["_models.SubResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The IP configuration name.
        :paramtype name: str
        :keyword subnet: The subnet.
        :paramtype subnet: ~azure.mgmt.compute.models.ApiEntityReference
        :keyword primary: Specifies the primary IP Configuration in case the network interface has more
         than one IP Configuration.
        :paramtype primary: bool
        :keyword public_ip_address_configuration: The publicIPAddressConfiguration.
        :paramtype public_ip_address_configuration:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
        :keyword private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it
         represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
         Possible values are: 'IPv4' and 'IPv6'. Known values are: "IPv4" and "IPv6".
        :paramtype private_ip_address_version: str or ~azure.mgmt.compute.models.IPVersion
        :keyword application_gateway_backend_address_pools: The application gateway backend address
         pools.
        :paramtype application_gateway_backend_address_pools:
         list[~azure.mgmt.compute.models.SubResource]
        :keyword application_security_groups: Specifies an array of references to application security
         group.
        :paramtype application_security_groups:
         list[~azure.mgmt.compute.models.SubResource]
        :keyword load_balancer_backend_address_pools: The load balancer backend address pools.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.compute.models.SubResource]
        :keyword load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
        :paramtype load_balancer_inbound_nat_pools:
         list[~azure.mgmt.compute.models.SubResource]
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.application_security_groups = application_security_groups
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools

class VirtualMachineScaleSetUpdateNetworkConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """Describes a virtual machine scale set network profile's network configurations.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The network configuration name.
    :vartype name: str
    :ivar primary: Whether this is a primary NIC on a virtual machine.
    :vartype primary: bool
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar disable_tcp_state_tracking: Specifies whether the network interface is disabled for tcp
     state tracking.
    :vartype disable_tcp_state_tracking: bool
    :ivar enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :vartype enable_fpga: bool
    :ivar network_security_group: The network security group.
    :vartype network_security_group: ~azure.mgmt.compute.models.SubResource
    :ivar dns_settings: The dns settings to be applied on the network interfaces.
    :vartype dns_settings:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :ivar ip_configurations: The virtual machine scale set IP Configuration.
    :vartype ip_configurations:
     list[~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateIPConfiguration]
    :ivar enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :vartype enable_ip_forwarding: bool
    :ivar delete_option: Specify what happens to the network interface when the VM is deleted.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "enable_accelerated_networking": {"key": "properties.enableAcceleratedNetworking", "type": "bool"},
        "disable_tcp_state_tracking": {"key": "properties.disableTcpStateTracking", "type": "bool"},
        "enable_fpga": {"key": "properties.enableFpga", "type": "bool"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "SubResource"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetNetworkConfigurationDnsSettings",
        },
        "ip_configurations": {
            "key": "properties.ipConfigurations",
            "type": "[VirtualMachineScaleSetUpdateIPConfiguration]",
        },
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        disable_tcp_state_tracking: Optional[bool] = None,
        enable_fpga: Optional[bool] = None,
        network_security_group: Optional["_models.SubResource"] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        ip_configurations: Optional[List["_models.VirtualMachineScaleSetUpdateIPConfiguration"]] = None,
        enable_ip_forwarding: Optional[bool] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword name: The network configuration name.
        :paramtype name: str
        :keyword primary: Whether this is a primary NIC on a virtual machine.
        :paramtype primary: bool
        :keyword enable_accelerated_networking: Specifies whether the network interface is accelerated
         networking-enabled.
        :paramtype enable_accelerated_networking: bool
        :keyword disable_tcp_state_tracking: Specifies whether the network interface is disabled for
         tcp state tracking.
        :paramtype disable_tcp_state_tracking: bool
        :keyword enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
        :paramtype enable_fpga: bool
        :keyword network_security_group: The network security group.
        :paramtype network_security_group: ~azure.mgmt.compute.models.SubResource
        :keyword dns_settings: The dns settings to be applied on the network interfaces.
        :paramtype dns_settings:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
        :keyword ip_configurations: The virtual machine scale set IP Configuration.
        :paramtype ip_configurations:
         list[~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateIPConfiguration]
        :keyword enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
        :paramtype enable_ip_forwarding: bool
        :keyword delete_option: Specify what happens to the network interface when the VM is deleted.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.disable_tcp_state_tracking = disable_tcp_state_tracking
        self.enable_fpga = enable_fpga
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.enable_ip_forwarding = enable_ip_forwarding
        self.delete_option = delete_option

class VirtualMachineScaleSetUpdateNetworkProfile(_serialization.Model):
    """Describes a virtual machine scale set network profile.

    :ivar health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
    :vartype health_probe: ~azure.mgmt.compute.models.ApiEntityReference
    :ivar network_interface_configurations: The list of network configurations.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateNetworkConfiguration]
    :ivar network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations for Virtual Machine Scale Set with
     orchestration mode 'Flexible'. "2020-11-01"
    :vartype network_api_version: str or ~azure.mgmt.compute.models.NetworkApiVersion
    """

    _attribute_map = {
        "health_probe": {"key": "healthProbe", "type": "ApiEntityReference"},
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineScaleSetUpdateNetworkConfiguration]",
        },
        "network_api_version": {"key": "networkApiVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        health_probe: Optional["_models.ApiEntityReference"] = None,
        network_interface_configurations: Optional[
            List["_models.VirtualMachineScaleSetUpdateNetworkConfiguration"]
        ] = None,
        network_api_version: Optional[Union[str, "_models.NetworkApiVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword health_probe: A reference to a load balancer probe used to determine the health of an
         instance in the virtual machine scale set. The reference will be in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
        :paramtype health_probe: ~azure.mgmt.compute.models.ApiEntityReference
        :keyword network_interface_configurations: The list of network configurations.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateNetworkConfiguration]
        :keyword network_api_version: specifies the Microsoft.Network API version used when creating
         networking resources in the Network Interface Configurations for Virtual Machine Scale Set with
         orchestration mode 'Flexible'. "2020-11-01"
        :paramtype network_api_version: str or ~azure.mgmt.compute.models.NetworkApiVersion
        """
        super().__init__(**kwargs)
        self.health_probe = health_probe
        self.network_interface_configurations = network_interface_configurations
        self.network_api_version = network_api_version

class VirtualMachineScaleSetUpdateOSDisk(_serialization.Model):
    """Describes virtual machine scale set operating system disk Update Object. This should be used
    for Updating VMSS OS Disk.

    :ivar caching: The caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype caching: str or ~azure.mgmt.compute.models.CachingTypes
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    :ivar disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than
     1023.
    :vartype disk_size_gb: int
    :ivar image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before
     using it to attach to the Virtual Machine. If SourceImage is provided, the destination
     VirtualHardDisk should not exist.
    :vartype image: ~azure.mgmt.compute.models.VirtualHardDisk
    :ivar vhd_containers: The list of virtual hard disk container uris.
    :vartype vhd_containers: list[str]
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetManagedDiskParameters
    :ivar delete_option: Specifies whether OS Disk should be deleted or detached upon VMSS Flex
     deletion (This feature is available for VMSS with Flexible OrchestrationMode only).
     :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this value is
     used, the OS disk is deleted when VMSS Flex VM is deleted.:code:`<br>`:code:`<br>` **Detach**
     If this value is used, the OS disk is retained after VMSS Flex VM is deleted.
     :code:`<br>`:code:`<br>` The default value is set to **Delete**. For an Ephemeral OS Disk, the
     default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
     Known values are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
    """

    _attribute_map = {
        "caching": {"key": "caching", "type": "str"},
        "write_accelerator_enabled": {"key": "writeAcceleratorEnabled", "type": "bool"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
        "image": {"key": "image", "type": "VirtualHardDisk"},
        "vhd_containers": {"key": "vhdContainers", "type": "[str]"},
        "managed_disk": {"key": "managedDisk", "type": "VirtualMachineScaleSetManagedDiskParameters"},
        "delete_option": {"key": "deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        caching: Optional[Union[str, "_models.CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        image: Optional["_models.VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["_models.VirtualMachineScaleSetManagedDiskParameters"] = None,
        delete_option: Optional[Union[str, "_models.DiskDeleteOptionTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword caching: The caching type. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype caching: str or ~azure.mgmt.compute.models.CachingTypes
        :keyword write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
         disabled on the disk.
        :paramtype write_accelerator_enabled: bool
        :keyword disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can
         be used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
         diskSizeGB is the number of bytes x 1024^3 for the disk and the value cannot be larger than
         1023.
        :paramtype disk_size_gb: int
        :keyword image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied
         before using it to attach to the Virtual Machine. If SourceImage is provided, the destination
         VirtualHardDisk should not exist.
        :paramtype image: ~azure.mgmt.compute.models.VirtualHardDisk
        :keyword vhd_containers: The list of virtual hard disk container uris.
        :paramtype vhd_containers: list[str]
        :keyword managed_disk: The managed disk parameters.
        :paramtype managed_disk:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetManagedDiskParameters
        :keyword delete_option: Specifies whether OS Disk should be deleted or detached upon VMSS Flex
         deletion (This feature is available for VMSS with Flexible OrchestrationMode only).
         :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this value is
         used, the OS disk is deleted when VMSS Flex VM is deleted.:code:`<br>`:code:`<br>` **Detach**
         If this value is used, the OS disk is retained after VMSS Flex VM is deleted.
         :code:`<br>`:code:`<br>` The default value is set to **Delete**. For an Ephemeral OS Disk, the
         default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
         Known values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DiskDeleteOptionTypes
        """
        super().__init__(**kwargs)
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.disk_size_gb = disk_size_gb
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk
        self.delete_option = delete_option

class VirtualMachineScaleSetUpdateOSProfile(_serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :ivar custom_data: A base-64 encoded string of custom data.
    :vartype custom_data: str
    :ivar windows_configuration: The Windows Configuration of the OS profile.
    :vartype windows_configuration: ~azure.mgmt.compute.models.WindowsConfiguration
    :ivar linux_configuration: The Linux Configuration of the OS profile.
    :vartype linux_configuration: ~azure.mgmt.compute.models.LinuxConfiguration
    :ivar secrets: The List of certificates for addition to the VM.
    :vartype secrets: list[~azure.mgmt.compute.models.VaultSecretGroup]
    """

    _attribute_map = {
        "custom_data": {"key": "customData", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "WindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "secrets": {"key": "secrets", "type": "[VaultSecretGroup]"},
    }

    def __init__(
        self,
        *,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        secrets: Optional[List["_models.VaultSecretGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword custom_data: A base-64 encoded string of custom data.
        :paramtype custom_data: str
        :keyword windows_configuration: The Windows Configuration of the OS profile.
        :paramtype windows_configuration: ~azure.mgmt.compute.models.WindowsConfiguration
        :keyword linux_configuration: The Linux Configuration of the OS profile.
        :paramtype linux_configuration: ~azure.mgmt.compute.models.LinuxConfiguration
        :keyword secrets: The List of certificates for addition to the VM.
        :paramtype secrets: list[~azure.mgmt.compute.models.VaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets

class VirtualMachineScaleSetUpdatePublicIPAddressConfiguration(_serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    :ivar name: The publicIP address configuration name.
    :vartype name: str
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar dns_settings: The dns settings to be applied on the publicIP addresses .
    :vartype dns_settings:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    :ivar public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
    :vartype public_ip_prefix: ~azure.mgmt.compute.models.SubResource
    :ivar delete_option: Specify what happens to the public IP when the VM is deleted. Known values
     are: "Delete" and "Detach".
    :vartype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "dns_settings": {
            "key": "properties.dnsSettings",
            "type": "VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings",
        },
        "public_ip_prefix": {"key": "properties.publicIPPrefix", "type": "SubResource"},
        "delete_option": {"key": "properties.deleteOption", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["_models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        public_ip_prefix: Optional["_models.SubResource"] = None,
        delete_option: Optional[Union[str, "_models.DeleteOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The publicIP address configuration name.
        :paramtype name: str
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword dns_settings: The dns settings to be applied on the publicIP addresses .
        :paramtype dns_settings:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
        :keyword public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
        :paramtype public_ip_prefix: ~azure.mgmt.compute.models.SubResource
        :keyword delete_option: Specify what happens to the public IP when the VM is deleted. Known
         values are: "Delete" and "Detach".
        :paramtype delete_option: str or ~azure.mgmt.compute.models.DeleteOptions
        """
        super().__init__(**kwargs)
        self.name = name
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.dns_settings = dns_settings
        self.public_ip_prefix = public_ip_prefix
        self.delete_option = delete_option

class VirtualMachineScaleSetUpdateStorageProfile(_serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :ivar image_reference: The image reference.
    :vartype image_reference: ~azure.mgmt.compute.models.ImageReference
    :ivar os_disk: The OS disk.
    :vartype os_disk: ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateOSDisk
    :ivar data_disks: The data disks.
    :vartype data_disks:
     list[~azure.mgmt.compute.models.VirtualMachineScaleSetDataDisk]
    :ivar disk_controller_type:
    :vartype disk_controller_type: str
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "VirtualMachineScaleSetUpdateOSDisk"},
        "data_disks": {"key": "dataDisks", "type": "[VirtualMachineScaleSetDataDisk]"},
        "disk_controller_type": {"key": "diskControllerType", "type": "str"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.VirtualMachineScaleSetUpdateOSDisk"] = None,
        data_disks: Optional[List["_models.VirtualMachineScaleSetDataDisk"]] = None,
        disk_controller_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_reference: The image reference.
        :paramtype image_reference: ~azure.mgmt.compute.models.ImageReference
        :keyword os_disk: The OS disk.
        :paramtype os_disk: ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateOSDisk
        :keyword data_disks: The data disks.
        :paramtype data_disks:
         list[~azure.mgmt.compute.models.VirtualMachineScaleSetDataDisk]
        :keyword disk_controller_type:
        :paramtype disk_controller_type: str
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.disk_controller_type = disk_controller_type

class VirtualMachineScaleSetUpdateVMProfile(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes a virtual machine scale set virtual machine profile.

    :ivar os_profile: The virtual machine scale set OS profile.
    :vartype os_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateOSProfile
    :ivar storage_profile: The virtual machine scale set storage profile.
    :vartype storage_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateStorageProfile
    :ivar network_profile: The virtual machine scale set network profile.
    :vartype network_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateNetworkProfile
    :ivar security_profile: The virtual machine scale set Security profile.
    :vartype security_profile: ~azure.mgmt.compute.models.SecurityProfile
    :ivar diagnostics_profile: The virtual machine scale set diagnostics profile.
    :vartype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
    :ivar extension_profile: The virtual machine scale set extension profile.
    :vartype extension_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetExtensionProfile
    :ivar license_type: The license type, which is for bring your own license scenario.
    :vartype license_type: str
    :ivar billing_profile: Specifies the billing related details of a Azure Spot VMSS.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :vartype billing_profile: ~azure.mgmt.compute.models.BillingProfile
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile:
     ~azure.mgmt.compute.models.ScheduledEventsProfile
    :ivar user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :vartype user_data: str
    :ivar hardware_profile: Specifies the hardware profile related details of a scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype hardware_profile:
     ~azure.mgmt.compute.models.VirtualMachineScaleSetHardwareProfile
    """

    _attribute_map = {
        "os_profile": {"key": "osProfile", "type": "VirtualMachineScaleSetUpdateOSProfile"},
        "storage_profile": {"key": "storageProfile", "type": "VirtualMachineScaleSetUpdateStorageProfile"},
        "network_profile": {"key": "networkProfile", "type": "VirtualMachineScaleSetUpdateNetworkProfile"},
        "security_profile": {"key": "securityProfile", "type": "SecurityProfile"},
        "diagnostics_profile": {"key": "diagnosticsProfile", "type": "DiagnosticsProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "VirtualMachineScaleSetExtensionProfile"},
        "license_type": {"key": "licenseType", "type": "str"},
        "billing_profile": {"key": "billingProfile", "type": "BillingProfile"},
        "scheduled_events_profile": {"key": "scheduledEventsProfile", "type": "ScheduledEventsProfile"},
        "user_data": {"key": "userData", "type": "str"},
        "hardware_profile": {"key": "hardwareProfile", "type": "VirtualMachineScaleSetHardwareProfile"},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["_models.VirtualMachineScaleSetUpdateOSProfile"] = None,
        storage_profile: Optional["_models.VirtualMachineScaleSetUpdateStorageProfile"] = None,
        network_profile: Optional["_models.VirtualMachineScaleSetUpdateNetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        extension_profile: Optional["_models.VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        billing_profile: Optional["_models.BillingProfile"] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        hardware_profile: Optional["_models.VirtualMachineScaleSetHardwareProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_profile: The virtual machine scale set OS profile.
        :paramtype os_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateOSProfile
        :keyword storage_profile: The virtual machine scale set storage profile.
        :paramtype storage_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateStorageProfile
        :keyword network_profile: The virtual machine scale set network profile.
        :paramtype network_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetUpdateNetworkProfile
        :keyword security_profile: The virtual machine scale set Security profile.
        :paramtype security_profile: ~azure.mgmt.compute.models.SecurityProfile
        :keyword diagnostics_profile: The virtual machine scale set diagnostics profile.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
        :keyword extension_profile: The virtual machine scale set extension profile.
        :paramtype extension_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetExtensionProfile
        :keyword license_type: The license type, which is for bring your own license scenario.
        :paramtype license_type: str
        :keyword billing_profile: Specifies the billing related details of a Azure Spot VMSS.
         :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype billing_profile: ~azure.mgmt.compute.models.BillingProfile
        :keyword scheduled_events_profile: Specifies Scheduled Event related configurations.
        :paramtype scheduled_events_profile:
         ~azure.mgmt.compute.models.ScheduledEventsProfile
        :keyword user_data: UserData for the VM, which must be base-64 encoded. Customer should not
         pass any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
        :paramtype user_data: str
        :keyword hardware_profile: Specifies the hardware profile related details of a scale set.
         :code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
        :paramtype hardware_profile:
         ~azure.mgmt.compute.models.VirtualMachineScaleSetHardwareProfile
        """
        super().__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.extension_profile = extension_profile
        self.license_type = license_type
        self.billing_profile = billing_profile
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data
        self.hardware_profile = hardware_profile

class ResourceSkuLocationInfo(_serialization.Model):
    """Describes an available Compute SKU Location Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location of the SKU.
    :vartype location: str
    :ivar zones: List of availability zones where the SKU is supported.
    :vartype zones: list[str]
    :ivar zone_details: Details of capabilities available to a SKU in specific zones.
    :vartype zone_details: list[~azure.mgmt.compute.models.ResourceSkuZoneDetails]
    :ivar extended_locations: The names of extended locations.
    :vartype extended_locations: list[str]
    :ivar type: The type of the extended location. "EdgeZone"
    :vartype type: str or ~azure.mgmt.compute.models.ExtendedLocationType
    """

    _validation = {
        "location": {"readonly": True},
        "zones": {"readonly": True},
        "zone_details": {"readonly": True},
        "extended_locations": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "zone_details": {"key": "zoneDetails", "type": "[ResourceSkuZoneDetails]"},
        "extended_locations": {"key": "extendedLocations", "type": "[str]"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location = None
        self.zones = None
        self.zone_details = None
        self.extended_locations = None
        self.type = None

class ResourceSkuRestrictionInfo(_serialization.Model):
    """Describes an available Compute SKU Restriction Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar locations: Locations where the SKU is restricted.
    :vartype locations: list[str]
    :ivar zones: List of availability zones where the SKU is restricted.
    :vartype zones: list[str]
    """

    _validation = {
        "locations": {"readonly": True},
        "zones": {"readonly": True},
    }

    _attribute_map = {
        "locations": {"key": "locations", "type": "[str]"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.locations = None
        self.zones = None

class AutoOSUpgradePolicy(_serialization.Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :ivar disable_auto_rollback: Whether OS image rollback feature should be disabled. Default
     value is false.
    :vartype disable_auto_rollback: bool
    """

    _attribute_map = {
        "disable_auto_rollback": {"key": "disableAutoRollback", "type": "bool"},
    }

    def __init__(self, *, disable_auto_rollback: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword disable_auto_rollback: Whether OS image rollback feature should be disabled. Default
         value is false.
        :paramtype disable_auto_rollback: bool
        """
        super().__init__(**kwargs)
        self.disable_auto_rollback = disable_auto_rollback

class AvailabilitySetUpdate(UpdateResource):
    """Specifies information about the availability set that the virtual machine should be assigned
    to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Sku of the availability set.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar platform_update_domain_count: Update Domain count.
    :vartype platform_update_domain_count: int
    :ivar platform_fault_domain_count: Fault Domain count.
    :vartype platform_fault_domain_count: int
    :ivar virtual_machines: A list of references to all virtual machines in the availability set.
    :vartype virtual_machines: list[~azure.mgmt.compute.models.SubResource]
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _validation = {
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_update_domain_count": {"key": "properties.platformUpdateDomainCount", "type": "int"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResource]"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "statuses": {"key": "properties.statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["_models.SubResource"]] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Sku of the availability set.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword platform_update_domain_count: Update Domain count.
        :paramtype platform_update_domain_count: int
        :keyword platform_fault_domain_count: Fault Domain count.
        :paramtype platform_fault_domain_count: int
        :keyword virtual_machines: A list of references to all virtual machines in the availability
         set.
        :paramtype virtual_machines: list[~azure.mgmt.compute.models.SubResource]
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
         2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.proximity_placement_group = proximity_placement_group
        self.statuses = None

class ComputeOperationListResult(_serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.compute.models.ComputeOperationValue]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ComputeOperationValue]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None

class ComputeOperationValue(_serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        "origin": {"readonly": True},
        "name": {"readonly": True},
        "operation": {"readonly": True},
        "resource": {"readonly": True},
        "description": {"readonly": True},
        "provider": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "operation": {"key": "display.operation", "type": "str"},
        "resource": {"key": "display.resource", "type": "str"},
        "description": {"key": "display.description", "type": "str"},
        "provider": {"key": "display.provider", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None

class ImageUpdate(UpdateResource):
    """The source user image virtual hard disk. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source_virtual_machine: The source virtual machine from which Image is created.
    :vartype source_virtual_machine: ~azure.mgmt.compute.models.SubResource
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created from
     the image. From API Version 2019-03-01 if the image source is a blob, then we need the user to
     specify the value, if the source is managed resource like disk or snapshot, we may require the
     user to specify the property if we cannot deduce it from the source managed resource. Known
     values are: "V1" and "V2".
    :vartype hyper_v_generation: str or
     ~azure.mgmt.compute.models.HyperVGenerationTypes
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "source_virtual_machine": {"key": "properties.sourceVirtualMachine", "type": "SubResource"},
        "storage_profile": {"key": "properties.storageProfile", "type": "ImageStorageProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        source_virtual_machine: Optional["_models.SubResource"] = None,
        storage_profile: Optional["_models.ImageStorageProfile"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGenerationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source_virtual_machine: The source virtual machine from which Image is created.
        :paramtype source_virtual_machine: ~azure.mgmt.compute.models.SubResource
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.models.ImageStorageProfile
        :keyword hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created
         from the image. From API Version 2019-03-01 if the image source is a blob, then we need the
         user to specify the value, if the source is managed resource like disk or snapshot, we may
         require the user to specify the property if we cannot deduce it from the source managed
         resource. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or
         ~azure.mgmt.compute.models.HyperVGenerationTypes
        """
        super().__init__(tags=tags, **kwargs)
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None
        self.hyper_v_generation = hyper_v_generation

class LogAnalyticsInputBase(_serialization.Model):
    """Api input base class for LogAnalytics Api.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    :ivar group_by_client_application_id: Group query result by Client Application ID.
    :vartype group_by_client_application_id: bool
    :ivar group_by_user_agent: Group query result by User Agent.
    :vartype group_by_user_agent: bool
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
        "group_by_client_application_id": {"key": "groupByClientApplicationId", "type": "bool"},
        "group_by_user_agent": {"key": "groupByUserAgent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        :keyword group_by_client_application_id: Group query result by Client Application ID.
        :paramtype group_by_client_application_id: bool
        :keyword group_by_user_agent: Group query result by User Agent.
        :paramtype group_by_user_agent: bool
        """
        super().__init__(**kwargs)
        self.blob_container_sas_uri = blob_container_sas_uri
        self.from_time = from_time
        self.to_time = to_time
        self.group_by_throttle_policy = group_by_throttle_policy
        self.group_by_operation_name = group_by_operation_name
        self.group_by_resource_name = group_by_resource_name
        self.group_by_client_application_id = group_by_client_application_id
        self.group_by_user_agent = group_by_user_agent

class LogAnalyticsOperationResult(_serialization.Model):
    """LogAnalytics operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: LogAnalyticsOutput.
    :vartype properties: ~azure.mgmt.compute.models.LogAnalyticsOutput
    """

    _validation = {
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "LogAnalyticsOutput"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties = None

class LogAnalyticsOutput(_serialization.Model):
    """LogAnalytics output properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar output: Output file Uri path to blob container.
    :vartype output: str
    """

    _validation = {
        "output": {"readonly": True},
    }

    _attribute_map = {
        "output": {"key": "output", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.output = None

class RecoveryWalkResponse(_serialization.Model):
    """Response after calling a manual recovery walk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar walk_performed: Whether the recovery walk was performed.
    :vartype walk_performed: bool
    :ivar next_platform_update_domain: The next update domain that needs to be walked. Null means
     walk spanning all update domains has been completed.
    :vartype next_platform_update_domain: int
    """

    _validation = {
        "walk_performed": {"readonly": True},
        "next_platform_update_domain": {"readonly": True},
    }

    _attribute_map = {
        "walk_performed": {"key": "walkPerformed", "type": "bool"},
        "next_platform_update_domain": {"key": "nextPlatformUpdateDomain", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.walk_performed = None
        self.next_platform_update_domain = None

class RequestRateByIntervalInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getRequestRateByInterval Api.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    :ivar group_by_client_application_id: Group query result by Client Application ID.
    :vartype group_by_client_application_id: bool
    :ivar group_by_user_agent: Group query result by User Agent.
    :vartype group_by_user_agent: bool
    :ivar interval_length: Interval value in minutes used to create LogAnalytics call rate logs.
     Required. Known values are: "ThreeMins", "FiveMins", "ThirtyMins", and "SixtyMins".
    :vartype interval_length: str or ~azure.mgmt.compute.models.IntervalInMins
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
        "interval_length": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
        "group_by_client_application_id": {"key": "groupByClientApplicationId", "type": "bool"},
        "group_by_user_agent": {"key": "groupByUserAgent", "type": "bool"},
        "interval_length": {"key": "intervalLength", "type": "str"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        interval_length: Union[str, "_models.IntervalInMins"],
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        :keyword group_by_client_application_id: Group query result by Client Application ID.
        :paramtype group_by_client_application_id: bool
        :keyword group_by_user_agent: Group query result by User Agent.
        :paramtype group_by_user_agent: bool
        :keyword interval_length: Interval value in minutes used to create LogAnalytics call rate logs.
         Required. Known values are: "ThreeMins", "FiveMins", "ThirtyMins", and "SixtyMins".
        :paramtype interval_length: str or ~azure.mgmt.compute.models.IntervalInMins
        """
        super().__init__(
            blob_container_sas_uri=blob_container_sas_uri,
            from_time=from_time,
            to_time=to_time,
            group_by_throttle_policy=group_by_throttle_policy,
            group_by_operation_name=group_by_operation_name,
            group_by_resource_name=group_by_resource_name,
            group_by_client_application_id=group_by_client_application_id,
            group_by_user_agent=group_by_user_agent,
            **kwargs
        )
        self.interval_length = interval_length

class RollbackStatusInfo(_serialization.Model):
    """Information about rollback on failed VM instances after a OS Upgrade operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successfully_rolledback_instance_count: The number of instances which have been
     successfully rolled back.
    :vartype successfully_rolledback_instance_count: int
    :ivar failed_rolledback_instance_count: The number of instances which failed to rollback.
    :vartype failed_rolledback_instance_count: int
    :ivar rollback_error: Error details if OS rollback failed.
    :vartype rollback_error: ~azure.mgmt.compute.models.ApiError
    """

    _validation = {
        "successfully_rolledback_instance_count": {"readonly": True},
        "failed_rolledback_instance_count": {"readonly": True},
        "rollback_error": {"readonly": True},
    }

    _attribute_map = {
        "successfully_rolledback_instance_count": {"key": "successfullyRolledbackInstanceCount", "type": "int"},
        "failed_rolledback_instance_count": {"key": "failedRolledbackInstanceCount", "type": "int"},
        "rollback_error": {"key": "rollbackError", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.successfully_rolledback_instance_count = None
        self.failed_rolledback_instance_count = None
        self.rollback_error = None

class ThrottledRequestsInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getThrottledRequests Api.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics Api
     writes output logs to. Required.
    :vartype blob_container_sas_uri: str
    :ivar from_time: From time of the query. Required.
    :vartype from_time: ~datetime.datetime
    :ivar to_time: To time of the query. Required.
    :vartype to_time: ~datetime.datetime
    :ivar group_by_throttle_policy: Group query result by Throttle Policy applied.
    :vartype group_by_throttle_policy: bool
    :ivar group_by_operation_name: Group query result by Operation Name.
    :vartype group_by_operation_name: bool
    :ivar group_by_resource_name: Group query result by Resource Name.
    :vartype group_by_resource_name: bool
    :ivar group_by_client_application_id: Group query result by Client Application ID.
    :vartype group_by_client_application_id: bool
    :ivar group_by_user_agent: Group query result by User Agent.
    :vartype group_by_user_agent: bool
    """

    _validation = {
        "blob_container_sas_uri": {"required": True},
        "from_time": {"required": True},
        "to_time": {"required": True},
    }

    _attribute_map = {
        "blob_container_sas_uri": {"key": "blobContainerSasUri", "type": "str"},
        "from_time": {"key": "fromTime", "type": "iso-8601"},
        "to_time": {"key": "toTime", "type": "iso-8601"},
        "group_by_throttle_policy": {"key": "groupByThrottlePolicy", "type": "bool"},
        "group_by_operation_name": {"key": "groupByOperationName", "type": "bool"},
        "group_by_resource_name": {"key": "groupByResourceName", "type": "bool"},
        "group_by_client_application_id": {"key": "groupByClientApplicationId", "type": "bool"},
        "group_by_user_agent": {"key": "groupByUserAgent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_container_sas_uri: SAS Uri of the logging blob container to which LogAnalytics
         Api writes output logs to. Required.
        :paramtype blob_container_sas_uri: str
        :keyword from_time: From time of the query. Required.
        :paramtype from_time: ~datetime.datetime
        :keyword to_time: To time of the query. Required.
        :paramtype to_time: ~datetime.datetime
        :keyword group_by_throttle_policy: Group query result by Throttle Policy applied.
        :paramtype group_by_throttle_policy: bool
        :keyword group_by_operation_name: Group query result by Operation Name.
        :paramtype group_by_operation_name: bool
        :keyword group_by_resource_name: Group query result by Resource Name.
        :paramtype group_by_resource_name: bool
        :keyword group_by_client_application_id: Group query result by Client Application ID.
        :paramtype group_by_client_application_id: bool
        :keyword group_by_user_agent: Group query result by User Agent.
        :paramtype group_by_user_agent: bool
        """
        super().__init__(
            blob_container_sas_uri=blob_container_sas_uri,
            from_time=from_time,
            to_time=to_time,
            group_by_throttle_policy=group_by_throttle_policy,
            group_by_operation_name=group_by_operation_name,
            group_by_resource_name=group_by_resource_name,
            group_by_client_application_id=group_by_client_application_id,
            group_by_user_agent=group_by_user_agent,
            **kwargs
        )

class UpgradeOperationHistoricalStatusInfo(_serialization.Model):
    """Virtual Machine Scale Set OS Upgrade History operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Information about the properties of the upgrade operation.
    :vartype properties:
     ~azure.mgmt.compute.models.UpgradeOperationHistoricalStatusInfoProperties
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        "properties": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "UpgradeOperationHistoricalStatusInfoProperties"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties = None
        self.type = None
        self.location = None

class UpgradeOperationHistoricalStatusInfoProperties(_serialization.Model):
    """Describes each OS upgrade on the Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar running_status: Information about the overall status of the upgrade operation.
    :vartype running_status: ~azure.mgmt.compute.models.UpgradeOperationHistoryStatus
    :ivar progress: Counts of the VMs in each state.
    :vartype progress: ~azure.mgmt.compute.models.RollingUpgradeProgressInfo
    :ivar error: Error Details for this upgrade if there are any.
    :vartype error: ~azure.mgmt.compute.models.ApiError
    :ivar started_by: Invoker of the Upgrade Operation. Known values are: "Unknown", "User", and
     "Platform".
    :vartype started_by: str or ~azure.mgmt.compute.models.UpgradeOperationInvoker
    :ivar target_image_reference: Image Reference details.
    :vartype target_image_reference: ~azure.mgmt.compute.models.ImageReference
    :ivar rollback_info: Information about OS rollback if performed.
    :vartype rollback_info: ~azure.mgmt.compute.models.RollbackStatusInfo
    """

    _validation = {
        "running_status": {"readonly": True},
        "progress": {"readonly": True},
        "error": {"readonly": True},
        "started_by": {"readonly": True},
        "target_image_reference": {"readonly": True},
        "rollback_info": {"readonly": True},
    }

    _attribute_map = {
        "running_status": {"key": "runningStatus", "type": "UpgradeOperationHistoryStatus"},
        "progress": {"key": "progress", "type": "RollingUpgradeProgressInfo"},
        "error": {"key": "error", "type": "ApiError"},
        "started_by": {"key": "startedBy", "type": "str"},
        "target_image_reference": {"key": "targetImageReference", "type": "ImageReference"},
        "rollback_info": {"key": "rollbackInfo", "type": "RollbackStatusInfo"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.running_status = None
        self.progress = None
        self.error = None
        self.started_by = None
        self.target_image_reference = None
        self.rollback_info = None

class UpgradeOperationHistoryStatus(_serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Known values are:
     "RollingForward", "Cancelled", "Completed", and "Faulted".
    :vartype code: str or ~azure.mgmt.compute.models.UpgradeState
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the upgrade.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "code": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.end_time = None

class VirtualMachineScaleSetListOSUpgradeHistory(_serialization.Model):
    """List of Virtual Machine Scale Set OS Upgrade History operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of OS upgrades performed on the virtual machine scale set. Required.
    :vartype value:
     list[~azure.mgmt.compute.models.UpgradeOperationHistoricalStatusInfo]
    :ivar next_link: The uri to fetch the next page of OS Upgrade History. Call ListNext() with
     this to fetch the next page of history of upgrades.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[UpgradeOperationHistoricalStatusInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: List["_models.UpgradeOperationHistoricalStatusInfo"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of OS upgrades performed on the virtual machine scale set. Required.
        :paramtype value:
         list[~azure.mgmt.compute.models.UpgradeOperationHistoricalStatusInfo]
        :keyword next_link: The uri to fetch the next page of OS Upgrade History. Call ListNext() with
         this to fetch the next page of history of upgrades.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VirtualMachineUpdate(UpdateResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :vartype plan: ~azure.mgmt.compute.models.Plan
    :ivar identity: The identity of the virtual machine, if configured.
    :vartype identity: ~azure.mgmt.compute.models.VirtualMachineIdentity
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar hardware_profile: Specifies the hardware settings for the virtual machine.
    :vartype hardware_profile: ~azure.mgmt.compute.models.HardwareProfile
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.compute.models.StorageProfile
    :ivar additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine.
    :vartype additional_capabilities: ~azure.mgmt.compute.models.AdditionalCapabilities
    :ivar os_profile: Specifies the operating system settings used while creating the virtual
     machine. Some of the settings cannot be changed once VM is provisioned.
    :vartype os_profile: ~azure.mgmt.compute.models.OSProfile
    :ivar network_profile: Specifies the network interfaces of the virtual machine.
    :vartype network_profile: ~azure.mgmt.compute.models.NetworkProfile
    :ivar security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :vartype security_profile: ~azure.mgmt.compute.models.SecurityProfile
    :ivar diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :vartype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
    :ivar availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Availability sets overview
     <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
     and updates for Virtual Machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. The availability set to which the VM is being added should be under the same resource
     group as the availability set resource. An existing VM cannot be added to an availability set.
     :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
     properties.virtualMachineScaleSet reference.
    :vartype availability_set: ~azure.mgmt.compute.models.SubResource
    :ivar virtual_machine_scale_set: Specifies information about the virtual machine scale set that
     the virtual machine should be assigned to. Virtual machines specified in the same virtual
     machine scale set are allocated to different nodes to maximize availability. Currently, a VM
     can only be added to virtual machine scale set at creation time. An existing VM cannot be added
     to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
     non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
     2019‐03‐01.
    :vartype virtual_machine_scale_set: ~azure.mgmt.compute.models.SubResource
    :ivar proximity_placement_group: Specifies information about the proximity placement group that
     the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :vartype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
    :ivar priority: Specifies the priority for the virtual machine. :code:`<br>`:code:`<br>`Minimum
     api-version: 2019-03-01. Known values are: "Regular", "Low", and "Spot".
    :vartype priority: str or ~azure.mgmt.compute.models.VirtualMachinePriorityTypes
    :ivar eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
    :vartype eviction_policy: str or
     ~azure.mgmt.compute.models.VirtualMachineEvictionPolicyTypes
    :ivar billing_profile: Specifies the billing related details of a Azure Spot virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :vartype billing_profile: ~azure.mgmt.compute.models.BillingProfile
    :ivar host: Specifies information about the dedicated host that the virtual machine resides in.
     :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
    :vartype host: ~azure.mgmt.compute.models.SubResource
    :ivar host_group: Specifies information about the dedicated host group that the virtual machine
     resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
     :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
    :vartype host_group: ~azure.mgmt.compute.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.models.VirtualMachineInstanceView
    :ivar license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :vartype license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    :ivar extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :vartype extensions_time_budget: str
    :ivar platform_fault_domain: Specifies the scale set logical fault domain into which the
     Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
     to a fault domain that best maintains balance across available fault
     domains.:code:`<br>`:code:`<li>`This is applicable only if the 'virtualMachineScaleSet'
     property of this Virtual Machine is set.:code:`<li>`The Virtual Machine Scale Set that is
     referenced, must have 'platformFaultDomainCount' &gt; 1.:code:`<li>`This property cannot be
     updated once the Virtual Machine is created.:code:`<li>`Fault domain assignment can be viewed
     in the Virtual Machine Instance View.:code:`<br>`:code:`<br>`Minimum api‐version: 2020‐12‐01.
    :vartype platform_fault_domain: int
    :ivar scheduled_events_profile: Specifies Scheduled Event related configurations.
    :vartype scheduled_events_profile:
     ~azure.mgmt.compute.models.ScheduledEventsProfile
    :ivar user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :vartype user_data: str
    :ivar capacity_reservation: Specifies information about the capacity reservation that is used
     to allocate virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
    :vartype capacity_reservation:
     ~azure.mgmt.compute.models.CapacityReservationProfile
    :ivar application_profile: Specifies the gallery applications that should be made available to
     the VM/VMSS.
    :vartype application_profile: ~azure.mgmt.compute.models.ApplicationProfile
    :ivar time_created: Specifies the time at which the Virtual Machine resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "vm_id": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "Plan"},
        "identity": {"key": "identity", "type": "VirtualMachineIdentity"},
        "zones": {"key": "zones", "type": "[str]"},
        "hardware_profile": {"key": "properties.hardwareProfile", "type": "HardwareProfile"},
        "storage_profile": {"key": "properties.storageProfile", "type": "StorageProfile"},
        "additional_capabilities": {"key": "properties.additionalCapabilities", "type": "AdditionalCapabilities"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "security_profile": {"key": "properties.securityProfile", "type": "SecurityProfile"},
        "diagnostics_profile": {"key": "properties.diagnosticsProfile", "type": "DiagnosticsProfile"},
        "availability_set": {"key": "properties.availabilitySet", "type": "SubResource"},
        "virtual_machine_scale_set": {"key": "properties.virtualMachineScaleSet", "type": "SubResource"},
        "proximity_placement_group": {"key": "properties.proximityPlacementGroup", "type": "SubResource"},
        "priority": {"key": "properties.priority", "type": "str"},
        "eviction_policy": {"key": "properties.evictionPolicy", "type": "str"},
        "billing_profile": {"key": "properties.billingProfile", "type": "BillingProfile"},
        "host": {"key": "properties.host", "type": "SubResource"},
        "host_group": {"key": "properties.hostGroup", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineInstanceView"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "extensions_time_budget": {"key": "properties.extensionsTimeBudget", "type": "str"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "scheduled_events_profile": {"key": "properties.scheduledEventsProfile", "type": "ScheduledEventsProfile"},
        "user_data": {"key": "properties.userData", "type": "str"},
        "capacity_reservation": {"key": "properties.capacityReservation", "type": "CapacityReservationProfile"},
        "application_profile": {"key": "properties.applicationProfile", "type": "ApplicationProfile"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.VirtualMachineIdentity"] = None,
        zones: Optional[List[str]] = None,
        hardware_profile: Optional["_models.HardwareProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        additional_capabilities: Optional["_models.AdditionalCapabilities"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        diagnostics_profile: Optional["_models.DiagnosticsProfile"] = None,
        availability_set: Optional["_models.SubResource"] = None,
        virtual_machine_scale_set: Optional["_models.SubResource"] = None,
        proximity_placement_group: Optional["_models.SubResource"] = None,
        priority: Optional[Union[str, "_models.VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "_models.VirtualMachineEvictionPolicyTypes"]] = None,
        billing_profile: Optional["_models.BillingProfile"] = None,
        host: Optional["_models.SubResource"] = None,
        host_group: Optional["_models.SubResource"] = None,
        license_type: Optional[str] = None,
        extensions_time_budget: Optional[str] = None,
        platform_fault_domain: Optional[int] = None,
        scheduled_events_profile: Optional["_models.ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["_models.CapacityReservationProfile"] = None,
        application_profile: Optional["_models.ApplicationProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: Specifies information about the marketplace image used to create the virtual
         machine. This element is only used for marketplace images. Before you can use a marketplace
         image from an API, you must enable the image for programmatic use.  In the Azure portal, find
         the marketplace image that you want to use and then click **Want to deploy programmatically,
         Get Started ->**. Enter any required information and then click **Save**.
        :paramtype plan: ~azure.mgmt.compute.models.Plan
        :keyword identity: The identity of the virtual machine, if configured.
        :paramtype identity: ~azure.mgmt.compute.models.VirtualMachineIdentity
        :keyword zones: The virtual machine zones.
        :paramtype zones: list[str]
        :keyword hardware_profile: Specifies the hardware settings for the virtual machine.
        :paramtype hardware_profile: ~azure.mgmt.compute.models.HardwareProfile
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.compute.models.StorageProfile
        :keyword additional_capabilities: Specifies additional capabilities enabled or disabled on the
         virtual machine.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.models.AdditionalCapabilities
        :keyword os_profile: Specifies the operating system settings used while creating the virtual
         machine. Some of the settings cannot be changed once VM is provisioned.
        :paramtype os_profile: ~azure.mgmt.compute.models.OSProfile
        :keyword network_profile: Specifies the network interfaces of the virtual machine.
        :paramtype network_profile: ~azure.mgmt.compute.models.NetworkProfile
        :keyword security_profile: Specifies the Security related profile settings for the virtual
         machine.
        :paramtype security_profile: ~azure.mgmt.compute.models.SecurityProfile
        :keyword diagnostics_profile: Specifies the boot diagnostic settings state.
         :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
        :paramtype diagnostics_profile: ~azure.mgmt.compute.models.DiagnosticsProfile
        :keyword availability_set: Specifies information about the availability set that the virtual
         machine should be assigned to. Virtual machines specified in the same availability set are
         allocated to different nodes to maximize availability. For more information about availability
         sets, see `Availability sets overview
         <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
         :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
         and updates for Virtual Machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
         :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
         time. The availability set to which the VM is being added should be under the same resource
         group as the availability set resource. An existing VM cannot be added to an availability set.
         :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
         properties.virtualMachineScaleSet reference.
        :paramtype availability_set: ~azure.mgmt.compute.models.SubResource
        :keyword virtual_machine_scale_set: Specifies information about the virtual machine scale set
         that the virtual machine should be assigned to. Virtual machines specified in the same virtual
         machine scale set are allocated to different nodes to maximize availability. Currently, a VM
         can only be added to virtual machine scale set at creation time. An existing VM cannot be added
         to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
         non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
         2019‐03‐01.
        :paramtype virtual_machine_scale_set: ~azure.mgmt.compute.models.SubResource
        :keyword proximity_placement_group: Specifies information about the proximity placement group
         that the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
         2018-04-01.
        :paramtype proximity_placement_group: ~azure.mgmt.compute.models.SubResource
        :keyword priority: Specifies the priority for the virtual machine.
         :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01. Known values are: "Regular", "Low",
         and "Spot".
        :paramtype priority: str or ~azure.mgmt.compute.models.VirtualMachinePriorityTypes
        :keyword eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
         Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
         'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
         :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
         and the minimum api-version is 2017-10-30-preview. Known values are: "Deallocate" and "Delete".
        :paramtype eviction_policy: str or
         ~azure.mgmt.compute.models.VirtualMachineEvictionPolicyTypes
        :keyword billing_profile: Specifies the billing related details of a Azure Spot virtual
         machine. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype billing_profile: ~azure.mgmt.compute.models.BillingProfile
        :keyword host: Specifies information about the dedicated host that the virtual machine resides
         in. :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
        :paramtype host: ~azure.mgmt.compute.models.SubResource
        :keyword host_group: Specifies information about the dedicated host group that the virtual
         machine resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
         :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
        :paramtype host_group: ~azure.mgmt.compute.models.SubResource
        :keyword license_type: Specifies that the image or disk that is being used was licensed
         on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
         :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
         :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
         :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
         :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
         <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
         :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
         <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
         :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
        :paramtype license_type: str
        :keyword extensions_time_budget: Specifies the time alloted for all extensions to start. The
         time duration should be between 15 minutes and 120 minutes (inclusive) and should be specified
         in ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
         api-version: 2020-06-01.
        :paramtype extensions_time_budget: str
        :keyword platform_fault_domain: Specifies the scale set logical fault domain into which the
         Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
         to a fault domain that best maintains balance across available fault
         domains.:code:`<br>`:code:`<li>`This is applicable only if the 'virtualMachineScaleSet'
         property of this Virtual Machine is set.:code:`<li>`The Virtual Machine Scale Set that is
         referenced, must have 'platformFaultDomainCount' &gt; 1.:code:`<li>`This property cannot be
         updated once the Virtual Machine is created.:code:`<li>`Fault domain assignment can be viewed
         in the Virtual Machine Instance View.:code:`<br>`:code:`<br>`Minimum api‐version: 2020‐12‐01.
        :paramtype platform_fault_domain: int
        :keyword scheduled_events_profile: Specifies Scheduled Event related configurations.
        :paramtype scheduled_events_profile:
         ~azure.mgmt.compute.models.ScheduledEventsProfile
        :keyword user_data: UserData for the VM, which must be base-64 encoded. Customer should not
         pass any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
        :paramtype user_data: str
        :keyword capacity_reservation: Specifies information about the capacity reservation that is
         used to allocate virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
        :paramtype capacity_reservation:
         ~azure.mgmt.compute.models.CapacityReservationProfile
        :keyword application_profile: Specifies the gallery applications that should be made available
         to the VM/VMSS.
        :paramtype application_profile: ~azure.mgmt.compute.models.ApplicationProfile
        """
        super().__init__(tags=tags, **kwargs)
        self.plan = plan
        self.identity = identity
        self.zones = zones
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.additional_capabilities = additional_capabilities
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.virtual_machine_scale_set = virtual_machine_scale_set
        self.proximity_placement_group = proximity_placement_group
        self.priority = priority
        self.eviction_policy = eviction_policy
        self.billing_profile = billing_profile
        self.host = host
        self.host_group = host_group
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None
        self.extensions_time_budget = extensions_time_budget
        self.platform_fault_domain = platform_fault_domain
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data
        self.capacity_reservation = capacity_reservation
        self.application_profile = application_profile
        self.time_created = None

class ProximityPlacementGroup(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the proximity placement group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: Specifies the Availability Zone where virtual machine, virtual machine scale set
     or availability set associated with the  proximity placement group can be created.
    :vartype zones: list[str]
    :ivar proximity_placement_group_type: Specifies the type of the proximity placement group.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Standard** : Co-locate
     resources within an Azure region or Availability Zone. :code:`<br>`:code:`<br>` **Ultra** : For
     future use. Known values are: "Standard" and "Ultra".
    :vartype proximity_placement_group_type: str or
     ~azure.mgmt.compute.models.ProximityPlacementGroupType
    :ivar virtual_machines: A list of references to all virtual machines in the proximity placement
     group.
    :vartype virtual_machines:
     list[~azure.mgmt.compute.models.SubResourceWithColocationStatus]
    :ivar virtual_machine_scale_sets: A list of references to all virtual machine scale sets in the
     proximity placement group.
    :vartype virtual_machine_scale_sets:
     list[~azure.mgmt.compute.models.SubResourceWithColocationStatus]
    :ivar availability_sets: A list of references to all availability sets in the proximity
     placement group.
    :vartype availability_sets:
     list[~azure.mgmt.compute.models.SubResourceWithColocationStatus]
    :ivar colocation_status: Describes colocation status of the Proximity Placement Group.
    :vartype colocation_status: ~azure.mgmt.compute.models.InstanceViewStatus
    :ivar intent: Specifies the user intent of the proximity placement group.
    :vartype intent: ~azure.mgmt.compute.models.ProximityPlacementGroupPropertiesIntent
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "virtual_machines": {"readonly": True},
        "virtual_machine_scale_sets": {"readonly": True},
        "availability_sets": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "zones": {"key": "zones", "type": "[str]"},
        "proximity_placement_group_type": {"key": "properties.proximityPlacementGroupType", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResourceWithColocationStatus]"},
        "virtual_machine_scale_sets": {
            "key": "properties.virtualMachineScaleSets",
            "type": "[SubResourceWithColocationStatus]",
        },
        "availability_sets": {"key": "properties.availabilitySets", "type": "[SubResourceWithColocationStatus]"},
        "colocation_status": {"key": "properties.colocationStatus", "type": "InstanceViewStatus"},
        "intent": {"key": "properties.intent", "type": "ProximityPlacementGroupPropertiesIntent"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        proximity_placement_group_type: Optional[Union[str, "_models.ProximityPlacementGroupType"]] = None,
        colocation_status: Optional["_models.InstanceViewStatus"] = None,
        intent: Optional["_models.ProximityPlacementGroupPropertiesIntent"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: Specifies the Availability Zone where virtual machine, virtual machine scale
         set or availability set associated with the  proximity placement group can be created.
        :paramtype zones: list[str]
        :keyword proximity_placement_group_type: Specifies the type of the proximity placement group.
         :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Standard** : Co-locate
         resources within an Azure region or Availability Zone. :code:`<br>`:code:`<br>` **Ultra** : For
         future use. Known values are: "Standard" and "Ultra".
        :paramtype proximity_placement_group_type: str or
         ~azure.mgmt.compute.models.ProximityPlacementGroupType
        :keyword colocation_status: Describes colocation status of the Proximity Placement Group.
        :paramtype colocation_status: ~azure.mgmt.compute.models.InstanceViewStatus
        :keyword intent: Specifies the user intent of the proximity placement group.
        :paramtype intent:
         ~azure.mgmt.compute.models.ProximityPlacementGroupPropertiesIntent
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.zones = zones
        self.proximity_placement_group_type = proximity_placement_group_type
        self.virtual_machines = None
        self.virtual_machine_scale_sets = None
        self.availability_sets = None
        self.colocation_status = colocation_status
        self.intent = intent

class ProximityPlacementGroupListResult(_serialization.Model):
    """The List Proximity Placement Group operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of proximity placement groups. Required.
    :vartype value: list[~azure.mgmt.compute.models.ProximityPlacementGroup]
    :ivar next_link: The URI to fetch the next page of proximity placement groups.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProximityPlacementGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ProximityPlacementGroup"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of proximity placement groups. Required.
        :paramtype value: list[~azure.mgmt.compute.models.ProximityPlacementGroup]
        :keyword next_link: The URI to fetch the next page of proximity placement groups.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ProximityPlacementGroupUpdate(UpdateResource):
    """Specifies information about the proximity placement group.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(tags=tags, **kwargs)

class SnapshotSku(_serialization.Model):
    """The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional
    parameter for incremental snapshot and the default behavior is the SKU will be set to the same
    sku as the previous snapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name. Known values are: "Standard_LRS", "Premium_LRS", and "Standard_ZRS".
    :vartype name: str or ~azure.mgmt.compute.models.SnapshotStorageAccountTypes
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _validation = {
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.SnapshotStorageAccountTypes"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name. Known values are: "Standard_LRS", "Premium_LRS", and
         "Standard_ZRS".
        :paramtype name: str or ~azure.mgmt.compute.models.SnapshotStorageAccountTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = None

class VirtualMachineScaleSetIpTag(_serialization.Model):
    """Contains the IP tag associated with the public IP address.

    :ivar ip_tag_type: IP tag type. Example: FirstPartyUsage.
    :vartype ip_tag_type: str
    :ivar tag: IP tag associated with the public IP. Example: SQL, Storage etc.
    :vartype tag: str
    """

    _attribute_map = {
        "ip_tag_type": {"key": "ipTagType", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
    }

    def __init__(self, *, ip_tag_type: Optional[str] = None, tag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_tag_type: IP tag type. Example: FirstPartyUsage.
        :paramtype ip_tag_type: str
        :keyword tag: IP tag associated with the public IP. Example: SQL, Storage etc.
        :paramtype tag: str
        """
        super().__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag

class AdditionalCapabilities(_serialization.Model):
    """Enables or disables a capability on the virtual machine or virtual machine scale set.

    :ivar ultra_ssd_enabled: The flag that enables or disables a capability to have one or more
     managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with
     storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale
     set only if this property is enabled.
    :vartype ultra_ssd_enabled: bool
    :ivar hibernation_enabled: The flag that enables or disables hibernation capability on the VM.
    :vartype hibernation_enabled: bool
    """

    _attribute_map = {
        "ultra_ssd_enabled": {"key": "ultraSSDEnabled", "type": "bool"},
        "hibernation_enabled": {"key": "hibernationEnabled", "type": "bool"},
    }

    def __init__(
        self, *, ultra_ssd_enabled: Optional[bool] = None, hibernation_enabled: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword ultra_ssd_enabled: The flag that enables or disables a capability to have one or more
         managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with
         storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale
         set only if this property is enabled.
        :paramtype ultra_ssd_enabled: bool
        :keyword hibernation_enabled: The flag that enables or disables hibernation capability on the
         VM.
        :paramtype hibernation_enabled: bool
        """
        super().__init__(**kwargs)
        self.ultra_ssd_enabled = ultra_ssd_enabled
        self.hibernation_enabled = hibernation_enabled

class DiffDiskSettings(_serialization.Model):
    """Describes the parameters of ephemeral disk settings that can be specified for operating system
    disk. :code:`<br>`:code:`<br>` NOTE: The ephemeral disk settings can only be specified for
    managed disk.

    :ivar option: Specifies the ephemeral disk settings for operating system disk. "Local"
    :vartype option: str or ~azure.mgmt.compute.models.DiffDiskOptions
    :ivar placement: Specifies the ephemeral disk placement for operating system
     disk.:code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **CacheDisk**
     :code:`<br>`:code:`<br>` **ResourceDisk** :code:`<br>`:code:`<br>` Default: **CacheDisk** if
     one is configured for the VM size otherwise **ResourceDisk** is used.:code:`<br>`:code:`<br>`
     Refer to VM size documentation for Windows VM at
     https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
     https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a
     cache disk. Known values are: "CacheDisk" and "ResourceDisk".
    :vartype placement: str or ~azure.mgmt.compute.models.DiffDiskPlacement
    """

    _attribute_map = {
        "option": {"key": "option", "type": "str"},
        "placement": {"key": "placement", "type": "str"},
    }

    def __init__(
        self,
        *,
        option: Optional[Union[str, "_models.DiffDiskOptions"]] = None,
        placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword option: Specifies the ephemeral disk settings for operating system disk. "Local"
        :paramtype option: str or ~azure.mgmt.compute.models.DiffDiskOptions
        :keyword placement: Specifies the ephemeral disk placement for operating system
         disk.:code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **CacheDisk**
         :code:`<br>`:code:`<br>` **ResourceDisk** :code:`<br>`:code:`<br>` Default: **CacheDisk** if
         one is configured for the VM size otherwise **ResourceDisk** is used.:code:`<br>`:code:`<br>`
         Refer to VM size documentation for Windows VM at
         https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
         https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a
         cache disk. Known values are: "CacheDisk" and "ResourceDisk".
        :paramtype placement: str or ~azure.mgmt.compute.models.DiffDiskPlacement
        """
        super().__init__(**kwargs)
        self.option = option
        self.placement = placement

class Disallowed(_serialization.Model):
    """Describes the disallowed disk types.

    :ivar disk_types: A list of disk types.
    :vartype disk_types: list[str]
    """

    _attribute_map = {
        "disk_types": {"key": "diskTypes", "type": "[str]"},
    }

    def __init__(self, *, disk_types: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword disk_types: A list of disk types.
        :paramtype disk_types: list[str]
        """
        super().__init__(**kwargs)
        self.disk_types = disk_types

class Gallery(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the Shared Image Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this Shared Image Gallery resource. This property is
     updatable.
    :vartype description: str
    :ivar identifier: Describes the gallery unique name.
    :vartype identifier: ~azure.mgmt.compute.models.GalleryIdentifier
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar sharing_profile: Profile for gallery sharing to subscription or tenant.
    :vartype sharing_profile: ~azure.mgmt.compute.models.SharingProfile
    :ivar soft_delete_policy: Contains information about the soft deletion policy of the gallery.
    :vartype soft_delete_policy: ~azure.mgmt.compute.models.SoftDeletePolicy
    :ivar sharing_status: Sharing status of current gallery.
    :vartype sharing_status: ~azure.mgmt.compute.models.SharingStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "sharing_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "GalleryIdentifier"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sharing_profile": {"key": "properties.sharingProfile", "type": "SharingProfile"},
        "soft_delete_policy": {"key": "properties.softDeletePolicy", "type": "SoftDeletePolicy"},
        "sharing_status": {"key": "properties.sharingStatus", "type": "SharingStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        identifier: Optional["_models.GalleryIdentifier"] = None,
        sharing_profile: Optional["_models.SharingProfile"] = None,
        soft_delete_policy: Optional["_models.SoftDeletePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this Shared Image Gallery resource. This property is
         updatable.
        :paramtype description: str
        :keyword identifier: Describes the gallery unique name.
        :paramtype identifier: ~azure.mgmt.compute.models.GalleryIdentifier
        :keyword sharing_profile: Profile for gallery sharing to subscription or tenant.
        :paramtype sharing_profile: ~azure.mgmt.compute.models.SharingProfile
        :keyword soft_delete_policy: Contains information about the soft deletion policy of the
         gallery.
        :paramtype soft_delete_policy: ~azure.mgmt.compute.models.SoftDeletePolicy
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.identifier = identifier
        self.provisioning_state = None
        self.sharing_profile = sharing_profile
        self.soft_delete_policy = soft_delete_policy
        self.sharing_status = None

class GalleryArtifactPublishingProfileBase(_serialization.Model):
    """Describes the basic gallery artifact publishing profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS", and "StandardSSD_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full" and "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
    """

    _validation = {
        "published_date": {"readonly": True},
    }

    _attribute_map = {
        "target_regions": {"key": "targetRegions", "type": "[TargetRegion]"},
        "replica_count": {"key": "replicaCount", "type": "int"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "endOfLifeDate", "type": "iso-8601"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "replication_mode": {"key": "replicationMode", "type": "str"},
        "target_extended_locations": {"key": "targetExtendedLocations", "type": "[GalleryTargetExtendedLocation]"},
    }

    def __init__(
        self,
        *,
        target_regions: Optional[List["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[List["_models.GalleryTargetExtendedLocation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS", and "StandardSSD_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full" and "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
        """
        super().__init__(**kwargs)
        self.target_regions = target_regions
        self.replica_count = replica_count
        self.exclude_from_latest = exclude_from_latest
        self.published_date = None
        self.end_of_life_date = end_of_life_date
        self.storage_account_type = storage_account_type
        self.replication_mode = replication_mode
        self.target_extended_locations = target_extended_locations

class GalleryArtifactSource(_serialization.Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to Azure.

    :ivar managed_image: The managed artifact. Required.
    :vartype managed_image: ~azure.mgmt.compute.models.ManagedArtifact
    """

    _validation = {
        "managed_image": {"required": True},
    }

    _attribute_map = {
        "managed_image": {"key": "managedImage", "type": "ManagedArtifact"},
    }

    def __init__(self, *, managed_image: "_models.ManagedArtifact", **kwargs: Any) -> None:
        """
        :keyword managed_image: The managed artifact. Required.
        :paramtype managed_image: ~azure.mgmt.compute.models.ManagedArtifact
        """
        super().__init__(**kwargs)
        self.managed_image = managed_image

class GalleryDiskImage(_serialization.Model):
    """This is the disk image base class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.models.HostCaching
    :ivar source: The source for the disk image.
    :vartype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
    """

    _validation = {
        "size_in_gb": {"readonly": True},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
        "source": {"key": "source", "type": "GalleryDiskImageSource"},
    }

    def __init__(
        self,
        *,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryDiskImageSource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.models.HostCaching
        :keyword source: The source for the disk image.
        :paramtype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
        """
        super().__init__(**kwargs)
        self.size_in_gb = None
        self.host_caching = host_caching
        self.source = source

class GalleryDataDiskImage(GalleryDiskImage):
    """This is the data disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.models.HostCaching
    :ivar source: The source for the disk image.
    :vartype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
    :ivar lun: This property specifies the logical unit number of the data disk. This value is used
     to identify data disks within the Virtual Machine and therefore must be unique for each data
     disk attached to the Virtual Machine. Required.
    :vartype lun: int
    """

    _validation = {
        "size_in_gb": {"readonly": True},
        "lun": {"required": True},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
        "source": {"key": "source", "type": "GalleryDiskImageSource"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(
        self,
        *,
        lun: int,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryDiskImageSource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.models.HostCaching
        :keyword source: The source for the disk image.
        :paramtype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
        :keyword lun: This property specifies the logical unit number of the data disk. This value is
         used to identify data disks within the Virtual Machine and therefore must be unique for each
         data disk attached to the Virtual Machine. Required.
        :paramtype lun: int
        """
        super().__init__(host_caching=host_caching, source=source, **kwargs)
        self.lun = lun

class GalleryIdentifier(_serialization.Model):
    """Describes the gallery unique name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unique_name: The unique name of the Shared Image Gallery. This name is generated
     automatically by Azure.
    :vartype unique_name: str
    """

    _validation = {
        "unique_name": {"readonly": True},
    }

    _attribute_map = {
        "unique_name": {"key": "uniqueName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.unique_name = None

class GalleryImage(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery image definition resource. This property is
     updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery image definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.models.Disallowed
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.models.Architecture
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "architecture": {"key": "properties.architecture", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        features: Optional[List["_models.GalleryImageFeature"]] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery image definition resource. This property
         is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery image definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.models.Disallowed
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.models.Architecture
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_v_generation = hyper_v_generation
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state = None
        self.features = features
        self.architecture = architecture

class GalleryImageIdentifier(_serialization.Model):
    """This is the gallery image definition identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher: The name of the gallery image definition publisher. Required.
    :vartype publisher: str
    :ivar offer: The name of the gallery image definition offer. Required.
    :vartype offer: str
    :ivar sku: The name of the gallery image definition SKU. Required.
    :vartype sku: str
    """

    _validation = {
        "publisher": {"required": True},
        "offer": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
    }

    def __init__(self, *, publisher: str, offer: str, sku: str, **kwargs: Any) -> None:
        """
        :keyword publisher: The name of the gallery image definition publisher. Required.
        :paramtype publisher: str
        :keyword offer: The name of the gallery image definition offer. Required.
        :paramtype offer: str
        :keyword sku: The name of the gallery image definition SKU. Required.
        :paramtype sku: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku

class GalleryImageList(_serialization.Model):
    """The List Gallery Images operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of Shared Image Gallery images. Required.
    :vartype value: list[~azure.mgmt.compute.models.GalleryImage]
    :ivar next_link: The uri to fetch the next page of Image Definitions in the Shared Image
     Gallery. Call ListNext() with this to fetch the next page of gallery image definitions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryImage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.GalleryImage"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of Shared Image Gallery images. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GalleryImage]
        :keyword next_link: The uri to fetch the next page of Image Definitions in the Shared Image
         Gallery. Call ListNext() with this to fetch the next page of gallery image definitions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class GalleryImageVersion(Resource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image Version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.models.GalleryImageVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar storage_profile: This is the storage profile of a Gallery Image Version.
    :vartype storage_profile:
     ~azure.mgmt.compute.models.GalleryImageVersionStorageProfile
    :ivar safety_profile: This is the safety profile of the Gallery Image Version.
    :vartype safety_profile:
     ~azure.mgmt.compute.models.GalleryImageVersionSafetyProfile
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "publishing_profile": {"key": "properties.publishingProfile", "type": "GalleryImageVersionPublishingProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "storage_profile": {"key": "properties.storageProfile", "type": "GalleryImageVersionStorageProfile"},
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryImageVersionSafetyProfile"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryImageVersionPublishingProfile"] = None,
        storage_profile: Optional["_models.GalleryImageVersionStorageProfile"] = None,
        safety_profile: Optional["_models.GalleryImageVersionSafetyProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image Version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.models.GalleryImageVersionPublishingProfile
        :keyword storage_profile: This is the storage profile of a Gallery Image Version.
        :paramtype storage_profile:
         ~azure.mgmt.compute.models.GalleryImageVersionStorageProfile
        :keyword safety_profile: This is the safety profile of the Gallery Image Version.
        :paramtype safety_profile:
         ~azure.mgmt.compute.models.GalleryImageVersionSafetyProfile
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.storage_profile = storage_profile
        self.safety_profile = safety_profile
        self.replication_status = None

class GalleryImageVersionList(_serialization.Model):
    """The List Gallery Image version operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of gallery image versions. Required.
    :vartype value: list[~azure.mgmt.compute.models.GalleryImageVersion]
    :ivar next_link: The uri to fetch the next page of gallery image versions. Call ListNext() with
     this to fetch the next page of gallery image versions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryImageVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.GalleryImageVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of gallery image versions. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GalleryImageVersion]
        :keyword next_link: The uri to fetch the next page of gallery image versions. Call ListNext()
         with this to fetch the next page of gallery image versions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class GalleryImageVersionPublishingProfile(GalleryArtifactPublishingProfileBase):
    """The publishing profile of a gallery image Version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS", and "StandardSSD_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full" and "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
    """

    _validation = {
        "published_date": {"readonly": True},
    }

    _attribute_map = {
        "target_regions": {"key": "targetRegions", "type": "[TargetRegion]"},
        "replica_count": {"key": "replicaCount", "type": "int"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "endOfLifeDate", "type": "iso-8601"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "replication_mode": {"key": "replicationMode", "type": "str"},
        "target_extended_locations": {"key": "targetExtendedLocations", "type": "[GalleryTargetExtendedLocation]"},
    }

    def __init__(
        self,
        *,
        target_regions: Optional[List["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[List["_models.GalleryTargetExtendedLocation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS", and "StandardSSD_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full" and "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
        """
        super().__init__(
            target_regions=target_regions,
            replica_count=replica_count,
            exclude_from_latest=exclude_from_latest,
            end_of_life_date=end_of_life_date,
            storage_account_type=storage_account_type,
            replication_mode=replication_mode,
            target_extended_locations=target_extended_locations,
            **kwargs
        )

class GalleryImageVersionStorageProfile(_serialization.Model):
    """This is the storage profile of a Gallery Image Version.

    :ivar source: The source of the gallery artifact version.
    :vartype source: ~azure.mgmt.compute.models.GalleryArtifactVersionFullSource
    :ivar os_disk_image: This is the OS disk image.
    :vartype os_disk_image: ~azure.mgmt.compute.models.GalleryOSDiskImage
    :ivar data_disk_images: A list of data disk images.
    :vartype data_disk_images: list[~azure.mgmt.compute.models.GalleryDataDiskImage]
    """

    _attribute_map = {
        "source": {"key": "source", "type": "GalleryArtifactVersionFullSource"},
        "os_disk_image": {"key": "osDiskImage", "type": "GalleryOSDiskImage"},
        "data_disk_images": {"key": "dataDiskImages", "type": "[GalleryDataDiskImage]"},
    }

    def __init__(
        self,
        *,
        source: Optional["_models.GalleryArtifactVersionFullSource"] = None,
        os_disk_image: Optional["_models.GalleryOSDiskImage"] = None,
        data_disk_images: Optional[List["_models.GalleryDataDiskImage"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: The source of the gallery artifact version.
        :paramtype source: ~azure.mgmt.compute.models.GalleryArtifactVersionFullSource
        :keyword os_disk_image: This is the OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.compute.models.GalleryOSDiskImage
        :keyword data_disk_images: A list of data disk images.
        :paramtype data_disk_images: list[~azure.mgmt.compute.models.GalleryDataDiskImage]
        """
        super().__init__(**kwargs)
        self.source = source
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images

class GalleryList(_serialization.Model):
    """The List Galleries operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of galleries. Required.
    :vartype value: list[~azure.mgmt.compute.models.Gallery]
    :ivar next_link: The uri to fetch the next page of galleries. Call ListNext() with this to
     fetch the next page of galleries.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Gallery]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Gallery"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of galleries. Required.
        :paramtype value: list[~azure.mgmt.compute.models.Gallery]
        :keyword next_link: The uri to fetch the next page of galleries. Call ListNext() with this to
         fetch the next page of galleries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class GalleryOSDiskImage(GalleryDiskImage):
    """This is the OS disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.models.HostCaching
    :ivar source: The source for the disk image.
    :vartype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
    """

    _validation = {
        "size_in_gb": {"readonly": True},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "host_caching": {"key": "hostCaching", "type": "str"},
        "source": {"key": "source", "type": "GalleryDiskImageSource"},
    }

    def __init__(
        self,
        *,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryDiskImageSource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", and "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.models.HostCaching
        :keyword source: The source for the disk image.
        :paramtype source: ~azure.mgmt.compute.models.GalleryDiskImageSource
        """
        super().__init__(host_caching=host_caching, source=source, **kwargs)

class ImagePurchasePlan(_serialization.Model):
    """Describes the gallery image definition purchase plan. This is used by marketplace images.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: The product ID.
    :vartype product: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: The product ID.
        :paramtype product: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product

class ManagedArtifact(_serialization.Model):
    """The managed artifact.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The managed artifact id. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The managed artifact id. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id

class RecommendedMachineConfiguration(_serialization.Model):
    """The properties describe the recommended machine configuration for this Image Definition. These
    properties are updatable.

    :ivar v_cp_us: Describes the resource range.
    :vartype v_cp_us: ~azure.mgmt.compute.models.ResourceRange
    :ivar memory: Describes the resource range.
    :vartype memory: ~azure.mgmt.compute.models.ResourceRange
    """

    _attribute_map = {
        "v_cp_us": {"key": "vCPUs", "type": "ResourceRange"},
        "memory": {"key": "memory", "type": "ResourceRange"},
    }

    def __init__(
        self,
        *,
        v_cp_us: Optional["_models.ResourceRange"] = None,
        memory: Optional["_models.ResourceRange"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword v_cp_us: Describes the resource range.
        :paramtype v_cp_us: ~azure.mgmt.compute.models.ResourceRange
        :keyword memory: Describes the resource range.
        :paramtype memory: ~azure.mgmt.compute.models.ResourceRange
        """
        super().__init__(**kwargs)
        self.v_cp_us = v_cp_us
        self.memory = memory

class RegionalReplicationStatus(_serialization.Model):
    """This is the regional replication status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar region: The region to which the gallery image version is being replicated to.
    :vartype region: str
    :ivar state: This is the regional replication state. Known values are: "Unknown",
     "Replicating", "Completed", and "Failed".
    :vartype state: str or ~azure.mgmt.compute.models.ReplicationState
    :ivar details: The details of the replication status.
    :vartype details: str
    :ivar progress: It indicates progress of the replication job.
    :vartype progress: int
    """

    _validation = {
        "region": {"readonly": True},
        "state": {"readonly": True},
        "details": {"readonly": True},
        "progress": {"readonly": True},
    }

    _attribute_map = {
        "region": {"key": "region", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "details": {"key": "details", "type": "str"},
        "progress": {"key": "progress", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.region = None
        self.state = None
        self.details = None
        self.progress = None

class ReplicationStatus(_serialization.Model):
    """This is the replication status of the gallery image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aggregated_state: This is the aggregated replication status based on all the regional
     replication status flags. Known values are: "Unknown", "InProgress", "Completed", and "Failed".
    :vartype aggregated_state: str or
     ~azure.mgmt.compute.models.AggregatedReplicationState
    :ivar summary: This is a summary of replication status for each region.
    :vartype summary: list[~azure.mgmt.compute.models.RegionalReplicationStatus]
    """

    _validation = {
        "aggregated_state": {"readonly": True},
        "summary": {"readonly": True},
    }

    _attribute_map = {
        "aggregated_state": {"key": "aggregatedState", "type": "str"},
        "summary": {"key": "summary", "type": "[RegionalReplicationStatus]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.aggregated_state = None
        self.summary = None

class ResourceRange(_serialization.Model):
    """Describes the resource range.

    :ivar min: The minimum number of the resource.
    :vartype min: int
    :ivar max: The maximum number of the resource.
    :vartype max: int
    """

    _attribute_map = {
        "min": {"key": "min", "type": "int"},
        "max": {"key": "max", "type": "int"},
    }

    def __init__(
        self,
        *,
        min: Optional[int] = None,  # pylint: disable=redefined-builtin
        max: Optional[int] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword min: The minimum number of the resource.
        :paramtype min: int
        :keyword max: The maximum number of the resource.
        :paramtype max: int
        """
        super().__init__(**kwargs)
        self.min = min
        self.max = max

class TargetRegion(_serialization.Model):
    """Describes the target region information.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the region. Required.
    :vartype name: str
    :ivar regional_replica_count: The number of replicas of the Image Version to be created per
     region. This property is updatable.
    :vartype regional_replica_count: int
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS", and "StandardSSD_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
    :ivar encryption: Optional. Allows users to provide customer managed keys for encrypting the OS
     and data disks in the gallery artifact.
    :vartype encryption: ~azure.mgmt.compute.models.EncryptionImages
    :ivar exclude_from_latest: Contains the flag setting to hide an image when users specify
     version='latest'.
    :vartype exclude_from_latest: bool
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "regional_replica_count": {"key": "regionalReplicaCount", "type": "int"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "encryption": {"key": "encryption", "type": "EncryptionImages"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        regional_replica_count: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        encryption: Optional["_models.EncryptionImages"] = None,
        exclude_from_latest: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the region. Required.
        :paramtype name: str
        :keyword regional_replica_count: The number of replicas of the Image Version to be created per
         region. This property is updatable.
        :paramtype regional_replica_count: int
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS", and "StandardSSD_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.models.StorageAccountType
        :keyword encryption: Optional. Allows users to provide customer managed keys for encrypting the
         OS and data disks in the gallery artifact.
        :paramtype encryption: ~azure.mgmt.compute.models.EncryptionImages
        :keyword exclude_from_latest: Contains the flag setting to hide an image when users specify
         version='latest'.
        :paramtype exclude_from_latest: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.regional_replica_count = regional_replica_count
        self.storage_account_type = storage_account_type
        self.encryption = encryption
        self.exclude_from_latest = exclude_from_latest

class UserAssignedIdentitiesValue(_serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None

class VirtualMachineReimageParameters(_serialization.Model):
    """Parameters for Reimaging Virtual Machine. NOTE: Virtual Machine OS disk will always be
    reimaged.

    :ivar temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :vartype temp_disk: bool
    :ivar exact_version: Specifies in decimal number, the version the OS disk should be reimaged
     to. If exact version is not provided, the OS disk is reimaged to the existing version of OS
     Disk.
    :vartype exact_version: str
    :ivar os_profile: Specifies information required for reimaging the non-ephemeral OS disk.
    :vartype os_profile: ~azure.mgmt.compute.models.OSProfileProvisioningData
    """

    _attribute_map = {
        "temp_disk": {"key": "tempDisk", "type": "bool"},
        "exact_version": {"key": "exactVersion", "type": "str"},
        "os_profile": {"key": "osProfile", "type": "OSProfileProvisioningData"},
    }

    def __init__(
        self,
        *,
        temp_disk: Optional[bool] = None,
        exact_version: Optional[str] = None,
        os_profile: Optional["_models.OSProfileProvisioningData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This
         temp disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
        :paramtype temp_disk: bool
        :keyword exact_version: Specifies in decimal number, the version the OS disk should be reimaged
         to. If exact version is not provided, the OS disk is reimaged to the existing version of OS
         Disk.
        :paramtype exact_version: str
        :keyword os_profile: Specifies information required for reimaging the non-ephemeral OS disk.
        :paramtype os_profile: ~azure.mgmt.compute.models.OSProfileProvisioningData
        """
        super().__init__(**kwargs)
        self.temp_disk = temp_disk
        self.exact_version = exact_version
        self.os_profile = os_profile

class VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue(_serialization.Model):
    """VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None

class VirtualMachineScaleSetVMReimageParameters(VirtualMachineReimageParameters):
    """Describes a Virtual Machine Scale Set VM Reimage Parameters.

    :ivar temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :vartype temp_disk: bool
    :ivar exact_version: Specifies in decimal number, the version the OS disk should be reimaged
     to. If exact version is not provided, the OS disk is reimaged to the existing version of OS
     Disk.
    :vartype exact_version: str
    :ivar os_profile: Specifies information required for reimaging the non-ephemeral OS disk.
    :vartype os_profile: ~azure.mgmt.compute.models.OSProfileProvisioningData
    """

    _attribute_map = {
        "temp_disk": {"key": "tempDisk", "type": "bool"},
        "exact_version": {"key": "exactVersion", "type": "str"},
        "os_profile": {"key": "osProfile", "type": "OSProfileProvisioningData"},
    }

    def __init__(
        self,
        *,
        temp_disk: Optional[bool] = None,
        exact_version: Optional[str] = None,
        os_profile: Optional["_models.OSProfileProvisioningData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This
         temp disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
        :paramtype temp_disk: bool
        :keyword exact_version: Specifies in decimal number, the version the OS disk should be reimaged
         to. If exact version is not provided, the OS disk is reimaged to the existing version of OS
         Disk.
        :paramtype exact_version: str
        :keyword os_profile: Specifies information required for reimaging the non-ephemeral OS disk.
        :paramtype os_profile: ~azure.mgmt.compute.models.OSProfileProvisioningData
        """
        super().__init__(temp_disk=temp_disk, exact_version=exact_version, os_profile=os_profile, **kwargs)

class VirtualMachineScaleSetReimageParameters(VirtualMachineScaleSetVMReimageParameters):
    """Describes a Virtual Machine Scale Set VM Reimage Parameters.

    :ivar temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :vartype temp_disk: bool
    :ivar exact_version: Specifies in decimal number, the version the OS disk should be reimaged
     to. If exact version is not provided, the OS disk is reimaged to the existing version of OS
     Disk.
    :vartype exact_version: str
    :ivar os_profile: Specifies information required for reimaging the non-ephemeral OS disk.
    :vartype os_profile: ~azure.mgmt.compute.models.OSProfileProvisioningData
    :ivar instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :vartype instance_ids: list[str]
    """

    _attribute_map = {
        "temp_disk": {"key": "tempDisk", "type": "bool"},
        "exact_version": {"key": "exactVersion", "type": "str"},
        "os_profile": {"key": "osProfile", "type": "OSProfileProvisioningData"},
        "instance_ids": {"key": "instanceIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        temp_disk: Optional[bool] = None,
        exact_version: Optional[str] = None,
        os_profile: Optional["_models.OSProfileProvisioningData"] = None,
        instance_ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This
         temp disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
        :paramtype temp_disk: bool
        :keyword exact_version: Specifies in decimal number, the version the OS disk should be reimaged
         to. If exact version is not provided, the OS disk is reimaged to the existing version of OS
         Disk.
        :paramtype exact_version: str
        :keyword os_profile: Specifies information required for reimaging the non-ephemeral OS disk.
        :paramtype os_profile: ~azure.mgmt.compute.models.OSProfileProvisioningData
        :keyword instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
         scale set instance ids will result in the operation being performed on all virtual machines in
         the virtual machine scale set.
        :paramtype instance_ids: list[str]
        """
        super().__init__(temp_disk=temp_disk, exact_version=exact_version, os_profile=os_profile, **kwargs)
        self.instance_ids = instance_ids

class EncryptionSettingsCollection(_serialization.Model):
    """Encryption settings for disk or snapshot.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Set this flag to true and provide DiskEncryptionKey and optional
     KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and
     KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object,
     the existing settings remain unchanged. Required.
    :vartype enabled: bool
    :ivar encryption_settings: A collection of encryption settings, one for each disk volume.
    :vartype encryption_settings:
     list[~azure.mgmt.compute.models.EncryptionSettingsElement]
    :ivar encryption_settings_version: Describes what type of encryption is used for the disks.
     Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption
     with AAD app.'1.1' corresponds to Azure Disk Encryption.
    :vartype encryption_settings_version: str
    """

    _validation = {
        "enabled": {"required": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "encryption_settings": {"key": "encryptionSettings", "type": "[EncryptionSettingsElement]"},
        "encryption_settings_version": {"key": "encryptionSettingsVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        encryption_settings: Optional[List["_models.EncryptionSettingsElement"]] = None,
        encryption_settings_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Set this flag to true and provide DiskEncryptionKey and optional
         KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and
         KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object,
         the existing settings remain unchanged. Required.
        :paramtype enabled: bool
        :keyword encryption_settings: A collection of encryption settings, one for each disk volume.
        :paramtype encryption_settings:
         list[~azure.mgmt.compute.models.EncryptionSettingsElement]
        :keyword encryption_settings_version: Describes what type of encryption is used for the disks.
         Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption
         with AAD app.'1.1' corresponds to Azure Disk Encryption.
        :paramtype encryption_settings_version: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.encryption_settings = encryption_settings
        self.encryption_settings_version = encryption_settings_version

class EncryptionSettingsElement(_serialization.Model):
    """Encryption settings for one disk volume.

    :ivar disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key.
    :vartype disk_encryption_key: ~azure.mgmt.compute.models.KeyVaultAndSecretReference
    :ivar key_encryption_key: Key Vault Key Url and vault id of the key encryption key.
     KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
    :vartype key_encryption_key: ~azure.mgmt.compute.models.KeyVaultAndKeyReference
    """

    _attribute_map = {
        "disk_encryption_key": {"key": "diskEncryptionKey", "type": "KeyVaultAndSecretReference"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyVaultAndKeyReference"},
    }

    def __init__(
        self,
        *,
        disk_encryption_key: Optional["_models.KeyVaultAndSecretReference"] = None,
        key_encryption_key: Optional["_models.KeyVaultAndKeyReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key.
        :paramtype disk_encryption_key:
         ~azure.mgmt.compute.models.KeyVaultAndSecretReference
        :keyword key_encryption_key: Key Vault Key Url and vault id of the key encryption key.
         KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
        :paramtype key_encryption_key: ~azure.mgmt.compute.models.KeyVaultAndKeyReference
        """
        super().__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key

class AutomaticOSUpgradePolicy(_serialization.Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :ivar enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be
     applied to scale set instances in a rolling fashion when a newer version of the OS image
     becomes available. Default value is false. :code:`<br>`:code:`<br>` If this is set to true for
     Windows based scale sets, `enableAutomaticUpdates
     <https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet>`_
     is automatically set to false and cannot be set to true.
    :vartype enable_automatic_os_upgrade: bool
    :ivar disable_automatic_rollback: Whether OS image rollback feature should be disabled. Default
     value is false.
    :vartype disable_automatic_rollback: bool
    :ivar use_rolling_upgrade_policy: Indicates whether rolling upgrade policy should be used
     during Auto OS Upgrade. Default value is false. Auto OS Upgrade will fallback to the default
     policy if no policy is defined on the VMSS.
    :vartype use_rolling_upgrade_policy: bool
    """

    _attribute_map = {
        "enable_automatic_os_upgrade": {"key": "enableAutomaticOSUpgrade", "type": "bool"},
        "disable_automatic_rollback": {"key": "disableAutomaticRollback", "type": "bool"},
        "use_rolling_upgrade_policy": {"key": "useRollingUpgradePolicy", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enable_automatic_os_upgrade: Optional[bool] = None,
        disable_automatic_rollback: Optional[bool] = None,
        use_rolling_upgrade_policy: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be
         applied to scale set instances in a rolling fashion when a newer version of the OS image
         becomes available. Default value is false. :code:`<br>`:code:`<br>` If this is set to true for
         Windows based scale sets, `enableAutomaticUpdates
         <https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet>`_
         is automatically set to false and cannot be set to true.
        :paramtype enable_automatic_os_upgrade: bool
        :keyword disable_automatic_rollback: Whether OS image rollback feature should be disabled.
         Default value is false.
        :paramtype disable_automatic_rollback: bool
        :keyword use_rolling_upgrade_policy: Indicates whether rolling upgrade policy should be used
         during Auto OS Upgrade. Default value is false. Auto OS Upgrade will fallback to the default
         policy if no policy is defined on the VMSS.
        :paramtype use_rolling_upgrade_policy: bool
        """
        super().__init__(**kwargs)
        self.enable_automatic_os_upgrade = enable_automatic_os_upgrade
        self.disable_automatic_rollback = disable_automatic_rollback
        self.use_rolling_upgrade_policy = use_rolling_upgrade_policy

class AutomaticOSUpgradeProperties(_serialization.Model):
    """Describes automatic OS upgrade properties on the image.

    All required parameters must be populated in order to send to Azure.

    :ivar automatic_os_upgrade_supported: Specifies whether automatic OS upgrade is supported on
     the image. Required.
    :vartype automatic_os_upgrade_supported: bool
    """

    _validation = {
        "automatic_os_upgrade_supported": {"required": True},
    }

    _attribute_map = {
        "automatic_os_upgrade_supported": {"key": "automaticOSUpgradeSupported", "type": "bool"},
    }

    def __init__(self, *, automatic_os_upgrade_supported: bool, **kwargs: Any) -> None:
        """
        :keyword automatic_os_upgrade_supported: Specifies whether automatic OS upgrade is supported on
         the image. Required.
        :paramtype automatic_os_upgrade_supported: bool
        """
        super().__init__(**kwargs)
        self.automatic_os_upgrade_supported = automatic_os_upgrade_supported

class AutomaticRepairsPolicy(_serialization.Model):
    """Specifies the configuration parameters for automatic repairs on the virtual machine scale set.

    :ivar enabled: Specifies whether automatic repairs should be enabled on the virtual machine
     scale set. The default value is false.
    :vartype enabled: bool
    :ivar grace_period: The amount of time for which automatic repairs are suspended due to a state
     change on VM. The grace time starts after the state change has completed. This helps avoid
     premature or accidental repairs. The time duration should be specified in ISO 8601 format. The
     minimum allowed grace period is 10 minutes (PT10M), which is also the default value. The
     maximum allowed grace period is 90 minutes (PT90M).
    :vartype grace_period: str
    :ivar repair_action: Type of repair action (replace, restart, reimage) that will be used for
     repairing unhealthy virtual machines in the scale set. Default value is replace. Known values
     are: "Replace", "Restart", and "Reimage".
    :vartype repair_action: str or ~azure.mgmt.compute.models.RepairAction
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "grace_period": {"key": "gracePeriod", "type": "str"},
        "repair_action": {"key": "repairAction", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        grace_period: Optional[str] = None,
        repair_action: Optional[Union[str, "_models.RepairAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Specifies whether automatic repairs should be enabled on the virtual machine
         scale set. The default value is false.
        :paramtype enabled: bool
        :keyword grace_period: The amount of time for which automatic repairs are suspended due to a
         state change on VM. The grace time starts after the state change has completed. This helps
         avoid premature or accidental repairs. The time duration should be specified in ISO 8601
         format. The minimum allowed grace period is 10 minutes (PT10M), which is also the default
         value. The maximum allowed grace period is 90 minutes (PT90M).
        :paramtype grace_period: str
        :keyword repair_action: Type of repair action (replace, restart, reimage) that will be used for
         repairing unhealthy virtual machines in the scale set. Default value is replace. Known values
         are: "Replace", "Restart", and "Reimage".
        :paramtype repair_action: str or ~azure.mgmt.compute.models.RepairAction
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.grace_period = grace_period
        self.repair_action = repair_action

class BillingProfile(_serialization.Model):
    """Specifies the billing related details of a Azure Spot VM or VMSS.
    :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.

    :ivar max_price: Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS.
     This price is in US Dollars. :code:`<br>`:code:`<br>` This price will be compared with the
     current Azure Spot price for the VM size. Also, the prices are compared at the time of
     create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is
     greater than the current Azure Spot price. :code:`<br>`:code:`<br>` The maxPrice will also be
     used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice
     after creation of VM/VMSS. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` - Any decimal value greater than zero. Example: 0.01538
     :code:`<br>`:code:`<br>` -1 – indicates default price to be up-to on-demand.
     :code:`<br>`:code:`<br>` You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS
     should not be evicted for price reasons. Also, the default max price is -1 if it is not
     provided by you. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :vartype max_price: float
    """

    _attribute_map = {
        "max_price": {"key": "maxPrice", "type": "float"},
    }

    def __init__(self, *, max_price: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword max_price: Specifies the maximum price you are willing to pay for a Azure Spot
         VM/VMSS. This price is in US Dollars. :code:`<br>`:code:`<br>` This price will be compared with
         the current Azure Spot price for the VM size. Also, the prices are compared at the time of
         create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is
         greater than the current Azure Spot price. :code:`<br>`:code:`<br>` The maxPrice will also be
         used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice
         after creation of VM/VMSS. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` - Any decimal value greater than zero. Example: 0.01538
         :code:`<br>`:code:`<br>` -1 – indicates default price to be up-to on-demand.
         :code:`<br>`:code:`<br>` You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS
         should not be evicted for price reasons. Also, the default max price is -1 if it is not
         provided by you. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
        :paramtype max_price: float
        """
        super().__init__(**kwargs)
        self.max_price = max_price

class DedicatedHost(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the Dedicated host.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: SKU of the dedicated host for Hardware Generation and VM family. Only name is
     required to be set. List Microsoft.Compute SKUs for a list of possible values. Required.
    :vartype sku: ~azure.mgmt.compute.models.Sku
    :ivar platform_fault_domain: Fault domain of the dedicated host within a dedicated host group.
    :vartype platform_fault_domain: int
    :ivar auto_replace_on_failure: Specifies whether the dedicated host should be replaced
     automatically in case of a failure. The value is defaulted to 'true' when not provided.
    :vartype auto_replace_on_failure: bool
    :ivar host_id: A unique id generated and assigned to the dedicated host by the platform.
     :code:`<br>`:code:`<br>` Does not change throughout the lifetime of the host.
    :vartype host_id: str
    :ivar virtual_machines: A list of references to all virtual machines in the Dedicated Host.
    :vartype virtual_machines: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar license_type: Specifies the software license type that will be applied to the VMs
     deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
     :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
     **None**. Known values are: "None", "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
    :vartype license_type: str or ~azure.mgmt.compute.models.DedicatedHostLicenseTypes
    :ivar provisioning_time: The date when the host was first provisioned.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The dedicated host instance view.
    :vartype instance_view: ~azure.mgmt.compute.models.DedicatedHostInstanceView
    :ivar time_created: Specifies the time at which the Dedicated Host resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "platform_fault_domain": {"minimum": 0},
        "host_id": {"readonly": True},
        "virtual_machines": {"readonly": True},
        "provisioning_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "auto_replace_on_failure": {"key": "properties.autoReplaceOnFailure", "type": "bool"},
        "host_id": {"key": "properties.hostId", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResourceReadOnly]"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "provisioning_time": {"key": "properties.provisioningTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostInstanceView"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        platform_fault_domain: Optional[int] = None,
        auto_replace_on_failure: Optional[bool] = None,
        license_type: Optional[Union[str, "_models.DedicatedHostLicenseTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: SKU of the dedicated host for Hardware Generation and VM family. Only name is
         required to be set. List Microsoft.Compute SKUs for a list of possible values. Required.
        :paramtype sku: ~azure.mgmt.compute.models.Sku
        :keyword platform_fault_domain: Fault domain of the dedicated host within a dedicated host
         group.
        :paramtype platform_fault_domain: int
        :keyword auto_replace_on_failure: Specifies whether the dedicated host should be replaced
         automatically in case of a failure. The value is defaulted to 'true' when not provided.
        :paramtype auto_replace_on_failure: bool
        :keyword license_type: Specifies the software license type that will be applied to the VMs
         deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
         :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
         **None**. Known values are: "None", "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
        :paramtype license_type: str or
         ~azure.mgmt.compute.models.DedicatedHostLicenseTypes
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.platform_fault_domain = platform_fault_domain
        self.auto_replace_on_failure = auto_replace_on_failure
        self.host_id = None
        self.virtual_machines = None
        self.license_type = license_type
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None
        self.time_created = None

class DedicatedHostAllocatableVM(_serialization.Model):
    """Represents the dedicated host unutilized capacity in terms of a specific VM size.

    :ivar vm_size: VM size in terms of which the unutilized capacity is represented.
    :vartype vm_size: str
    :ivar count: Maximum number of VMs of size vmSize that can fit in the dedicated host's
     remaining capacity.
    :vartype count: float
    """

    _attribute_map = {
        "vm_size": {"key": "vmSize", "type": "str"},
        "count": {"key": "count", "type": "float"},
    }

    def __init__(self, *, vm_size: Optional[str] = None, count: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword vm_size: VM size in terms of which the unutilized capacity is represented.
        :paramtype vm_size: str
        :keyword count: Maximum number of VMs of size vmSize that can fit in the dedicated host's
         remaining capacity.
        :paramtype count: float
        """
        super().__init__(**kwargs)
        self.vm_size = vm_size
        self.count = count

class DedicatedHostAvailableCapacity(_serialization.Model):
    """Dedicated host unutilized capacity.

    :ivar allocatable_v_ms: The unutilized capacity of the dedicated host represented in terms of
     each VM size that is allowed to be deployed to the dedicated host.
    :vartype allocatable_v_ms:
     list[~azure.mgmt.compute.models.DedicatedHostAllocatableVM]
    """

    _attribute_map = {
        "allocatable_v_ms": {"key": "allocatableVMs", "type": "[DedicatedHostAllocatableVM]"},
    }

    def __init__(
        self, *, allocatable_v_ms: Optional[List["_models.DedicatedHostAllocatableVM"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword allocatable_v_ms: The unutilized capacity of the dedicated host represented in terms
         of each VM size that is allowed to be deployed to the dedicated host.
        :paramtype allocatable_v_ms:
         list[~azure.mgmt.compute.models.DedicatedHostAllocatableVM]
        """
        super().__init__(**kwargs)
        self.allocatable_v_ms = allocatable_v_ms

class DedicatedHostGroup(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the dedicated host group that the dedicated hosts should be
    assigned to. :code:`<br>`:code:`<br>` Currently, a dedicated host can only be added to a
    dedicated host group at creation time. An existing dedicated host cannot be added to another
    dedicated host group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: Availability Zone to use for this host group. Only single zone is supported. The
     zone can be assigned only during creation. If not provided, the group supports all zones in the
     region. If provided, enforces each host in the group to be in the same zone.
    :vartype zones: list[str]
    :ivar platform_fault_domain_count: Number of fault domains that the host group can span.
    :vartype platform_fault_domain_count: int
    :ivar hosts: A list of references to all dedicated hosts in the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar instance_view: The dedicated host group instance view, which has the list of instance
     view of the dedicated hosts under the dedicated host group.
    :vartype instance_view: ~azure.mgmt.compute.models.DedicatedHostGroupInstanceView
    :ivar support_automatic_placement: Specifies whether virtual machines or virtual machine scale
     sets can be placed automatically on the dedicated host group. Automatic placement means
     resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
     group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
     api-version: 2020-06-01.
    :vartype support_automatic_placement: bool
    :ivar additional_capabilities: Enables or disables a capability on the dedicated host
     group.:code:`<br>`:code:`<br>`Minimum api-version: 2022-03-01.
    :vartype additional_capabilities:
     ~azure.mgmt.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "platform_fault_domain_count": {"minimum": 1},
        "hosts": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "zones": {"key": "zones", "type": "[str]"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "hosts": {"key": "properties.hosts", "type": "[SubResourceReadOnly]"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostGroupInstanceView"},
        "support_automatic_placement": {"key": "properties.supportAutomaticPlacement", "type": "bool"},
        "additional_capabilities": {
            "key": "properties.additionalCapabilities",
            "type": "DedicatedHostGroupPropertiesAdditionalCapabilities",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        platform_fault_domain_count: Optional[int] = None,
        support_automatic_placement: Optional[bool] = None,
        additional_capabilities: Optional["_models.DedicatedHostGroupPropertiesAdditionalCapabilities"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: Availability Zone to use for this host group. Only single zone is supported.
         The zone can be assigned only during creation. If not provided, the group supports all zones in
         the region. If provided, enforces each host in the group to be in the same zone.
        :paramtype zones: list[str]
        :keyword platform_fault_domain_count: Number of fault domains that the host group can span.
        :paramtype platform_fault_domain_count: int
        :keyword support_automatic_placement: Specifies whether virtual machines or virtual machine
         scale sets can be placed automatically on the dedicated host group. Automatic placement means
         resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
         group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
         api-version: 2020-06-01.
        :paramtype support_automatic_placement: bool
        :keyword additional_capabilities: Enables or disables a capability on the dedicated host
         group.:code:`<br>`:code:`<br>`Minimum api-version: 2022-03-01.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.zones = zones
        self.platform_fault_domain_count = platform_fault_domain_count
        self.hosts = None
        self.instance_view = None
        self.support_automatic_placement = support_automatic_placement
        self.additional_capabilities = additional_capabilities

class DedicatedHostGroupListResult(_serialization.Model):
    """The List Dedicated Host Group with resource group response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of dedicated host groups. Required.
    :vartype value: list[~azure.mgmt.compute.models.DedicatedHostGroup]
    :ivar next_link: The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with
     this URI to fetch the next page of Dedicated Host Groups.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DedicatedHostGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DedicatedHostGroup"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of dedicated host groups. Required.
        :paramtype value: list[~azure.mgmt.compute.models.DedicatedHostGroup]
        :keyword next_link: The URI to fetch the next page of Dedicated Host Groups. Call ListNext()
         with this URI to fetch the next page of Dedicated Host Groups.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class DedicatedHostGroupUpdate(UpdateResource):
    """Specifies information about the dedicated host group that the dedicated host should be assigned
    to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar zones: Availability Zone to use for this host group. Only single zone is supported. The
     zone can be assigned only during creation. If not provided, the group supports all zones in the
     region. If provided, enforces each host in the group to be in the same zone.
    :vartype zones: list[str]
    :ivar platform_fault_domain_count: Number of fault domains that the host group can span.
    :vartype platform_fault_domain_count: int
    :ivar hosts: A list of references to all dedicated hosts in the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar instance_view: The dedicated host group instance view, which has the list of instance
     view of the dedicated hosts under the dedicated host group.
    :vartype instance_view: ~azure.mgmt.compute.models.DedicatedHostGroupInstanceView
    :ivar support_automatic_placement: Specifies whether virtual machines or virtual machine scale
     sets can be placed automatically on the dedicated host group. Automatic placement means
     resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
     group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
     api-version: 2020-06-01.
    :vartype support_automatic_placement: bool
    :ivar additional_capabilities: Enables or disables a capability on the dedicated host
     group.:code:`<br>`:code:`<br>`Minimum api-version: 2022-03-01.
    :vartype additional_capabilities:
     ~azure.mgmt.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities
    """

    _validation = {
        "platform_fault_domain_count": {"minimum": 1},
        "hosts": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "zones": {"key": "zones", "type": "[str]"},
        "platform_fault_domain_count": {"key": "properties.platformFaultDomainCount", "type": "int"},
        "hosts": {"key": "properties.hosts", "type": "[SubResourceReadOnly]"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostGroupInstanceView"},
        "support_automatic_placement": {"key": "properties.supportAutomaticPlacement", "type": "bool"},
        "additional_capabilities": {
            "key": "properties.additionalCapabilities",
            "type": "DedicatedHostGroupPropertiesAdditionalCapabilities",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        platform_fault_domain_count: Optional[int] = None,
        support_automatic_placement: Optional[bool] = None,
        additional_capabilities: Optional["_models.DedicatedHostGroupPropertiesAdditionalCapabilities"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword zones: Availability Zone to use for this host group. Only single zone is supported.
         The zone can be assigned only during creation. If not provided, the group supports all zones in
         the region. If provided, enforces each host in the group to be in the same zone.
        :paramtype zones: list[str]
        :keyword platform_fault_domain_count: Number of fault domains that the host group can span.
        :paramtype platform_fault_domain_count: int
        :keyword support_automatic_placement: Specifies whether virtual machines or virtual machine
         scale sets can be placed automatically on the dedicated host group. Automatic placement means
         resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
         group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
         api-version: 2020-06-01.
        :paramtype support_automatic_placement: bool
        :keyword additional_capabilities: Enables or disables a capability on the dedicated host
         group.:code:`<br>`:code:`<br>`Minimum api-version: 2022-03-01.
        :paramtype additional_capabilities:
         ~azure.mgmt.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities
        """
        super().__init__(tags=tags, **kwargs)
        self.zones = zones
        self.platform_fault_domain_count = platform_fault_domain_count
        self.hosts = None
        self.instance_view = None
        self.support_automatic_placement = support_automatic_placement
        self.additional_capabilities = additional_capabilities

class DedicatedHostInstanceView(_serialization.Model):
    """The instance view of a dedicated host.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_id: Specifies the unique id of the dedicated physical machine on which the
     dedicated host resides.
    :vartype asset_id: str
    :ivar available_capacity: Unutilized capacity of the dedicated host.
    :vartype available_capacity:
     ~azure.mgmt.compute.models.DedicatedHostAvailableCapacity
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _validation = {
        "asset_id": {"readonly": True},
    }

    _attribute_map = {
        "asset_id": {"key": "assetId", "type": "str"},
        "available_capacity": {"key": "availableCapacity", "type": "DedicatedHostAvailableCapacity"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        available_capacity: Optional["_models.DedicatedHostAvailableCapacity"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_capacity: Unutilized capacity of the dedicated host.
        :paramtype available_capacity:
         ~azure.mgmt.compute.models.DedicatedHostAvailableCapacity
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.asset_id = None
        self.available_capacity = available_capacity
        self.statuses = statuses

class DedicatedHostListResult(_serialization.Model):
    """The list dedicated host operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of dedicated hosts. Required.
    :vartype value: list[~azure.mgmt.compute.models.DedicatedHost]
    :ivar next_link: The URI to fetch the next page of dedicated hosts. Call ListNext() with this
     URI to fetch the next page of dedicated hosts.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DedicatedHost]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DedicatedHost"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of dedicated hosts. Required.
        :paramtype value: list[~azure.mgmt.compute.models.DedicatedHost]
        :keyword next_link: The URI to fetch the next page of dedicated hosts. Call ListNext() with
         this URI to fetch the next page of dedicated hosts.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class DedicatedHostUpdate(UpdateResource):
    """Specifies information about the dedicated host. Only tags, autoReplaceOnFailure and licenseType
    may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar platform_fault_domain: Fault domain of the dedicated host within a dedicated host group.
    :vartype platform_fault_domain: int
    :ivar auto_replace_on_failure: Specifies whether the dedicated host should be replaced
     automatically in case of a failure. The value is defaulted to 'true' when not provided.
    :vartype auto_replace_on_failure: bool
    :ivar host_id: A unique id generated and assigned to the dedicated host by the platform.
     :code:`<br>`:code:`<br>` Does not change throughout the lifetime of the host.
    :vartype host_id: str
    :ivar virtual_machines: A list of references to all virtual machines in the Dedicated Host.
    :vartype virtual_machines: list[~azure.mgmt.compute.models.SubResourceReadOnly]
    :ivar license_type: Specifies the software license type that will be applied to the VMs
     deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
     :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
     **None**. Known values are: "None", "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
    :vartype license_type: str or ~azure.mgmt.compute.models.DedicatedHostLicenseTypes
    :ivar provisioning_time: The date when the host was first provisioned.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The dedicated host instance view.
    :vartype instance_view: ~azure.mgmt.compute.models.DedicatedHostInstanceView
    :ivar time_created: Specifies the time at which the Dedicated Host resource was
     created.:code:`<br>`:code:`<br>`Minimum api-version: 2021-11-01.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "platform_fault_domain": {"minimum": 0},
        "host_id": {"readonly": True},
        "virtual_machines": {"readonly": True},
        "provisioning_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "platform_fault_domain": {"key": "properties.platformFaultDomain", "type": "int"},
        "auto_replace_on_failure": {"key": "properties.autoReplaceOnFailure", "type": "bool"},
        "host_id": {"key": "properties.hostId", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[SubResourceReadOnly]"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "provisioning_time": {"key": "properties.provisioningTime", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "DedicatedHostInstanceView"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        platform_fault_domain: Optional[int] = None,
        auto_replace_on_failure: Optional[bool] = None,
        license_type: Optional[Union[str, "_models.DedicatedHostLicenseTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword platform_fault_domain: Fault domain of the dedicated host within a dedicated host
         group.
        :paramtype platform_fault_domain: int
        :keyword auto_replace_on_failure: Specifies whether the dedicated host should be replaced
         automatically in case of a failure. The value is defaulted to 'true' when not provided.
        :paramtype auto_replace_on_failure: bool
        :keyword license_type: Specifies the software license type that will be applied to the VMs
         deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
         :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
         **None**. Known values are: "None", "Windows_Server_Hybrid", and "Windows_Server_Perpetual".
        :paramtype license_type: str or
         ~azure.mgmt.compute.models.DedicatedHostLicenseTypes
        """
        super().__init__(tags=tags, **kwargs)
        self.platform_fault_domain = platform_fault_domain
        self.auto_replace_on_failure = auto_replace_on_failure
        self.host_id = None
        self.virtual_machines = None
        self.license_type = license_type
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None
        self.time_created = None

class GalleryApplication(Resource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery Application Definition that you want to create or
    update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery Application Definition resource. This
     property is updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery Application Definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar end_of_life_date: The end of life date of the gallery Application Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar supported_os_type: This property allows you to specify the supported type of the OS that
     application is built for. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype supported_os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar custom_actions: A list of custom actions that can be performed with all of the Gallery
     Application Versions within this Gallery Application.
    :vartype custom_actions:
     list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "supported_os_type": {"key": "properties.supportedOSType", "type": "str"},
        "custom_actions": {"key": "properties.customActions", "type": "[GalleryApplicationCustomAction]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        supported_os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        custom_actions: Optional[List["_models.GalleryApplicationCustomAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery Application Definition resource. This
         property is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery Application Definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword end_of_life_date: The end of life date of the gallery Application Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword supported_os_type: This property allows you to specify the supported type of the OS
         that application is built for. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype supported_os_type: str or
         ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword custom_actions: A list of custom actions that can be performed with all of the Gallery
         Application Versions within this Gallery Application.
        :paramtype custom_actions:
         list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type
        self.custom_actions = custom_actions

class GalleryApplicationList(_serialization.Model):
    """The List Gallery Applications operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of Gallery Applications. Required.
    :vartype value: list[~azure.mgmt.compute.models.GalleryApplication]
    :ivar next_link: The uri to fetch the next page of Application Definitions in the Application
     Gallery. Call ListNext() with this to fetch the next page of gallery Application Definitions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryApplication]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.GalleryApplication"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of Gallery Applications. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GalleryApplication]
        :keyword next_link: The uri to fetch the next page of Application Definitions in the
         Application Gallery. Call ListNext() with this to fetch the next page of gallery Application
         Definitions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class GalleryApplicationVersion(Resource):
    """Specifies information about the gallery Application Version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.models.GalleryApplicationVersionPublishingProfile
    :ivar safety_profile: The safety profile of the Gallery Application Version.
    :vartype safety_profile:
     ~azure.mgmt.compute.models.GalleryApplicationVersionSafetyProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "publishing_profile": {
            "key": "properties.publishingProfile",
            "type": "GalleryApplicationVersionPublishingProfile",
        },
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryApplicationVersionSafetyProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryApplicationVersionPublishingProfile"] = None,
        safety_profile: Optional["_models.GalleryApplicationVersionSafetyProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.models.GalleryApplicationVersionPublishingProfile
        :keyword safety_profile: The safety profile of the Gallery Application Version.
        :paramtype safety_profile:
         ~azure.mgmt.compute.models.GalleryApplicationVersionSafetyProfile
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.safety_profile = safety_profile
        self.provisioning_state = None
        self.replication_status = None

class GalleryApplicationVersionList(_serialization.Model):
    """The List Gallery Application version operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of gallery Application Versions. Required.
    :vartype value: list[~azure.mgmt.compute.models.GalleryApplicationVersion]
    :ivar next_link: The uri to fetch the next page of gallery Application Versions. Call
     ListNext() with this to fetch the next page of gallery Application Versions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GalleryApplicationVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.GalleryApplicationVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of gallery Application Versions. Required.
        :paramtype value: list[~azure.mgmt.compute.models.GalleryApplicationVersion]
        :keyword next_link: The uri to fetch the next page of gallery Application Versions. Call
         ListNext() with this to fetch the next page of gallery Application Versions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class GalleryApplicationVersionPublishingProfile(
    GalleryArtifactPublishingProfileBase
):  # pylint: disable=too-many-instance-attributes
    """The publishing profile of a gallery image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS", and "StandardSSD_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full" and "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
    :ivar source: The source image from which the Image Version is going to be created. Required.
    :vartype source: ~azure.mgmt.compute.models.UserArtifactSource
    :ivar manage_actions:
    :vartype manage_actions: ~azure.mgmt.compute.models.UserArtifactManage
    :ivar settings: Additional settings for the VM app that contains the target package and config
     file name when it is deployed to target VM or VM scale set.
    :vartype settings: ~azure.mgmt.compute.models.UserArtifactSettings
    :ivar advanced_settings: Optional. Additional settings to pass to the vm-application-manager
     extension. For advanced use only.
    :vartype advanced_settings: dict[str, str]
    :ivar enable_health_check: Optional. Whether or not this application reports health.
    :vartype enable_health_check: bool
    :ivar custom_actions: A list of custom actions that can be performed with this Gallery
     Application Version.
    :vartype custom_actions:
     list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
    """

    _validation = {
        "published_date": {"readonly": True},
        "source": {"required": True},
    }

    _attribute_map = {
        "target_regions": {"key": "targetRegions", "type": "[TargetRegion]"},
        "replica_count": {"key": "replicaCount", "type": "int"},
        "exclude_from_latest": {"key": "excludeFromLatest", "type": "bool"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "endOfLifeDate", "type": "iso-8601"},
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "replication_mode": {"key": "replicationMode", "type": "str"},
        "target_extended_locations": {"key": "targetExtendedLocations", "type": "[GalleryTargetExtendedLocation]"},
        "source": {"key": "source", "type": "UserArtifactSource"},
        "manage_actions": {"key": "manageActions", "type": "UserArtifactManage"},
        "settings": {"key": "settings", "type": "UserArtifactSettings"},
        "advanced_settings": {"key": "advancedSettings", "type": "{str}"},
        "enable_health_check": {"key": "enableHealthCheck", "type": "bool"},
        "custom_actions": {"key": "customActions", "type": "[GalleryApplicationCustomAction]"},
    }

    def __init__(
        self,
        *,
        source: "_models.UserArtifactSource",
        target_regions: Optional[List["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[List["_models.GalleryTargetExtendedLocation"]] = None,
        manage_actions: Optional["_models.UserArtifactManage"] = None,
        settings: Optional["_models.UserArtifactSettings"] = None,
        advanced_settings: Optional[Dict[str, str]] = None,
        enable_health_check: Optional[bool] = None,
        custom_actions: Optional[List["_models.GalleryApplicationCustomAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS", and "StandardSSD_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full" and "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.models.GalleryTargetExtendedLocation]
        :keyword source: The source image from which the Image Version is going to be created.
         Required.
        :paramtype source: ~azure.mgmt.compute.models.UserArtifactSource
        :keyword manage_actions:
        :paramtype manage_actions: ~azure.mgmt.compute.models.UserArtifactManage
        :keyword settings: Additional settings for the VM app that contains the target package and
         config file name when it is deployed to target VM or VM scale set.
        :paramtype settings: ~azure.mgmt.compute.models.UserArtifactSettings
        :keyword advanced_settings: Optional. Additional settings to pass to the vm-application-manager
         extension. For advanced use only.
        :paramtype advanced_settings: dict[str, str]
        :keyword enable_health_check: Optional. Whether or not this application reports health.
        :paramtype enable_health_check: bool
        :keyword custom_actions: A list of custom actions that can be performed with this Gallery
         Application Version.
        :paramtype custom_actions:
         list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
        """
        super().__init__(
            target_regions=target_regions,
            replica_count=replica_count,
            exclude_from_latest=exclude_from_latest,
            end_of_life_date=end_of_life_date,
            storage_account_type=storage_account_type,
            replication_mode=replication_mode,
            target_extended_locations=target_extended_locations,
            **kwargs
        )
        self.source = source
        self.manage_actions = manage_actions
        self.settings = settings
        self.advanced_settings = advanced_settings
        self.enable_health_check = enable_health_check
        self.custom_actions = custom_actions

class ScaleInPolicy(_serialization.Model):
    """Describes a scale-in policy for a virtual machine scale set.

    :ivar rules: The rules to be followed when scaling-in a virtual machine scale set.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Default** When a
     virtual machine scale set is scaled in, the scale set will first be balanced across zones if it
     is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within
     each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not
     protected from scale-in. :code:`<br>`:code:`<br>` **OldestVM** When a virtual machine scale set
     is being scaled-in, the oldest virtual machines that are not protected from scale-in will be
     chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
     across zones. Within each zone, the oldest virtual machines that are not protected will be
     chosen for removal. :code:`<br>`:code:`<br>` **NewestVM** When a virtual machine scale set is
     being scaled-in, the newest virtual machines that are not protected from scale-in will be
     chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
     across zones. Within each zone, the newest virtual machines that are not protected will be
     chosen for removal. :code:`<br>`:code:`<br>`.
    :vartype rules: list[str or
     ~azure.mgmt.compute.models.VirtualMachineScaleSetScaleInRules]
    :ivar force_deletion: This property allows you to specify if virtual machines chosen for
     removal have to be force deleted when a virtual machine scale set is being scaled-in.(Feature
     in Preview).
    :vartype force_deletion: bool
    """

    _attribute_map = {
        "rules": {"key": "rules", "type": "[str]"},
        "force_deletion": {"key": "forceDeletion", "type": "bool"},
    }

    def __init__(
        self,
        *,
        rules: Optional[List[Union[str, "_models.VirtualMachineScaleSetScaleInRules"]]] = None,
        force_deletion: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rules: The rules to be followed when scaling-in a virtual machine scale set.
         :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Default** When a
         virtual machine scale set is scaled in, the scale set will first be balanced across zones if it
         is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within
         each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not
         protected from scale-in. :code:`<br>`:code:`<br>` **OldestVM** When a virtual machine scale set
         is being scaled-in, the oldest virtual machines that are not protected from scale-in will be
         chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
         across zones. Within each zone, the oldest virtual machines that are not protected will be
         chosen for removal. :code:`<br>`:code:`<br>` **NewestVM** When a virtual machine scale set is
         being scaled-in, the newest virtual machines that are not protected from scale-in will be
         chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
         across zones. Within each zone, the newest virtual machines that are not protected will be
         chosen for removal. :code:`<br>`:code:`<br>`.
        :paramtype rules: list[str or
         ~azure.mgmt.compute.models.VirtualMachineScaleSetScaleInRules]
        :keyword force_deletion: This property allows you to specify if virtual machines chosen for
         removal have to be force deleted when a virtual machine scale set is being scaled-in.(Feature
         in Preview).
        :paramtype force_deletion: bool
        """
        super().__init__(**kwargs)
        self.rules = rules
        self.force_deletion = force_deletion

class ScheduledEventsProfile(_serialization.Model):
    """ScheduledEventsProfile.

    :ivar terminate_notification_profile: Specifies Terminate Scheduled Event related
     configurations.
    :vartype terminate_notification_profile:
     ~azure.mgmt.compute.models.TerminateNotificationProfile
    :ivar os_image_notification_profile: Specifies OS Image Scheduled Event related configurations.
    :vartype os_image_notification_profile:
     ~azure.mgmt.compute.models.OSImageNotificationProfile
    """

    _attribute_map = {
        "terminate_notification_profile": {
            "key": "terminateNotificationProfile",
            "type": "TerminateNotificationProfile",
        },
        "os_image_notification_profile": {"key": "osImageNotificationProfile", "type": "OSImageNotificationProfile"},
    }

    def __init__(
        self,
        *,
        terminate_notification_profile: Optional["_models.TerminateNotificationProfile"] = None,
        os_image_notification_profile: Optional["_models.OSImageNotificationProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword terminate_notification_profile: Specifies Terminate Scheduled Event related
         configurations.
        :paramtype terminate_notification_profile:
         ~azure.mgmt.compute.models.TerminateNotificationProfile
        :keyword os_image_notification_profile: Specifies OS Image Scheduled Event related
         configurations.
        :paramtype os_image_notification_profile:
         ~azure.mgmt.compute.models.OSImageNotificationProfile
        """
        super().__init__(**kwargs)
        self.terminate_notification_profile = terminate_notification_profile
        self.os_image_notification_profile = os_image_notification_profile

class TerminateNotificationProfile(_serialization.Model):
    """TerminateNotificationProfile.

    :ivar not_before_timeout: Configurable length of time a Virtual Machine being deleted will have
     to potentially approve the Terminate Scheduled Event before the event is auto approved (timed
     out). The configuration must be specified in ISO 8601 format, the default value is 5 minutes
     (PT5M).
    :vartype not_before_timeout: str
    :ivar enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
    :vartype enable: bool
    """

    _attribute_map = {
        "not_before_timeout": {"key": "notBeforeTimeout", "type": "str"},
        "enable": {"key": "enable", "type": "bool"},
    }

    def __init__(
        self, *, not_before_timeout: Optional[str] = None, enable: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword not_before_timeout: Configurable length of time a Virtual Machine being deleted will
         have to potentially approve the Terminate Scheduled Event before the event is auto approved
         (timed out). The configuration must be specified in ISO 8601 format, the default value is 5
         minutes (PT5M).
        :paramtype not_before_timeout: str
        :keyword enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
        :paramtype enable: bool
        """
        super().__init__(**kwargs)
        self.not_before_timeout = not_before_timeout
        self.enable = enable

class UserArtifactManage(_serialization.Model):
    """UserArtifactManage.

    All required parameters must be populated in order to send to Azure.

    :ivar install: Required. The path and arguments to install the gallery application. This is
     limited to 4096 characters. Required.
    :vartype install: str
    :ivar remove: Required. The path and arguments to remove the gallery application. This is
     limited to 4096 characters. Required.
    :vartype remove: str
    :ivar update: Optional. The path and arguments to update the gallery application. If not
     present, then update operation will invoke remove command on the previous version and install
     command on the current version of the gallery application. This is limited to 4096 characters.
    :vartype update: str
    """

    _validation = {
        "install": {"required": True},
        "remove": {"required": True},
    }

    _attribute_map = {
        "install": {"key": "install", "type": "str"},
        "remove": {"key": "remove", "type": "str"},
        "update": {"key": "update", "type": "str"},
    }

    def __init__(self, *, install: str, remove: str, update: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword install: Required. The path and arguments to install the gallery application. This is
         limited to 4096 characters. Required.
        :paramtype install: str
        :keyword remove: Required. The path and arguments to remove the gallery application. This is
         limited to 4096 characters. Required.
        :paramtype remove: str
        :keyword update: Optional. The path and arguments to update the gallery application. If not
         present, then update operation will invoke remove command on the previous version and install
         command on the current version of the gallery application. This is limited to 4096 characters.
        :paramtype update: str
        """
        super().__init__(**kwargs)
        self.install = install
        self.remove = remove
        self.update = update

class UserArtifactSource(_serialization.Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to Azure.

    :ivar media_link: Required. The mediaLink of the artifact, must be a readable storage page
     blob. Required.
    :vartype media_link: str
    :ivar default_configuration_link: Optional. The defaultConfigurationLink of the artifact, must
     be a readable storage page blob.
    :vartype default_configuration_link: str
    """

    _validation = {
        "media_link": {"required": True},
    }

    _attribute_map = {
        "media_link": {"key": "mediaLink", "type": "str"},
        "default_configuration_link": {"key": "defaultConfigurationLink", "type": "str"},
    }

    def __init__(self, *, media_link: str, default_configuration_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword media_link: Required. The mediaLink of the artifact, must be a readable storage page
         blob. Required.
        :paramtype media_link: str
        :keyword default_configuration_link: Optional. The defaultConfigurationLink of the artifact,
         must be a readable storage page blob.
        :paramtype default_configuration_link: str
        """
        super().__init__(**kwargs)
        self.media_link = media_link
        self.default_configuration_link = default_configuration_link

class VMScaleSetConvertToSinglePlacementGroupInput(_serialization.Model):
    """VMScaleSetConvertToSinglePlacementGroupInput.

    :ivar active_placement_group_id: Id of the placement group in which you want future virtual
     machine instances to be placed. To query placement group Id, please use Virtual Machine Scale
     Set VMs - Get API. If not provided, the platform will choose one with maximum number of virtual
     machine instances.
    :vartype active_placement_group_id: str
    """

    _attribute_map = {
        "active_placement_group_id": {"key": "activePlacementGroupId", "type": "str"},
    }

    def __init__(self, *, active_placement_group_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword active_placement_group_id: Id of the placement group in which you want future virtual
         machine instances to be placed. To query placement group Id, please use Virtual Machine Scale
         Set VMs - Get API. If not provided, the platform will choose one with maximum number of virtual
         machine instances.
        :paramtype active_placement_group_id: str
        """
        super().__init__(**kwargs)
        self.active_placement_group_id = active_placement_group_id

class VirtualMachineScaleSetVMNetworkProfileConfiguration(_serialization.Model):
    """Describes a virtual machine scale set VM network profile.

    :ivar network_interface_configurations: The list of network configurations.
    :vartype network_interface_configurations:
     list[~azure.mgmt.compute.models.VirtualMachineScaleSetNetworkConfiguration]
    """

    _attribute_map = {
        "network_interface_configurations": {
            "key": "networkInterfaceConfigurations",
            "type": "[VirtualMachineScaleSetNetworkConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        network_interface_configurations: Optional[List["_models.VirtualMachineScaleSetNetworkConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interface_configurations: The list of network configurations.
        :paramtype network_interface_configurations:
         list[~azure.mgmt.compute.models.VirtualMachineScaleSetNetworkConfiguration]
        """
        super().__init__(**kwargs)
        self.network_interface_configurations = network_interface_configurations

class VirtualMachineScaleSetVMProtectionPolicy(_serialization.Model):
    """The protection policy of a virtual machine scale set VM.

    :ivar protect_from_scale_in: Indicates that the virtual machine scale set VM shouldn't be
     considered for deletion during a scale-in operation.
    :vartype protect_from_scale_in: bool
    :ivar protect_from_scale_set_actions: Indicates that model updates or actions (including
     scale-in) initiated on the virtual machine scale set should not be applied to the virtual
     machine scale set VM.
    :vartype protect_from_scale_set_actions: bool
    """

    _attribute_map = {
        "protect_from_scale_in": {"key": "protectFromScaleIn", "type": "bool"},
        "protect_from_scale_set_actions": {"key": "protectFromScaleSetActions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        protect_from_scale_in: Optional[bool] = None,
        protect_from_scale_set_actions: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protect_from_scale_in: Indicates that the virtual machine scale set VM shouldn't be
         considered for deletion during a scale-in operation.
        :paramtype protect_from_scale_in: bool
        :keyword protect_from_scale_set_actions: Indicates that model updates or actions (including
         scale-in) initiated on the virtual machine scale set should not be applied to the virtual
         machine scale set VM.
        :paramtype protect_from_scale_set_actions: bool
        """
        super().__init__(**kwargs)
        self.protect_from_scale_in = protect_from_scale_in
        self.protect_from_scale_set_actions = protect_from_scale_set_actions

class ResourceSkuZoneDetails(_serialization.Model):
    """Describes The zonal capabilities of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The set of zones that the SKU is available in with the specified capabilities.
    :vartype name: list[str]
    :ivar capabilities: A list of capabilities that are available for the SKU in the specified list
     of zones.
    :vartype capabilities: list[~azure.mgmt.compute.models.ResourceSkuCapabilities]
    """

    _validation = {
        "name": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[ResourceSkuCapabilities]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.capabilities = None

class DiskEncryptionSet(Resource):  # pylint: disable=too-many-instance-attributes
    """disk encryption set resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed identity for the disk encryption set. It should be given permission
     on the key vault before it can be used to encrypt disks.
    :vartype identity: ~azure.mgmt.compute.models.EncryptionSetIdentity
    :ivar encryption_type: The type of key used to encrypt the data of the disk. Known values are:
     "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys", and
     "ConfidentialVmEncryptedWithCustomerKey".
    :vartype encryption_type: str or ~azure.mgmt.compute.models.DiskEncryptionSetType
    :ivar active_key: The key vault key which is currently used by this disk encryption set.
    :vartype active_key: ~azure.mgmt.compute.models.KeyForDiskEncryptionSet
    :ivar previous_keys: A readonly collection of key vault keys previously used by this disk
     encryption set while a key rotation is in progress. It will be empty if there is no ongoing key
     rotation.
    :vartype previous_keys: list[~azure.mgmt.compute.models.KeyForDiskEncryptionSet]
    :ivar provisioning_state: The disk encryption set provisioning state.
    :vartype provisioning_state: str
    :ivar rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating of
     this disk encryption set to the latest key version.
    :vartype rotation_to_latest_key_version_enabled: bool
    :ivar last_key_rotation_timestamp: The time when the active key of this disk encryption set was
     updated.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    :ivar auto_key_rotation_error: The error that was encountered during auto-key rotation. If an
     error is present, then auto-key rotation will not be attempted until the error on this disk
     encryption set is fixed.
    :vartype auto_key_rotation_error: ~azure.mgmt.compute.models.ApiError
    :ivar federated_client_id: Multi-tenant application client id to access key vault in a
     different tenant. Setting the value to 'None' will clear the property.
    :vartype federated_client_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "previous_keys": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "last_key_rotation_timestamp": {"readonly": True},
        "auto_key_rotation_error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "EncryptionSetIdentity"},
        "encryption_type": {"key": "properties.encryptionType", "type": "str"},
        "active_key": {"key": "properties.activeKey", "type": "KeyForDiskEncryptionSet"},
        "previous_keys": {"key": "properties.previousKeys", "type": "[KeyForDiskEncryptionSet]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "rotation_to_latest_key_version_enabled": {
            "key": "properties.rotationToLatestKeyVersionEnabled",
            "type": "bool",
        },
        "last_key_rotation_timestamp": {"key": "properties.lastKeyRotationTimestamp", "type": "iso-8601"},
        "auto_key_rotation_error": {"key": "properties.autoKeyRotationError", "type": "ApiError"},
        "federated_client_id": {"key": "properties.federatedClientId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.EncryptionSetIdentity"] = None,
        encryption_type: Optional[Union[str, "_models.DiskEncryptionSetType"]] = None,
        active_key: Optional["_models.KeyForDiskEncryptionSet"] = None,
        rotation_to_latest_key_version_enabled: Optional[bool] = None,
        federated_client_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The managed identity for the disk encryption set. It should be given
         permission on the key vault before it can be used to encrypt disks.
        :paramtype identity: ~azure.mgmt.compute.models.EncryptionSetIdentity
        :keyword encryption_type: The type of key used to encrypt the data of the disk. Known values
         are: "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys", and
         "ConfidentialVmEncryptedWithCustomerKey".
        :paramtype encryption_type: str or ~azure.mgmt.compute.models.DiskEncryptionSetType
        :keyword active_key: The key vault key which is currently used by this disk encryption set.
        :paramtype active_key: ~azure.mgmt.compute.models.KeyForDiskEncryptionSet
        :keyword rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating
         of this disk encryption set to the latest key version.
        :paramtype rotation_to_latest_key_version_enabled: bool
        :keyword federated_client_id: Multi-tenant application client id to access key vault in a
         different tenant. Setting the value to 'None' will clear the property.
        :paramtype federated_client_id: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.encryption_type = encryption_type
        self.active_key = active_key
        self.previous_keys = None
        self.provisioning_state = None
        self.rotation_to_latest_key_version_enabled = rotation_to_latest_key_version_enabled
        self.last_key_rotation_timestamp = None
        self.auto_key_rotation_error = None
        self.federated_client_id = federated_client_id

class DiskEncryptionSetList(_serialization.Model):
    """The List disk encryption set operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of disk encryption sets. Required.
    :vartype value: list[~azure.mgmt.compute.models.DiskEncryptionSet]
    :ivar next_link: The uri to fetch the next page of disk encryption sets. Call ListNext() with
     this to fetch the next page of disk encryption sets.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiskEncryptionSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DiskEncryptionSet"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of disk encryption sets. Required.
        :paramtype value: list[~azure.mgmt.compute.models.DiskEncryptionSet]
        :keyword next_link: The uri to fetch the next page of disk encryption sets. Call ListNext()
         with this to fetch the next page of disk encryption sets.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class DiskEncryptionSetParameters(SubResource):
    """Describes the parameter of customer managed disk encryption set resource id that can be
    specified for disk. :code:`<br>`:code:`<br>` NOTE: The disk encryption set resource id can only
    be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more
    details.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Id.
        :paramtype id: str
        """
        super().__init__(id=id, **kwargs)

class DiskEncryptionSetUpdate(_serialization.Model):
    """disk encryption set update resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed identity for the disk encryption set. It should be given permission
     on the key vault before it can be used to encrypt disks.
    :vartype identity: ~azure.mgmt.compute.models.EncryptionSetIdentity
    :ivar encryption_type: The type of key used to encrypt the data of the disk. Known values are:
     "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys", and
     "ConfidentialVmEncryptedWithCustomerKey".
    :vartype encryption_type: str or ~azure.mgmt.compute.models.DiskEncryptionSetType
    :ivar active_key: Key Vault Key Url to be used for server side encryption of Managed Disks and
     Snapshots.
    :vartype active_key: ~azure.mgmt.compute.models.KeyForDiskEncryptionSet
    :ivar rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating of
     this disk encryption set to the latest key version.
    :vartype rotation_to_latest_key_version_enabled: bool
    :ivar federated_client_id: Multi-tenant application client id to access key vault in a
     different tenant. Setting the value to 'None' will clear the property.
    :vartype federated_client_id: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "EncryptionSetIdentity"},
        "encryption_type": {"key": "properties.encryptionType", "type": "str"},
        "active_key": {"key": "properties.activeKey", "type": "KeyForDiskEncryptionSet"},
        "rotation_to_latest_key_version_enabled": {
            "key": "properties.rotationToLatestKeyVersionEnabled",
            "type": "bool",
        },
        "federated_client_id": {"key": "properties.federatedClientId", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.EncryptionSetIdentity"] = None,
        encryption_type: Optional[Union[str, "_models.DiskEncryptionSetType"]] = None,
        active_key: Optional["_models.KeyForDiskEncryptionSet"] = None,
        rotation_to_latest_key_version_enabled: Optional[bool] = None,
        federated_client_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The managed identity for the disk encryption set. It should be given
         permission on the key vault before it can be used to encrypt disks.
        :paramtype identity: ~azure.mgmt.compute.models.EncryptionSetIdentity
        :keyword encryption_type: The type of key used to encrypt the data of the disk. Known values
         are: "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys", and
         "ConfidentialVmEncryptedWithCustomerKey".
        :paramtype encryption_type: str or ~azure.mgmt.compute.models.DiskEncryptionSetType
        :keyword active_key: Key Vault Key Url to be used for server side encryption of Managed Disks
         and Snapshots.
        :paramtype active_key: ~azure.mgmt.compute.models.KeyForDiskEncryptionSet
        :keyword rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating
         of this disk encryption set to the latest key version.
        :paramtype rotation_to_latest_key_version_enabled: bool
        :keyword federated_client_id: Multi-tenant application client id to access key vault in a
         different tenant. Setting the value to 'None' will clear the property.
        :paramtype federated_client_id: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.encryption_type = encryption_type
        self.active_key = active_key
        self.rotation_to_latest_key_version_enabled = rotation_to_latest_key_version_enabled
        self.federated_client_id = federated_client_id

class Encryption(_serialization.Model):
    """Encryption at rest settings for disk or snapshot.

    :ivar disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :vartype disk_encryption_set_id: str
    :ivar type: The type of key used to encrypt the data of the disk. Known values are:
     "EncryptionAtRestWithPlatformKey", "EncryptionAtRestWithCustomerKey", and
     "EncryptionAtRestWithPlatformAndCustomerKeys".
    :vartype type: str or ~azure.mgmt.compute.models.EncryptionType
    """

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_encryption_set_id: Optional[str] = None,
        type: Optional[Union[str, "_models.EncryptionType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
         encryption at rest.
        :paramtype disk_encryption_set_id: str
        :keyword type: The type of key used to encrypt the data of the disk. Known values are:
         "EncryptionAtRestWithPlatformKey", "EncryptionAtRestWithCustomerKey", and
         "EncryptionAtRestWithPlatformAndCustomerKeys".
        :paramtype type: str or ~azure.mgmt.compute.models.EncryptionType
        """
        super().__init__(**kwargs)
        self.disk_encryption_set_id = disk_encryption_set_id
        self.type = type

class EncryptionSetIdentity(_serialization.Model):
    """The managed identity for the disk encryption set. It should be given permission on the key
    vault before it can be used to encrypt disks.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is
     supported for new creations. Disk Encryption Sets can be updated with Identity type None during
     migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted
     resources to lose access to the keys. Known values are: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.compute.models.DiskEncryptionSetIdentityType
    :ivar principal_id: The object id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype tenant_id: str
    :ivar user_assigned_identities: The list of user identities associated with the disk encryption
     set. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.compute.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentitiesValue}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.DiskEncryptionSetIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentitiesValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned
         is supported for new creations. Disk Encryption Sets can be updated with Identity type None
         during migration of subscription to a new Azure Active Directory tenant; it will cause the
         encrypted resources to lose access to the keys. Known values are: "SystemAssigned",
         "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.compute.models.DiskEncryptionSetIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the disk
         encryption set. The user identity dictionary key references will be ARM resource ids in the
         form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.compute.models.UserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None
        self.user_assigned_identities = user_assigned_identities

class UpdateResourceDefinition(_serialization.Model):
    """The Update Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags

class GalleryApplicationUpdate(UpdateResourceDefinition):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery Application Definition that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery Application Definition resource. This
     property is updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery Application Definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar end_of_life_date: The end of life date of the gallery Application Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar supported_os_type: This property allows you to specify the supported type of the OS that
     application is built for. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype supported_os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar custom_actions: A list of custom actions that can be performed with all of the Gallery
     Application Versions within this Gallery Application.
    :vartype custom_actions:
     list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "supported_os_type": {"key": "properties.supportedOSType", "type": "str"},
        "custom_actions": {"key": "properties.customActions", "type": "[GalleryApplicationCustomAction]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        supported_os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        custom_actions: Optional[List["_models.GalleryApplicationCustomAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery Application Definition resource. This
         property is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery Application Definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword end_of_life_date: The end of life date of the gallery Application Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword supported_os_type: This property allows you to specify the supported type of the OS
         that application is built for. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype supported_os_type: str or
         ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword custom_actions: A list of custom actions that can be performed with all of the Gallery
         Application Versions within this Gallery Application.
        :paramtype custom_actions:
         list[~azure.mgmt.compute.models.GalleryApplicationCustomAction]
        """
        super().__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type
        self.custom_actions = custom_actions

class GalleryApplicationVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery Application Version that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.models.GalleryApplicationVersionPublishingProfile
    :ivar safety_profile: The safety profile of the Gallery Application Version.
    :vartype safety_profile:
     ~azure.mgmt.compute.models.GalleryApplicationVersionSafetyProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "publishing_profile": {
            "key": "properties.publishingProfile",
            "type": "GalleryApplicationVersionPublishingProfile",
        },
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryApplicationVersionSafetyProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryApplicationVersionPublishingProfile"] = None,
        safety_profile: Optional["_models.GalleryApplicationVersionSafetyProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.models.GalleryApplicationVersionPublishingProfile
        :keyword safety_profile: The safety profile of the Gallery Application Version.
        :paramtype safety_profile:
         ~azure.mgmt.compute.models.GalleryApplicationVersionSafetyProfile
        """
        super().__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.safety_profile = safety_profile
        self.provisioning_state = None
        self.replication_status = None

class GalleryArtifactVersionSource(_serialization.Model):
    """The gallery artifact version source.

    :ivar id: The id of the gallery artifact version source. Can specify a disk uri, snapshot uri,
     user image or storage account resource.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The id of the gallery artifact version source. Can specify a disk uri, snapshot
         uri, user image or storage account resource.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id

class GalleryImageUpdate(UpdateResourceDefinition):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery image definition that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery image definition resource. This property is
     updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery image definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.models.Disallowed
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.models.Architecture
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "release_note_uri": {"key": "properties.releaseNoteUri", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "architecture": {"key": "properties.architecture", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        features: Optional[List["_models.GalleryImageFeature"]] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery image definition resource. This property
         is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery image definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.models.Disallowed
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.models.Architecture
        """
        super().__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_v_generation = hyper_v_generation
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state = None
        self.features = features
        self.architecture = architecture

class GalleryImageVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery image version that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image Version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.models.GalleryImageVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar storage_profile: This is the storage profile of a Gallery Image Version.
    :vartype storage_profile:
     ~azure.mgmt.compute.models.GalleryImageVersionStorageProfile
    :ivar safety_profile: This is the safety profile of the Gallery Image Version.
    :vartype safety_profile:
     ~azure.mgmt.compute.models.GalleryImageVersionSafetyProfile
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.models.ReplicationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "replication_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "publishing_profile": {"key": "properties.publishingProfile", "type": "GalleryImageVersionPublishingProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "storage_profile": {"key": "properties.storageProfile", "type": "GalleryImageVersionStorageProfile"},
        "safety_profile": {"key": "properties.safetyProfile", "type": "GalleryImageVersionSafetyProfile"},
        "replication_status": {"key": "properties.replicationStatus", "type": "ReplicationStatus"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryImageVersionPublishingProfile"] = None,
        storage_profile: Optional["_models.GalleryImageVersionStorageProfile"] = None,
        safety_profile: Optional["_models.GalleryImageVersionSafetyProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image Version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.models.GalleryImageVersionPublishingProfile
        :keyword storage_profile: This is the storage profile of a Gallery Image Version.
        :paramtype storage_profile:
         ~azure.mgmt.compute.models.GalleryImageVersionStorageProfile
        :keyword safety_profile: This is the safety profile of the Gallery Image Version.
        :paramtype safety_profile:
         ~azure.mgmt.compute.models.GalleryImageVersionSafetyProfile
        """
        super().__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.storage_profile = storage_profile
        self.safety_profile = safety_profile
        self.replication_status = None

class GalleryUpdate(UpdateResourceDefinition):
    """Specifies information about the Shared Image Gallery that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this Shared Image Gallery resource. This property is
     updatable.
    :vartype description: str
    :ivar identifier: Describes the gallery unique name.
    :vartype identifier: ~azure.mgmt.compute.models.GalleryIdentifier
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", and "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.models.GalleryProvisioningState
    :ivar sharing_profile: Profile for gallery sharing to subscription or tenant.
    :vartype sharing_profile: ~azure.mgmt.compute.models.SharingProfile
    :ivar soft_delete_policy: Contains information about the soft deletion policy of the gallery.
    :vartype soft_delete_policy: ~azure.mgmt.compute.models.SoftDeletePolicy
    :ivar sharing_status: Sharing status of current gallery.
    :vartype sharing_status: ~azure.mgmt.compute.models.SharingStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "sharing_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "identifier": {"key": "properties.identifier", "type": "GalleryIdentifier"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sharing_profile": {"key": "properties.sharingProfile", "type": "SharingProfile"},
        "soft_delete_policy": {"key": "properties.softDeletePolicy", "type": "SoftDeletePolicy"},
        "sharing_status": {"key": "properties.sharingStatus", "type": "SharingStatus"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        identifier: Optional["_models.GalleryIdentifier"] = None,
        sharing_profile: Optional["_models.SharingProfile"] = None,
        soft_delete_policy: Optional["_models.SoftDeletePolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this Shared Image Gallery resource. This property is
         updatable.
        :paramtype description: str
        :keyword identifier: Describes the gallery unique name.
        :paramtype identifier: ~azure.mgmt.compute.models.GalleryIdentifier
        :keyword sharing_profile: Profile for gallery sharing to subscription or tenant.
        :paramtype sharing_profile: ~azure.mgmt.compute.models.SharingProfile
        :keyword soft_delete_policy: Contains information about the soft deletion policy of the
         gallery.
        :paramtype soft_delete_policy: ~azure.mgmt.compute.models.SoftDeletePolicy
        """
        super().__init__(tags=tags, **kwargs)
        self.description = description
        self.identifier = identifier
        self.provisioning_state = None
        self.sharing_profile = sharing_profile
        self.soft_delete_policy = soft_delete_policy
        self.sharing_status = None

class SubResourceWithColocationStatus(SubResource):
    """SubResourceWithColocationStatus.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar colocation_status: Describes colocation status of a resource in the Proximity Placement
     Group.
    :vartype colocation_status: ~azure.mgmt.compute.models.InstanceViewStatus
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "colocation_status": {"key": "colocationStatus", "type": "InstanceViewStatus"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        colocation_status: Optional["_models.InstanceViewStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Id.
        :paramtype id: str
        :keyword colocation_status: Describes colocation status of a resource in the Proximity
         Placement Group.
        :paramtype colocation_status: ~azure.mgmt.compute.models.InstanceViewStatus
        """
        super().__init__(id=id, **kwargs)
        self.colocation_status = colocation_status

class VirtualMachineScaleSetExtensionUpdate(SubResourceReadOnly):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :vartype provision_after_extensions: list[str]
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.compute.models.KeyVaultSecretReference
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "provision_after_extensions": {"key": "properties.provisionAfterExtensions", "type": "[str]"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {
            "key": "properties.protectedSettingsFromKeyVault",
            "type": "KeyVaultSecretReference",
        },
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        provision_after_extensions: Optional[List[str]] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional["_models.KeyVaultSecretReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword force_update_tag: If a value is provided and is different from the previous value, the
         extension handler will be forced to update even if the extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword provision_after_extensions: Collection of extension names after which this extension
         needs to be provisioned.
        :paramtype provision_after_extensions: list[str]
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault:
         ~azure.mgmt.compute.models.KeyVaultSecretReference
        """
        super().__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.provision_after_extensions = provision_after_extensions
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault

class ShareInfoElement(_serialization.Model):
    """ShareInfoElement.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_uri: A relative URI containing the ID of the VM that has the disk attached.
    :vartype vm_uri: str
    """

    _validation = {
        "vm_uri": {"readonly": True},
    }

    _attribute_map = {
        "vm_uri": {"key": "vmUri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.vm_uri = None

class DiskImageEncryption(_serialization.Model):
    """This is the disk image encryption base class.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    """

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
    }

    def __init__(self, *, disk_encryption_set_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.disk_encryption_set_id = disk_encryption_set_id

class DataDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for a data disk image.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    :ivar lun: This property specifies the logical unit number of the data disk. This value is used
     to identify data disks within the Virtual Machine and therefore must be unique for each data
     disk attached to the Virtual Machine. Required.
    :vartype lun: int
    """

    _validation = {
        "lun": {"required": True},
    }

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "lun": {"key": "lun", "type": "int"},
    }

    def __init__(self, *, lun: int, disk_encryption_set_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        :keyword lun: This property specifies the logical unit number of the data disk. This value is
         used to identify data disks within the Virtual Machine and therefore must be unique for each
         data disk attached to the Virtual Machine. Required.
        :paramtype lun: int
        """
        super().__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)
        self.lun = lun

class EncryptionImages(_serialization.Model):
    """Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in
    the gallery artifact.

    :ivar os_disk_image: Contains encryption settings for an OS disk image.
    :vartype os_disk_image: ~azure.mgmt.compute.models.OSDiskImageEncryption
    :ivar data_disk_images: A list of encryption specifications for data disk images.
    :vartype data_disk_images: list[~azure.mgmt.compute.models.DataDiskImageEncryption]
    """

    _attribute_map = {
        "os_disk_image": {"key": "osDiskImage", "type": "OSDiskImageEncryption"},
        "data_disk_images": {"key": "dataDiskImages", "type": "[DataDiskImageEncryption]"},
    }

    def __init__(
        self,
        *,
        os_disk_image: Optional["_models.OSDiskImageEncryption"] = None,
        data_disk_images: Optional[List["_models.DataDiskImageEncryption"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_disk_image: Contains encryption settings for an OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.compute.models.OSDiskImageEncryption
        :keyword data_disk_images: A list of encryption specifications for data disk images.
        :paramtype data_disk_images:
         list[~azure.mgmt.compute.models.DataDiskImageEncryption]
        """
        super().__init__(**kwargs)
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images

class OSDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for an OS disk image.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    :ivar security_profile: This property specifies the security profile of an OS disk image.
    :vartype security_profile: ~azure.mgmt.compute.models.OSDiskImageSecurityProfile
    """

    _attribute_map = {
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "security_profile": {"key": "securityProfile", "type": "OSDiskImageSecurityProfile"},
    }

    def __init__(
        self,
        *,
        disk_encryption_set_id: Optional[str] = None,
        security_profile: Optional["_models.OSDiskImageSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        :keyword security_profile: This property specifies the security profile of an OS disk image.
        :paramtype security_profile: ~azure.mgmt.compute.models.OSDiskImageSecurityProfile
        """
        super().__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)
        self.security_profile = security_profile

class OrchestrationServiceStateInput(_serialization.Model):
    """The input for OrchestrationServiceState.

    All required parameters must be populated in order to send to Azure.

    :ivar service_name: The name of the service. Required. Known values are: "AutomaticRepairs" and
     "DummyOrchestrationServiceName".
    :vartype service_name: str or ~azure.mgmt.compute.models.OrchestrationServiceNames
    :ivar action: The action to be performed. Required. Known values are: "Resume" and "Suspend".
    :vartype action: str or ~azure.mgmt.compute.models.OrchestrationServiceStateAction
    """

    _validation = {
        "service_name": {"required": True},
        "action": {"required": True},
    }

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_name: Union[str, "_models.OrchestrationServiceNames"],
        action: Union[str, "_models.OrchestrationServiceStateAction"],
        **kwargs: Any
    ) -> None:
        """
        :keyword service_name: The name of the service. Required. Known values are: "AutomaticRepairs"
         and "DummyOrchestrationServiceName".
        :paramtype service_name: str or
         ~azure.mgmt.compute.models.OrchestrationServiceNames
        :keyword action: The action to be performed. Required. Known values are: "Resume" and
         "Suspend".
        :paramtype action: str or
         ~azure.mgmt.compute.models.OrchestrationServiceStateAction
        """
        super().__init__(**kwargs)
        self.service_name = service_name
        self.action = action

class OrchestrationServiceSummary(_serialization.Model):
    """Summary for an orchestration service of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_name: The name of the service. Known values are: "AutomaticRepairs" and
     "DummyOrchestrationServiceName".
    :vartype service_name: str or ~azure.mgmt.compute.models.OrchestrationServiceNames
    :ivar service_state: The current state of the service. Known values are: "NotRunning",
     "Running", and "Suspended".
    :vartype service_state: str or ~azure.mgmt.compute.models.OrchestrationServiceState
    """

    _validation = {
        "service_name": {"readonly": True},
        "service_state": {"readonly": True},
    }

    _attribute_map = {
        "service_name": {"key": "serviceName", "type": "str"},
        "service_state": {"key": "serviceState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.service_name = None
        self.service_state = None

class SshPublicKeyGenerateKeyPairResult(_serialization.Model):
    """Response from generation of an SSH key pair.

    All required parameters must be populated in order to send to Azure.

    :ivar private_key: Private key portion of the key pair used to authenticate to a virtual
     machine through ssh. The private key is returned in RFC3447 format and should be treated as a
     secret. Required.
    :vartype private_key: str
    :ivar public_key: Public key portion of the key pair used to authenticate to a virtual machine
     through ssh. The public key is in ssh-rsa format. Required.
    :vartype public_key: str
    :ivar id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{SshPublicKeyName}.
     Required.
    :vartype id: str
    """

    _validation = {
        "private_key": {"required": True},
        "public_key": {"required": True},
        "id": {"required": True},
    }

    _attribute_map = {
        "private_key": {"key": "privateKey", "type": "str"},
        "public_key": {"key": "publicKey", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self, *, private_key: str, public_key: str, id: str, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword private_key: Private key portion of the key pair used to authenticate to a virtual
         machine through ssh. The private key is returned in RFC3447 format and should be treated as a
         secret. Required.
        :paramtype private_key: str
        :keyword public_key: Public key portion of the key pair used to authenticate to a virtual
         machine through ssh. The public key is in ssh-rsa format. Required.
        :paramtype public_key: str
        :keyword id: The ARM resource id in the form of
         /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{SshPublicKeyName}.
         Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.private_key = private_key
        self.public_key = public_key
        self.id = id

class SshPublicKeyResource(Resource):
    """Specifies information about the SSH public key.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar public_key: SSH public key used to authenticate to a virtual machine through ssh. If this
     property is not initially provided when the resource is created, the publicKey property will be
     populated when generateKeyPair is called. If the public key is provided upon resource creation,
     the provided public key needs to be at least 2048-bit and in ssh-rsa format.
    :vartype public_key: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "public_key": {"key": "properties.publicKey", "type": "str"},
    }

    def __init__(
        self, *, location: str, tags: Optional[Dict[str, str]] = None, public_key: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword public_key: SSH public key used to authenticate to a virtual machine through ssh. If
         this property is not initially provided when the resource is created, the publicKey property
         will be populated when generateKeyPair is called. If the public key is provided upon resource
         creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
        :paramtype public_key: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.public_key = public_key

class SshPublicKeyUpdateResource(UpdateResource):
    """Specifies information about the SSH public key.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar public_key: SSH public key used to authenticate to a virtual machine through ssh. If this
     property is not initially provided when the resource is created, the publicKey property will be
     populated when generateKeyPair is called. If the public key is provided upon resource creation,
     the provided public key needs to be at least 2048-bit and in ssh-rsa format.
    :vartype public_key: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "public_key": {"key": "properties.publicKey", "type": "str"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, public_key: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword public_key: SSH public key used to authenticate to a virtual machine through ssh. If
         this property is not initially provided when the resource is created, the publicKey property
         will be populated when generateKeyPair is called. If the public key is provided upon resource
         creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
        :paramtype public_key: str
        """
        super().__init__(tags=tags, **kwargs)
        self.public_key = public_key

class SshPublicKeysGroupListResult(_serialization.Model):
    """The list SSH public keys operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of SSH public keys. Required.
    :vartype value: list[~azure.mgmt.compute.models.SshPublicKeyResource]
    :ivar next_link: The URI to fetch the next page of SSH public keys. Call ListNext() with this
     URI to fetch the next page of SSH public keys.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SshPublicKeyResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SshPublicKeyResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of SSH public keys. Required.
        :paramtype value: list[~azure.mgmt.compute.models.SshPublicKeyResource]
        :keyword next_link: The URI to fetch the next page of SSH public keys. Call ListNext() with
         this URI to fetch the next page of SSH public keys.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class DiskAccess(Resource):
    """disk access resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: The extended location where the disk access will be created. Extended
     location cannot be changed.
    :vartype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
    :ivar private_endpoint_connections: A readonly collection of private endpoint connections
     created on the disk. Currently only one endpoint connection is supported.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.compute.models.PrivateEndpointConnection]
    :ivar provisioning_state: The disk access resource provisioning state.
    :vartype provisioning_state: str
    :ivar time_created: The time when the disk access was created.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "private_endpoint_connections": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "time_created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: The extended location where the disk access will be created.
         Extended location cannot be changed.
        :paramtype extended_location: ~azure.mgmt.compute.models.ExtendedLocation
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.private_endpoint_connections = None
        self.provisioning_state = None
        self.time_created = None

class DiskAccessList(_serialization.Model):
    """The List disk access operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of disk access resources. Required.
    :vartype value: list[~azure.mgmt.compute.models.DiskAccess]
    :ivar next_link: The uri to fetch the next page of disk access resources. Call ListNext() with
     this to fetch the next page of disk access resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiskAccess]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DiskAccess"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of disk access resources. Required.
        :paramtype value: list[~azure.mgmt.compute.models.DiskAccess]
        :keyword next_link: The uri to fetch the next page of disk access resources. Call ListNext()
         with this to fetch the next page of disk access resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class DiskAccessUpdate(_serialization.Model):
    """Used for updating a disk access resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags

class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None

class PrivateEndpointConnection(_serialization.Model):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: private endpoint connection Id.
    :vartype id: str
    :ivar name: private endpoint connection name.
    :vartype name: str
    :ivar type: private endpoint connection type.
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.compute.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between DiskAccess and Virtual Network.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.compute.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "private_endpoint": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between DiskAccess and Virtual Network.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.compute.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.private_endpoint = None
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None

class PrivateLinkResource(_serialization.Model):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: private link resource Id.
    :vartype id: str
    :ivar name: private link resource name.
    :vartype name: str
    :ivar type: private link resource type.
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names

class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.compute.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.compute.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value

class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.compute.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or
         ~azure.mgmt.compute.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required

class AvailablePatchSummary(_serialization.Model):
    """Describes the properties of an virtual machine instance view for available patch summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Known values are: "Unknown", "InProgress", "Failed", "Succeeded",
     and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.models.PatchOperationStatus
    :ivar assessment_activity_id: The activity ID of the operation that produced this result. It is
     used to correlate across CRP and extension logs.
    :vartype assessment_activity_id: str
    :ivar reboot_pending: The overall reboot status of the VM. It will be true when partially
     installed patches require a reboot to complete installation but the reboot has not yet
     occurred.
    :vartype reboot_pending: bool
    :ivar critical_and_security_patch_count: The number of critical or security patches that have
     been detected as available and not yet installed.
    :vartype critical_and_security_patch_count: int
    :ivar other_patch_count: The number of all available patches excluding critical and security.
    :vartype other_patch_count: int
    :ivar start_time: The UTC timestamp when the operation began.
    :vartype start_time: ~datetime.datetime
    :ivar last_modified_time: The UTC timestamp when the operation began.
    :vartype last_modified_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.models.ApiError
    """

    _validation = {
        "status": {"readonly": True},
        "assessment_activity_id": {"readonly": True},
        "reboot_pending": {"readonly": True},
        "critical_and_security_patch_count": {"readonly": True},
        "other_patch_count": {"readonly": True},
        "start_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "assessment_activity_id": {"key": "assessmentActivityId", "type": "str"},
        "reboot_pending": {"key": "rebootPending", "type": "bool"},
        "critical_and_security_patch_count": {"key": "criticalAndSecurityPatchCount", "type": "int"},
        "other_patch_count": {"key": "otherPatchCount", "type": "int"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.assessment_activity_id = None
        self.reboot_pending = None
        self.critical_and_security_patch_count = None
        self.other_patch_count = None
        self.start_time = None
        self.last_modified_time = None
        self.error = None

class DedicatedHostGroupInstanceView(_serialization.Model):
    """DedicatedHostGroupInstanceView.

    :ivar hosts: List of instance view of the dedicated hosts under the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.models.DedicatedHostInstanceViewWithName]
    """

    _attribute_map = {
        "hosts": {"key": "hosts", "type": "[DedicatedHostInstanceViewWithName]"},
    }

    def __init__(
        self, *, hosts: Optional[List["_models.DedicatedHostInstanceViewWithName"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword hosts: List of instance view of the dedicated hosts under the dedicated host group.
        :paramtype hosts:
         list[~azure.mgmt.compute.models.DedicatedHostInstanceViewWithName]
        """
        super().__init__(**kwargs)
        self.hosts = hosts

class DedicatedHostInstanceViewWithName(DedicatedHostInstanceView):
    """The instance view of a dedicated host that includes the name of the dedicated host. It is used
    for the response to the instance view of a dedicated host group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_id: Specifies the unique id of the dedicated physical machine on which the
     dedicated host resides.
    :vartype asset_id: str
    :ivar available_capacity: Unutilized capacity of the dedicated host.
    :vartype available_capacity:
     ~azure.mgmt.compute.models.DedicatedHostAvailableCapacity
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    :ivar name: The name of the dedicated host.
    :vartype name: str
    """

    _validation = {
        "asset_id": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "asset_id": {"key": "assetId", "type": "str"},
        "available_capacity": {"key": "availableCapacity", "type": "DedicatedHostAvailableCapacity"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        available_capacity: Optional["_models.DedicatedHostAvailableCapacity"] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_capacity: Unutilized capacity of the dedicated host.
        :paramtype available_capacity:
         ~azure.mgmt.compute.models.DedicatedHostAvailableCapacity
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(available_capacity=available_capacity, statuses=statuses, **kwargs)
        self.name = None

class DisallowedConfiguration(_serialization.Model):
    """Specifies the disallowed configuration for a virtual machine image.

    :ivar vm_disk_type: VM disk types which are disallowed. Known values are: "None" and
     "Unmanaged".
    :vartype vm_disk_type: str or ~azure.mgmt.compute.models.VmDiskTypes
    """

    _attribute_map = {
        "vm_disk_type": {"key": "vmDiskType", "type": "str"},
    }

    def __init__(self, *, vm_disk_type: Optional[Union[str, "_models.VmDiskTypes"]] = None, **kwargs: Any) -> None:
        """
        :keyword vm_disk_type: VM disk types which are disallowed. Known values are: "None" and
         "Unmanaged".
        :paramtype vm_disk_type: str or ~azure.mgmt.compute.models.VmDiskTypes
        """
        super().__init__(**kwargs)
        self.vm_disk_type = vm_disk_type

class LastPatchInstallationSummary(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes the properties of the last installed patch summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Known values are: "Unknown", "InProgress", "Failed", "Succeeded",
     and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.models.PatchOperationStatus
    :ivar installation_activity_id: The activity ID of the operation that produced this result. It
     is used to correlate across CRP and extension logs.
    :vartype installation_activity_id: str
    :ivar maintenance_window_exceeded: Describes whether the operation ran out of time before it
     completed all its intended actions.
    :vartype maintenance_window_exceeded: bool
    :ivar not_selected_patch_count: The number of all available patches but not going to be
     installed because it didn't match a classification or inclusion list entry.
    :vartype not_selected_patch_count: int
    :ivar excluded_patch_count: The number of all available patches but excluded explicitly by a
     customer-specified exclusion list match.
    :vartype excluded_patch_count: int
    :ivar pending_patch_count: The number of all available patches expected to be installed over
     the course of the patch installation operation.
    :vartype pending_patch_count: int
    :ivar installed_patch_count: The count of patches that successfully installed.
    :vartype installed_patch_count: int
    :ivar failed_patch_count: The count of patches that failed installation.
    :vartype failed_patch_count: int
    :ivar start_time: The UTC timestamp when the operation began.
    :vartype start_time: ~datetime.datetime
    :ivar last_modified_time: The UTC timestamp when the operation began.
    :vartype last_modified_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.models.ApiError
    """

    _validation = {
        "status": {"readonly": True},
        "installation_activity_id": {"readonly": True},
        "maintenance_window_exceeded": {"readonly": True},
        "not_selected_patch_count": {"readonly": True},
        "excluded_patch_count": {"readonly": True},
        "pending_patch_count": {"readonly": True},
        "installed_patch_count": {"readonly": True},
        "failed_patch_count": {"readonly": True},
        "start_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "installation_activity_id": {"key": "installationActivityId", "type": "str"},
        "maintenance_window_exceeded": {"key": "maintenanceWindowExceeded", "type": "bool"},
        "not_selected_patch_count": {"key": "notSelectedPatchCount", "type": "int"},
        "excluded_patch_count": {"key": "excludedPatchCount", "type": "int"},
        "pending_patch_count": {"key": "pendingPatchCount", "type": "int"},
        "installed_patch_count": {"key": "installedPatchCount", "type": "int"},
        "failed_patch_count": {"key": "failedPatchCount", "type": "int"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.installation_activity_id = None
        self.maintenance_window_exceeded = None
        self.not_selected_patch_count = None
        self.excluded_patch_count = None
        self.pending_patch_count = None
        self.installed_patch_count = None
        self.failed_patch_count = None
        self.start_time = None
        self.last_modified_time = None
        self.error = None

class PatchSettings(_serialization.Model):
    """Specifies settings related to VM Guest Patching on Windows.

    :ivar patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as Flexible.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of patches to a virtual machine. You do this by applying patches manually
     inside the VM. In this mode, automatic updates are disabled; the property
     WindowsConfiguration.enableAutomaticUpdates must be false:code:`<br />`:code:`<br />`
     **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property
     WindowsConfiguration.enableAutomaticUpdates must be true. :code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The
     properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true. Known
     values are: "Manual", "AutomaticByOS", and "AutomaticByPlatform".
    :vartype patch_mode: str or ~azure.mgmt.compute.models.WindowsVMGuestPatchMode
    :ivar enable_hotpatching: Enables customers to patch their Azure VMs without requiring a
     reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must
     be set to 'AutomaticByPlatform'.
    :vartype enable_hotpatching: bool
    :ivar assessment_mode: Specifies the mode of VM Guest patch assessment for the IaaS virtual
     machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - You control the timing of patch assessments on a virtual machine.:code:`<br
     />`:code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic patch
     assessments. The property provisionVMAgent must be true. Known values are: "ImageDefault" and
     "AutomaticByPlatform".
    :vartype assessment_mode: str or
     ~azure.mgmt.compute.models.WindowsPatchAssessmentMode
    :ivar automatic_by_platform_settings: Specifies additional settings for patch mode
     AutomaticByPlatform in VM Guest Patching on Windows.
    :vartype automatic_by_platform_settings:
     ~azure.mgmt.compute.models.WindowsVMGuestPatchAutomaticByPlatformSettings
    """

    _attribute_map = {
        "patch_mode": {"key": "patchMode", "type": "str"},
        "enable_hotpatching": {"key": "enableHotpatching", "type": "bool"},
        "assessment_mode": {"key": "assessmentMode", "type": "str"},
        "automatic_by_platform_settings": {
            "key": "automaticByPlatformSettings",
            "type": "WindowsVMGuestPatchAutomaticByPlatformSettings",
        },
    }

    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "_models.WindowsVMGuestPatchMode"]] = None,
        enable_hotpatching: Optional[bool] = None,
        assessment_mode: Optional[Union[str, "_models.WindowsPatchAssessmentMode"]] = None,
        automatic_by_platform_settings: Optional["_models.WindowsVMGuestPatchAutomaticByPlatformSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
         machines associated to virtual machine scale set with OrchestrationMode as Flexible.:code:`<br
         />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
         the application of patches to a virtual machine. You do this by applying patches manually
         inside the VM. In this mode, automatic updates are disabled; the property
         WindowsConfiguration.enableAutomaticUpdates must be false:code:`<br />`:code:`<br />`
         **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property
         WindowsConfiguration.enableAutomaticUpdates must be true. :code:`<br />`:code:`<br />`
         **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The
         properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true. Known
         values are: "Manual", "AutomaticByOS", and "AutomaticByPlatform".
        :paramtype patch_mode: str or ~azure.mgmt.compute.models.WindowsVMGuestPatchMode
        :keyword enable_hotpatching: Enables customers to patch their Azure VMs without requiring a
         reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must
         be set to 'AutomaticByPlatform'.
        :paramtype enable_hotpatching: bool
        :keyword assessment_mode: Specifies the mode of VM Guest patch assessment for the IaaS virtual
         machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
         **ImageDefault** - You control the timing of patch assessments on a virtual machine.:code:`<br
         />`:code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic patch
         assessments. The property provisionVMAgent must be true. Known values are: "ImageDefault" and
         "AutomaticByPlatform".
        :paramtype assessment_mode: str or
         ~azure.mgmt.compute.models.WindowsPatchAssessmentMode
        :keyword automatic_by_platform_settings: Specifies additional settings for patch mode
         AutomaticByPlatform in VM Guest Patching on Windows.
        :paramtype automatic_by_platform_settings:
         ~azure.mgmt.compute.models.WindowsVMGuestPatchAutomaticByPlatformSettings
        """
        super().__init__(**kwargs)
        self.patch_mode = patch_mode
        self.enable_hotpatching = enable_hotpatching
        self.assessment_mode = assessment_mode
        self.automatic_by_platform_settings = automatic_by_platform_settings

class RetrieveBootDiagnosticsDataResult(_serialization.Model):
    """The SAS URIs of the console screenshot and serial log blobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The serial console log blob URI.
    :vartype serial_console_log_blob_uri: str
    """

    _validation = {
        "console_screenshot_blob_uri": {"readonly": True},
        "serial_console_log_blob_uri": {"readonly": True},
    }

    _attribute_map = {
        "console_screenshot_blob_uri": {"key": "consoleScreenshotBlobUri", "type": "str"},
        "serial_console_log_blob_uri": {"key": "serialConsoleLogBlobUri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None

class SecurityProfile(_serialization.Model):
    """Specifies the Security profile settings for the virtual machine or virtual machine scale set.

    :ivar uefi_settings: Specifies the security settings like secure boot and vTPM used while
     creating the virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
    :vartype uefi_settings: ~azure.mgmt.compute.models.UefiSettings
    :ivar encryption_at_host: This property can be used by user in the request to enable or disable
     the Host Encryption for the virtual machine or virtual machine scale set. This will enable the
     encryption for all the disks including Resource/Temp disk at host itself.
     :code:`<br>`:code:`<br>` Default: The Encryption at host will be disabled unless this property
     is set to true for the resource.
    :vartype encryption_at_host: bool
    :ivar security_type: Specifies the SecurityType of the virtual machine. It has to be set to any
     specified value to enable UefiSettings. :code:`<br>`:code:`<br>` Default: UefiSettings will not
     be enabled unless this property is set. Known values are: "TrustedLaunch" and "ConfidentialVM".
    :vartype security_type: str or ~azure.mgmt.compute.models.SecurityTypes
    """

    _attribute_map = {
        "uefi_settings": {"key": "uefiSettings", "type": "UefiSettings"},
        "encryption_at_host": {"key": "encryptionAtHost", "type": "bool"},
        "security_type": {"key": "securityType", "type": "str"},
    }

    def __init__(
        self,
        *,
        uefi_settings: Optional["_models.UefiSettings"] = None,
        encryption_at_host: Optional[bool] = None,
        security_type: Optional[Union[str, "_models.SecurityTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword uefi_settings: Specifies the security settings like secure boot and vTPM used while
         creating the virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
        :paramtype uefi_settings: ~azure.mgmt.compute.models.UefiSettings
        :keyword encryption_at_host: This property can be used by user in the request to enable or
         disable the Host Encryption for the virtual machine or virtual machine scale set. This will
         enable the encryption for all the disks including Resource/Temp disk at host itself.
         :code:`<br>`:code:`<br>` Default: The Encryption at host will be disabled unless this property
         is set to true for the resource.
        :paramtype encryption_at_host: bool
        :keyword security_type: Specifies the SecurityType of the virtual machine. It has to be set to
         any specified value to enable UefiSettings. :code:`<br>`:code:`<br>` Default: UefiSettings will
         not be enabled unless this property is set. Known values are: "TrustedLaunch" and
         "ConfidentialVM".
        :paramtype security_type: str or ~azure.mgmt.compute.models.SecurityTypes
        """
        super().__init__(**kwargs)
        self.uefi_settings = uefi_settings
        self.encryption_at_host = encryption_at_host
        self.security_type = security_type

class VirtualMachineAssessPatchesResult(_serialization.Model):
    """Describes the properties of an AssessPatches result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Known values are: "Unknown", "InProgress", "Failed", "Succeeded",
     and "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.models.PatchOperationStatus
    :ivar assessment_activity_id: The activity ID of the operation that produced this result. It is
     used to correlate across CRP and extension logs.
    :vartype assessment_activity_id: str
    :ivar reboot_pending: The overall reboot status of the VM. It will be true when partially
     installed patches require a reboot to complete installation but the reboot has not yet
     occurred.
    :vartype reboot_pending: bool
    :ivar critical_and_security_patch_count: The number of critical or security patches that have
     been detected as available and not yet installed.
    :vartype critical_and_security_patch_count: int
    :ivar other_patch_count: The number of all available patches excluding critical and security.
    :vartype other_patch_count: int
    :ivar start_date_time: The UTC timestamp when the operation began.
    :vartype start_date_time: ~datetime.datetime
    :ivar available_patches: The list of patches that have been detected as available for
     installation.
    :vartype available_patches:
     list[~azure.mgmt.compute.models.VirtualMachineSoftwarePatchProperties]
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.models.ApiError
    """

    _validation = {
        "status": {"readonly": True},
        "assessment_activity_id": {"readonly": True},
        "reboot_pending": {"readonly": True},
        "critical_and_security_patch_count": {"readonly": True},
        "other_patch_count": {"readonly": True},
        "start_date_time": {"readonly": True},
        "available_patches": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "assessment_activity_id": {"key": "assessmentActivityId", "type": "str"},
        "reboot_pending": {"key": "rebootPending", "type": "bool"},
        "critical_and_security_patch_count": {"key": "criticalAndSecurityPatchCount", "type": "int"},
        "other_patch_count": {"key": "otherPatchCount", "type": "int"},
        "start_date_time": {"key": "startDateTime", "type": "iso-8601"},
        "available_patches": {"key": "availablePatches", "type": "[VirtualMachineSoftwarePatchProperties]"},
        "error": {"key": "error", "type": "ApiError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.assessment_activity_id = None
        self.reboot_pending = None
        self.critical_and_security_patch_count = None
        self.other_patch_count = None
        self.start_date_time = None
        self.available_patches = None
        self.error = None

class VirtualMachinePatchStatus(_serialization.Model):
    """The status of virtual machine patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar available_patch_summary: The available patch summary of the latest assessment operation
     for the virtual machine.
    :vartype available_patch_summary: ~azure.mgmt.compute.models.AvailablePatchSummary
    :ivar last_patch_installation_summary: The installation summary of the latest installation
     operation for the virtual machine.
    :vartype last_patch_installation_summary:
     ~azure.mgmt.compute.models.LastPatchInstallationSummary
    :ivar configuration_statuses: The enablement status of the specified patchMode.
    :vartype configuration_statuses:
     list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _validation = {
        "configuration_statuses": {"readonly": True},
    }

    _attribute_map = {
        "available_patch_summary": {"key": "availablePatchSummary", "type": "AvailablePatchSummary"},
        "last_patch_installation_summary": {
            "key": "lastPatchInstallationSummary",
            "type": "LastPatchInstallationSummary",
        },
        "configuration_statuses": {"key": "configurationStatuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        available_patch_summary: Optional["_models.AvailablePatchSummary"] = None,
        last_patch_installation_summary: Optional["_models.LastPatchInstallationSummary"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_patch_summary: The available patch summary of the latest assessment
         operation for the virtual machine.
        :paramtype available_patch_summary:
         ~azure.mgmt.compute.models.AvailablePatchSummary
        :keyword last_patch_installation_summary: The installation summary of the latest installation
         operation for the virtual machine.
        :paramtype last_patch_installation_summary:
         ~azure.mgmt.compute.models.LastPatchInstallationSummary
        """
        super().__init__(**kwargs)
        self.available_patch_summary = available_patch_summary
        self.last_patch_installation_summary = last_patch_installation_summary
        self.configuration_statuses = None

class VirtualMachineRunCommand(Resource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine run command.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source: The source of the run command script.
    :vartype source: ~azure.mgmt.compute.models.VirtualMachineRunCommandScriptSource
    :ivar parameters: The parameters used by the script.
    :vartype parameters: list[~azure.mgmt.compute.models.RunCommandInputParameter]
    :ivar protected_parameters: The parameters used by the script.
    :vartype protected_parameters:
     list[~azure.mgmt.compute.models.RunCommandInputParameter]
    :ivar async_execution: Optional. If set to true, provisioning will complete as soon as the
     script starts and will not wait for script to complete.
    :vartype async_execution: bool
    :ivar run_as_user: Specifies the user account on the VM when executing the run command.
    :vartype run_as_user: str
    :ivar run_as_password: Specifies the user account password on the VM when executing the run
     command.
    :vartype run_as_password: str
    :ivar timeout_in_seconds: The timeout in seconds to execute the run command.
    :vartype timeout_in_seconds: int
    :ivar output_blob_uri: Specifies the Azure storage blob where script output stream will be
     uploaded.
    :vartype output_blob_uri: str
    :ivar error_blob_uri: Specifies the Azure storage blob where script error stream will be
     uploaded.
    :vartype error_blob_uri: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine run command instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.models.VirtualMachineRunCommandInstanceView
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "VirtualMachineRunCommandScriptSource"},
        "parameters": {"key": "properties.parameters", "type": "[RunCommandInputParameter]"},
        "protected_parameters": {"key": "properties.protectedParameters", "type": "[RunCommandInputParameter]"},
        "async_execution": {"key": "properties.asyncExecution", "type": "bool"},
        "run_as_user": {"key": "properties.runAsUser", "type": "str"},
        "run_as_password": {"key": "properties.runAsPassword", "type": "str"},
        "timeout_in_seconds": {"key": "properties.timeoutInSeconds", "type": "int"},
        "output_blob_uri": {"key": "properties.outputBlobUri", "type": "str"},
        "error_blob_uri": {"key": "properties.errorBlobUri", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineRunCommandInstanceView"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["_models.VirtualMachineRunCommandScriptSource"] = None,
        parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        protected_parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        async_execution: bool = False,
        run_as_user: Optional[str] = None,
        run_as_password: Optional[str] = None,
        timeout_in_seconds: Optional[int] = None,
        output_blob_uri: Optional[str] = None,
        error_blob_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source: The source of the run command script.
        :paramtype source: ~azure.mgmt.compute.models.VirtualMachineRunCommandScriptSource
        :keyword parameters: The parameters used by the script.
        :paramtype parameters: list[~azure.mgmt.compute.models.RunCommandInputParameter]
        :keyword protected_parameters: The parameters used by the script.
        :paramtype protected_parameters:
         list[~azure.mgmt.compute.models.RunCommandInputParameter]
        :keyword async_execution: Optional. If set to true, provisioning will complete as soon as the
         script starts and will not wait for script to complete.
        :paramtype async_execution: bool
        :keyword run_as_user: Specifies the user account on the VM when executing the run command.
        :paramtype run_as_user: str
        :keyword run_as_password: Specifies the user account password on the VM when executing the run
         command.
        :paramtype run_as_password: str
        :keyword timeout_in_seconds: The timeout in seconds to execute the run command.
        :paramtype timeout_in_seconds: int
        :keyword output_blob_uri: Specifies the Azure storage blob where script output stream will be
         uploaded.
        :paramtype output_blob_uri: str
        :keyword error_blob_uri: Specifies the Azure storage blob where script error stream will be
         uploaded.
        :paramtype error_blob_uri: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.source = source
        self.parameters = parameters
        self.protected_parameters = protected_parameters
        self.async_execution = async_execution
        self.run_as_user = run_as_user
        self.run_as_password = run_as_password
        self.timeout_in_seconds = timeout_in_seconds
        self.output_blob_uri = output_blob_uri
        self.error_blob_uri = error_blob_uri
        self.provisioning_state = None
        self.instance_view = None

class VirtualMachineRunCommandInstanceView(_serialization.Model):
    """The instance view of a virtual machine run command.

    :ivar execution_state: Script execution status. Known values are: "Unknown", "Pending",
     "Running", "Failed", "Succeeded", "TimedOut", and "Canceled".
    :vartype execution_state: str or ~azure.mgmt.compute.models.ExecutionState
    :ivar execution_message: Communicate script configuration errors or execution messages.
    :vartype execution_message: str
    :ivar exit_code: Exit code returned from script execution.
    :vartype exit_code: int
    :ivar output: Script output stream.
    :vartype output: str
    :ivar error: Script error stream.
    :vartype error: str
    :ivar start_time: Script start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Script end time.
    :vartype end_time: ~datetime.datetime
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
    """

    _attribute_map = {
        "execution_state": {"key": "executionState", "type": "str"},
        "execution_message": {"key": "executionMessage", "type": "str"},
        "exit_code": {"key": "exitCode", "type": "int"},
        "output": {"key": "output", "type": "str"},
        "error": {"key": "error", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "statuses": {"key": "statuses", "type": "[InstanceViewStatus]"},
    }

    def __init__(
        self,
        *,
        execution_state: Optional[Union[str, "_models.ExecutionState"]] = None,
        execution_message: Optional[str] = None,
        exit_code: Optional[int] = None,
        output: Optional[str] = None,
        error: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        statuses: Optional[List["_models.InstanceViewStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword execution_state: Script execution status. Known values are: "Unknown", "Pending",
         "Running", "Failed", "Succeeded", "TimedOut", and "Canceled".
        :paramtype execution_state: str or ~azure.mgmt.compute.models.ExecutionState
        :keyword execution_message: Communicate script configuration errors or execution messages.
        :paramtype execution_message: str
        :keyword exit_code: Exit code returned from script execution.
        :paramtype exit_code: int
        :keyword output: Script output stream.
        :paramtype output: str
        :keyword error: Script error stream.
        :paramtype error: str
        :keyword start_time: Script start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Script end time.
        :paramtype end_time: ~datetime.datetime
        :keyword statuses: The resource status information.
        :paramtype statuses: list[~azure.mgmt.compute.models.InstanceViewStatus]
        """
        super().__init__(**kwargs)
        self.execution_state = execution_state
        self.execution_message = execution_message
        self.exit_code = exit_code
        self.output = output
        self.error = error
        self.start_time = start_time
        self.end_time = end_time
        self.statuses = statuses

class VirtualMachineRunCommandScriptSource(_serialization.Model):
    """Describes the script sources for run command.

    :ivar script: Specifies the script content to be executed on the VM.
    :vartype script: str
    :ivar script_uri: Specifies the script download location.
    :vartype script_uri: str
    :ivar command_id: Specifies a commandId of predefined built-in script.
    :vartype command_id: str
    """

    _attribute_map = {
        "script": {"key": "script", "type": "str"},
        "script_uri": {"key": "scriptUri", "type": "str"},
        "command_id": {"key": "commandId", "type": "str"},
    }

    def __init__(
        self,
        *,
        script: Optional[str] = None,
        script_uri: Optional[str] = None,
        command_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword script: Specifies the script content to be executed on the VM.
        :paramtype script: str
        :keyword script_uri: Specifies the script download location.
        :paramtype script_uri: str
        :keyword command_id: Specifies a commandId of predefined built-in script.
        :paramtype command_id: str
        """
        super().__init__(**kwargs)
        self.script = script
        self.script_uri = script_uri
        self.command_id = command_id

class VirtualMachineRunCommandUpdate(UpdateResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Virtual Machine run command.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar source: The source of the run command script.
    :vartype source: ~azure.mgmt.compute.models.VirtualMachineRunCommandScriptSource
    :ivar parameters: The parameters used by the script.
    :vartype parameters: list[~azure.mgmt.compute.models.RunCommandInputParameter]
    :ivar protected_parameters: The parameters used by the script.
    :vartype protected_parameters:
     list[~azure.mgmt.compute.models.RunCommandInputParameter]
    :ivar async_execution: Optional. If set to true, provisioning will complete as soon as the
     script starts and will not wait for script to complete.
    :vartype async_execution: bool
    :ivar run_as_user: Specifies the user account on the VM when executing the run command.
    :vartype run_as_user: str
    :ivar run_as_password: Specifies the user account password on the VM when executing the run
     command.
    :vartype run_as_password: str
    :ivar timeout_in_seconds: The timeout in seconds to execute the run command.
    :vartype timeout_in_seconds: int
    :ivar output_blob_uri: Specifies the Azure storage blob where script output stream will be
     uploaded.
    :vartype output_blob_uri: str
    :ivar error_blob_uri: Specifies the Azure storage blob where script error stream will be
     uploaded.
    :vartype error_blob_uri: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine run command instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.models.VirtualMachineRunCommandInstanceView
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "instance_view": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "source": {"key": "properties.source", "type": "VirtualMachineRunCommandScriptSource"},
        "parameters": {"key": "properties.parameters", "type": "[RunCommandInputParameter]"},
        "protected_parameters": {"key": "properties.protectedParameters", "type": "[RunCommandInputParameter]"},
        "async_execution": {"key": "properties.asyncExecution", "type": "bool"},
        "run_as_user": {"key": "properties.runAsUser", "type": "str"},
        "run_as_password": {"key": "properties.runAsPassword", "type": "str"},
        "timeout_in_seconds": {"key": "properties.timeoutInSeconds", "type": "int"},
        "output_blob_uri": {"key": "properties.outputBlobUri", "type": "str"},
        "error_blob_uri": {"key": "properties.errorBlobUri", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineRunCommandInstanceView"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["_models.VirtualMachineRunCommandScriptSource"] = None,
        parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        protected_parameters: Optional[List["_models.RunCommandInputParameter"]] = None,
        async_execution: bool = False,
        run_as_user: Optional[str] = None,
        run_as_password: Optional[str] = None,
        timeout_in_seconds: Optional[int] = None,
        output_blob_uri: Optional[str] = None,
        error_blob_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword source: The source of the run command script.
        :paramtype source: ~azure.mgmt.compute.models.VirtualMachineRunCommandScriptSource
        :keyword parameters: The parameters used by the script.
        :paramtype parameters: list[~azure.mgmt.compute.models.RunCommandInputParameter]
        :keyword protected_parameters: The parameters used by the script.
        :paramtype protected_parameters:
         list[~azure.mgmt.compute.models.RunCommandInputParameter]
        :keyword async_execution: Optional. If set to true, provisioning will complete as soon as the
         script starts and will not wait for script to complete.
        :paramtype async_execution: bool
        :keyword run_as_user: Specifies the user account on the VM when executing the run command.
        :paramtype run_as_user: str
        :keyword run_as_password: Specifies the user account password on the VM when executing the run
         command.
        :paramtype run_as_password: str
        :keyword timeout_in_seconds: The timeout in seconds to execute the run command.
        :paramtype timeout_in_seconds: int
        :keyword output_blob_uri: Specifies the Azure storage blob where script output stream will be
         uploaded.
        :paramtype output_blob_uri: str
        :keyword error_blob_uri: Specifies the Azure storage blob where script error stream will be
         uploaded.
        :paramtype error_blob_uri: str
        """
        super().__init__(tags=tags, **kwargs)
        self.source = source
        self.parameters = parameters
        self.protected_parameters = protected_parameters
        self.async_execution = async_execution
        self.run_as_user = run_as_user
        self.run_as_password = run_as_password
        self.timeout_in_seconds = timeout_in_seconds
        self.output_blob_uri = output_blob_uri
        self.error_blob_uri = error_blob_uri
        self.provisioning_state = None
        self.instance_view = None

class VirtualMachineRunCommandsListResult(_serialization.Model):
    """The List run command operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of run commands. Required.
    :vartype value: list[~azure.mgmt.compute.models.VirtualMachineRunCommand]
    :ivar next_link: The uri to fetch the next page of run commands.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineRunCommand]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachineRunCommand"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of run commands. Required.
        :paramtype value: list[~azure.mgmt.compute.models.VirtualMachineRunCommand]
        :keyword next_link: The uri to fetch the next page of run commands.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class VirtualMachineScaleSetVMExtension(SubResourceReadOnly):  # pylint: disable=too-many-instance-attributes
    """Describes a VMSS VM Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine extension instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.models.VirtualMachineExtensionInstanceView
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.compute.models.KeyVaultSecretReference
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "VirtualMachineExtensionInstanceView"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {
            "key": "properties.protectedSettingsFromKeyVault",
            "type": "KeyVaultSecretReference",
        },
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        instance_view: Optional["_models.VirtualMachineExtensionInstanceView"] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional["_models.KeyVaultSecretReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword instance_view: The virtual machine extension instance view.
        :paramtype instance_view:
         ~azure.mgmt.compute.models.VirtualMachineExtensionInstanceView
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault:
         ~azure.mgmt.compute.models.KeyVaultSecretReference
        """
        super().__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault

class VirtualMachineScaleSetVMExtensionUpdate(SubResourceReadOnly):  # pylint: disable=too-many-instance-attributes
    """Describes a VMSS VM Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: JSON
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: JSON
    :ivar suppress_failures: Indicates whether failures stemming from the extension will be
     suppressed (Operational failures such as not connecting to the VM will not be suppressed
     regardless of this value). The default is false.
    :vartype suppress_failures: bool
    :ivar protected_settings_from_key_vault: The extensions protected settings that are passed by
     reference, and consumed from key vault.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.compute.models.KeyVaultSecretReference
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "object"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "object"},
        "suppress_failures": {"key": "properties.suppressFailures", "type": "bool"},
        "protected_settings_from_key_vault": {
            "key": "properties.protectedSettingsFromKeyVault",
            "type": "KeyVaultSecretReference",
        },
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        suppress_failures: Optional[bool] = None,
        protected_settings_from_key_vault: Optional["_models.KeyVaultSecretReference"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version of the extension available.
        :paramtype enable_automatic_upgrade: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: JSON
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: JSON
        :keyword suppress_failures: Indicates whether failures stemming from the extension will be
         suppressed (Operational failures such as not connecting to the VM will not be suppressed
         regardless of this value). The default is false.
        :paramtype suppress_failures: bool
        :keyword protected_settings_from_key_vault: The extensions protected settings that are passed
         by reference, and consumed from key vault.
        :paramtype protected_settings_from_key_vault:
         ~azure.mgmt.compute.models.KeyVaultSecretReference
        """
        super().__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.suppress_failures = suppress_failures
        self.protected_settings_from_key_vault = protected_settings_from_key_vault

class VirtualMachineScaleSetVMExtensionsListResult(_serialization.Model):
    """The List VMSS VM Extension operation response.

    :ivar value: The list of VMSS VM extensions.
    :vartype value: list[~azure.mgmt.compute.models.VirtualMachineScaleSetVMExtension]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachineScaleSetVMExtension]"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualMachineScaleSetVMExtension"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of VMSS VM extensions.
        :paramtype value:
         list[~azure.mgmt.compute.models.VirtualMachineScaleSetVMExtension]
        """
        super().__init__(**kwargs)
        self.value = value

class VirtualMachineSoftwarePatchProperties(_serialization.Model):
    """Describes the properties of a Virtual Machine software patch.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar patch_id: A unique identifier for the patch.
    :vartype patch_id: str
    :ivar name: The friendly name of the patch.
    :vartype name: str
    :ivar version: The version number of the patch. This property applies only to Linux patches.
    :vartype version: str
    :ivar kb_id: The KBID of the patch. Only applies to Windows patches.
    :vartype kb_id: str
    :ivar classifications: The classification(s) of the patch as provided by the patch publisher.
    :vartype classifications: list[str]
    :ivar reboot_behavior: Describes the reboot requirements of the patch. Known values are:
     "Unknown", "NeverReboots", "AlwaysRequiresReboot", and "CanRequestReboot".
    :vartype reboot_behavior: str or
     ~azure.mgmt.compute.models.VMGuestPatchRebootBehavior
    :ivar activity_id: The activity ID of the operation that produced this result. It is used to
     correlate across CRP and extension logs.
    :vartype activity_id: str
    :ivar published_date: The UTC timestamp when the repository published this patch.
    :vartype published_date: ~datetime.datetime
    :ivar last_modified_date_time: The UTC timestamp of the last update to this patch record.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar assessment_state: Describes the availability of a given patch. Known values are:
     "Unknown" and "Available".
    :vartype assessment_state: str or ~azure.mgmt.compute.models.PatchAssessmentState
    """

    _validation = {
        "patch_id": {"readonly": True},
        "name": {"readonly": True},
        "version": {"readonly": True},
        "kb_id": {"readonly": True},
        "classifications": {"readonly": True},
        "reboot_behavior": {"readonly": True},
        "activity_id": {"readonly": True},
        "published_date": {"readonly": True},
        "last_modified_date_time": {"readonly": True},
        "assessment_state": {"readonly": True},
    }

    _attribute_map = {
        "patch_id": {"key": "patchId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "kb_id": {"key": "kbId", "type": "str"},
        "classifications": {"key": "classifications", "type": "[str]"},
        "reboot_behavior": {"key": "rebootBehavior", "type": "str"},
        "activity_id": {"key": "activityId", "type": "str"},
        "published_date": {"key": "publishedDate", "type": "iso-8601"},
        "last_modified_date_time": {"key": "lastModifiedDateTime", "type": "iso-8601"},
        "assessment_state": {"key": "assessmentState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.patch_id = None
        self.name = None
        self.version = None
        self.kb_id = None
        self.classifications = None
        self.reboot_behavior = None
        self.activity_id = None
        self.published_date = None
        self.last_modified_date_time = None
        self.assessment_state = None

class ResourceUriList(_serialization.Model):
    """The List resources which are encrypted with the disk encryption set.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of IDs or Owner IDs of resources which are encrypted with the disk
     encryption set. Required.
    :vartype value: list[str]
    :ivar next_link: The uri to fetch the next page of encrypted resources. Call ListNext() with
     this to fetch the next page of encrypted resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List[str], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of IDs or Owner IDs of resources which are encrypted with the disk
         encryption set. Required.
        :paramtype value: list[str]
        :keyword next_link: The uri to fetch the next page of encrypted resources. Call ListNext() with
         this to fetch the next page of encrypted resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ProxyOnlyResource(_serialization.Model):
    """The ProxyOnly Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None

class DiskRestorePoint(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Properties of disk restore point.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time_created: The timestamp of restorePoint creation.
    :vartype time_created: ~datetime.datetime
    :ivar source_resource_id: arm id of source disk or source disk restore point.
    :vartype source_resource_id: str
    :ivar os_type: The Operating System type. Known values are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar purchase_plan: Purchase plan information for the the image from which the OS disk was
     created.
    :vartype purchase_plan: ~azure.mgmt.compute.models.PurchasePlan
    :ivar supported_capabilities: List of supported capabilities for the image from which the OS
     disk was created.
    :vartype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
    :ivar family_id: id of the backing snapshot's MIS family.
    :vartype family_id: str
    :ivar source_unique_id: unique incarnation id of the source disk.
    :vartype source_unique_id: str
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.models.Encryption
    :ivar supports_hibernation: Indicates the OS on a disk supports hibernation.
    :vartype supports_hibernation: bool
    :ivar network_access_policy: Policy for accessing the disk via network. Known values are:
     "AllowAll", "AllowPrivate", and "DenyAll".
    :vartype network_access_policy: str or
     ~azure.mgmt.compute.models.NetworkAccessPolicy
    :ivar public_network_access: Policy for controlling export on the disk. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.compute.models.PublicNetworkAccess
    :ivar disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :vartype disk_access_id: str
    :ivar completion_percent: Percentage complete for the background copy of disk restore point
     when source resource is from a different region.
    :vartype completion_percent: float
    :ivar replication_state: Replication state of disk restore point when source resource is from a
     different region.
    :vartype replication_state: str
    :ivar source_resource_location: Location of source disk or source disk restore point when
     source resource is from a different region.
    :vartype source_resource_location: str
    :ivar security_profile: Contains the security related information for the resource.
    :vartype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "time_created": {"readonly": True},
        "source_resource_id": {"readonly": True},
        "os_type": {"readonly": True},
        "family_id": {"readonly": True},
        "source_unique_id": {"readonly": True},
        "encryption": {"readonly": True},
        "replication_state": {"readonly": True},
        "source_resource_location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "time_created": {"key": "properties.timeCreated", "type": "iso-8601"},
        "source_resource_id": {"key": "properties.sourceResourceId", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "PurchasePlan"},
        "supported_capabilities": {"key": "properties.supportedCapabilities", "type": "SupportedCapabilities"},
        "family_id": {"key": "properties.familyId", "type": "str"},
        "source_unique_id": {"key": "properties.sourceUniqueId", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "supports_hibernation": {"key": "properties.supportsHibernation", "type": "bool"},
        "network_access_policy": {"key": "properties.networkAccessPolicy", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "disk_access_id": {"key": "properties.diskAccessId", "type": "str"},
        "completion_percent": {"key": "properties.completionPercent", "type": "float"},
        "replication_state": {"key": "properties.replicationState", "type": "str"},
        "source_resource_location": {"key": "properties.sourceResourceLocation", "type": "str"},
        "security_profile": {"key": "properties.securityProfile", "type": "DiskSecurityProfile"},
    }

    def __init__(
        self,
        *,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        purchase_plan: Optional["_models.PurchasePlan"] = None,
        supported_capabilities: Optional["_models.SupportedCapabilities"] = None,
        supports_hibernation: Optional[bool] = None,
        network_access_policy: Optional[Union[str, "_models.NetworkAccessPolicy"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        disk_access_id: Optional[str] = None,
        completion_percent: Optional[float] = None,
        security_profile: Optional["_models.DiskSecurityProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword purchase_plan: Purchase plan information for the the image from which the OS disk was
         created.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.PurchasePlan
        :keyword supported_capabilities: List of supported capabilities for the image from which the OS
         disk was created.
        :paramtype supported_capabilities: ~azure.mgmt.compute.models.SupportedCapabilities
        :keyword supports_hibernation: Indicates the OS on a disk supports hibernation.
        :paramtype supports_hibernation: bool
        :keyword network_access_policy: Policy for accessing the disk via network. Known values are:
         "AllowAll", "AllowPrivate", and "DenyAll".
        :paramtype network_access_policy: str or
         ~azure.mgmt.compute.models.NetworkAccessPolicy
        :keyword public_network_access: Policy for controlling export on the disk. Known values are:
         "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.compute.models.PublicNetworkAccess
        :keyword disk_access_id: ARM id of the DiskAccess resource for using private endpoints on
         disks.
        :paramtype disk_access_id: str
        :keyword completion_percent: Percentage complete for the background copy of disk restore point
         when source resource is from a different region.
        :paramtype completion_percent: float
        :keyword security_profile: Contains the security related information for the resource.
        :paramtype security_profile: ~azure.mgmt.compute.models.DiskSecurityProfile
        """
        super().__init__(**kwargs)
        self.time_created = None
        self.source_resource_id = None
        self.os_type = None
        self.hyper_v_generation = hyper_v_generation
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.family_id = None
        self.source_unique_id = None
        self.encryption = None
        self.supports_hibernation = supports_hibernation
        self.network_access_policy = network_access_policy
        self.public_network_access = public_network_access
        self.disk_access_id = disk_access_id
        self.completion_percent = completion_percent
        self.replication_state = None
        self.source_resource_location = None
        self.security_profile = security_profile

class DiskRestorePointList(_serialization.Model):
    """The List Disk Restore Points operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of disk restore points. Required.
    :vartype value: list[~azure.mgmt.compute.models.DiskRestorePoint]
    :ivar next_link: The uri to fetch the next page of disk restore points. Call ListNext() with
     this to fetch the next page of disk restore points.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiskRestorePoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DiskRestorePoint"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of disk restore points. Required.
        :paramtype value: list[~azure.mgmt.compute.models.DiskRestorePoint]
        :keyword next_link: The uri to fetch the next page of disk restore points. Call ListNext() with
         this to fetch the next page of disk restore points.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class ExtendedLocation(_serialization.Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "EdgeZone"
    :vartype type: str or ~azure.mgmt.compute.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "EdgeZone"
        :paramtype type: str or ~azure.mgmt.compute.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type

class GalleryImageFeature(_serialization.Model):
    """A feature for gallery image.

    :ivar name: The name of the gallery image feature.
    :vartype name: str
    :ivar value: The value of the gallery image feature.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the gallery image feature.
        :paramtype name: str
        :keyword value: The value of the gallery image feature.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value

class KeyForDiskEncryptionSet(_serialization.Model):
    """Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots.

    All required parameters must be populated in order to send to Azure.

    :ivar source_vault: Resource id of the KeyVault containing the key or secret. This property is
     optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption
     Set subscription.
    :vartype source_vault: ~azure.mgmt.compute.models.SourceVault
    :ivar key_url: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the
     Url is required regardless of rotationToLatestKeyVersionEnabled value. Required.
    :vartype key_url: str
    """

    _validation = {
        "key_url": {"required": True},
    }

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SourceVault"},
        "key_url": {"key": "keyUrl", "type": "str"},
    }

    def __init__(self, *, key_url: str, source_vault: Optional["_models.SourceVault"] = None, **kwargs: Any) -> None:
        """
        :keyword source_vault: Resource id of the KeyVault containing the key or secret. This property
         is optional and cannot be used if the KeyVault subscription is not the same as the Disk
         Encryption Set subscription.
        :paramtype source_vault: ~azure.mgmt.compute.models.SourceVault
        :keyword key_url: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the
         Url is required regardless of rotationToLatestKeyVersionEnabled value. Required.
        :paramtype key_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.key_url = key_url

class PirResource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.location = None

class PirSharedGalleryResource(PirResource):
    """Base information about the shared gallery resource in pir.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
    }

    def __init__(self, *, unique_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        """
        super().__init__(**kwargs)
        self.unique_id = unique_id

class PrivateEndpointConnectionListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.compute.models.PrivateEndpointConnection]
    :ivar next_link: The uri to fetch the next page of snapshots. Call ListNext() with this to
     fetch the next page of snapshots.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.compute.models.PrivateEndpointConnection]
        :keyword next_link: The uri to fetch the next page of snapshots. Call ListNext() with this to
         fetch the next page of snapshots.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class SharedGallery(PirSharedGalleryResource):
    """Specifies information about the Shared Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
    }

    def __init__(self, *, unique_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        """
        super().__init__(unique_id=unique_id, **kwargs)

class SharedGalleryImage(PirSharedGalleryResource):  # pylint: disable=too-many-instance-attributes
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized" and
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.models.Disallowed
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1" and "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64" and "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.models.Architecture
    :ivar privacy_statement_uri: Privacy statement uri for the current community gallery image.
    :vartype privacy_statement_uri: str
    :ivar eula: End-user license agreement for the current community gallery image.
    :vartype eula: str
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "os_state": {"key": "properties.osState", "type": "str"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "identifier": {"key": "properties.identifier", "type": "GalleryImageIdentifier"},
        "recommended": {"key": "properties.recommended", "type": "RecommendedMachineConfiguration"},
        "disallowed": {"key": "properties.disallowed", "type": "Disallowed"},
        "hyper_v_generation": {"key": "properties.hyperVGeneration", "type": "str"},
        "features": {"key": "properties.features", "type": "[GalleryImageFeature]"},
        "purchase_plan": {"key": "properties.purchasePlan", "type": "ImagePurchasePlan"},
        "architecture": {"key": "properties.architecture", "type": "str"},
        "privacy_statement_uri": {"key": "properties.privacyStatementUri", "type": "str"},
        "eula": {"key": "properties.eula", "type": "str"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        features: Optional[List["_models.GalleryImageFeature"]] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        privacy_statement_uri: Optional[str] = None,
        eula: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized"
         and "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.models.OperatingSystemStateTypes
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.models.Disallowed
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1" and "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.models.HyperVGeneration
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.models.GalleryImageFeature]
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.models.ImagePurchasePlan
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64" and "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.models.Architecture
        :keyword privacy_statement_uri: Privacy statement uri for the current community gallery image.
        :paramtype privacy_statement_uri: str
        :keyword eula: End-user license agreement for the current community gallery image.
        :paramtype eula: str
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.os_type = os_type
        self.os_state = os_state
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.hyper_v_generation = hyper_v_generation
        self.features = features
        self.purchase_plan = purchase_plan
        self.architecture = architecture
        self.privacy_statement_uri = privacy_statement_uri
        self.eula = eula

class SharedGalleryImageList(_serialization.Model):
    """The List Shared Gallery Images operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of shared gallery images. Required.
    :vartype value: list[~azure.mgmt.compute.models.SharedGalleryImage]
    :ivar next_link: The uri to fetch the next page of shared gallery images. Call ListNext() with
     this to fetch the next page of shared gallery images.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedGalleryImage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SharedGalleryImage"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of shared gallery images. Required.
        :paramtype value: list[~azure.mgmt.compute.models.SharedGalleryImage]
        :keyword next_link: The uri to fetch the next page of shared gallery images. Call ListNext()
         with this to fetch the next page of shared gallery images.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class SharedGalleryImageVersion(PirSharedGalleryResource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Resource name.
    :vartype name: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar unique_id: The unique id of this shared gallery.
    :vartype unique_id: str
    :ivar published_date: The published date of the gallery image version Definition. This property
     can be used for decommissioning purposes. This property is updatable.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar storage_profile: Describes the storage profile of the image version.
    :vartype storage_profile:
     ~azure.mgmt.compute.models.SharedGalleryImageVersionStorageProfile
    """

    _validation = {
        "name": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "unique_id": {"key": "identifier.uniqueId", "type": "str"},
        "published_date": {"key": "properties.publishedDate", "type": "iso-8601"},
        "end_of_life_date": {"key": "properties.endOfLifeDate", "type": "iso-8601"},
        "exclude_from_latest": {"key": "properties.excludeFromLatest", "type": "bool"},
        "storage_profile": {"key": "properties.storageProfile", "type": "SharedGalleryImageVersionStorageProfile"},
    }

    def __init__(
        self,
        *,
        unique_id: Optional[str] = None,
        published_date: Optional[datetime.datetime] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        exclude_from_latest: Optional[bool] = None,
        storage_profile: Optional["_models.SharedGalleryImageVersionStorageProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_id: The unique id of this shared gallery.
        :paramtype unique_id: str
        :keyword published_date: The published date of the gallery image version Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype published_date: ~datetime.datetime
        :keyword end_of_life_date: The end of life date of the gallery image version Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword storage_profile: Describes the storage profile of the image version.
        :paramtype storage_profile:
         ~azure.mgmt.compute.models.SharedGalleryImageVersionStorageProfile
        """
        super().__init__(unique_id=unique_id, **kwargs)
        self.published_date = published_date
        self.end_of_life_date = end_of_life_date
        self.exclude_from_latest = exclude_from_latest
        self.storage_profile = storage_profile

class SharedGalleryImageVersionList(_serialization.Model):
    """The List Shared Gallery Image versions operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of shared gallery images versions. Required.
    :vartype value: list[~azure.mgmt.compute.models.SharedGalleryImageVersion]
    :ivar next_link: The uri to fetch the next page of shared gallery image versions. Call
     ListNext() with this to fetch the next page of shared gallery image versions.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedGalleryImageVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SharedGalleryImageVersion"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of shared gallery images versions. Required.
        :paramtype value: list[~azure.mgmt.compute.models.SharedGalleryImageVersion]
        :keyword next_link: The uri to fetch the next page of shared gallery image versions. Call
         ListNext() with this to fetch the next page of shared gallery image versions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class SharedGalleryList(_serialization.Model):
    """The List Shared Galleries operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of shared galleries. Required.
    :vartype value: list[~azure.mgmt.compute.models.SharedGallery]
    :ivar next_link: The uri to fetch the next page of shared galleries. Call ListNext() with this
     to fetch the next page of shared galleries.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedGallery]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SharedGallery"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of shared galleries. Required.
        :paramtype value: list[~azure.mgmt.compute.models.SharedGallery]
        :keyword next_link: The uri to fetch the next page of shared galleries. Call ListNext() with
         this to fetch the next page of shared galleries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class SharingProfile(_serialization.Model):
    """Profile for gallery sharing to subscription or tenant.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar permissions: This property allows you to specify the permission of sharing gallery.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Private**
     :code:`<br>`:code:`<br>` **Groups** :code:`<br>`:code:`<br>` **Community**. Known values are:
     "Private", "Groups", and "Community".
    :vartype permissions: str or
     ~azure.mgmt.compute.models.GallerySharingPermissionTypes
    :ivar groups: A list of sharing profile groups.
    :vartype groups: list[~azure.mgmt.compute.models.SharingProfileGroup]
    :ivar community_gallery_info: Information of community gallery if current gallery is shared to
     community.
    :vartype community_gallery_info: ~azure.mgmt.compute.models.CommunityGalleryInfo
    """

    _validation = {
        "groups": {"readonly": True},
    }

    _attribute_map = {
        "permissions": {"key": "permissions", "type": "str"},
        "groups": {"key": "groups", "type": "[SharingProfileGroup]"},
        "community_gallery_info": {"key": "communityGalleryInfo", "type": "CommunityGalleryInfo"},
    }

    def __init__(
        self,
        *,
        permissions: Optional[Union[str, "_models.GallerySharingPermissionTypes"]] = None,
        community_gallery_info: Optional["_models.CommunityGalleryInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword permissions: This property allows you to specify the permission of sharing gallery.
         :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Private**
         :code:`<br>`:code:`<br>` **Groups** :code:`<br>`:code:`<br>` **Community**. Known values are:
         "Private", "Groups", and "Community".
        :paramtype permissions: str or
         ~azure.mgmt.compute.models.GallerySharingPermissionTypes
        :keyword community_gallery_info: Information of community gallery if current gallery is shared
         to community.
        :paramtype community_gallery_info: ~azure.mgmt.compute.models.CommunityGalleryInfo
        """
        super().__init__(**kwargs)
        self.permissions = permissions
        self.groups = None
        self.community_gallery_info = community_gallery_info

class SharingProfileGroup(_serialization.Model):
    """Group of the gallery sharing profile.

    :ivar type: This property allows you to specify the type of sharing group.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Subscriptions**
     :code:`<br>`:code:`<br>` **AADTenants**. Known values are: "Subscriptions" and "AADTenants".
    :vartype type: str or ~azure.mgmt.compute.models.SharingProfileGroupTypes
    :ivar ids: A list of subscription/tenant ids the gallery is aimed to be shared to.
    :vartype ids: list[str]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "ids": {"key": "ids", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.SharingProfileGroupTypes"]] = None,
        ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: This property allows you to specify the type of sharing group.
         :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Subscriptions**
         :code:`<br>`:code:`<br>` **AADTenants**. Known values are: "Subscriptions" and "AADTenants".
        :paramtype type: str or ~azure.mgmt.compute.models.SharingProfileGroupTypes
        :keyword ids: A list of subscription/tenant ids the gallery is aimed to be shared to.
        :paramtype ids: list[str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.ids = ids

class SharingUpdate(_serialization.Model):
    """Specifies information about the gallery sharing profile update.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_type: This property allows you to specify the operation type of gallery sharing
     update. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Add**
     :code:`<br>`:code:`<br>` **Remove** :code:`<br>`:code:`<br>` **Reset**. Required. Known values
     are: "Add", "Remove", "Reset", and "EnableCommunity".
    :vartype operation_type: str or
     ~azure.mgmt.compute.models.SharingUpdateOperationTypes
    :ivar groups: A list of sharing profile groups.
    :vartype groups: list[~azure.mgmt.compute.models.SharingProfileGroup]
    """

    _validation = {
        "operation_type": {"required": True},
    }

    _attribute_map = {
        "operation_type": {"key": "operationType", "type": "str"},
        "groups": {"key": "groups", "type": "[SharingProfileGroup]"},
    }

    def __init__(
        self,
        *,
        operation_type: Union[str, "_models.SharingUpdateOperationTypes"],
        groups: Optional[List["_models.SharingProfileGroup"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_type: This property allows you to specify the operation type of gallery
         sharing update. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Add**
         :code:`<br>`:code:`<br>` **Remove** :code:`<br>`:code:`<br>` **Reset**. Required. Known values
         are: "Add", "Remove", "Reset", and "EnableCommunity".
        :paramtype operation_type: str or
         ~azure.mgmt.compute.models.SharingUpdateOperationTypes
        :keyword groups: A list of sharing profile groups.
        :paramtype groups: list[~azure.mgmt.compute.models.SharingProfileGroup]
        """
        super().__init__(**kwargs)
        self.operation_type = operation_type
        self.groups = groups

class CloudService(_serialization.Model):
    """Describes the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Cloud service properties.
    :vartype properties: ~azure.mgmt.compute.models.CloudServiceProperties
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.compute.models.SystemData
    :ivar zones: List of logical availability zone of the resource. List should contain only 1 zone
     where cloud service should be provisioned. This field is optional.
    :vartype zones: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "CloudServiceProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CloudServiceProperties"] = None,
        system_data: Optional["_models.SystemData"] = None,
        zones: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Cloud service properties.
        :paramtype properties: ~azure.mgmt.compute.models.CloudServiceProperties
        :keyword system_data: The system meta data relating to this resource.
        :paramtype system_data: ~azure.mgmt.compute.models.SystemData
        :keyword zones: List of logical availability zone of the resource. List should contain only 1
         zone where cloud service should be provisioned. This field is optional.
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.properties = properties
        self.system_data = system_data
        self.zones = zones

class CloudServiceExtensionProfile(_serialization.Model):
    """Describes a cloud service extension profile.

    :ivar extensions: List of extensions for the cloud service.
    :vartype extensions: list[~azure.mgmt.compute.models.Extension]
    """

    _attribute_map = {
        "extensions": {"key": "extensions", "type": "[Extension]"},
    }

    def __init__(self, *, extensions: Optional[List["_models.Extension"]] = None, **kwargs: Any) -> None:
        """
        :keyword extensions: List of extensions for the cloud service.
        :paramtype extensions: list[~azure.mgmt.compute.models.Extension]
        """
        super().__init__(**kwargs)
        self.extensions = extensions

class CloudServiceExtensionProperties(_serialization.Model):
    """Extension Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension.
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the extension. Specifies the version of
     the extension. If this element is not specified or an asterisk (*) is used as the value, the
     latest version of the extension is used. If the value is specified with a major version number
     and an asterisk as the minor version number (X.), the latest minor version of the specified
     major version is selected. If a major version number and a minor version number are specified
     (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade
     is performed on the role instance.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Explicitly specify whether platform can automatically upgrade
     typeHandlerVersion to higher minor versions when they become available.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Public settings for the extension. For JSON extensions, this is the JSON
     settings for the extension. For XML Extension (like RDP), this is the XML setting for the
     extension.
    :vartype settings: JSON
    :ivar protected_settings: Protected settings for the extension which are encrypted before sent
     to the role instance.
    :vartype protected_settings: JSON
    :ivar protected_settings_from_key_vault: Protected settings for the extension, referenced using
     KeyVault which are encrypted before sent to the role instance.
    :vartype protected_settings_from_key_vault:
     ~azure.mgmt.compute.models.CloudServiceVaultAndSecretReference
    :ivar force_update_tag: Tag to force apply the provided public and protected settings.
     Changing the tag value allows for re-running the extension without changing any of the public
     or protected settings.
     If forceUpdateTag is not changed, updates to public or protected settings would still be
     applied by the handler.
     If neither forceUpdateTag nor any of public or protected settings change, extension would flow
     to the role instance with the same sequence-number, and
     it is up to handler implementation whether to re-run it or not.
    :vartype force_update_tag: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar roles_applied_to: Optional list of roles to apply this extension. If property is not
     specified or '*' is specified, extension is applied to all roles in the cloud service.
    :vartype roles_applied_to: list[str]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "auto_upgrade_minor_version": {"key": "autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "settings", "type": "object"},
        "protected_settings": {"key": "protectedSettings", "type": "object"},
        "protected_settings_from_key_vault": {
            "key": "protectedSettingsFromKeyVault",
            "type": "CloudServiceVaultAndSecretReference",
        },
        "force_update_tag": {"key": "forceUpdateTag", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "roles_applied_to": {"key": "rolesAppliedTo", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[JSON] = None,
        protected_settings: Optional[JSON] = None,
        protected_settings_from_key_vault: Optional["_models.CloudServiceVaultAndSecretReference"] = None,
        force_update_tag: Optional[str] = None,
        roles_applied_to: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension.
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the extension. Specifies the version of
         the extension. If this element is not specified or an asterisk (*) is used as the value, the
         latest version of the extension is used. If the value is specified with a major version number
         and an asterisk as the minor version number (X.), the latest minor version of the specified
         major version is selected. If a major version number and a minor version number are specified
         (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade
         is performed on the role instance.
        :paramtype type_handler_version: str
        :keyword auto_upgrade_minor_version: Explicitly specify whether platform can automatically
         upgrade typeHandlerVersion to higher minor versions when they become available.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Public settings for the extension. For JSON extensions, this is the JSON
         settings for the extension. For XML Extension (like RDP), this is the XML setting for the
         extension.
        :paramtype settings: JSON
        :keyword protected_settings: Protected settings for the extension which are encrypted before
         sent to the role instance.
        :paramtype protected_settings: JSON
        :keyword protected_settings_from_key_vault: Protected settings for the extension, referenced
         using KeyVault which are encrypted before sent to the role instance.
        :paramtype protected_settings_from_key_vault:
         ~azure.mgmt.compute.models.CloudServiceVaultAndSecretReference
        :keyword force_update_tag: Tag to force apply the provided public and protected settings.
         Changing the tag value allows for re-running the extension without changing any of the public
         or protected settings.
         If forceUpdateTag is not changed, updates to public or protected settings would still be
         applied by the handler.
         If neither forceUpdateTag nor any of public or protected settings change, extension would flow
         to the role instance with the same sequence-number, and
         it is up to handler implementation whether to re-run it or not.
        :paramtype force_update_tag: str
        :keyword roles_applied_to: Optional list of roles to apply this extension. If property is not
         specified or '*' is specified, extension is applied to all roles in the cloud service.
        :paramtype roles_applied_to: list[str]
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.protected_settings_from_key_vault = protected_settings_from_key_vault
        self.force_update_tag = force_update_tag
        self.provisioning_state = None
        self.roles_applied_to = roles_applied_to

class CloudServiceInstanceView(_serialization.Model):
    """InstanceView of CloudService as a whole.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar role_instance: Instance view statuses.
    :vartype role_instance: ~azure.mgmt.compute.models.InstanceViewStatusesSummary
    :ivar sdk_version: The version of the SDK that was used to generate the package for the cloud
     service.
    :vartype sdk_version: str
    :ivar private_ids: Specifies a list of unique identifiers generated internally for the cloud
     service. :code:`<br />`:code:`<br />` NOTE: If you are using Azure Diagnostics extension, this
     property can be used as 'DeploymentId' for querying details.
    :vartype private_ids: list[str]
    :ivar statuses:
    :vartype statuses: list[~azure.mgmt.compute.models.ResourceInstanceViewStatus]
    """

    _validation = {
        "sdk_version": {"readonly": True},
        "private_ids": {"readonly": True},
        "statuses": {"readonly": True},
    }

    _attribute_map = {
        "role_instance": {"key": "roleInstance", "type": "InstanceViewStatusesSummary"},
        "sdk_version": {"key": "sdkVersion", "type": "str"},
        "private_ids": {"key": "privateIds", "type": "[str]"},
        "statuses": {"key": "statuses", "type": "[ResourceInstanceViewStatus]"},
    }

    def __init__(self, *, role_instance: Optional["_models.InstanceViewStatusesSummary"] = None, **kwargs: Any) -> None:
        """
        :keyword role_instance: Instance view statuses.
        :paramtype role_instance: ~azure.mgmt.compute.models.InstanceViewStatusesSummary
        """
        super().__init__(**kwargs)
        self.role_instance = role_instance
        self.sdk_version = None
        self.private_ids = None
        self.statuses = None

class CloudServiceListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.models.CloudService]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CloudService"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.models.CloudService]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class CloudServiceNetworkProfile(_serialization.Model):
    """Network Profile for the cloud service.

    :ivar load_balancer_configurations: List of Load balancer configurations. Cloud service can
     have up to two load balancer configurations, corresponding to a Public Load Balancer and an
     Internal Load Balancer.
    :vartype load_balancer_configurations:
     list[~azure.mgmt.compute.models.LoadBalancerConfiguration]
    :ivar slot_type: Slot type for the cloud service.
     Possible values are :code:`<br />`:code:`<br />`\ **Production**\ :code:`<br />`:code:`<br
     />`\ **Staging**\ :code:`<br />`:code:`<br />`
     If not specified, the default value is Production. Known values are: "Production" and
     "Staging".
    :vartype slot_type: str or ~azure.mgmt.compute.models.CloudServiceSlotType
    :ivar swappable_cloud_service: The id reference of the cloud service containing the target IP
     with which the subject cloud service can perform a swap. This property cannot be updated once
     it is set. The swappable cloud service referred by this id must be present otherwise an error
     will be thrown.
    :vartype swappable_cloud_service: ~azure.mgmt.compute.models.SubResource
    """

    _attribute_map = {
        "load_balancer_configurations": {"key": "loadBalancerConfigurations", "type": "[LoadBalancerConfiguration]"},
        "slot_type": {"key": "slotType", "type": "str"},
        "swappable_cloud_service": {"key": "swappableCloudService", "type": "SubResource"},
    }

    def __init__(
        self,
        *,
        load_balancer_configurations: Optional[List["_models.LoadBalancerConfiguration"]] = None,
        slot_type: Optional[Union[str, "_models.CloudServiceSlotType"]] = None,
        swappable_cloud_service: Optional["_models.SubResource"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword load_balancer_configurations: List of Load balancer configurations. Cloud service can
         have up to two load balancer configurations, corresponding to a Public Load Balancer and an
         Internal Load Balancer.
        :paramtype load_balancer_configurations:
         list[~azure.mgmt.compute.models.LoadBalancerConfiguration]
        :keyword slot_type: Slot type for the cloud service.
         Possible values are :code:`<br />`:code:`<br />`\ **Production**\ :code:`<br />`:code:`<br
         />`\ **Staging**\ :code:`<br />`:code:`<br />`
         If not specified, the default value is Production. Known values are: "Production" and
         "Staging".
        :paramtype slot_type: str or ~azure.mgmt.compute.models.CloudServiceSlotType
        :keyword swappable_cloud_service: The id reference of the cloud service containing the target
         IP with which the subject cloud service can perform a swap. This property cannot be updated
         once it is set. The swappable cloud service referred by this id must be present otherwise an
         error will be thrown.
        :paramtype swappable_cloud_service: ~azure.mgmt.compute.models.SubResource
        """
        super().__init__(**kwargs)
        self.load_balancer_configurations = load_balancer_configurations
        self.slot_type = slot_type
        self.swappable_cloud_service = swappable_cloud_service

class CloudServiceOsProfile(_serialization.Model):
    """Describes the OS profile for the cloud service.

    :ivar secrets: Specifies set of certificates that should be installed onto the role instances.
    :vartype secrets: list[~azure.mgmt.compute.models.CloudServiceVaultSecretGroup]
    """

    _attribute_map = {
        "secrets": {"key": "secrets", "type": "[CloudServiceVaultSecretGroup]"},
    }

    def __init__(
        self, *, secrets: Optional[List["_models.CloudServiceVaultSecretGroup"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secrets: Specifies set of certificates that should be installed onto the role
         instances.
        :paramtype secrets: list[~azure.mgmt.compute.models.CloudServiceVaultSecretGroup]
        """
        super().__init__(**kwargs)
        self.secrets = secrets

class CloudServiceProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Cloud service properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar package_url: Specifies a URL that refers to the location of the service package in the
     Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage
     account.
     This is a write-only property and is not returned in GET calls.
    :vartype package_url: str
    :ivar configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
    :vartype configuration: str
    :ivar configuration_url: Specifies a URL that refers to the location of the service
     configuration in the Blob service. The service package URL  can be Shared Access Signature
     (SAS) URI from any storage account.
     This is a write-only property and is not returned in GET calls.
    :vartype configuration_url: str
    :ivar start_cloud_service: (Optional) Indicates whether to start the cloud service immediately
     after it is created. The default value is ``true``.
     If false, the service model is still deployed, but the code is not run immediately. Instead,
     the service is PoweredOff until you call Start, at which time the service will be started. A
     deployed service still incurs charges, even if it is poweredoff.
    :vartype start_cloud_service: bool
    :ivar allow_model_override: (Optional) Indicates whether the role sku properties
     (roleProfile.roles.sku) specified in the model/template should override the role instance count
     and vm size specified in the .cscfg and .csdef respectively.
     The default value is ``false``.
    :vartype allow_model_override: bool
    :ivar upgrade_mode: Update mode for the cloud service. Role instances are allocated to update
     domains when the service is deployed. Updates can be initiated manually in each update domain
     or initiated automatically in all update domains.
     Possible Values are :code:`<br />`:code:`<br />`\ **Auto**\ :code:`<br />`:code:`<br />`\
     **Manual** :code:`<br />`:code:`<br />`\ **Simultaneous**\ :code:`<br />`:code:`<br />`
     If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called
     to apply the update. If set to Auto, the update is automatically applied to each update domain
     in sequence. Known values are: "Auto", "Manual", and "Simultaneous".
    :vartype upgrade_mode: str or ~azure.mgmt.compute.models.CloudServiceUpgradeMode
    :ivar role_profile: Describes the role profile for the cloud service.
    :vartype role_profile: ~azure.mgmt.compute.models.CloudServiceRoleProfile
    :ivar os_profile: Describes the OS profile for the cloud service.
    :vartype os_profile: ~azure.mgmt.compute.models.CloudServiceOsProfile
    :ivar network_profile: Network Profile for the cloud service.
    :vartype network_profile: ~azure.mgmt.compute.models.CloudServiceNetworkProfile
    :ivar extension_profile: Describes a cloud service extension profile.
    :vartype extension_profile: ~azure.mgmt.compute.models.CloudServiceExtensionProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar unique_id: The unique identifier for the cloud service.
    :vartype unique_id: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "unique_id": {"readonly": True},
    }

    _attribute_map = {
        "package_url": {"key": "packageUrl", "type": "str"},
        "configuration": {"key": "configuration", "type": "str"},
        "configuration_url": {"key": "configurationUrl", "type": "str"},
        "start_cloud_service": {"key": "startCloudService", "type": "bool"},
        "allow_model_override": {"key": "allowModelOverride", "type": "bool"},
        "upgrade_mode": {"key": "upgradeMode", "type": "str"},
        "role_profile": {"key": "roleProfile", "type": "CloudServiceRoleProfile"},
        "os_profile": {"key": "osProfile", "type": "CloudServiceOsProfile"},
        "network_profile": {"key": "networkProfile", "type": "CloudServiceNetworkProfile"},
        "extension_profile": {"key": "extensionProfile", "type": "CloudServiceExtensionProfile"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "unique_id": {"key": "uniqueId", "type": "str"},
    }

    def __init__(
        self,
        *,
        package_url: Optional[str] = None,
        configuration: Optional[str] = None,
        configuration_url: Optional[str] = None,
        start_cloud_service: Optional[bool] = None,
        allow_model_override: Optional[bool] = None,
        upgrade_mode: Optional[Union[str, "_models.CloudServiceUpgradeMode"]] = None,
        role_profile: Optional["_models.CloudServiceRoleProfile"] = None,
        os_profile: Optional["_models.CloudServiceOsProfile"] = None,
        network_profile: Optional["_models.CloudServiceNetworkProfile"] = None,
        extension_profile: Optional["_models.CloudServiceExtensionProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword package_url: Specifies a URL that refers to the location of the service package in the
         Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage
         account.
         This is a write-only property and is not returned in GET calls.
        :paramtype package_url: str
        :keyword configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
        :paramtype configuration: str
        :keyword configuration_url: Specifies a URL that refers to the location of the service
         configuration in the Blob service. The service package URL  can be Shared Access Signature
         (SAS) URI from any storage account.
         This is a write-only property and is not returned in GET calls.
        :paramtype configuration_url: str
        :keyword start_cloud_service: (Optional) Indicates whether to start the cloud service
         immediately after it is created. The default value is ``true``.
         If false, the service model is still deployed, but the code is not run immediately. Instead,
         the service is PoweredOff until you call Start, at which time the service will be started. A
         deployed service still incurs charges, even if it is poweredoff.
        :paramtype start_cloud_service: bool
        :keyword allow_model_override: (Optional) Indicates whether the role sku properties
         (roleProfile.roles.sku) specified in the model/template should override the role instance count
         and vm size specified in the .cscfg and .csdef respectively.
         The default value is ``false``.
        :paramtype allow_model_override: bool
        :keyword upgrade_mode: Update mode for the cloud service. Role instances are allocated to
         update domains when the service is deployed. Updates can be initiated manually in each update
         domain or initiated automatically in all update domains.
         Possible Values are :code:`<br />`:code:`<br />`\ **Auto**\ :code:`<br />`:code:`<br />`\
         **Manual** :code:`<br />`:code:`<br />`\ **Simultaneous**\ :code:`<br />`:code:`<br />`
         If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called
         to apply the update. If set to Auto, the update is automatically applied to each update domain
         in sequence. Known values are: "Auto", "Manual", and "Simultaneous".
        :paramtype upgrade_mode: str or ~azure.mgmt.compute.models.CloudServiceUpgradeMode
        :keyword role_profile: Describes the role profile for the cloud service.
        :paramtype role_profile: ~azure.mgmt.compute.models.CloudServiceRoleProfile
        :keyword os_profile: Describes the OS profile for the cloud service.
        :paramtype os_profile: ~azure.mgmt.compute.models.CloudServiceOsProfile
        :keyword network_profile: Network Profile for the cloud service.
        :paramtype network_profile: ~azure.mgmt.compute.models.CloudServiceNetworkProfile
        :keyword extension_profile: Describes a cloud service extension profile.
        :paramtype extension_profile:
         ~azure.mgmt.compute.models.CloudServiceExtensionProfile
        """
        super().__init__(**kwargs)
        self.package_url = package_url
        self.configuration = configuration
        self.configuration_url = configuration_url
        self.start_cloud_service = start_cloud_service
        self.allow_model_override = allow_model_override
        self.upgrade_mode = upgrade_mode
        self.role_profile = role_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.extension_profile = extension_profile
        self.provisioning_state = None
        self.unique_id = None

class CloudServiceRole(_serialization.Model):
    """Describes a role of the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar sku: Describes the cloud service role sku.
    :vartype sku: ~azure.mgmt.compute.models.CloudServiceRoleSku
    :ivar properties: The cloud service role properties.
    :vartype properties: ~azure.mgmt.compute.models.CloudServiceRoleProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "CloudServiceRoleSku"},
        "properties": {"key": "properties", "type": "CloudServiceRoleProperties"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.CloudServiceRoleSku"] = None,
        properties: Optional["_models.CloudServiceRoleProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: Describes the cloud service role sku.
        :paramtype sku: ~azure.mgmt.compute.models.CloudServiceRoleSku
        :keyword properties: The cloud service role properties.
        :paramtype properties: ~azure.mgmt.compute.models.CloudServiceRoleProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.sku = sku
        self.properties = properties

class CloudServiceRoleListResult(_serialization.Model):
    """The list operation result.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of resources. Required.
    :vartype value: list[~azure.mgmt.compute.models.CloudServiceRole]
    :ivar next_link: The URI to fetch the next page of resources. Use this to get the next page of
     resources. Do this till nextLink is null to fetch all the resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudServiceRole]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.CloudServiceRole"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of resources. Required.
        :paramtype value: list[~azure.mgmt.compute.models.CloudServiceRole]
        :keyword next_link: The URI to fetch the next page of resources. Use this to get the next page
         of resources. Do this till nextLink is null to fetch all the resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link

class CloudServiceRoleProfile(_serialization.Model):
    """Describes the role profile for the cloud service.

    :ivar roles: List of roles for the cloud service.
    :vartype roles: list[~azure.mgmt.compute.models.CloudServiceRoleProfileProperties]
    """

    _attribute_map = {
        "roles": {"key": "roles", "type": "[CloudServiceRoleProfileProperties]"},
    }

    def __init__(
        self, *, roles: Optional[List["_models.CloudServiceRoleProfileProperties"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword roles: List of roles for the cloud service.
        :paramtype roles:
         list[~azure.mgmt.compute.models.CloudServiceRoleProfileProperties]
        """
        super().__init__(**kwargs)
        self.roles = roles

class CloudServiceRoleProfileProperties(_serialization.Model):
    """Describes the role properties.

    :ivar name: Resource name.
    :vartype name: str
    :ivar sku: Describes the cloud service role sku.
    :vartype sku: ~azure.mgmt.compute.models.CloudServiceRoleSku
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "CloudServiceRoleSku"},
    }

    def __init__(
        self, *, name: Optional[str] = None, sku: Optional["_models.CloudServiceRoleSku"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword sku: Describes the cloud service role sku.
        :paramtype sku: ~azure.mgmt.compute.models.CloudServiceRoleSku
        """
        super().__init__(**kwargs)
        self.name = name
        self.sku = sku

class CloudServiceRoleProperties(_serialization.Model):
    """The cloud service role properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unique_id: Specifies the ID which uniquely identifies a cloud service role.
    :vartype unique_id: str
    """

    _validation = {
        "unique_id": {"readonly": True},
    }

    _attribute_map = {
        "unique_id": {"key": "uniqueId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.unique_id = None

class CloudServiceRoleSku(_serialization.Model):
    """Describes the cloud service role sku.

    :ivar name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud
     service is currently on, you need to delete and recreate the cloud service or move back to the
     old sku.
    :vartype name: str
    :ivar tier: Specifies the tier of the cloud service. Possible Values are :code:`<br
     />`:code:`<br />` **Standard** :code:`<br />`:code:`<br />` **Basic**.
    :vartype tier: str
    :ivar capacity: Specifies the number of role instances in the cloud service.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Optional[str] = None, tier: Optional[str] = None, capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud
         service is currently on, you need to delete and recreate the cloud service or move back to the
         old sku.
        :paramtype name: str
        :keyword tier: Specifies the tier of the cloud service. Possible Values are :code:`<br
         />`:code:`<br />` **Standard** :code:`<br />`:code:`<br />` **Basic**.
        :paramtype tier: str
        :keyword capacity: Specifies the number of role instances in the cloud service.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity

class CloudServiceUpdate(_serialization.Model):
    """CloudServiceUpdate.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags

class CloudServiceVaultAndSecretReference(_serialization.Model):
    """Protected settings for the extension, referenced using KeyVault which are encrypted before sent
    to the role instance.

    :ivar source_vault: The ARM Resource ID of the Key Vault.
    :vartype source_vault: ~azure.mgmt.compute.models.SubResource
    :ivar secret_url: Secret URL which contains the protected settings of the extension.
    :vartype secret_url: str
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "secret_url": {"key": "secretUrl", "type": "str"},
    }

    def __init__(
        self, *, source_vault: Optional["_models.SubResource"] = None, secret_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword source_vault: The ARM Resource ID of the Key Vault.
        :paramtype source_vault: ~azure.mgmt.compute.models.SubResource
        :keyword secret_url: Secret URL which contains the protected settings of the extension.
        :paramtype secret_url: str
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url

class CloudServiceVaultCertificate(_serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should
    reside on the role instance.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret.
    :vartype certificate_url: str
    """

    _attribute_map = {
        "certificate_url": {"key": "certificateUrl", "type": "str"},
    }

    def __init__(self, *, certificate_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword certificate_url: This is the URL of a certificate that has been uploaded to Key Vault
         as a secret.
        :paramtype certificate_url: str
        """
        super().__init__(**kwargs)
        self.certificate_url = certificate_url

class CloudServiceVaultSecretGroup(_serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :vartype source_vault: ~azure.mgmt.compute.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :vartype vault_certificates:
     list[~azure.mgmt.compute.models.CloudServiceVaultCertificate]
    """

    _attribute_map = {
        "source_vault": {"key": "sourceVault", "type": "SubResource"},
        "vault_certificates": {"key": "vaultCertificates", "type": "[CloudServiceVaultCertificate]"},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["_models.SubResource"] = None,
        vault_certificates: Optional[List["_models.CloudServiceVaultCertificate"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_vault: The relative URL of the Key Vault containing all of the certificates in
         VaultCertificates.
        :paramtype source_vault: ~azure.mgmt.compute.models.SubResource
        :keyword vault_certificates: The list of key vault references in SourceVault which contain
         certificates.
        :paramtype vault_certificates:
         list[~azure.mgmt.compute.models.CloudServiceVaultCertificate]
        """
        super().__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates

class Extension(_serialization.Model):
    """Describes a cloud service Extension.

    :ivar name: The name of the extension.
    :vartype name: str
    :ivar properties: Extension Properties.
    :vartype properties: ~azure.mgmt.compute.models.CloudServiceExtensionProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "CloudServiceExtensionProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.CloudServiceExtensionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extension.
        :paramtype name: str
        :keyword properties: Extension Properties.
        :paramtype properties: ~azure.mgmt.compute.models.CloudServiceExtensionProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties

class InstanceSku(_serialization.Model):
    """The role instance SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: The tier of the cloud service role instance.
    :vartype tier: str
    """

    _validation = {
        "name": {"readonly": True},
        "tie