"""
Attributes for Index of Attributes
http://www.w3.org/TR/REC-html40/index/attributes.html
"""

from trustedhtml.rules.html.values import values

attributes = {}

attributes['a'] = {
    'accesskey': values['accesskey'],
    'charset': values['charset'],
    'class': values['class'],
    'coords': values['coords'],
    'dir': values['dir'],
    'href': values['href'],
    'hreflang': values['hreflang'],
    'id': values['id'],
    'lang': values['lang'],
    'name': values['name'],
    'onblur': values['onblur'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onfocus': values['onfocus'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'rel': values['rel'],
    'rev': values['rev'],
    'shape': values['shape'],
    'style': values['style'],
    'tabindex': values['tabindex'],
    'target': values['target'],
    'title': values['title'],
    'type': values['type'],
}

attributes['abbr'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['acronym'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['address'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['applet'] = {
    'align': values['align~i'],
    'alt': values['alt'],
    'archive': values['archive~a'],
    'class': values['class'],
    'code': values['code'],
    'codebase': values['codebase'],
    'height': values['height~r'],
    'hspace': values['hspace'],
    'id': values['id'],
    'name': values['name'],
    'object': values['object'],
    'style': values['style'],
    'title': values['title'],
    'vspace': values['vspace'],
    'width': values['width~r'],
}

attributes['area'] = {
    'accesskey': values['accesskey'],
    'alt': values['alt~r'],
    'class': values['class'],
    'coords': values['coords'],
    'dir': values['dir'],
    'href': values['href'],
    'id': values['id'],
    'lang': values['lang'],
    'nohref': values['nohref'],
    'onblur': values['onblur'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onfocus': values['onfocus'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'shape': values['shape'],
    'style': values['style'],
    'tabindex': values['tabindex'],
    'target': values['target'],
    'title': values['title'],
}

attributes['b'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['base'] = {
    'href': values['href'],
    'target': values['target'],
}

attributes['basefont'] = {
    'color': values['color'],
    'face': values['face'],
    'id': values['id'],
    'size': values['size~b'],
}

attributes['bdo'] = {
    'class': values['class'],
    'dir': values['dir~r'],
    'id': values['id'],
    'lang': values['lang'],
    'style': values['style'],
    'title': values['title'],
}

attributes['big'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['blockquote'] = {
    'cite': values['cite'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['body'] = {
    'alink': values['alink'],
    'background': values['background'],
    'bgcolor': values['bgcolor'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'link': values['link'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onload': values['onload'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'onunload': values['onunload'],
    'style': values['style'],
    'text': values['text'],
    'title': values['title'],
    'vlink': values['vlink'],
}

attributes['br'] = {
    'class': values['class'],
    'clear': values['clear'],
    'id': values['id'],
    'style': values['style'],
    'title': values['title'],
}

attributes['button'] = {
    'accesskey': values['accesskey'],
    'class': values['class'],
    'dir': values['dir'],
    'disabled': values['disabled'],
    'id': values['id'],
    'lang': values['lang'],
    'name': values['name'],
    'onblur': values['onblur'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onfocus': values['onfocus'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'tabindex': values['tabindex'],
    'title': values['title'],
    'type': values['type~b'],
    'value': values['value'],
}

attributes['caption'] = {
    'align': values['align~c'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['center'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['cite'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['code'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['col'] = {
    'align': values['align'],
    'char': values['char'],
    'charoff': values['charoff'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'span': values['span'],
    'style': values['style'],
    'title': values['title'],
    'valign': values['valign'],
    'width': values['width~c'],
}

attributes['colgroup'] = {
    'align': values['align'],
    'char': values['char'],
    'charoff': values['charoff'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'span': values['span'],
    'style': values['style'],
    'title': values['title'],
    'valign': values['valign'],
    'width': values['width~c'],
}

attributes['dd'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['del'] = {
    'cite': values['cite'],
    'class': values['class'],
    'datetime': values['datetime'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['dfn'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['dir'] = {
    'class': values['class'],
    'compact': values['compact'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['div'] = {
    'align': values['align~d'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['dl'] = {
    'class': values['class'],
    'compact': values['compact'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['dt'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['em'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['fieldset'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['font'] = {
    'class': values['class'],
    'color': values['color'],
    'dir': values['dir'],
    'face': values['face'],
    'id': values['id'],
    'lang': values['lang'],
    'size': values['size~f'],
    'style': values['style'],
    'title': values['title'],
}

attributes['form'] = {
    'accept': values['accept'],
    'accept-charset': values['accept-charset'],
    'action': values['action'],
    'class': values['class'],
    'dir': values['dir'],
    'enctype': values['enctype'],
    'id': values['id'],
    'lang': values['lang'],
    'method': values['method'],
    'name': values['name'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'onreset': values['onreset'],
    'onsubmit': values['onsubmit'],
    'style': values['style'],
    'target': values['target'],
    'title': values['title'],
}

attributes['frame'] = {
    'class': values['class'],
    'frameborder': values['frameborder'],
    'id': values['id'],
    'longdesc': values['longdesc'],
    'marginheight': values['marginheight'],
    'marginwidth': values['marginwidth'],
    'name': values['name'],
    'noresize': values['noresize'],
    'scrolling': values['scrolling'],
    'src': values['src~f'],
    'style': values['style'],
    'title': values['title'],
}

attributes['frameset'] = {
    'class': values['class'],
    'cols': values['cols'],
    'id': values['id'],
    'onload': values['onload'],
    'onunload': values['onunload'],
    'rows': values['rows'],
    'style': values['style'],
    'title': values['title'],
}

attributes['h1'] = {
    'align': values['align~d'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['h2'] = {
    'align': values['align~d'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['h3'] = {
    'align': values['align~d'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['h4'] = {
    'align': values['align~d'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['h5'] = {
    'align': values['align~d'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['h6'] = {
    'align': values['align~d'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['head'] = {
    'dir': values['dir'],
    'lang': values['lang'],
    'profile': values['profile'],
}

attributes['hr'] = {
    'align': values['align~h'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'noshade': values['noshade'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'size': values['size~h'],
    'style': values['style'],
    'title': values['title'],
    'width': values['width'],
}

attributes['html'] = {
    'dir': values['dir'],
    'lang': values['lang'],
    'version': values['version'],
}

attributes['i'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['iframe'] = {
    'align': values['align~i'],
    'class': values['class'],
    'frameborder': values['frameborder'],
    'height': values['height'],
    'id': values['id'],
    'longdesc': values['longdesc'],
    'marginheight': values['marginheight'],
    'marginwidth': values['marginwidth'],
    'name': values['name'],
    'scrolling': values['scrolling'],
    'src': values['src~f'],
    'style': values['style'],
    'title': values['title'],
    'width': values['width'],
}

attributes['img'] = {
    'align': values['align~i'],
    'alt': values['alt~i'],
    'border': values['border'],
    'class': values['class'],
    'dir': values['dir'],
    'height': values['height'],
    'hspace': values['hspace'],
    'id': values['id'],
    'ismap': values['ismap'],
    'lang': values['lang'],
    'longdesc': values['longdesc'],
    'name': values['name'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'src': values['src~r'],
    'style': values['style'],
    'title': values['title'],
    'usemap': values['usemap'],
    'vspace': values['vspace'],
    'width': values['width'],
}

attributes['input'] = {
    'accept': values['accept'],
    'accesskey': values['accesskey'],
    'align': values['align~i'],
    'alt': values['alt'],
    'checked': values['checked'],
    'class': values['class'],
    'dir': values['dir'],
    'disabled': values['disabled'],
    'id': values['id'],
    'ismap': values['ismap'],
    'lang': values['lang'],
    'maxlength': values['maxlength'],
    'name': values['name'],
    'onblur': values['onblur'],
    'onchange': values['onchange'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onfocus': values['onfocus'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'onselect': values['onselect'],
    'readonly': values['readonly'],
    'size': values['size'],
    'src': values['src~i'],
    'style': values['style'],
    'tabindex': values['tabindex'],
    'title': values['title'],
    'type': values['type~i'],
    'usemap': values['usemap'],
    'value': values['value'],
}

attributes['ins'] = {
    'cite': values['cite'],
    'class': values['class'],
    'datetime': values['datetime'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['isindex'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'prompt': values['prompt'],
    'style': values['style'],
    'title': values['title'],
}

attributes['kbd'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['label'] = {
    'accesskey': values['accesskey'],
    'class': values['class'],
    'dir': values['dir'],
    'for': values['for'],
    'id': values['id'],
    'lang': values['lang'],
    'onblur': values['onblur'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onfocus': values['onfocus'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['legend'] = {
    'accesskey': values['accesskey'],
    'align': values['align~l'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['li'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
    'type': values['type~l'],
    'value': values['value~l'],
}

attributes['link'] = {
    'charset': values['charset'],
    'class': values['class'],
    'dir': values['dir'],
    'href': values['href'],
    'hreflang': values['hreflang'],
    'id': values['id'],
    'lang': values['lang'],
    'media': values['media'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'rel': values['rel'],
    'rev': values['rev'],
    'style': values['style'],
    'target': values['target'],
    'title': values['title'],
    'type': values['type'],
}

attributes['map'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'name': values['name~r'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['menu'] = {
    'class': values['class'],
    'compact': values['compact'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['meta'] = {
    'content': values['content'],
    'dir': values['dir'],
    'http-equiv': values['http-equiv'],
    'lang': values['lang'],
    'name': values['name'],
    'scheme': values['scheme'],
}

attributes['noframes'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['noscript'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['object'] = {
    'align': values['align~i'],
    'archive': values['archive'],
    'border': values['border'],
    'class': values['class'],
    'classid': values['classid'],
    'codebase': values['codebase'],
    'codetype': values['codetype'],
    'data': values['data'],
    'declare': values['declare'],
    'dir': values['dir'],
    'height': values['height'],
    'hspace': values['hspace'],
    'id': values['id'],
    'lang': values['lang'],
    'name': values['name'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'standby': values['standby'],
    'style': values['style'],
    'tabindex': values['tabindex'],
    'title': values['title'],
    'type': values['type'],
    'usemap': values['usemap'],
    'vspace': values['vspace'],
    'width': values['width'],
}

attributes['ol'] = {
    'class': values['class'],
    'compact': values['compact'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'start': values['start'],
    'style': values['style'],
    'title': values['title'],
    'type': values['type~o'],
}

attributes['optgroup'] = {
    'class': values['class'],
    'dir': values['dir'],
    'disabled': values['disabled'],
    'id': values['id'],
    'label': values['label~r'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['option'] = {
    'class': values['class'],
    'dir': values['dir'],
    'disabled': values['disabled'],
    'id': values['id'],
    'label': values['label'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'selected': values['selected'],
    'style': values['style'],
    'title': values['title'],
    'value': values['value'],
}

attributes['p'] = {
    'align': values['align~d'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['param'] = {
    'id': values['id'],
    'name': values['name~r'],
    'type': values['type'],
    'value': values['value'],
    'valuetype': values['valuetype'],
}

attributes['pre'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
    'width': values['width~p'],
}

attributes['q'] = {
    'cite': values['cite'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['s'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['samp'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['script'] = {
    'charset': values['charset'],
    'defer': values['defer'],
    'language': values['language'],
    'src': values['src'],
    'type': values['type~r'],
}

attributes['select'] = {
    'class': values['class'],
    'dir': values['dir'],
    'disabled': values['disabled'],
    'id': values['id'],
    'lang': values['lang'],
    'multiple': values['multiple'],
    'name': values['name'],
    'onblur': values['onblur'],
    'onchange': values['onchange'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onfocus': values['onfocus'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'size': values['size'],
    'style': values['style'],
    'tabindex': values['tabindex'],
    'title': values['title'],
}

attributes['small'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['span'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['strike'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['strong'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['style'] = {
    'dir': values['dir'],
    'lang': values['lang'],
    'media': values['media'],
    'title': values['title'],
    'type': values['type~r'],
}

attributes['sub'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['sup'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['table'] = {
    'align': values['align~t'],
    'bgcolor': values['bgcolor'],
    'border': values['border'],
    'cellpadding': values['cellpadding'],
    'cellspacing': values['cellspacing'],
    'class': values['class'],
    'dir': values['dir'],
    'frame': values['frame'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'rules': values['rules'],
    'style': values['style'],
    'summary': values['summary'],
    'title': values['title'],
    'width': values['width'],
}

attributes['tbody'] = {
    'align': values['align'],
    'char': values['char'],
    'charoff': values['charoff'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
    'valign': values['valign'],
}

attributes['td'] = {
    'abbr': values['abbr'],
    'align': values['align'],
    'axis': values['axis'],
    'bgcolor': values['bgcolor'],
    'char': values['char'],
    'charoff': values['charoff'],
    'class': values['class'],
    'colspan': values['colspan'],
    'dir': values['dir'],
    'headers': values['headers'],
    'height': values['height'],
    'id': values['id'],
    'lang': values['lang'],
    'nowrap': values['nowrap'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'rowspan': values['rowspan'],
    'scope': values['scope'],
    'style': values['style'],
    'title': values['title'],
    'valign': values['valign'],
    'width': values['width'],
}

attributes['textarea'] = {
    'accesskey': values['accesskey'],
    'class': values['class'],
    'cols': values['cols'],
    'dir': values['dir'],
    'disabled': values['disabled'],
    'id': values['id'],
    'lang': values['lang'],
    'name': values['name'],
    'onblur': values['onblur'],
    'onchange': values['onchange'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onfocus': values['onfocus'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'onselect': values['onselect'],
    'readonly': values['readonly'],
    'rows': values['rows'],
    'style': values['style'],
    'tabindex': values['tabindex'],
    'title': values['title'],
}

attributes['tfoot'] = {
    'align': values['align'],
    'char': values['char'],
    'charoff': values['charoff'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
    'valign': values['valign'],
}

attributes['th'] = {
    'abbr': values['abbr'],
    'align': values['align'],
    'axis': values['axis'],
    'bgcolor': values['bgcolor'],
    'char': values['char'],
    'charoff': values['charoff'],
    'class': values['class'],
    'colspan': values['colspan'],
    'dir': values['dir'],
    'headers': values['headers'],
    'height': values['height'],
    'id': values['id'],
    'lang': values['lang'],
    'nowrap': values['nowrap'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'rowspan': values['rowspan'],
    'scope': values['scope'],
    'style': values['style'],
    'title': values['title'],
    'valign': values['valign'],
    'width': values['width'],
}

attributes['thead'] = {
    'align': values['align'],
    'char': values['char'],
    'charoff': values['charoff'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
    'valign': values['valign'],
}

attributes['title'] = {
    'dir': values['dir'],
    'lang': values['lang'],
}

attributes['tr'] = {
    'align': values['align'],
    'bgcolor': values['bgcolor'],
    'char': values['char'],
    'charoff': values['charoff'],
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
    'valign': values['valign'],
}

attributes['tt'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['u'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['ul'] = {
    'class': values['class'],
    'compact': values['compact'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
    'type': values['type~u'],
}

attributes['var'] = {
    'class': values['class'],
    'dir': values['dir'],
    'id': values['id'],
    'lang': values['lang'],
    'onclick': values['onclick'],
    'ondblclick': values['ondblclick'],
    'onkeydown': values['onkeydown'],
    'onkeypress': values['onkeypress'],
    'onkeyup': values['onkeyup'],
    'onmousedown': values['onmousedown'],
    'onmousemove': values['onmousemove'],
    'onmouseout': values['onmouseout'],
    'onmouseover': values['onmouseover'],
    'onmouseup': values['onmouseup'],
    'style': values['style'],
    'title': values['title'],
}

attributes['noindex'] = {}
# This not w3c tag, but it is used by Yandex search engine
