# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Dataset(Model):
    """The Azure Data Factory nested object which identifies data within different
    data stores, such as tables, files, folders, and documents.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: VerticaTableDataset, NetezzaTableDataset,
    ZohoObjectDataset, XeroObjectDataset, SquareObjectDataset,
    SparkObjectDataset, ShopifyObjectDataset, ServiceNowObjectDataset,
    QuickBooksObjectDataset, PrestoObjectDataset, PhoenixObjectDataset,
    PaypalObjectDataset, MarketoObjectDataset, MariaDBTableDataset,
    MagentoObjectDataset, JiraObjectDataset, ImpalaObjectDataset,
    HubspotObjectDataset, HiveObjectDataset, HBaseObjectDataset,
    GreenplumTableDataset, GoogleBigQueryObjectDataset, EloquaObjectDataset,
    DrillTableDataset, CouchbaseTableDataset, ConcurObjectDataset,
    AzurePostgreSqlTableDataset, AmazonMWSObjectDataset, HttpDataset,
    AzureSearchIndexDataset, WebTableDataset, SqlServerTableDataset,
    SapEccResourceDataset, SapCloudForCustomerResourceDataset,
    SalesforceObjectDataset, RelationalTableDataset, AzureMySqlTableDataset,
    OracleTableDataset, ODataResourceDataset, MongoDbCollectionDataset,
    FileShareDataset, AzureDataLakeStoreDataset, DynamicsEntityDataset,
    DocumentDbCollectionDataset, CustomDataset, CassandraTableDataset,
    AzureSqlDWTableDataset, AzureSqlTableDataset, AzureTableDataset,
    AzureBlobDataset, AmazonS3Dataset

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param description: Dataset description.
    :type description: str
    :param structure: Columns that define the structure of the dataset. Type:
     array (or Expression with resultType array), itemType: DatasetDataElement.
    :type structure: object
    :param linked_service_name: Linked service reference.
    :type linked_service_name:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param parameters: Parameters for dataset.
    :type parameters: dict[str,
     ~azure.mgmt.datafactory.models.ParameterSpecification]
    :param type: Constant filled by server.
    :type type: str
    """

    _validation = {
        'linked_service_name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'structure': {'key': 'structure', 'type': 'object'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'parameters': {'key': 'parameters', 'type': '{ParameterSpecification}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'VerticaTable': 'VerticaTableDataset', 'NetezzaTable': 'NetezzaTableDataset', 'ZohoObject': 'ZohoObjectDataset', 'XeroObject': 'XeroObjectDataset', 'SquareObject': 'SquareObjectDataset', 'SparkObject': 'SparkObjectDataset', 'ShopifyObject': 'ShopifyObjectDataset', 'ServiceNowObject': 'ServiceNowObjectDataset', 'QuickBooksObject': 'QuickBooksObjectDataset', 'PrestoObject': 'PrestoObjectDataset', 'PhoenixObject': 'PhoenixObjectDataset', 'PaypalObject': 'PaypalObjectDataset', 'MarketoObject': 'MarketoObjectDataset', 'MariaDBTable': 'MariaDBTableDataset', 'MagentoObject': 'MagentoObjectDataset', 'JiraObject': 'JiraObjectDataset', 'ImpalaObject': 'ImpalaObjectDataset', 'HubspotObject': 'HubspotObjectDataset', 'HiveObject': 'HiveObjectDataset', 'HBaseObject': 'HBaseObjectDataset', 'GreenplumTable': 'GreenplumTableDataset', 'GoogleBigQueryObject': 'GoogleBigQueryObjectDataset', 'EloquaObject': 'EloquaObjectDataset', 'DrillTable': 'DrillTableDataset', 'CouchbaseTable': 'CouchbaseTableDataset', 'ConcurObject': 'ConcurObjectDataset', 'AzurePostgreSqlTable': 'AzurePostgreSqlTableDataset', 'AmazonMWSObject': 'AmazonMWSObjectDataset', 'HttpFile': 'HttpDataset', 'AzureSearchIndex': 'AzureSearchIndexDataset', 'WebTable': 'WebTableDataset', 'SqlServerTable': 'SqlServerTableDataset', 'SapEccResource': 'SapEccResourceDataset', 'SapCloudForCustomerResource': 'SapCloudForCustomerResourceDataset', 'SalesforceObject': 'SalesforceObjectDataset', 'RelationalTable': 'RelationalTableDataset', 'AzureMySqlTable': 'AzureMySqlTableDataset', 'OracleTable': 'OracleTableDataset', 'ODataResource': 'ODataResourceDataset', 'MongoDbCollection': 'MongoDbCollectionDataset', 'FileShare': 'FileShareDataset', 'AzureDataLakeStoreFile': 'AzureDataLakeStoreDataset', 'DynamicsEntity': 'DynamicsEntityDataset', 'DocumentDbCollection': 'DocumentDbCollectionDataset', 'CustomDataset': 'CustomDataset', 'CassandraTable': 'CassandraTableDataset', 'AzureSqlDWTable': 'AzureSqlDWTableDataset', 'AzureSqlTable': 'AzureSqlTableDataset', 'AzureTable': 'AzureTableDataset', 'AzureBlob': 'AzureBlobDataset', 'AmazonS3Object': 'AmazonS3Dataset'}
    }

    def __init__(self, linked_service_name, additional_properties=None, description=None, structure=None, parameters=None):
        super(Dataset, self).__init__()
        self.additional_properties = additional_properties
        self.description = description
        self.structure = structure
        self.linked_service_name = linked_service_name
        self.parameters = parameters
        self.type = None
