""" cgenerator
~~~~~~~~~~
Tests for main module.
:copyright: 2016 by Alexey Voronin.
:license: GPL, see LICENSE for more details.
"""

#!/usr/bin/env

import os
import StringIO
import tempfile
import pytest
from cgenerator import cgenerator


def test_templates_storage():
	assert cgenerator.templates_storage() == os.path.realpath(os.path.dirname(cgenerator.__file__)) + '/templates/'


def test_add_comments_to_file():
    output = StringIO.StringIO()
    cgenerator.add_comments_to_file(output, "FILE_NAME")
    content = output.getvalue()
    assert content.find('//Generated by:') != -1
    assert content.find('//File: FILE_NAME\n\n') != -1


def test_generate_file():
    entity_name     = "struct Entity"
    tempFile         = tempfile.gettempdir() + "some.c"
    replacements    = cgenerator.get_replacements(entity_name, True)
    cgenerator.generate_file(cgenerator.templates_storage() + 'clist.c.tmp', tempFile, replacements)
    print tempFile
    with open(tempFile, 'r') as infile:
        content = infile.read()
    assert content.find('Entity') != -1
    assert content.find('struct clist_Entity*') != -1
    assert content.find('clist_Entity_') != -1
    assert content.find('#include "clist_Entity.h"') != -1
    assert content.find('#include "entity_Entity.h"') != -1


def test_get_replacements():
    replacements = cgenerator.get_replacements("struct car",  False)
    assert replacements['<%name%>'] == "struct car"
    assert replacements['<%name_upper%>'] == "CAR"
    assert replacements['<%name_prefix%>'] == "car"
    assert replacements['<%simple%>'] == ""
    assert replacements['<%custom%>'] == "//"
    replacements = cgenerator.get_replacements("unsigned char",  True)
    assert replacements['<%name%>'] == "unsigned char"
    assert replacements['<%name_upper%>'] == "UNSIGNED_CHAR"
    assert replacements['<%name_prefix%>'] == "unsigned_char"
    assert replacements['<%simple%>'] == "//"
    assert replacements['<%custom%>'] == ""

def test_generate():
    assert True

