""" cgenerator
~~~~~~~~~~
The module implements container generation.
:copyright: 2016 by Alexey Voronin.
:license: GPL, see LICENSE for more details.
"""

#!/usr/bin/env

import sys
import time
import os


def templates_storage():
    return os.path.realpath(os.path.dirname(__file__)) + '/templates/'


def add_comments_to_file(out_file, file_name):
    out_file.write('//Generated by: ' + time.strftime("%c") + '\n')
    out_file.write('//File: ' + file_name + '\n\n')


def generate_file(input_file_path, out_file_path, replacements):
    with open(input_file_path) as infile, open(out_file_path, 'w') as outfile:
        add_comments_to_file(outfile, os.path.basename(out_file_path))
        for line in infile:
            for src, target in replacements.iteritems():
                line = line.replace(src, target)
            outfile.write(line)


def generate(entity_name, output_dir, custom, types):
    replacements = get_replacements(entity_name, custom)
    if output_dir[-1] != '/' or output_dir[-1] != '\\':
        output_dir += '/'
    types_list = types.split(',')
    short_name = entity_name.replace("struct ", "").replace(" ", "_")
    for type_item in types_list:
        if type_item == "list":
            generate_file(templates_storage() + 'clist.c.tmp',
                          output_dir + 'clist_' + short_name + '.c', replacements)
            generate_file(templates_storage() + 'clist.h.tmp',
                          output_dir + 'clist_' + short_name + '.h', replacements)
        elif type_item == "vector":
            generate_file(templates_storage() + 'cvector.c.tmp',
                          output_dir + 'cvector_' + short_name + '.c', replacements)
            generate_file(templates_storage() + 'cvector.h.tmp',
                          output_dir + 'cvector_' + short_name + '.h', replacements)
        else:
            print "Unkrow type: " + type_item
            sys.exit(-1)
    generate_file(templates_storage() + 'ctypes.h.tmp', output_dir + 'ctypes.h')
    generate_file(templates_storage() + 'entity.h.tmp',
                  output_dir + 'entity_' + short_name + '.h', replacements)
    generate_file(templates_storage() + 'entity.c.tmp',
                  output_dir + 'entity_' + short_name + '.c', replacements)


def get_replacements(entity_name, custom=False):
    replacements = {'':''}
    replacements['<%name%>'] = entity_name
    replacements['<%name_upper%>'] = entity_name.replace(
        "struct ", "").replace(
        "union ", "").upper().replace(" ", "_")
    replacements['<%name_prefix%>'] = entity_name.replace(
        "struct ", "").replace(
        "union ", "").replace(" ", "_")
    if custom == False:
        replacements['<%simple%>'] = ''
        replacements['<%custom%>'] = '//'
    else:
        replacements['<%simple%>'] = '//'
        replacements['<%custom%>'] = ''
    return replacements


def main():
    if len(sys.argv) == 5:
        generate(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])
        print "Done."
    else:
        app_name = os.path.basename(sys.argv[0]).replace("-script", "")
        print app_name + " <type name> <output folder> <is custom> <containers>"
        print "Example 1: " + app_name + " uint ../src/ False list,vector"
        print "Example 2: " + app_name + " 'struct matrix' ./source/ True vector"


if __name__ == "__main__":
    main()
