/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.lang.reflect.Method;
import java.util.EventListener;
import org.sikuli.basics.Debug;
import org.sikuli.script.ObserveEvent;
import org.sikuli.util.JythonHelper;

public class ObserverCallBack
implements EventListener {
    Object callback = null;
    ObserveEvent.Type obsType = ObserveEvent.Type.GENERIC;
    Object scriptRunner = null;
    String scriptRunnerType = null;
    Method doSomethingSpecial = null;

    public ObserverCallBack(Object callback, ObserveEvent.Type obsType) {
        this.callback = callback;
        this.obsType = obsType;
        if (callback.getClass().getName().contains("org.python")) {
            this.scriptRunnerType = "jython";
            this.scriptRunner = JythonHelper.get();
        } else {
            try {
                if (callback.getClass().getName().contains("org.jruby")) {
                    this.scriptRunnerType = "jruby";
                }
                if (this.scriptRunnerType != null) {
                    Class<?> Scripting = Class.forName("org.sikuli.scriptrunner.ScriptingSupport");
                    Method getRunner = Scripting.getMethod("getRunner", String.class, String.class);
                    this.scriptRunner = getRunner.invoke(Scripting, null, this.scriptRunnerType);
                    if (this.scriptRunner != null) {
                        this.doSomethingSpecial = this.scriptRunner.getClass().getMethod("doSomethingSpecial", String.class, Object[].class);
                    }
                } else {
                    Debug.error("ObserverCallBack: no valid callback: %s", callback);
                }
            }
            catch (Exception ex) {
                Debug.error("ObserverCallBack: %s init: ScriptRunner not available for %s", new Object[]{obsType, this.scriptRunnerType});
                this.scriptRunner = null;
            }
        }
    }

    public void appeared(ObserveEvent e) {
        if (this.scriptRunner != null && ObserveEvent.Type.APPEAR.equals((Object)this.obsType)) {
            this.run(e);
        }
    }

    public void vanished(ObserveEvent e) {
        if (this.scriptRunner != null && ObserveEvent.Type.VANISH.equals((Object)this.obsType)) {
            this.run(e);
        }
    }

    public void changed(ObserveEvent e) {
        if (this.scriptRunner != null && ObserveEvent.Type.CHANGE.equals((Object)this.obsType)) {
            this.run(e);
        }
    }

    public void happened(ObserveEvent e) {
        if (this.scriptRunner != null && ObserveEvent.Type.GENERIC.equals((Object)this.obsType)) {
            this.run(e);
        }
    }

    private void run(ObserveEvent e) {
        boolean success = true;
        Object[] args = new Object[]{this.callback, e};
        if (this.scriptRunnerType == "jython") {
            success = ((JythonHelper)this.scriptRunner).runObserveCallback(args);
        } else {
            String msg = "IScriptRunner: doSomethingSpecial returned false";
            try {
                if (this.scriptRunner != null) {
                    success = (Boolean)this.doSomethingSpecial.invoke(this.scriptRunner, "runObserveCallback", args);
                }
            }
            catch (Exception ex) {
                success = false;
                msg = ex.getMessage();
            }
            if (!success) {
                Debug.error("ObserverCallBack: problem with scripting handler: %s\n%s\n%s", this.scriptRunner, this.callback, msg);
            }
        }
    }

    public ObserverCallBack() {
    }
}

