/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.sikuli.basics.Debug;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Mouse;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;
import org.sikuli.script.Screen;

public class Location
implements Comparable<Location> {
    static RunTime runTime = RunTime.get();
    public int x;
    public int y;
    private IScreen otherScreen = null;

    public Location(double x, double y) {
        this.x = (int)x;
        this.y = (int)y;
    }

    public Location(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Location(Location loc) {
        this.x = loc.x;
        this.y = loc.y;
        if (loc.isOtherScreen()) {
            this.otherScreen = loc.getScreen();
        }
    }

    public Location(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public Location setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Location setLocation(double x, double y) {
        this.x = (int)x;
        this.y = (int)y;
        return this;
    }

    public IScreen getScreen() {
        if (this.otherScreen != null) {
            return this.otherScreen;
        }
        for (int i = 0; i < Screen.getNumberScreens(); ++i) {
            Rectangle r = Screen.getScreen(i).getBounds();
            if (!r.contains(this.x, this.y)) continue;
            return Screen.getScreen(i);
        }
        Debug.error("Location: outside any screen (%s, %s) - subsequent actions might not work as expected", this.x, this.y);
        return null;
    }

    public boolean isOtherScreen() {
        return this.otherScreen != null;
    }

    public Location setOtherScreen(IScreen scr) {
        this.otherScreen = scr;
        return this;
    }

    private Location setOtherScreen(Location loc) {
        if (loc.isOtherScreen()) {
            this.setOtherScreen(loc.getScreen());
        }
        return this;
    }

    public Color getColor() {
        if (this.getScreen() == null) {
            return null;
        }
        return this.getScreen().getRobot().getColorAt(this.x, this.y);
    }

    public Location getOffset(Location loc) {
        return new Location(loc.x - this.x, loc.y - this.y);
    }

    public Region grow(int w, int h) {
        return Region.grow(this, w, h);
    }

    public Region grow(int wh) {
        return this.grow(wh, wh);
    }

    public Region grow(int CREATE_X_DIRECTION, int CREATE_Y_DIRECTION, int w, int h) {
        return Region.create(this, CREATE_X_DIRECTION, CREATE_Y_DIRECTION, w, h);
    }

    @Deprecated
    public Location moveFor(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public Location translate(int dx, int dy) {
        return this.moveFor(dx, dy);
    }

    @Deprecated
    public Location moveTo(int X, int Y) {
        this.x = X;
        this.y = Y;
        return this;
    }

    public Location move(int X, int Y) {
        return this.moveTo(X, Y);
    }

    public Location offset(int dx, int dy) {
        return new Location(this.x + dx, this.y + dy);
    }

    public Location offset(Location loc) {
        return new Location(this.x + loc.x, this.y + loc.y);
    }

    public Location left(int dx) {
        return new Location(this.x - dx, this.y).setOtherScreen(this);
    }

    public Location right(int dx) {
        return new Location(this.x + dx, this.y).setOtherScreen(this);
    }

    public Location above(int dy) {
        return new Location(this.x, this.y - dy).setOtherScreen(this);
    }

    public Location below(int dy) {
        return new Location(this.x, this.y + dy).setOtherScreen(this);
    }

    public Location copyTo(int scrID) {
        return this.copyTo(Screen.getScreen(scrID));
    }

    public Location copyTo(IScreen screen) {
        IScreen s = this.getScreen();
        s = s == null ? Screen.getPrimaryScreen() : s;
        Location o = new Location(s.getBounds().getLocation());
        Location n = new Location(screen.getBounds().getLocation());
        return new Location(n.x + this.x - o.x, n.y + this.y - o.y);
    }

    public Location hover() {
        Mouse.move(this);
        return this;
    }

    public Location click() {
        Mouse.click(this, "L", new Integer[0]);
        return this;
    }

    public Location doubleClick() {
        Mouse.click(this, "LD", new Integer[0]);
        return this;
    }

    public Location rightClick() {
        Mouse.click(this, "R", new Integer[0]);
        return this;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof Location)) {
            return false;
        }
        Location that = (Location)oThat;
        return this.x == that.x && this.y == that.y;
    }

    @Override
    public int compareTo(Location loc) {
        if (this.equals(loc)) {
            return 0;
        }
        if (loc.x > this.x) {
            return 1;
        }
        if (loc.x == this.x && loc.y > this.y) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        IScreen s = this.getScreen();
        if (s instanceof Screen) {
            return "L(" + this.x + "," + this.y + ")" + "@" + ((Screen)s).toStringShort();
        }
        return "L(" + this.x + "," + this.y + ")" + (s == null ? "" : "@" + s.toString());
    }

    public String toStringShort() {
        return "L(" + this.x + "," + this.y + ")";
    }

    public String toJSON() {
        return String.format("[\"L\", %d, %d]", this.x, this.y);
    }

    protected IRobot getRobotForPoint(String action) {
        if (this.getScreen() == null) {
            Debug.error("Point %s outside any screen not useable for %s", this, action);
            return null;
        }
        if (!this.getScreen().isOtherScreen()) {
            this.getScreen().showTarget(this);
        }
        return Screen.getMouseRobot();
    }
}

