/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.Image;
import org.sikuli.script.RunTime;

public class ImagePath {
    static RunTime runTime = RunTime.get();
    private static final String me = "ImagePath: ";
    private static final int lvl = 3;
    private static final List<PathEntry> imagePaths = Collections.synchronizedList(new ArrayList());
    private static PathEntry bundlePath = null;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public static List<PathEntry> getPaths() {
        return imagePaths;
    }

    private static int getCount() {
        int count = imagePaths.size();
        for (PathEntry path : imagePaths) {
            if (path != null) continue;
            --count;
        }
        return count;
    }

    public static String[] get() {
        int i = 0;
        for (PathEntry p : imagePaths) {
            if (p == null) continue;
            ++i;
        }
        String[] paths = new String[i];
        i = 0;
        for (PathEntry p : imagePaths) {
            if (p == null) continue;
            paths[i++] = p.getPath();
        }
        return paths;
    }

    public static void dump(int lvl) {
        ImagePath.log(lvl, "ImagePath has %d entries (valid %d)", imagePaths.size(), ImagePath.getCount());
        String bundle = "(taken as bundle path)";
        for (PathEntry p : imagePaths) {
            if (p == null) {
                ImagePath.log(lvl, "Path: NULL %s", bundle);
            } else {
                ImagePath.log(lvl, "Path: given: %s\nis: %s", p.path, p.getPath());
            }
            bundle = "";
        }
    }

    private static boolean bundleEquals(Object path) {
        if (bundlePath != null) {
            return bundlePath.equals(path);
        }
        return false;
    }

    public static boolean isImageBundled(URL fURL) {
        if ("file".equals(fURL.getProtocol())) {
            return ImagePath.bundleEquals(new File(fURL.getPath()).getParent());
        }
        return false;
    }

    public static URL find(String fname) {
        URL fURL = null;
        String proto = "";
        if (new File(fname = FileManager.normalize(fname)).isAbsolute()) {
            if (new File(fname).exists()) {
                fURL = FileManager.makeURL(fname);
            } else {
                ImagePath.log(-1, "find: File does not exist: " + fname, new Object[0]);
            }
            return fURL;
        }
        if (bundlePath == null) {
            ImagePath.setBundlePath(null);
        }
        for (PathEntry path : ImagePath.getPaths()) {
            if (path == null) continue;
            proto = path.pathURL.getProtocol();
            if ("file".equals(proto)) {
                fURL = FileManager.makeURL(path.pathURL, fname);
                if (!new File(fURL.getPath()).exists()) continue;
                break;
            }
            if ("jar".equals(proto) || proto.startsWith("http")) {
                fURL = FileManager.getURLForContentFromURL(path.pathURL, fname);
                if (fURL == null) continue;
                break;
            }
            ImagePath.log(-1, "find: URL not supported: " + path.pathURL, new Object[0]);
            return fURL;
        }
        if (fURL == null) {
            ImagePath.log(-1, "find: not on image path: " + fname, new Object[0]);
            ImagePath.dump(3);
        }
        return fURL;
    }

    public static BufferedReader open(String fname) {
        ImagePath.log(3, "open: " + fname, new Object[0]);
        URL furl = ImagePath.find(fname);
        if (furl != null) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(furl.openStream()));
            }
            catch (IOException ex) {
                ImagePath.log(-1, "open: %s", ex.getMessage());
                return null;
            }
            try {
                br.mark(10);
                if (br.read() < 0) {
                    br.close();
                    return null;
                }
                br.reset();
                return br;
            }
            catch (IOException ex) {
                ImagePath.log(-1, "open: %s", ex.getMessage());
                try {
                    br.close();
                }
                catch (IOException ex1) {
                    ImagePath.log(-1, "open: %s", ex1.getMessage());
                    return null;
                }
                return null;
            }
        }
        return null;
    }

    public static boolean add(String mainPath) {
        return ImagePath.add(mainPath, null);
    }

    public static boolean addHTTP(String pathHTTP) {
        try {
            String proto = "http://";
            String protos = "https://";
            if (pathHTTP.startsWith(proto) || pathHTTP.startsWith(protos)) {
                proto = "";
            }
            pathHTTP = FileManager.slashify(pathHTTP, false);
            URL aURL = new URL(proto + pathHTTP);
            if (0 != FileManager.isUrlUseabel(new URL(aURL.toString() + "/THIS_FILE_SHOULD_RETURN_404"))) {
                return false;
            }
            PathEntry path = new PathEntry(pathHTTP, aURL);
            if (ImagePath.hasPath(path) < 0) {
                ImagePath.log(3, "add: %s", path);
                imagePaths.add(path);
            } else {
                ImagePath.log(3, "duplicate not added: %s", path);
            }
        }
        catch (Exception ex) {
            ImagePath.log(-1, "addHTTP: not possible: %s\n%s", pathHTTP, ex);
            return false;
        }
        return true;
    }

    public static boolean removeHTTP(String pathHTTP) {
        try {
            String proto = "http://";
            String protos = "https://";
            if (pathHTTP.startsWith(proto) || pathHTTP.startsWith(protos)) {
                proto = "";
            }
            pathHTTP = FileManager.slashify(pathHTTP, false);
            return ImagePath.remove(new URL(proto + pathHTTP));
        }
        catch (Exception ex) {
            ImagePath.log(-1, "removeHTTP: not possible: %s\n%s", pathHTTP, ex);
            return false;
        }
    }

    public static boolean add(String mainPath, String altPath) {
        PathEntry path = null;
        File fPath = new File(mainPath);
        if (!fPath.isAbsolute() && mainPath.contains(":")) {
            return ImagePath.addHTTP(mainPath);
        }
        path = ImagePath.makePathURL(mainPath, altPath);
        if (path != null) {
            if (ImagePath.hasPath(path) < 0) {
                ImagePath.log(3, "add: %s", path);
                imagePaths.add(path);
            } else {
                ImagePath.log(3, "duplicate not added: %s", path);
            }
            return true;
        }
        ImagePath.log(-1, "add: not valid: %s %s", mainPath, altPath == null ? "" : " / " + altPath);
        return false;
    }

    public static boolean addJar(String fpJar, String fpImage) {
        URL pathURL = null;
        if (new File(fpJar).exists()) {
            if (fpImage == null) {
                fpImage = "";
            }
            pathURL = FileManager.makeURL(fpJar + "!/" + fpImage, "jar");
            ImagePath.add(pathURL);
        }
        return true;
    }

    private static int hasPath(PathEntry path) {
        PathEntry pe = imagePaths.get(0);
        if (imagePaths.size() == 1 && pe == null) {
            return -1;
        }
        if (pe != null && pe.equals(path)) {
            return 0;
        }
        for (PathEntry p : imagePaths.subList(1, imagePaths.size())) {
            if (p == null || !p.equals(path)) continue;
            return 1;
        }
        return -1;
    }

    public static void add(URL pURL) {
        imagePaths.add(new PathEntry("__PATH_URL__", pURL));
    }

    public static boolean remove(String path) {
        File fPath = new File(path);
        if (!fPath.isAbsolute() && path.contains(":")) {
            return ImagePath.removeHTTP(path);
        }
        return ImagePath.remove(ImagePath.makePathURL((String)FileManager.normalize((String)path), null).pathURL);
    }

    private static boolean remove(URL pURL) {
        if (ImagePath.bundleEquals(pURL)) {
            Image.purge(pURL);
            bundlePath = null;
            Settings.BundlePath = null;
            imagePaths.set(0, null);
        }
        Iterator<PathEntry> it = imagePaths.subList(1, imagePaths.size()).iterator();
        PathEntry p0 = imagePaths.get(0);
        while (it.hasNext()) {
            PathEntry p = it.next();
            if (!p.equals(pURL)) continue;
            it.remove();
            Image.purge(p.pathURL);
        }
        return true;
    }

    public static boolean reset(String path) {
        if (ImagePath.bundleEquals(path)) {
            return true;
        }
        ImagePath.reset();
        return ImagePath.setBundlePath(path);
    }

    public static boolean reset() {
        ImagePath.log(3, "reset", new Object[0]);
        if (imagePaths.isEmpty()) {
            return false;
        }
        for (PathEntry p : imagePaths) {
            if (p == null) continue;
            Image.purge(p.pathURL);
        }
        PathEntry bp = imagePaths.get(0);
        imagePaths.clear();
        imagePaths.add(bp);
        return true;
    }

    public static boolean setBundlePath(String bPath) {
        PathEntry path = null;
        path = bPath == null ? ImagePath.makePathURL(FileManager.normalizeAbsolute(Settings.BundlePath, false), null) : ImagePath.makePathURL(FileManager.normalizeAbsolute(bPath, false), null);
        if (path != null && path.isFile()) {
            if (ImagePath.bundleEquals(path)) {
                return true;
            }
            Image.purge(bundlePath);
            if (path.exists()) {
                imagePaths.set(0, path);
                Settings.BundlePath = path.getPath();
                bundlePath = path;
                ImagePath.log(3, "new BundlePath:\n%s", path);
                return true;
            }
        }
        if (ImagePath.getCount() == 0) {
            String wf = System.getProperty("user.dir");
            ImagePath.log(-1, "setBundlePath: invalid BundlePath: %s \nusing working folder: %s", bPath, wf);
            if (!new File(wf).exists()) {
                ImagePath.log(-1, "setBundlePath: Fatal error: working folder does not exist --- terminating", new Object[0]);
                System.exit(1);
            }
            return ImagePath.setBundlePath(wf);
        }
        return true;
    }

    public static String getBundlePath() {
        if (bundlePath == null) {
            ImagePath.setBundlePath(null);
        }
        return new File(FileManager.slashify(bundlePath.getPath(), false)).getAbsolutePath();
    }

    public static String getBundlePathSet() {
        if (bundlePath == null) {
            return null;
        }
        return new File(FileManager.slashify(bundlePath.getPath(), false)).getAbsolutePath();
    }

    public static String getBundleFolder() {
        if (bundlePath == null) {
            ImagePath.setBundlePath(null);
        }
        return new File(FileManager.slashify(bundlePath.getPath(), true)).getAbsolutePath();
    }

    private static PathEntry makePathURL(String fpMainPath, String fpAltPath) {
        if (fpMainPath == null || fpMainPath.isEmpty()) {
            return null;
        }
        URL pathURL = null;
        File fPath = new File(FileManager.normalizeAbsolute(fpMainPath, false));
        if (fPath.exists()) {
            pathURL = FileManager.makeURL(fPath.getAbsolutePath());
        } else {
            CodeSource codeSrc;
            String klassName;
            if (fpMainPath.contains("\\")) {
                return null;
            }
            Class<?> cls = null;
            String fpSubPath = "";
            int n = fpMainPath.indexOf("/");
            if (n > 0) {
                klassName = fpMainPath.substring(0, n);
                if (n < fpMainPath.length() - 2) {
                    fpSubPath = fpMainPath.substring(n + 1);
                }
            } else {
                klassName = fpMainPath;
            }
            try {
                cls = Class.forName(klassName);
            }
            catch (ClassNotFoundException ex) {
                ImagePath.log(-1, "add: class %s not found on classpath.", klassName);
            }
            if (cls != null && (codeSrc = cls.getProtectionDomain().getCodeSource()) != null && codeSrc.getLocation() != null) {
                URL jarURL = codeSrc.getLocation();
                if (ImagePath.runTime.runningWinApp || jarURL.getPath().endsWith(".jar")) {
                    pathURL = FileManager.makeURL(jarURL.toString() + "!/" + fpSubPath, "jar");
                } else {
                    if (fpAltPath == null || fpAltPath.isEmpty()) {
                        fpAltPath = jarURL.getPath();
                    }
                    if (new File(FileManager.normalizeAbsolute(fpAltPath, false), fpSubPath).exists()) {
                        File fAltPath = new File(FileManager.normalizeAbsolute(fpAltPath, false), fpSubPath);
                        pathURL = FileManager.makeURL(fAltPath.getPath());
                    }
                }
            }
        }
        if (pathURL != null) {
            return new PathEntry(fpMainPath, pathURL);
        }
        return null;
    }

    static {
        imagePaths.add(null);
    }

    public static class PathEntry {
        public URL pathURL;
        public String path;

        public PathEntry(String givenName, URL eqivalentURL) {
            this.path = FileManager.normalize(givenName);
            this.pathURL = eqivalentURL != null ? eqivalentURL : ImagePath.makePathURL((String)this.path, null).pathURL;
            ImagePath.log(4, "PathEntry: %s \nas %s", new Object[]{this.path, this.pathURL});
        }

        public String getPath() {
            if (this.pathURL == null) {
                return "-- empty --";
            }
            String uPath = this.pathURL.toExternalForm();
            if (this.isFile() && uPath.startsWith("file:")) {
                uPath = uPath.substring(5);
            }
            return uPath;
        }

        public boolean isFile() {
            if (this.pathURL == null) {
                return false;
            }
            return "file".equals(this.pathURL.getProtocol());
        }

        public boolean isJar() {
            if (this.pathURL == null) {
                return false;
            }
            return "jar".equals(this.pathURL.getProtocol());
        }

        public boolean isHTTP() {
            if (this.pathURL == null) {
                return false;
            }
            return this.pathURL.getProtocol().startsWith("http");
        }

        public boolean exists() {
            if (this.pathURL == null) {
                return false;
            }
            return new File(this.getPath()).exists();
        }

        public boolean equals(Object other) {
            if (this.pathURL == null) {
                return false;
            }
            if (!(other instanceof PathEntry)) {
                if (other instanceof URL) {
                    if (this.pathURL.equals((URL)other)) {
                        return true;
                    }
                } else if (other instanceof String) {
                    if (this.isFile()) {
                        return FileManager.pathEquals(this.pathURL.getPath(), (String)other);
                    }
                    return false;
                }
                return false;
            }
            return this.pathURL.equals(((PathEntry)other).pathURL);
        }

        public String toString() {
            return this.getPath();
        }
    }
}

