/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.sikuli.basics.Debug;
import org.sikuli.guide.Visual;
import org.sikuli.script.Region;

public class SxRectangle
extends Visual {
    public SxRectangle(Region region) {
        this.init(region);
    }

    public SxRectangle(Visual comp) {
        this.init(comp.getRegion());
    }

    public SxRectangle() {
        this.init(null);
    }

    private void init(Region region) {
        if (region != null) {
            this.targetRegion = region;
        } else {
            Debug.log(2, "SikuliGuideRectangle: targetRegion is given as null", new Object[0]);
            this.targetRegion = Region.create(0, 0, 2 * this.stroke, 2 * this.stroke);
        }
        this.setColor(Color.RED);
    }

    @Override
    public void updateComponent() {
        this.setActualBounds(this.targetRegion.getRect());
        this.setForeground(this.colorFront);
        super.setLocationRelative(Visual.Layout.OVER);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        BasicStroke pen = new BasicStroke(this.stroke);
        g2d.setStroke(pen);
        g2d.drawRect(0, 0, this.getActualWidth() - 1, this.getActualHeight() - 1);
    }
}

