/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.xmlrpc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import org.apache.ws.commons.util.Base64;
import org.apache.xmlrpc.serializer.TypeSerializerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class StringSerializer
extends TypeSerializerImpl {
    public static final String STRING_TAG = "string";
    public static final String BASE_64_TAG = "base64";
    private static Pattern pattern = Pattern.compile("[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]");

    @Override
    public void write(ContentHandler pHandler, Object pObject) throws SAXException {
        String value = pObject.toString();
        if (pattern.matcher(value).find()) {
            pHandler.startElement("", "value", "value", ZERO_ATTRIBUTES);
            pHandler.startElement("", BASE_64_TAG, BASE_64_TAG, ZERO_ATTRIBUTES);
            byte[] buffer = null;
            try {
                buffer = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
            if (buffer.length > 0) {
                char[] charBuffer = new char[buffer.length >= 1024 ? 1024 : (buffer.length + 3) / 4 * 4];
                Base64.SAXEncoder encoder = new Base64.SAXEncoder(charBuffer, 0, null, pHandler);
                try {
                    encoder.write(buffer, 0, buffer.length);
                    encoder.flush();
                }
                catch (Base64.SAXIOException e) {
                    throw e.getSAXException();
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
            pHandler.endElement("", BASE_64_TAG, BASE_64_TAG);
            pHandler.endElement("", "value", "value");
        } else {
            this.write(pHandler, null, value);
        }
    }
}

