/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.library;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.robotframework.remoteserver.library.RemoteLibrary;

public class DynamicApiRemoteLibrary
implements RemoteLibrary {
    private Object library;
    private Method getKeywordNames;
    private Method runKeyword;
    private Method getKeywordArguments;
    private Method getKeywordDocumentation;

    protected DynamicApiRemoteLibrary(Object library, Method getKeywordNames, Method runKeyword, Method getKeywordArguments, Method getKeywordDocumentation) {
        this.library = library;
        this.getKeywordNames = getKeywordNames;
        this.runKeyword = runKeyword;
        this.getKeywordArguments = getKeywordArguments;
        this.getKeywordDocumentation = getKeywordDocumentation;
    }

    @Override
    public String[] getKeywordNames() {
        try {
            Object names = this.getKeywordNames.invoke(this.library, new Object[0]);
            if (names instanceof List) {
                return (String[])((List)names).toArray();
            }
            return (String[])names;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Object runKeyword(String keyword, Object[] args, Map<String, Object> kwargs) throws Throwable {
        if (kwargs != null && !kwargs.isEmpty() && this.runKeyword.getParameterTypes().length == 2) {
            throw new RuntimeException("This library does not support keyword arguments.");
        }
        Object[] invokeArgs = new Object[this.runKeyword.getParameterTypes().length];
        invokeArgs[0] = keyword;
        Object object = invokeArgs[1] = this.runKeyword.getParameterTypes()[1].equals(List.class) ? Arrays.asList(args) : args;
        if (invokeArgs.length == 3) {
            invokeArgs[2] = kwargs;
        }
        try {
            return this.runKeyword.invoke(this.library, invokeArgs);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Override
    public String[] getKeywordArguments(String keyword) {
        if (this.getKeywordArguments == null) {
            return new String[]{"*args"};
        }
        try {
            Object args = this.getKeywordArguments.invoke(this.library, keyword);
            if (args instanceof List) {
                return (String[])((List)args).toArray();
            }
            return (String[])args;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getKeywordDocumentation(String keyword) {
        if (this.getKeywordDocumentation == null) {
            return "";
        }
        try {
            return (String)this.getKeywordDocumentation.invoke(this.library, keyword);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return this.library.getClass().getName();
    }

    @Override
    public Object getImplementation() {
        return this.library;
    }
}

