/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.javalib;

import java.lang.reflect.InvocationTargetException;
import org.robotframework.javalib.factory.KeywordFactory;
import org.robotframework.javalib.library.KeywordDocumentationRepository;
import org.robotframework.javalib.library.KeywordFactoryBasedLibrary;
import org.robotframework.remoteserver.javalib.OverloadableKeyword;
import org.robotframework.remoteserver.javalib.SimpleKeywordFactory;

public class SingleClassLibrary
extends KeywordFactoryBasedLibrary<OverloadableKeyword>
implements KeywordDocumentationRepository {
    private KeywordFactory<OverloadableKeyword> keywordFactory;
    private Object keywordBean;

    public SingleClassLibrary(Object keywordBean) {
        this.keywordBean = keywordBean;
    }

    @Override
    protected KeywordFactory<OverloadableKeyword> createKeywordFactory() {
        if (this.keywordFactory == null) {
            this.keywordFactory = new SimpleKeywordFactory(this.keywordBean);
        }
        return this.keywordFactory;
    }

    @Override
    public Object runKeyword(String keywordName, Object[] args) {
        try {
            return super.runKeyword(keywordName, args);
        }
        catch (RuntimeException e) {
            throw this.retrieveInnerException(e);
        }
    }

    @Override
    public String[] getKeywordArguments(String keywordName) {
        return this.createKeywordFactory().createKeyword(keywordName).getArguments();
    }

    @Override
    public String getKeywordDocumentation(String keywordName) {
        return "";
    }

    private RuntimeException retrieveInnerException(RuntimeException e) {
        Throwable cause = e.getCause();
        if (InvocationTargetException.class.equals(cause.getClass())) {
            Throwable original = cause.getCause();
            return new RuntimeException(original.getMessage(), original);
        }
        return e;
    }
}

