/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.remoteserver.javalib;

import java.lang.reflect.Method;
import org.robotframework.javalib.keyword.Keyword;
import org.robotframework.javalib.reflection.ArgumentConverter;
import org.robotframework.javalib.reflection.ArgumentGrouper;
import org.robotframework.javalib.reflection.IArgumentConverter;
import org.robotframework.javalib.reflection.IArgumentGrouper;

public class KeywordOverload
implements Keyword {
    private final Method method;
    private final Object obj;

    public KeywordOverload(Object obj, Method method) {
        this.obj = obj;
        this.method = method;
    }

    @Override
    public Object execute(Object[] args) {
        try {
            Object[] groupedArguments = this.createArgumentGrouper().groupArguments(args);
            Object[] convertedArguments = this.createArgumentConverter().convertArguments(groupedArguments);
            return this.method.invoke(this.obj, convertedArguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canExecute(Object[] args) {
        try {
            Object[] groupedArguments = this.createArgumentGrouper().groupArguments(args);
            Object[] convertedArguments = this.createArgumentConverter().convertArguments(groupedArguments);
            for (int i = 0; i < args.length; ++i) {
                if (convertedArguments[i] != null || args[i] == null) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected IArgumentConverter createArgumentConverter() {
        return new ArgumentConverter(this.method.getParameterTypes());
    }

    protected IArgumentGrouper createArgumentGrouper() {
        return new ArgumentGrouper(this.method.getParameterTypes());
    }
}

