/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.reflection;

import org.robotframework.javalib.reflection.IArgumentConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentConverter
implements IArgumentConverter {
    private final Class<?>[] parameterTypes;

    public ArgumentConverter(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    @Override
    public Object[] convertArguments(Object[] args) {
        if (!this.shouldConvert(args)) {
            return args;
        }
        return this.internalConvert(args);
    }

    private Object[] internalConvert(Object[] args) {
        Object[] convertedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            convertedArgs[i] = !this.isArrayArgument(args[i]) ? this.convertToType(this.parameterTypes[i], args[i]) : args[i];
        }
        return convertedArgs;
    }

    private boolean shouldConvert(Object[] args) {
        return args != null;
    }

    private boolean isArrayArgument(Object object) {
        return object.getClass().isArray();
    }

    private Object convertToType(Class<?> clazz, Object object) {
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Integer.valueOf(object.toString());
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Long.valueOf(object.toString());
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return Short.valueOf(object.toString());
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return Byte.valueOf(object.toString());
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Boolean.valueOf(object.toString());
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(object.toString());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return Double.valueOf(object.toString());
        }
        if (clazz == String.class) {
            return object.toString();
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        return null;
    }
}

