/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.iol.dlc;

import edu.unh.iol.dlc.ProtocolVersion;
import edu.unh.iol.dlc.UnrecognizedVersionException;

public class VersionParser {
    private static final int INDEX_MAJOR_FROM = 4;
    private static final int INDEX_MAJOR_TO = 7;
    private static final int INDEX_MINOR_FROM = 8;
    private static final int INDEX_MINOR_TO = 11;
    private static final int VERSION_LENGTH = 11;
    private String protocolString;

    public VersionParser(String protocolString) {
        this.protocolString = protocolString;
    }

    public ProtocolVersion parse() {
        this.verifyInputIsValid(this.protocolString);
        int majorVersion = this.parseMajorVersion();
        int minorVersion = this.parseMinorVersion();
        return this.getSupportedVersion(majorVersion, minorVersion);
    }

    private int parseMinorVersion() {
        return this.parseSubstring(8, 11);
    }

    private int parseMajorVersion() {
        return this.parseSubstring(4, 7);
    }

    private int parseSubstring(int from, int to) {
        int version;
        try {
            String subString = this.protocolString.substring(from, to);
            version = Integer.parseInt(subString);
        }
        catch (NumberFormatException e) {
            String errorMessage = "Invalid protocol version format: '%s'";
            String formattedMessage = String.format("Invalid protocol version format: '%s'", this.protocolString);
            throw new IllegalArgumentException(formattedMessage);
        }
        return version;
    }

    private void verifyInputIsValid(String protocolString) {
        this.verifyNotNull(protocolString);
        this.verifyCorrectLength(protocolString);
    }

    private void verifyCorrectLength(String protocolString) {
        int length = protocolString.length();
        if (length != 11) {
            String error = "Unexpected version length: '%d'";
            String errorMessage = String.format("Unexpected version length: '%d'", length);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void verifyNotNull(String protocolString) {
        if (protocolString == null) {
            throw new IllegalArgumentException("Protocol input is NULL.");
        }
    }

    private ProtocolVersion getSupportedVersion(int major, int minor) {
        ProtocolVersion version = this.getProtocolVersion(major, minor);
        this.verifyIsFound(version);
        return version;
    }

    private ProtocolVersion getProtocolVersion(int major, int minor) {
        ProtocolVersion[] supportedVersions;
        ProtocolVersion protocolVersion = null;
        for (ProtocolVersion supported : supportedVersions = ProtocolVersion.values()) {
            if (supported.getMajorVersion() != major || supported.getMinorVersion() != minor) continue;
            protocolVersion = supported;
            break;
        }
        return protocolVersion;
    }

    private void verifyIsFound(ProtocolVersion protocolVersion) {
        if (protocolVersion == null) {
            String error = "Unrecognized protocol version: '%s'";
            String errorMessage = String.format("Unrecognized protocol version: '%s'", this.protocolString);
            throw new UnrecognizedVersionException(errorMessage);
        }
    }
}

