/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.iol.dlc;

import edu.unh.iol.dlc.ConnectionController;
import edu.unh.iol.dlc.Framebuffer;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.sikuli.basics.AnimatorOutQuarticEase;
import org.sikuli.basics.AnimatorTimeBased;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.ScreenImage;

public class VNCRobot
implements IRobot {
    private ConnectionController con;
    private int index;
    private boolean shiftFlag = false;
    private int last_x = -1;
    private int last_y = -1;
    private int autodelay = 0;
    private boolean waitForIdle = false;
    static final int MAX_DELAY = 60000;

    public VNCRobot(GraphicsDevice gDev) throws AWTException {
        if (gDev instanceof Framebuffer) {
            this.con = ConnectionController.getActiveController(0);
            for (int i = 0; i < this.con.threads.size(); ++i) {
                if (gDev != this.con.getF(i)) continue;
                this.index = i;
            }
        } else {
            throw new AWTException("Error cannot instantiate Robot for non-remote screen");
        }
    }

    @Override
    public void keyDown(int keycode) {
        if (keycode == 16) {
            this.shiftFlag = true;
            return;
        }
        int key = this.getKeysym(keycode);
        if (key == 0xFFFFFF) {
            Debug.log(3, "Error: Key not supprted-" + keycode, new Object[0]);
        } else {
            try {
                this.con.getC(this.index).keyDown(key);
            }
            catch (IOException e) {
                Debug.log(3, "Cannot KeyDown: " + e, new Object[0]);
            }
        }
        this.tidyUp();
    }

    @Override
    public void keyUp(int keycode) {
        if (keycode == 16) {
            this.shiftFlag = false;
            return;
        }
        int key = this.getKeysym(keycode);
        if (key == 0xFFFFFF) {
            Debug.log(3, "Key not supported " + keycode, new Object[0]);
        } else {
            try {
                this.con.getC(this.index).keyUp(key);
            }
            catch (IOException e) {
                Debug.log(3, "Cannot KeyUp: " + e, new Object[0]);
            }
        }
        this.tidyUp();
    }

    @Override
    public void mouseMove(int x, int y) {
        try {
            this.con.getC(this.index).mouseEvent(0, 0, 0, 0, 0, 0, 0, 0, x, y);
        }
        catch (IOException e) {
            Debug.log(3, "Cannot generate mouse event: " + e, new Object[0]);
        }
        this.last_x = x;
        this.last_y = y;
        this.tidyUp();
    }

    @Override
    public void mouseDown(int buttons) {
        int[] b = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        switch (buttons) {
            case 16: {
                b[0] = 1;
                break;
            }
            case 8: {
                b[1] = 1;
                break;
            }
            case 4: {
                b[2] = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        try {
            this.con.getC(this.index).mouseEvent(b[0], b[1], b[2], b[3], b[4], b[5], b[6], b[7], this.last_x, this.last_y);
        }
        catch (IOException e) {
            Debug.log(3, "Cannot generate mouse event: " + e, new Object[0]);
        }
        this.tidyUp();
    }

    @Override
    public int mouseUp(int buttons) {
        try {
            this.con.getC(this.index).mouseEvent(0, 0, 0, 0, 0, 0, 0, 0, this.last_x, this.last_y);
        }
        catch (IOException e) {
            Debug.log(3, "Cannot generate mouse event: " + e, new Object[0]);
        }
        this.tidyUp();
        return 0;
    }

    @Override
    public void mouseWheel(int wheelAmt) {
        if (wheelAmt > 0) {
            for (int i = 0; i < wheelAmt; ++i) {
                try {
                    this.con.getC(this.index).mouseEvent(0, 0, 0, 0, 1, 0, 0, 0, this.last_x, this.last_y);
                    this.con.getC(this.index).mouseEvent(0, 0, 0, 0, 0, 0, 0, 0, this.last_x, this.last_y);
                    continue;
                }
                catch (IOException e) {
                    Debug.log(3, "Cannot generate mouse event: " + e, new Object[0]);
                }
            }
        } else {
            for (int j = 0; j > -wheelAmt; --j) {
                try {
                    this.con.getC(this.index).mouseEvent(0, 0, 0, 1, 0, 0, 0, 0, this.last_x, this.last_y);
                    this.con.getC(this.index).mouseEvent(0, 0, 0, 0, 0, 0, 0, 0, this.last_x, this.last_y);
                    continue;
                }
                catch (IOException e) {
                    Debug.log(3, "Cannot generate mouse event: " + e, new Object[0]);
                }
            }
        }
        this.tidyUp();
    }

    @Override
    public ScreenImage captureScreen(Rectangle screenRect) {
        return new ScreenImage(screenRect, this.con.getF(this.index).getBuffer().getSubimage(screenRect.x, screenRect.y, screenRect.width, screenRect.height));
    }

    public BufferedImage capture(Rectangle rect) {
        return this.con.getF(this.index).getBuffer().getSubimage(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void waitForIdle() {
        try {
            new Robot().waitForIdle();
        }
        catch (AWTException e) {
            Debug.log(3, "Error-could non instantiate robot: " + e, new Object[0]);
        }
    }

    @Override
    public void delay(int ms) {
        if (ms < 0) {
            ms = 0;
        }
        if (ms > 60000) {
            ms = 60000;
        }
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Debug.log(3, "Thread Interrupted: " + e, new Object[0]);
        }
    }

    @Override
    public void setAutoDelay(int ms) {
        if (ms < 0) {
            ms = 0;
        }
        if (ms > 60000) {
            ms = 60000;
        }
        this.autodelay = ms;
    }

    public void dragDrop(Location start, Location end, int steps, long ms, int buttons) {
        this.mouseMove(start.x, start.y);
        this.mouseDown(buttons);
        this.delay((int)(Settings.DelayAfterDrag * 1000.0));
        this.waitForIdle();
        this.smoothMove(start, end, ms);
        this.delay((int)(Settings.DelayBeforeDrop * 1000.0));
        this.mouseUp(buttons);
        this.waitForIdle();
    }

    protected void doType(IRobot.KeyMode mode, int ... keyCodes) {
        if (mode == IRobot.KeyMode.PRESS_ONLY) {
            for (int i = 0; i < keyCodes.length; ++i) {
                this.keyDown(keyCodes[i]);
            }
        } else if (mode == IRobot.KeyMode.RELEASE_ONLY) {
            for (int i = 0; i < keyCodes.length; ++i) {
                this.keyUp(keyCodes[i]);
            }
        } else {
            int i;
            for (i = 0; i < keyCodes.length; ++i) {
                this.keyDown(keyCodes[i]);
            }
            for (i = 0; i < keyCodes.length; ++i) {
                this.keyUp(keyCodes[i]);
            }
        }
    }

    @Override
    public void typeChar(char character, IRobot.KeyMode mode) {
        switch (character) {
            case 'a': {
                this.doType(mode, 65);
                break;
            }
            case 'b': {
                this.doType(mode, 66);
                break;
            }
            case 'c': {
                this.doType(mode, 67);
                break;
            }
            case 'd': {
                this.doType(mode, 68);
                break;
            }
            case 'e': {
                this.doType(mode, 69);
                break;
            }
            case 'f': {
                this.doType(mode, 70);
                break;
            }
            case 'g': {
                this.doType(mode, 71);
                break;
            }
            case 'h': {
                this.doType(mode, 72);
                break;
            }
            case 'i': {
                this.doType(mode, 73);
                break;
            }
            case 'j': {
                this.doType(mode, 74);
                break;
            }
            case 'k': {
                this.doType(mode, 75);
                break;
            }
            case 'l': {
                this.doType(mode, 76);
                break;
            }
            case 'm': {
                this.doType(mode, 77);
                break;
            }
            case 'n': {
                this.doType(mode, 78);
                break;
            }
            case 'o': {
                this.doType(mode, 79);
                break;
            }
            case 'p': {
                this.doType(mode, 80);
                break;
            }
            case 'q': {
                this.doType(mode, 81);
                break;
            }
            case 'r': {
                this.doType(mode, 82);
                break;
            }
            case 's': {
                this.doType(mode, 83);
                break;
            }
            case 't': {
                this.doType(mode, 84);
                break;
            }
            case 'u': {
                this.doType(mode, 85);
                break;
            }
            case 'v': {
                this.doType(mode, 86);
                break;
            }
            case 'w': {
                this.doType(mode, 87);
                break;
            }
            case 'x': {
                this.doType(mode, 88);
                break;
            }
            case 'y': {
                this.doType(mode, 89);
                break;
            }
            case 'z': {
                this.doType(mode, 90);
                break;
            }
            case 'A': {
                this.doType(mode, 16, 65);
                break;
            }
            case 'B': {
                this.doType(mode, 16, 66);
                break;
            }
            case 'C': {
                this.doType(mode, 16, 67);
                break;
            }
            case 'D': {
                this.doType(mode, 16, 68);
                break;
            }
            case 'E': {
                this.doType(mode, 16, 69);
                break;
            }
            case 'F': {
                this.doType(mode, 16, 70);
                break;
            }
            case 'G': {
                this.doType(mode, 16, 71);
                break;
            }
            case 'H': {
                this.doType(mode, 16, 72);
                break;
            }
            case 'I': {
                this.doType(mode, 16, 73);
                break;
            }
            case 'J': {
                this.doType(mode, 16, 74);
                break;
            }
            case 'K': {
                this.doType(mode, 16, 75);
                break;
            }
            case 'L': {
                this.doType(mode, 16, 76);
                break;
            }
            case 'M': {
                this.doType(mode, 16, 77);
                break;
            }
            case 'N': {
                this.doType(mode, 16, 78);
                break;
            }
            case 'O': {
                this.doType(mode, 16, 79);
                break;
            }
            case 'P': {
                this.doType(mode, 16, 80);
                break;
            }
            case 'Q': {
                this.doType(mode, 16, 81);
                break;
            }
            case 'R': {
                this.doType(mode, 16, 82);
                break;
            }
            case 'S': {
                this.doType(mode, 16, 83);
                break;
            }
            case 'T': {
                this.doType(mode, 16, 84);
                break;
            }
            case 'U': {
                this.doType(mode, 16, 85);
                break;
            }
            case 'V': {
                this.doType(mode, 16, 86);
                break;
            }
            case 'W': {
                this.doType(mode, 16, 87);
                break;
            }
            case 'X': {
                this.doType(mode, 16, 88);
                break;
            }
            case 'Y': {
                this.doType(mode, 16, 89);
                break;
            }
            case 'Z': {
                this.doType(mode, 16, 90);
                break;
            }
            case '`': {
                this.doType(mode, 192);
                break;
            }
            case '0': {
                this.doType(mode, 48);
                break;
            }
            case '1': {
                this.doType(mode, 49);
                break;
            }
            case '2': {
                this.doType(mode, 50);
                break;
            }
            case '3': {
                this.doType(mode, 51);
                break;
            }
            case '4': {
                this.doType(mode, 52);
                break;
            }
            case '5': {
                this.doType(mode, 53);
                break;
            }
            case '6': {
                this.doType(mode, 54);
                break;
            }
            case '7': {
                this.doType(mode, 55);
                break;
            }
            case '8': {
                this.doType(mode, 56);
                break;
            }
            case '9': {
                this.doType(mode, 57);
                break;
            }
            case '-': {
                this.doType(mode, 45);
                break;
            }
            case '=': {
                this.doType(mode, 61);
                break;
            }
            case '~': {
                this.doType(mode, 16, 192);
                break;
            }
            case '!': {
                this.doType(mode, 16, 49);
                break;
            }
            case '@': {
                this.doType(mode, 16, 50);
                break;
            }
            case '#': {
                this.doType(mode, 16, 51);
                break;
            }
            case '$': {
                this.doType(mode, 16, 52);
                break;
            }
            case '%': {
                this.doType(mode, 16, 53);
                break;
            }
            case '^': {
                this.doType(mode, 16, 54);
                break;
            }
            case '&': {
                this.doType(mode, 16, 55);
                break;
            }
            case '*': {
                this.doType(mode, 16, 56);
                break;
            }
            case '(': {
                this.doType(mode, 16, 57);
                break;
            }
            case ')': {
                this.doType(mode, 16, 48);
                break;
            }
            case '_': {
                this.doType(mode, 16, 45);
                break;
            }
            case '+': {
                this.doType(mode, 16, 61);
                break;
            }
            case '\b': {
                this.doType(mode, 8);
                break;
            }
            case '\t': {
                this.doType(mode, 9);
                break;
            }
            case '\r': {
                this.doType(mode, 10);
                break;
            }
            case '\n': {
                this.doType(mode, 10);
                break;
            }
            case '[': {
                this.doType(mode, 91);
                break;
            }
            case ']': {
                this.doType(mode, 93);
                break;
            }
            case '\\': {
                this.doType(mode, 92);
                break;
            }
            case '{': {
                this.doType(mode, 16, 91);
                break;
            }
            case '}': {
                this.doType(mode, 16, 93);
                break;
            }
            case '|': {
                this.doType(mode, 16, 92);
                break;
            }
            case ';': {
                this.doType(mode, 59);
                break;
            }
            case ':': {
                this.doType(mode, 16, 59);
                break;
            }
            case '\'': {
                this.doType(mode, 222);
                break;
            }
            case '\"': {
                this.doType(mode, 16, 222);
                break;
            }
            case ',': {
                this.doType(mode, 44);
                break;
            }
            case '<': {
                this.doType(mode, 16, 44);
                break;
            }
            case '.': {
                this.doType(mode, 46);
                break;
            }
            case '>': {
                this.doType(mode, 16, 46);
                break;
            }
            case '/': {
                this.doType(mode, 47);
                break;
            }
            case '?': {
                this.doType(mode, 16, 47);
                break;
            }
            case ' ': {
                this.doType(mode, 32);
                break;
            }
            case '\u001b': {
                this.doType(mode, 27);
                break;
            }
            case '\ue000': {
                this.doType(mode, 38);
                break;
            }
            case '\ue001': {
                this.doType(mode, 39);
                break;
            }
            case '\ue002': {
                this.doType(mode, 40);
                break;
            }
            case '\ue003': {
                this.doType(mode, 37);
                break;
            }
            case '\ue004': {
                this.doType(mode, 33);
                break;
            }
            case '\ue005': {
                this.doType(mode, 34);
                break;
            }
            case '\ue006': {
                this.doType(mode, 127);
                break;
            }
            case '\ue007': {
                this.doType(mode, 35);
                break;
            }
            case '\ue008': {
                this.doType(mode, 36);
                break;
            }
            case '\ue009': {
                this.doType(mode, 155);
                break;
            }
            case '\ue011': {
                this.doType(mode, 112);
                break;
            }
            case '\ue012': {
                this.doType(mode, 113);
                break;
            }
            case '\ue013': {
                this.doType(mode, 114);
                break;
            }
            case '\ue014': {
                this.doType(mode, 115);
                break;
            }
            case '\ue015': {
                this.doType(mode, 116);
                break;
            }
            case '\ue016': {
                this.doType(mode, 117);
                break;
            }
            case '\ue017': {
                this.doType(mode, 118);
                break;
            }
            case '\ue018': {
                this.doType(mode, 119);
                break;
            }
            case '\ue019': {
                this.doType(mode, 120);
                break;
            }
            case '\ue01a': {
                this.doType(mode, 121);
                break;
            }
            case '\ue01b': {
                this.doType(mode, 122);
                break;
            }
            case '\ue01c': {
                this.doType(mode, 123);
                break;
            }
            case '\ue01d': {
                this.doType(mode, 61440);
                break;
            }
            case '\ue01e': {
                this.doType(mode, 61441);
                break;
            }
            case '\ue01f': {
                this.doType(mode, 61442);
                break;
            }
            case '\ue020': {
                this.doType(mode, 16);
                break;
            }
            case '\ue021': {
                this.doType(mode, 17);
                break;
            }
            case '\ue022': {
                this.doType(mode, 18);
                break;
            }
            case '\ue023': {
                this.doType(mode, 157);
                break;
            }
            case '\ue024': {
                this.doType(mode, 154);
                break;
            }
            case '\ue025': {
                this.doType(mode, 145);
                break;
            }
            case '\ue026': {
                this.doType(mode, 19);
                break;
            }
            case '\ue027': {
                this.doType(mode, 20);
                break;
            }
            case '\ue030': {
                this.doType(mode, 96);
                break;
            }
            case '\ue031': {
                this.doType(mode, 97);
                break;
            }
            case '\ue032': {
                this.doType(mode, 98);
                break;
            }
            case '\ue033': {
                this.doType(mode, 99);
                break;
            }
            case '\ue034': {
                this.doType(mode, 100);
                break;
            }
            case '\ue035': {
                this.doType(mode, 101);
                break;
            }
            case '\ue036': {
                this.doType(mode, 102);
                break;
            }
            case '\ue037': {
                this.doType(mode, 103);
                break;
            }
            case '\ue038': {
                this.doType(mode, 104);
                break;
            }
            case '\ue039': {
                this.doType(mode, 105);
                break;
            }
            case '\ue03a': {
                this.doType(mode, 108);
                break;
            }
            case '\ue03b': {
                this.doType(mode, 144);
                break;
            }
            case '\ue03c': {
                this.doType(mode, 107);
                break;
            }
            case '\ue03d': {
                this.doType(mode, 45);
                break;
            }
            case '\ue03e': {
                this.doType(mode, 106);
                break;
            }
            case '\ue03f': {
                this.doType(mode, 111);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot type character " + character);
            }
        }
    }

    @Override
    public void smoothMove(Location dest) {
        this.smoothMove(new Location(this.last_x, this.last_y), dest, (long)(Settings.MoveMouseDelay * 1000.0f));
    }

    @Override
    public void smoothMove(Location src, Location dest, long ms) {
        if (ms == 0L) {
            this.mouseMove(dest.x, dest.y);
            return;
        }
        AnimatorTimeBased aniX = new AnimatorTimeBased(new AnimatorOutQuarticEase(src.x, dest.x, ms));
        AnimatorTimeBased aniY = new AnimatorTimeBased(new AnimatorOutQuarticEase(src.y, dest.y, ms));
        while (aniX.running()) {
            float x = aniX.step();
            float y = aniY.step();
            this.mouseMove((int)x, (int)y);
            this.delay(50);
        }
    }

    private int getKeysym(int keycode) {
        int key;
        if (this.shiftFlag) {
            switch (keycode) {
                case 48: {
                    key = 41;
                    break;
                }
                case 49: {
                    key = 33;
                    break;
                }
                case 50: {
                    key = 64;
                    break;
                }
                case 51: {
                    key = 35;
                    break;
                }
                case 52: {
                    key = 36;
                    break;
                }
                case 53: {
                    key = 37;
                    break;
                }
                case 54: {
                    key = 94;
                    break;
                }
                case 55: {
                    key = 38;
                    break;
                }
                case 56: {
                    key = 42;
                    break;
                }
                case 57: {
                    key = 40;
                    break;
                }
                case 8: {
                    key = 65288;
                    break;
                }
                case 9: {
                    key = 64773;
                    break;
                }
                case 10: {
                    key = 65293;
                    break;
                }
                case 155: {
                    key = 64797;
                    break;
                }
                case 127: {
                    key = 65535;
                    break;
                }
                case 36: {
                    key = 65360;
                    break;
                }
                case 35: {
                    key = 65367;
                    break;
                }
                case 33: {
                    key = 65365;
                    break;
                }
                case 34: {
                    key = 65366;
                    break;
                }
                case 37: {
                    key = 65361;
                    break;
                }
                case 38: {
                    key = 65362;
                    break;
                }
                case 39: {
                    key = 65363;
                    break;
                }
                case 40: {
                    key = 65364;
                    break;
                }
                case 112: {
                    key = 65470;
                    break;
                }
                case 113: {
                    key = 65471;
                    break;
                }
                case 114: {
                    key = 65472;
                    break;
                }
                case 115: {
                    key = 65473;
                    break;
                }
                case 116: {
                    key = 65474;
                    break;
                }
                case 117: {
                    key = 65475;
                    break;
                }
                case 118: {
                    key = 65476;
                    break;
                }
                case 119: {
                    key = 65477;
                    break;
                }
                case 120: {
                    key = 65478;
                    break;
                }
                case 121: {
                    key = 65479;
                    break;
                }
                case 122: {
                    key = 65480;
                    break;
                }
                case 123: {
                    key = 65481;
                    break;
                }
                case 17: {
                    key = 65507;
                    break;
                }
                case 157: {
                    key = 65511;
                    break;
                }
                case 18: {
                    key = 65513;
                    break;
                }
                case 65: {
                    key = 65;
                    break;
                }
                case 66: {
                    key = 66;
                    break;
                }
                case 67: {
                    key = 67;
                    break;
                }
                case 68: {
                    key = 68;
                    break;
                }
                case 69: {
                    key = 69;
                    break;
                }
                case 70: {
                    key = 70;
                    break;
                }
                case 71: {
                    key = 71;
                    break;
                }
                case 72: {
                    key = 72;
                    break;
                }
                case 73: {
                    key = 73;
                    break;
                }
                case 74: {
                    key = 74;
                    break;
                }
                case 75: {
                    key = 75;
                    break;
                }
                case 76: {
                    key = 76;
                    break;
                }
                case 77: {
                    key = 77;
                    break;
                }
                case 78: {
                    key = 78;
                    break;
                }
                case 79: {
                    key = 79;
                    break;
                }
                case 80: {
                    key = 80;
                    break;
                }
                case 81: {
                    key = 81;
                    break;
                }
                case 82: {
                    key = 82;
                    break;
                }
                case 83: {
                    key = 83;
                    break;
                }
                case 84: {
                    key = 84;
                    break;
                }
                case 85: {
                    key = 85;
                    break;
                }
                case 86: {
                    key = 86;
                    break;
                }
                case 87: {
                    key = 87;
                    break;
                }
                case 88: {
                    key = 88;
                    break;
                }
                case 89: {
                    key = 89;
                    break;
                }
                case 90: {
                    key = 90;
                    break;
                }
                case 32: {
                    key = 32;
                    break;
                }
                case 192: {
                    key = 126;
                    break;
                }
                case 45: {
                    key = 95;
                    break;
                }
                case 61: {
                    key = 43;
                    break;
                }
                case 222: {
                    key = 34;
                    break;
                }
                case 59: {
                    key = 58;
                    break;
                }
                case 92: {
                    key = 124;
                    break;
                }
                case 161: {
                    key = 123;
                    break;
                }
                case 162: {
                    key = 125;
                    break;
                }
                case 46: {
                    key = 62;
                    break;
                }
                case 44: {
                    key = 60;
                    break;
                }
                case 47: {
                    key = 63;
                    break;
                }
                case 521: {
                    key = 43;
                    break;
                }
                case 91: {
                    key = 123;
                    break;
                }
                case 93: {
                    key = 125;
                    break;
                }
                case 27: {
                    key = 65307;
                    break;
                }
                case 61440: {
                    key = 65482;
                    break;
                }
                case 61441: {
                    key = 65483;
                    break;
                }
                case 61442: {
                    key = 65483;
                    break;
                }
                case 154: {
                    key = 64797;
                    break;
                }
                case 145: {
                    key = 65300;
                    break;
                }
                case 19: {
                    key = 65299;
                    break;
                }
                case 20: {
                    key = 65509;
                    break;
                }
                case 96: {
                    key = 48;
                    break;
                }
                case 97: {
                    key = 49;
                    break;
                }
                case 98: {
                    key = 50;
                    break;
                }
                case 99: {
                    key = 51;
                    break;
                }
                case 100: {
                    key = 52;
                    break;
                }
                case 101: {
                    key = 53;
                    break;
                }
                case 102: {
                    key = 54;
                    break;
                }
                case 103: {
                    key = 55;
                    break;
                }
                case 104: {
                    key = 56;
                    break;
                }
                case 105: {
                    key = 57;
                    break;
                }
                case 108: {
                    key = 65452;
                    break;
                }
                case 144: {
                    key = 65407;
                    break;
                }
                case 106: {
                    key = 42;
                    break;
                }
                case 107: {
                    key = 43;
                    break;
                }
                case 111: {
                    key = 47;
                    break;
                }
                default: {
                    key = 0xFFFFFF;
                    break;
                }
            }
        } else {
            switch (keycode) {
                case 48: {
                    key = 48;
                    break;
                }
                case 49: {
                    key = 49;
                    break;
                }
                case 50: {
                    key = 50;
                    break;
                }
                case 51: {
                    key = 51;
                    break;
                }
                case 52: {
                    key = 52;
                    break;
                }
                case 53: {
                    key = 53;
                    break;
                }
                case 54: {
                    key = 54;
                    break;
                }
                case 55: {
                    key = 55;
                    break;
                }
                case 56: {
                    key = 56;
                    break;
                }
                case 57: {
                    key = 57;
                    break;
                }
                case 8: {
                    key = 65288;
                    break;
                }
                case 9: {
                    key = 65289;
                    break;
                }
                case 10: {
                    key = 65293;
                    break;
                }
                case 155: {
                    key = 65379;
                    break;
                }
                case 127: {
                    key = 65535;
                    break;
                }
                case 36: {
                    key = 65360;
                    break;
                }
                case 35: {
                    key = 65367;
                    break;
                }
                case 33: {
                    key = 65365;
                    break;
                }
                case 34: {
                    key = 65366;
                    break;
                }
                case 37: {
                    key = 65361;
                    break;
                }
                case 38: {
                    key = 65362;
                    break;
                }
                case 39: {
                    key = 65363;
                    break;
                }
                case 40: {
                    key = 65364;
                    break;
                }
                case 112: {
                    key = 65470;
                    break;
                }
                case 113: {
                    key = 65471;
                    break;
                }
                case 114: {
                    key = 65472;
                    break;
                }
                case 115: {
                    key = 65473;
                    break;
                }
                case 116: {
                    key = 65474;
                    break;
                }
                case 117: {
                    key = 65475;
                    break;
                }
                case 118: {
                    key = 65476;
                    break;
                }
                case 119: {
                    key = 65477;
                    break;
                }
                case 120: {
                    key = 65478;
                    break;
                }
                case 121: {
                    key = 65479;
                    break;
                }
                case 122: {
                    key = 65480;
                    break;
                }
                case 123: {
                    key = 65481;
                    break;
                }
                case 17: {
                    key = 65507;
                    break;
                }
                case 157: {
                    key = 65511;
                    break;
                }
                case 18: {
                    key = 65513;
                    break;
                }
                case 65: {
                    key = 97;
                    break;
                }
                case 66: {
                    key = 98;
                    break;
                }
                case 67: {
                    key = 99;
                    break;
                }
                case 68: {
                    key = 100;
                    break;
                }
                case 69: {
                    key = 101;
                    break;
                }
                case 70: {
                    key = 102;
                    break;
                }
                case 71: {
                    key = 103;
                    break;
                }
                case 72: {
                    key = 104;
                    break;
                }
                case 73: {
                    key = 105;
                    break;
                }
                case 74: {
                    key = 106;
                    break;
                }
                case 75: {
                    key = 107;
                    break;
                }
                case 76: {
                    key = 108;
                    break;
                }
                case 77: {
                    key = 109;
                    break;
                }
                case 78: {
                    key = 110;
                    break;
                }
                case 79: {
                    key = 111;
                    break;
                }
                case 80: {
                    key = 112;
                    break;
                }
                case 81: {
                    key = 113;
                    break;
                }
                case 82: {
                    key = 114;
                    break;
                }
                case 83: {
                    key = 115;
                    break;
                }
                case 84: {
                    key = 116;
                    break;
                }
                case 85: {
                    key = 117;
                    break;
                }
                case 86: {
                    key = 118;
                    break;
                }
                case 87: {
                    key = 119;
                    break;
                }
                case 88: {
                    key = 120;
                    break;
                }
                case 89: {
                    key = 121;
                    break;
                }
                case 90: {
                    key = 122;
                    break;
                }
                case 32: {
                    key = 32;
                    break;
                }
                case 192: {
                    key = 96;
                    break;
                }
                case 45: {
                    key = 45;
                    break;
                }
                case 61: {
                    key = 61;
                    break;
                }
                case 222: {
                    key = 39;
                    break;
                }
                case 59: {
                    key = 59;
                    break;
                }
                case 92: {
                    key = 92;
                    break;
                }
                case 161: {
                    key = 91;
                    break;
                }
                case 162: {
                    key = 93;
                    break;
                }
                case 46: {
                    key = 46;
                    break;
                }
                case 44: {
                    key = 44;
                    break;
                }
                case 47: {
                    key = 47;
                    break;
                }
                case 521: {
                    key = 43;
                    break;
                }
                case 91: {
                    key = 91;
                    break;
                }
                case 93: {
                    key = 93;
                    break;
                }
                case 27: {
                    key = 65307;
                    break;
                }
                case 61440: {
                    key = 65482;
                    break;
                }
                case 61441: {
                    key = 65483;
                    break;
                }
                case 61442: {
                    key = 65483;
                    break;
                }
                case 154: {
                    key = 64797;
                    break;
                }
                case 145: {
                    key = 65300;
                    break;
                }
                case 19: {
                    key = 65299;
                    break;
                }
                case 20: {
                    key = 65509;
                    break;
                }
                case 96: {
                    key = 48;
                    break;
                }
                case 97: {
                    key = 49;
                    break;
                }
                case 98: {
                    key = 50;
                    break;
                }
                case 99: {
                    key = 51;
                    break;
                }
                case 100: {
                    key = 52;
                    break;
                }
                case 101: {
                    key = 53;
                    break;
                }
                case 102: {
                    key = 54;
                    break;
                }
                case 103: {
                    key = 55;
                    break;
                }
                case 104: {
                    key = 56;
                    break;
                }
                case 105: {
                    key = 57;
                    break;
                }
                case 108: {
                    key = 65452;
                    break;
                }
                case 144: {
                    key = 65407;
                    break;
                }
                case 106: {
                    key = 42;
                    break;
                }
                case 107: {
                    key = 43;
                    break;
                }
                case 111: {
                    key = 47;
                    break;
                }
                default: {
                    key = 0xFFFFFF;
                }
            }
        }
        Debug.log(3, "Keycode-" + keycode, new Object[0]);
        Debug.log(3, "Shiftflag-" + this.shiftFlag, new Object[0]);
        Debug.log(3, "Key-" + Integer.toHexString(key), new Object[0]);
        return key;
    }

    private void tidyUp() {
        if (this.waitForIdle) {
            this.waitForIdle();
        }
        this.delay(this.autodelay);
    }

    @Override
    public void keyDown(String keys) {
    }

    @Override
    public void keyUp(String keys) {
    }

    @Override
    public void keyUp() {
    }

    @Override
    public void pressModifiers(int modifiers) {
    }

    @Override
    public void releaseModifiers(int modifiers) {
    }

    @Override
    public void typeKey(int key) {
    }

    @Override
    public void typeStarts() {
    }

    @Override
    public void typeEnds() {
    }

    @Override
    public void clickStarts() {
    }

    @Override
    public void clickEnds() {
    }

    @Override
    public Color getColorAt(int x, int y) {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public IScreen getScreen() {
        return null;
    }
}

